/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplaceWithObjectsEqualsFix
extends PsiUpdateModCommandQuickFix {
    private final String myQualifierText;
    private final String myReplacementText;

    private ReplaceWithObjectsEqualsFix(String qualifierText, String replacementText) {
        this.myQualifierText = qualifierText;
        this.myReplacementText = replacementText;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{this.myQualifierText + ".equals(...)", "Objects.equals(" + this.myReplacementText + ", ...)"});
        if (string == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{".equals()", "Objects.equals()"});
        if (string == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiMethodCallExpression call;
        if (project == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(4);
        }
        if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) == null) {
            return;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1) {
            return;
        }
        String replacementText = "java.util.Objects.equals(" + this.myReplacementText + ", " + args[0].getText() + ")";
        PsiElement replaced = call.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(replacementText, (PsiElement)call));
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)((PsiMethodCallExpression)replaced).getMethodExpression());
    }

    @Nullable
    public static ReplaceWithObjectsEqualsFix createFix(@NotNull PsiMethodCallExpression call, @NotNull PsiReferenceExpression methodExpression) {
        if (call == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(5);
        }
        if (methodExpression == null) {
            ReplaceWithObjectsEqualsFix.$$$reportNull$$$0(6);
        }
        if (!"equals".equals(methodExpression.getReferenceName()) || call.getArgumentList().getExpressionCount() != 1 || !PsiUtil.isAvailable((JavaFeature)JavaFeature.OBJECTS_CLASS, (PsiElement)call)) {
            return null;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        PsiExpression noParens = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier);
        if (noParens == null) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method != null && method.getParameterList().getParametersCount() == 1 && Objects.requireNonNull(method.getParameterList().getParameter(0)).getType().equalsToText("java.lang.Object")) {
            return new ReplaceWithObjectsEqualsFix(qualifier.getText(), noParens.getText());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/fix/ReplaceWithObjectsEqualsFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/fix/ReplaceWithObjectsEqualsFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

