/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.inference.ContractInferenceGist;
import com.intellij.codeInspection.dataFlow.inference.InferenceVisitor;
import com.intellij.codeInspection.dataFlow.inference.MethodData;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.StubInconsistencyReporter;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a&\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\n\u0010\f\u001a\u00060\u0007j\u0002`\b\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n\u001a2\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00030\u00012\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"indexFile", "", "", "Lcom/intellij/codeInspection/dataFlow/inference/MethodData;", "tree", "Lcom/intellij/lang/LighterAST;", "handleInconsistency", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "method", "Lcom/intellij/psi/impl/source/PsiMethodImpl;", "cachedData", "e", "getIndexedData", "bindMethods", "Lcom/intellij/psi/PsiMethod;", "fileData", "file", "Lcom/intellij/psi/PsiFile;", "intellij.java.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nContractInferenceIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractInferenceIndex.kt\ncom/intellij/codeInspection/dataFlow/inference/ContractInferenceIndexKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1#2:267\n*E\n"})
public final class ContractInferenceIndexKt {
    @NotNull
    public static final Map<Integer, MethodData> indexFile(@NotNull LighterAST tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        InferenceVisitor visitor2 = new InferenceVisitor(tree);
        LighterASTNode lighterASTNode = tree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)lighterASTNode, (String)"getRoot(...)");
        visitor2.visitNode(lighterASTNode);
        return visitor2.getResult();
    }

    @NotNull
    public static final RuntimeException handleInconsistency(@NotNull PsiMethodImpl method, @NotNull MethodData cachedData, @NotNull RuntimeException e) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)cachedData, (String)"cachedData");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof ProcessCanceledException) {
            return e;
        }
        PsiFile psiFile = method.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        PsiFileGist<Map<Integer, MethodData>> gist = ContractInferenceGist.Companion.getInstance().getGist();
        Map gistMap = (Map)gist.getFileData(file);
        GistManager.getInstance().invalidateData(file.getViewProvider().getVirtualFile());
        LighterAST lighterAST = file.getNode().getLighterAST();
        Intrinsics.checkNotNullExpressionValue((Object)lighterAST, (String)"getLighterAST(...)");
        Map<Integer, MethodData> psiMap = ContractInferenceIndexKt.indexFile(lighterAST);
        if (!Intrinsics.areEqual((Object)gistMap, psiMap)) {
            GistManager.getInstance().invalidateData(file.getViewProvider().getVirtualFile());
            Attachment[] attachmentArray = new Attachment[]{new Attachment("persisted.txt", gistMap.toString()), new Attachment("psi.txt", psiMap.toString())};
            return (RuntimeException)new RuntimeExceptionWithAttachments("Gist outdated", (Throwable)e, attachmentArray);
        }
        StubTextInconsistencyException.checkStubTextConsistency((PsiFile)file, (StubInconsistencyReporter.SourceOfCheck)StubInconsistencyReporter.SourceOfCheck.CheckAfterExceptionInJava);
        MethodData actualData = ContractInferenceIndexKt.bindMethods(psiMap, file).get(method);
        if (!Intrinsics.areEqual((Object)actualData, (Object)cachedData)) {
            Attachment[] attachmentArray = new Attachment[]{new Attachment("actual.txt", String.valueOf(actualData)), new Attachment("cached.txt", cachedData.toString())};
            return (RuntimeException)new RuntimeExceptionWithAttachments("Cache outdated", attachmentArray);
        }
        return e;
    }

    @Nullable
    public static final MethodData getIndexedData(@NotNull PsiMethodImpl method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiFile psiFile = method.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> ContractInferenceIndexKt.getIndexedData$lambda$0(file));
        return (MethodData)map.get(method);
    }

    private static final Map<PsiMethod, MethodData> bindMethods(Map<Integer, MethodData> fileData, PsiFile file) {
        HashMap result = new HashMap();
        if (fileData != null) {
            Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            StubbedSpine stubbedSpine = ((PsiFileImpl)file).getStubbedSpine();
            Intrinsics.checkNotNullExpressionValue((Object)stubbedSpine, (String)"getStubbedSpine(...)");
            StubbedSpine spine = stubbedSpine;
            int methodIndex = 0;
            int n = spine.getStubCount();
            for (int i = 0; i < n; ++i) {
                if (spine.getStubType(i) != JavaElementType.METHOD) continue;
                if (fileData.get(methodIndex) != null) {
                    MethodData it;
                    boolean bl = false;
                    Map map = result;
                    PsiElement psiElement = spine.getStubPsi(i);
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                    map.put((PsiMethod)psiElement, it);
                }
                ++methodIndex;
            }
        }
        return result;
    }

    private static final CachedValueProvider.Result getIndexedData$lambda$0(PsiFile $file) {
        PsiFileGist<Map<Integer, MethodData>> gist = ContractInferenceGist.Companion.getInstance().getGist();
        Object[] objectArray = new Object[]{$file};
        return CachedValueProvider.Result.create(ContractInferenceIndexKt.bindMethods((Map)gist.getFileData($file), $file), (Object[])objectArray);
    }
}

