/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.inference.DelegationContract;
import com.intellij.codeInspection.dataFlow.inference.ExpressionRange;
import com.intellij.codeInspection.dataFlow.inference.KnownContract;
import com.intellij.codeInspection.dataFlow.inference.MethodCallContract;
import com.intellij.codeInspection.dataFlow.inference.PreContract;
import com.intellij.codeInspection.dataFlow.inference.SideEffectFilter;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

class ContractInferenceInterpreter {
    private static final TokenSet UNARY_INCREMENT_DECREMENT = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.PLUSPLUS, JavaTokenType.MINUSMINUS});
    private final LighterAST myTree;
    private final LighterASTNode myMethod;
    private final LighterASTNode myBody;

    ContractInferenceInterpreter(LighterAST tree, LighterASTNode method, LighterASTNode body) {
        this.myTree = tree;
        this.myMethod = method;
        this.myBody = body;
    }

    @NotNull
    List<LighterASTNode> getParameters() {
        LighterASTNode paramList = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)this.myMethod, (IElementType)JavaElementType.PARAMETER_LIST);
        List list = paramList != null ? LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)paramList, (IElementType)JavaElementType.PARAMETER) : Collections.emptyList();
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    List<PreContract> inferContracts(List<LighterASTNode> statements) {
        ContractReturnValue value;
        List<PreContract> result;
        if (statements.isEmpty()) {
            List<PreContract> list = Collections.emptyList();
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (statements.size() == 1 && (result = this.handleSingleStatement(statements.get(0))) != null) {
            List<PreContract> list = result;
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<PreContract> contracts = this.visitStatements(Collections.singletonList(StandardMethodContract.createConstraintArray(this.getParameters().size())), statements);
        if (contracts.isEmpty() && !(value = this.getDefaultReturnValue(statements)).isFail() && !value.equals(ContractReturnValue.returnAny())) {
            contracts = Collections.singletonList(new KnownContract(StandardMethodContract.trivialContract(this.getParameters().size(), value)));
        }
        List<PreContract> list = contracts;
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private List<PreContract> handleSingleStatement(LighterASTNode statement) {
        if (statement.getTokenType() == JavaElementType.RETURN_STATEMENT) {
            LighterASTNode returned = JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)statement);
            return this.getLiteralConstraint(returned) != null ? Collections.emptyList() : this.handleDelegation(returned, false);
        }
        if (statement.getTokenType() == JavaElementType.EXPRESSION_STATEMENT) {
            LighterASTNode expr = JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)statement);
            return expr != null && expr.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION ? this.handleDelegation(expr, false) : null;
        }
        return null;
    }

    @Nullable
    private LighterASTNode getCodeBlock(@Nullable LighterASTNode parent) {
        return LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)parent, (IElementType)JavaElementType.CODE_BLOCK);
    }

    @NotNull
    static List<LighterASTNode> getStatements(@Nullable LighterASTNode codeBlock, LighterAST tree) {
        List list = codeBlock == null ? Collections.emptyList() : LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)codeBlock, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET);
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    private List<PreContract> handleDelegation(@Nullable LighterASTNode expression, boolean negated) {
        if (expression == null) {
            return null;
        }
        if (expression.getTokenType() == JavaElementType.PARENTH_EXPRESSION) {
            return this.handleDelegation(JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)expression), negated);
        }
        if (this.isNegationExpression(expression)) {
            return this.handleDelegation(JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)expression), !negated);
        }
        if (expression.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION) {
            return Collections.singletonList(new DelegationContract(ExpressionRange.create(expression, this.myBody.getStartOffset()), negated));
        }
        return null;
    }

    private boolean isNegationExpression(@Nullable LighterASTNode expression) {
        return expression != null && expression.getTokenType() == JavaElementType.PREFIX_EXPRESSION && LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expression, (IElementType)JavaTokenType.EXCL) != null;
    }

    private ContractReturnValue getDefaultReturnValue(List<LighterASTNode> statements) {
        class ReturnValueVisitor
        extends RecursiveLighterASTNodeWalkingVisitor {
            public ContractReturnValue returnValue;
            private BitSet assignedParameters;

            ReturnValueVisitor() {
                super(ContractInferenceInterpreter.this.myTree);
                this.returnValue = ContractReturnValue.fail();
            }

            public void visitNode(@NotNull LighterASTNode element) {
                LighterASTNode expression;
                int paramIndex;
                IElementType type;
                if (element == null) {
                    ReturnValueVisitor.$$$reportNull$$$0(0);
                }
                if ((type = element.getTokenType()) == JavaElementType.CLASS || type == JavaElementType.LAMBDA_EXPRESSION) {
                    return;
                }
                if (this.returnValue.equals(ContractReturnValue.returnAny())) {
                    return;
                }
                if ((type == JavaElementType.ASSIGNMENT_EXPRESSION || type == JavaElementType.POSTFIX_EXPRESSION || type == JavaElementType.PREFIX_EXPRESSION && LightTreeUtil.firstChildOfType((LighterAST)ContractInferenceInterpreter.this.myTree, (LighterASTNode)element, (TokenSet)UNARY_INCREMENT_DECREMENT) != null) && (paramIndex = ContractInferenceInterpreter.this.resolveParameter(expression = JavaLightTreeUtil.skipParenthesesCastsDown((LighterAST)ContractInferenceInterpreter.this.myTree, (LighterASTNode)JavaLightTreeUtil.findExpressionChild((LighterAST)ContractInferenceInterpreter.this.myTree, (LighterASTNode)element)))) >= 0) {
                    if (this.assignedParameters == null) {
                        this.assignedParameters = new BitSet();
                    }
                    this.assignedParameters.set(paramIndex);
                    if (this.returnValue.equals(ContractReturnValue.returnParameter(paramIndex))) {
                        this.returnValue = ContractReturnValue.returnAny();
                    }
                }
                if (type == JavaElementType.RETURN_STATEMENT) {
                    expression = JavaLightTreeUtil.findExpressionChild((LighterAST)ContractInferenceInterpreter.this.myTree, (LighterASTNode)element);
                    ContractReturnValue newReturnValue = this.expressionToReturnValue(expression);
                    if (this.returnValue.isFail()) {
                        this.returnValue = newReturnValue;
                    } else if (!this.returnValue.equals(newReturnValue)) {
                        this.returnValue = ContractReturnValue.returnAny();
                    }
                }
                super.visitNode(element);
            }

            @NotNull
            private ContractReturnValue expressionToReturnValue(LighterASTNode expression) {
                int paramIndex;
                if ((expression = JavaLightTreeUtil.skipParenthesesDown((LighterAST)ContractInferenceInterpreter.this.myTree, (LighterASTNode)expression)) == null) {
                    ContractReturnValue contractReturnValue = ContractReturnValue.returnAny();
                    if (contractReturnValue == null) {
                        ReturnValueVisitor.$$$reportNull$$$0(1);
                    }
                    return contractReturnValue;
                }
                IElementType type = expression.getTokenType();
                if (type == JavaElementType.NEW_EXPRESSION) {
                    ContractReturnValue contractReturnValue = ContractReturnValue.returnNew();
                    if (contractReturnValue == null) {
                        ReturnValueVisitor.$$$reportNull$$$0(2);
                    }
                    return contractReturnValue;
                }
                if (type == JavaElementType.THIS_EXPRESSION) {
                    ContractReturnValue contractReturnValue = ContractReturnValue.returnThis();
                    if (contractReturnValue == null) {
                        ReturnValueVisitor.$$$reportNull$$$0(3);
                    }
                    return contractReturnValue;
                }
                if (!(type != JavaElementType.REFERENCE_EXPRESSION || (paramIndex = ContractInferenceInterpreter.this.resolveParameter(expression)) < 0 || this.assignedParameters != null && this.assignedParameters.get(paramIndex))) {
                    ContractReturnValue contractReturnValue = ContractReturnValue.returnParameter(paramIndex);
                    if (contractReturnValue == null) {
                        ReturnValueVisitor.$$$reportNull$$$0(4);
                    }
                    return contractReturnValue;
                }
                ContractReturnValue contractReturnValue = ContractReturnValue.returnAny();
                if (contractReturnValue == null) {
                    ReturnValueVisitor.$$$reportNull$$$0(5);
                }
                return contractReturnValue;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/dataFlow/inference/ContractInferenceInterpreter$1ReturnValueVisitor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/dataFlow/inference/ContractInferenceInterpreter$1ReturnValueVisitor";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "expressionToReturnValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitNode";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
                };
            }
        }
        ReturnValueVisitor visitor2 = new ReturnValueVisitor();
        for (LighterASTNode statement : statements) {
            visitor2.visitNode(statement);
        }
        return visitor2.returnValue;
    }

    @NotNull
    private @Unmodifiable List<PreContract> visitExpression(List<StandardMethodContract.ValueConstraint[]> states, @Nullable LighterASTNode expr) {
        int parameter;
        if (expr == null) {
            List<PreContract> list = Collections.emptyList();
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (states.isEmpty()) {
            List<PreContract> list = Collections.emptyList();
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (states.size() > 300) {
            List<PreContract> list = Collections.emptyList();
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(7);
            }
            return list;
        }
        IElementType type = expr.getTokenType();
        if (type == JavaElementType.POLYADIC_EXPRESSION || type == JavaElementType.BINARY_EXPRESSION) {
            return this.visitPolyadic(states, expr);
        }
        if (type == JavaElementType.CONDITIONAL_EXPRESSION) {
            List children = JavaLightTreeUtil.getExpressionChildren((LighterAST)this.myTree, (LighterASTNode)expr);
            if (children.size() != 3) {
                List<PreContract> list = Collections.emptyList();
                if (list == null) {
                    ContractInferenceInterpreter.$$$reportNull$$$0(8);
                }
                return list;
            }
            List<PreContract> conditionResults = this.visitExpression(states, (LighterASTNode)children.get(0));
            List list = ContainerUtil.concat(this.visitExpression(ContractInferenceInterpreter.antecedentsReturning(conditionResults, ContractReturnValue.returnTrue()), (LighterASTNode)children.get(1)), this.visitExpression(ContractInferenceInterpreter.antecedentsReturning(conditionResults, ContractReturnValue.returnFalse()), (LighterASTNode)children.get(2)));
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (type == JavaElementType.PARENTH_EXPRESSION) {
            return this.visitExpression(states, JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)expr));
        }
        if (type == JavaElementType.TYPE_CAST_EXPRESSION && !JavaLightTreeUtil.isPrimitiveCast((LighterAST)this.myTree, (LighterASTNode)expr)) {
            return this.visitExpression(states, JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)expr));
        }
        if (this.isNegationExpression(expr)) {
            List list = ContainerUtil.mapNotNull(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)expr)), PreContract::negate);
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(10);
            }
            return list;
        }
        if (type == JavaElementType.INSTANCE_OF_EXPRESSION && (parameter = this.resolveParameter(JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)expr))) >= 0) {
            return ContractInferenceInterpreter.asPreContracts(ContainerUtil.mapNotNull(states, state -> ContractInferenceInterpreter.contractWithConstraint(state, parameter, StandardMethodContract.ValueConstraint.NULL_VALUE, ContractReturnValue.returnFalse())));
        }
        if (type == JavaElementType.NEW_EXPRESSION) {
            return ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, ContractReturnValue.returnNew()));
        }
        if (type == JavaElementType.THIS_EXPRESSION) {
            return ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, ContractReturnValue.returnThis()));
        }
        if (type == JavaElementType.METHOD_CALL_EXPRESSION) {
            List<PreContract> list = Collections.singletonList(new MethodCallContract(ExpressionRange.create(expr, this.myBody.getStartOffset()), ContainerUtil.map(states, Arrays::asList)));
            if (list == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(11);
            }
            return list;
        }
        StandardMethodContract.ValueConstraint constraint = this.getLiteralConstraint(expr);
        if (constraint != null) {
            return ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, constraint.asReturnValue()));
        }
        int paramIndex = this.resolveParameter(expr);
        if (paramIndex >= 0) {
            ArrayList<StandardMethodContract> result = new ArrayList<StandardMethodContract>();
            for (StandardMethodContract.ValueConstraint[] state2 : states) {
                if (state2[paramIndex] == StandardMethodContract.ValueConstraint.TRUE_VALUE || state2[paramIndex] == StandardMethodContract.ValueConstraint.FALSE_VALUE || state2[paramIndex] == StandardMethodContract.ValueConstraint.NULL_VALUE) {
                    result.add(new StandardMethodContract(state2, state2[paramIndex].asReturnValue()));
                    continue;
                }
                if (JavaTokenType.BOOLEAN_KEYWORD == this.getPrimitiveParameterType(paramIndex)) {
                    ContainerUtil.addIfNotNull(result, (Object)ContractInferenceInterpreter.contractWithConstraint(state2, paramIndex, StandardMethodContract.ValueConstraint.TRUE_VALUE, ContractReturnValue.returnTrue()));
                    ContainerUtil.addIfNotNull(result, (Object)ContractInferenceInterpreter.contractWithConstraint(state2, paramIndex, StandardMethodContract.ValueConstraint.FALSE_VALUE, ContractReturnValue.returnFalse()));
                    continue;
                }
                result.add(new StandardMethodContract(state2, ContractReturnValue.returnParameter(paramIndex)));
            }
            return ContractInferenceInterpreter.asPreContracts(result);
        }
        List<PreContract> list = Collections.emptyList();
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private @Unmodifiable List<PreContract> visitPolyadic(List<StandardMethodContract.ValueConstraint[]> states, @NotNull LighterASTNode expr) {
        boolean logicalAnd;
        if (expr == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(13);
        }
        if (LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.PLUS) != null) {
            return ContractInferenceInterpreter.asPreContracts(ContainerUtil.map(states, s -> new StandardMethodContract((StandardMethodContract.ValueConstraint[])s, ContractReturnValue.returnNotNull())));
        }
        List operands = JavaLightTreeUtil.getExpressionChildren((LighterAST)this.myTree, (LighterASTNode)expr);
        if (operands.size() == 2) {
            boolean equality;
            boolean bl = equality = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.EQEQ) != null;
            if (equality || LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.NE) != null) {
                return ContractInferenceInterpreter.asPreContracts(this.visitEqualityComparison(states, (LighterASTNode)operands.get(0), (LighterASTNode)operands.get(1), equality));
            }
        }
        boolean bl = logicalAnd = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.ANDAND) != null;
        if (logicalAnd || LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)expr, (IElementType)JavaTokenType.OROR) != null) {
            return ContractInferenceInterpreter.asPreContracts(this.visitLogicalOperation(operands, logicalAnd, states));
        }
        List<PreContract> list = Collections.emptyList();
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static @Unmodifiable List<PreContract> asPreContracts(List<StandardMethodContract> contracts) {
        List list = ContainerUtil.map(contracts, KnownContract::new);
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    private static StandardMethodContract contractWithConstraint(StandardMethodContract.ValueConstraint[] state, int parameter, StandardMethodContract.ValueConstraint paramConstraint, ContractReturnValue returnValue) {
        StandardMethodContract.ValueConstraint[] newState = ContractInferenceInterpreter.withConstraint(state, parameter, paramConstraint);
        return newState == null ? null : new StandardMethodContract(newState, returnValue);
    }

    private List<StandardMethodContract> visitEqualityComparison(List<StandardMethodContract.ValueConstraint[]> states, LighterASTNode op1, LighterASTNode op2, boolean equality) {
        int parameter = this.resolveParameter(op1);
        StandardMethodContract.ValueConstraint constraint = this.getLiteralConstraint(op2);
        if (parameter < 0 || constraint == null) {
            parameter = this.resolveParameter(op2);
            constraint = this.getLiteralConstraint(op1);
        }
        if (parameter >= 0 && constraint != null) {
            ArrayList<StandardMethodContract> result = new ArrayList<StandardMethodContract>();
            for (StandardMethodContract.ValueConstraint[] state : states) {
                if (constraint == StandardMethodContract.ValueConstraint.NOT_NULL_VALUE) {
                    if (this.getPrimitiveParameterType(parameter) != null) continue;
                    ContainerUtil.addIfNotNull(result, (Object)ContractInferenceInterpreter.contractWithConstraint(state, parameter, StandardMethodContract.ValueConstraint.NULL_VALUE, ContractReturnValue.returnBoolean(!equality)));
                    continue;
                }
                ContainerUtil.addIfNotNull(result, (Object)ContractInferenceInterpreter.contractWithConstraint(state, parameter, constraint, ContractReturnValue.returnBoolean(equality)));
                ContainerUtil.addIfNotNull(result, (Object)ContractInferenceInterpreter.contractWithConstraint(state, parameter, constraint.negate(), ContractReturnValue.returnBoolean(!equality)));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Nullable
    private IElementType getPrimitiveParameterType(int paramIndex) {
        LighterASTNode typeElement = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)this.getParameters().get(paramIndex), (IElementType)JavaElementType.TYPE);
        LighterASTNode primitive = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)typeElement, (TokenSet)ElementType.PRIMITIVE_TYPE_BIT_SET);
        return primitive == null ? null : primitive.getTokenType();
    }

    static @Unmodifiable List<StandardMethodContract> toContracts(List<StandardMethodContract.ValueConstraint[]> states, ContractReturnValue constraint) {
        return ContainerUtil.map(states, state -> new StandardMethodContract((StandardMethodContract.ValueConstraint[])state, constraint));
    }

    private List<StandardMethodContract> visitLogicalOperation(List<LighterASTNode> operands, boolean conjunction, List<StandardMethodContract.ValueConstraint[]> states) {
        ContractReturnValue.BooleanReturnValue breakValue = ContractReturnValue.returnBoolean(!conjunction);
        ArrayList<StandardMethodContract> finalStates = new ArrayList<StandardMethodContract>();
        for (LighterASTNode operand : operands) {
            List<PreContract> opResults = this.visitExpression(states, operand);
            finalStates.addAll(ContainerUtil.filter(ContractInferenceInterpreter.knownContracts(opResults), contract -> contract.getReturnValue() == breakValue));
            states = ContractInferenceInterpreter.antecedentsReturning(opResults, breakValue.negate());
        }
        finalStates.addAll(ContractInferenceInterpreter.toContracts(states, breakValue.negate()));
        return finalStates;
    }

    private static @Unmodifiable List<StandardMethodContract> knownContracts(List<PreContract> values) {
        return ContainerUtil.mapNotNull(values, pc -> pc instanceof KnownContract ? ((KnownContract)pc).getContract() : null);
    }

    private static @Unmodifiable List<StandardMethodContract.ValueConstraint[]> antecedentsReturning(List<PreContract> values, ContractReturnValue result) {
        return ContainerUtil.mapNotNull(ContractInferenceInterpreter.knownContracts(values), contract -> contract.getReturnValue().equals(result) ? contract.getConstraints().toArray(new StandardMethodContract.ValueConstraint[0]) : null);
    }

    @NotNull
    private List<PreContract> visitStatements(List<StandardMethodContract.ValueConstraint[]> states, List<LighterASTNode> statements) {
        CodeBlockContracts result = new CodeBlockContracts();
        for (LighterASTNode statement : statements) {
            List<PreContract> conditionResults;
            IElementType type = statement.getTokenType();
            if (type == JavaElementType.BLOCK_STATEMENT) {
                result.addAll(this.visitStatements(states, ContractInferenceInterpreter.getStatements(this.getCodeBlock(statement), this.myTree)));
                break;
            }
            if (type == JavaElementType.IF_STATEMENT) {
                conditionResults = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)statement));
                List<LighterASTNode> thenElse = ContractInferenceInterpreter.getStatements(statement, this.myTree);
                if (!thenElse.isEmpty()) {
                    result.addAll(this.visitStatements(ContractInferenceInterpreter.antecedentsReturning(conditionResults, ContractReturnValue.returnTrue()), Collections.singletonList(thenElse.get(0))));
                }
                List<StandardMethodContract.ValueConstraint[]> falseStates = ContractInferenceInterpreter.antecedentsReturning(conditionResults, ContractReturnValue.returnFalse());
                if (thenElse.size() > 1) {
                    result.addAll(this.visitStatements(falseStates, Collections.singletonList(thenElse.get(1))));
                    break;
                }
                states = falseStates;
                continue;
            }
            if (type == JavaElementType.WHILE_STATEMENT) {
                states = ContractInferenceInterpreter.antecedentsReturning(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)statement)), ContractReturnValue.returnFalse());
                continue;
            }
            if (type == JavaElementType.THROW_STATEMENT) {
                result.addAll(ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, ContractReturnValue.fail())));
                break;
            }
            if (type == JavaElementType.RETURN_STATEMENT) {
                result.addAll(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)statement)));
                break;
            }
            if (type == JavaElementType.ASSERT_STATEMENT) {
                conditionResults = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)statement));
                result.addAll(ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(ContractInferenceInterpreter.antecedentsReturning(conditionResults, ContractReturnValue.returnFalse()), ContractReturnValue.fail())));
                break;
            }
            if (type == JavaElementType.DECLARATION_STATEMENT) {
                result.registerDeclaration(statement, this.myTree, this.myBody.getStartOffset());
                continue;
            }
            if (type != JavaElementType.DO_WHILE_STATEMENT) break;
            result.addAll(this.visitStatements(states, ContractInferenceInterpreter.getStatements(statement, this.myTree)));
            break;
        }
        List<PreContract> list = result.accumulated;
        if (list == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Nullable
    private StandardMethodContract.ValueConstraint getLiteralConstraint(@Nullable LighterASTNode expr) {
        if (expr != null && expr.getTokenType() == JavaElementType.LITERAL_EXPRESSION) {
            return ContractInferenceInterpreter.getLiteralConstraint(((LighterASTNode)this.myTree.getChildren(expr).get(0)).getTokenType());
        }
        return null;
    }

    @NotNull
    static StandardMethodContract.ValueConstraint getLiteralConstraint(@NotNull IElementType literalTokenType) {
        if (literalTokenType == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(17);
        }
        if (literalTokenType.equals(JavaTokenType.TRUE_KEYWORD)) {
            StandardMethodContract.ValueConstraint valueConstraint = StandardMethodContract.ValueConstraint.TRUE_VALUE;
            if (valueConstraint == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(18);
            }
            return valueConstraint;
        }
        if (literalTokenType.equals(JavaTokenType.FALSE_KEYWORD)) {
            StandardMethodContract.ValueConstraint valueConstraint = StandardMethodContract.ValueConstraint.FALSE_VALUE;
            if (valueConstraint == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(19);
            }
            return valueConstraint;
        }
        if (literalTokenType.equals(JavaTokenType.NULL_KEYWORD)) {
            StandardMethodContract.ValueConstraint valueConstraint = StandardMethodContract.ValueConstraint.NULL_VALUE;
            if (valueConstraint == null) {
                ContractInferenceInterpreter.$$$reportNull$$$0(20);
            }
            return valueConstraint;
        }
        StandardMethodContract.ValueConstraint valueConstraint = StandardMethodContract.ValueConstraint.NOT_NULL_VALUE;
        if (valueConstraint == null) {
            ContractInferenceInterpreter.$$$reportNull$$$0(21);
        }
        return valueConstraint;
    }

    private int resolveParameter(@Nullable LighterASTNode expr) {
        if (expr != null && expr.getTokenType() == JavaElementType.REFERENCE_EXPRESSION && JavaLightTreeUtil.findExpressionChild((LighterAST)this.myTree, (LighterASTNode)expr) == null) {
            String name = JavaLightTreeUtil.getNameIdentifierText((LighterAST)this.myTree, (LighterASTNode)expr);
            if (name == null) {
                return -1;
            }
            List<LighterASTNode> parameters = this.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                if (!name.equals(JavaLightTreeUtil.getNameIdentifierText((LighterAST)this.myTree, (LighterASTNode)parameters.get(i)))) continue;
                return i;
            }
        }
        return -1;
    }

    static StandardMethodContract.ValueConstraint @Nullable [] withConstraint(StandardMethodContract.ValueConstraint[] constraints, int index, StandardMethodContract.ValueConstraint constraint) {
        if (constraints[index] == constraint) {
            return constraints;
        }
        StandardMethodContract.ValueConstraint negated = constraint.negate();
        if (negated != constraint && constraints[index] == negated) {
            return null;
        }
        StandardMethodContract.ValueConstraint[] copy = (StandardMethodContract.ValueConstraint[])constraints.clone();
        copy[index] = constraint;
        return copy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 13, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/inference/ContractInferenceInterpreter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalTokenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "inferContracts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "visitExpression";
                break;
            }
            case 13: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/inference/ContractInferenceInterpreter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPolyadic";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "asPreContracts";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "visitStatements";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralConstraint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitPolyadic";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralConstraint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 13, 17 -> new IllegalArgumentException(string);
        };
    }

    private static class CodeBlockContracts {
        final List<PreContract> accumulated = new ArrayList<PreContract>();
        final List<ExpressionRange> varInitializers = new ArrayList<ExpressionRange>();

        private CodeBlockContracts() {
        }

        void addAll(List<PreContract> contracts) {
            if (contracts.isEmpty()) {
                return;
            }
            if (this.varInitializers.isEmpty()) {
                this.accumulated.addAll(contracts);
            } else {
                this.accumulated.add(new SideEffectFilter(this.varInitializers, contracts));
            }
        }

        void registerDeclaration(@NotNull LighterASTNode declStatement, @NotNull LighterAST tree, int scopeStart) {
            if (declStatement == null) {
                CodeBlockContracts.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                CodeBlockContracts.$$$reportNull$$$0(1);
            }
            for (LighterASTNode var : LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)declStatement, (IElementType)JavaElementType.LOCAL_VARIABLE)) {
                LighterASTNode initializer = JavaLightTreeUtil.findExpressionChild((LighterAST)tree, (LighterASTNode)var);
                if (initializer == null) continue;
                this.varInitializers.add(ExpressionRange.create(initializer, scopeStart));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "declStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/inference/ContractInferenceInterpreter$CodeBlockContracts";
            objectArray[2] = "registerDeclaration";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

