/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.codeInspection.dataFlow.java.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class AllNotNullInliner
implements CallInliner {
    private static final CallMatcher NULL_TESTS = CallMatcher.anyOf(CallMatcher.staticCall("org.apache.commons.lang3.ObjectUtils", "allNull").parameterTypes("java.lang.Object..."), CallMatcher.staticCall("org.apache.commons.lang3.ObjectUtils", "allNotNull").parameterTypes("java.lang.Object..."), CallMatcher.staticCall("org.apache.commons.lang3.ObjectUtils", "anyNull").parameterTypes("java.lang.Object..."), CallMatcher.staticCall("org.apache.commons.lang3.ObjectUtils", "anyNotNull").parameterTypes("java.lang.Object..."));

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (builder == null) {
            AllNotNullInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            AllNotNullInliner.$$$reportNull$$$0(1);
        }
        if (!NULL_TESTS.matches((PsiExpression)call) || !MethodCallUtils.isVarArgCall((PsiCall)call)) {
            return false;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        String methodName = call.getMethodExpression().getReferenceName();
        PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)call.getManager(), (GlobalSearchScope)call.getResolveScope());
        boolean allMatchResult = "allNotNull".equals(methodName) || "allNull".equals(methodName);
        builder.push(DfTypes.booleanValue(!allMatchResult));
        for (PsiExpression arg : args) {
            builder.pushExpression(arg).boxUnbox(arg, (PsiType)objectType);
            if ("allNotNull".equals(methodName) || "anyNull".equals(methodName)) {
                builder.ifNotNull();
                continue;
            }
            builder.ifNull();
        }
        builder.not();
        for (int i = 0; i < args.length; ++i) {
            builder.end();
        }
        builder.resultOf((PsiExpression)call);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/dataFlow/java/inliner/AllNotNullInliner";
        objectArray[2] = "tryInlineCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

