/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.codeInspection.dataFlow.java.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.problems.MutabilityProblem;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;

public class CollectionUpdateInliner
implements CallInliner {
    private static final CallMatcher COLLECTION_REMOVEIF = CallMatcher.instanceCall("java.util.Collection", "removeIf").parameterTypes("java.util.function.Predicate");

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (builder == null) {
            CollectionUpdateInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            CollectionUpdateInliner.$$$reportNull$$$0(1);
        }
        if (COLLECTION_REMOVEIF.test(call)) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)qualifier.getType(), (String)"java.util.Collection", (int)0, (boolean)true);
            DfType elementDfType = DfTypes.typedObject(elementType, DfaPsiUtil.getTypeNullability(elementType));
            PsiExpression predicate = call.getArgumentList().getExpressions()[0];
            DfaVariableValue result = builder.createTempVariable((PsiType)PsiTypes.booleanType());
            builder.assignAndPop((DfaValue)result, DfTypes.FALSE).pushExpression(qualifier).ensure(RelationType.IS, Mutability.MUTABLE.asDfType(), new MutabilityProblem((PsiElement)call, true), null).evaluateFunction(predicate).unwrap(SpecialField.COLLECTION_SIZE).dup().push(DfTypes.intValue(0)).ifCondition(RelationType.GT).doWhileUnknown().push(elementDfType).invokeFunction(1, predicate).ifConditionIs(true).pushUnknown().assign().assignAndPop((DfaValue)result, DfTypes.TRUE).end().end().end().pop().push((DfaValue)result);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/dataFlow/java/inliner/CollectionUpdateInliner";
        objectArray[2] = "tryInlineCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

