/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.codeInspection.dataFlow.java.inliner.CallInliner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class SimpleMethodInliner
implements CallInliner {
    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (builder == null) {
            SimpleMethodInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            SimpleMethodInliner.$$$reportNull$$$0(1);
        }
        if (!call.getArgumentList().isEmpty()) {
            return false;
        }
        if (!ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)call.getMethodExpression())) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null || PsiUtil.canBeOverridden((PsiMethod)method) || call.isPhysical() && !method.isPhysical()) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || !PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)call, (boolean)true)) {
            return false;
        }
        if (PsiTypes.voidType().equals((Object)method.getReturnType())) {
            return false;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)call, (boolean)true)) {
            return false;
        }
        PsiReturnStatement statement = (PsiReturnStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.getOnlyStatementInBlock(method.getBody()), PsiReturnStatement.class);
        if (statement == null) {
            return false;
        }
        PsiExpression returnValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getReturnValue());
        if (returnValue == null) {
            return false;
        }
        if (returnValue instanceof PsiLiteralExpression) {
            return false;
        }
        if (!SimpleMethodInliner.isSimple(returnValue)) {
            return false;
        }
        NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)method.getProject()).findEffectiveNullabilityInfo((PsiModifierListOwner)method);
        boolean nonNull = info != null && info.getNullability() == Nullability.NOT_NULL && !info.isInferred();
        builder.pushExpression(returnValue, nonNull ? NullabilityProblemKind.assumeNotNull : NullabilityProblemKind.noProblem).boxUnbox(returnValue, call.getType()).resultOf((PsiExpression)call);
        return true;
    }

    private static boolean isSimple(@NotNull PsiExpression value) {
        Ref hasFieldRefs;
        boolean allowed;
        if (value == null) {
            SimpleMethodInliner.$$$reportNull$$$0(2);
        }
        return (allowed = PsiTreeUtil.processElements((PsiElement)value, arg_0 -> SimpleMethodInliner.lambda$isSimple$0(hasFieldRefs = Ref.create((Object)false), arg_0))) && (Boolean)hasFieldRefs.get() != false;
    }

    private static /* synthetic */ boolean lambda$isSimple$0(Ref hasFieldRefs, PsiElement e) {
        if (!(e instanceof PsiExpression)) {
            return true;
        }
        if (e instanceof PsiInstanceOfExpression || e instanceof PsiParenthesizedExpression || e instanceof PsiLiteralExpression || e instanceof PsiPolyadicExpression || e instanceof PsiUnaryExpression || e instanceof PsiConditionalExpression || e instanceof PsiTypeCastExpression || e instanceof PsiArrayAccessExpression || e instanceof PsiLambdaExpression || e instanceof PsiMethodReferenceExpression || e instanceof PsiThisExpression) {
            return true;
        }
        if (e instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)e).resolve();
            if (target instanceof PsiField && !((PsiField)target).hasModifierProperty("static")) {
                hasFieldRefs.set((Object)true);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inliner/SimpleMethodInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSimple";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

