/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.codeInspection.dataFlow.java.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.java.inliner.ComparatorModel;
import com.intellij.codeInspection.dataFlow.java.inliner.InlinerUtil;
import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.problems.ConsumedStreamProblem;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfBooleanConstantType;
import com.intellij.codeInspection.dataFlow.types.DfStreamStateType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamChainInliner
implements CallInliner {
    private static final String[] TERMINALS = new String[]{"count", "sum", "summaryStatistics", "reduce", "collect", "findFirst", "findAny", "anyMatch", "allMatch", "noneMatch", "toArray", "average", "forEach", "forEachOrdered", "min", "max", "toList", "toSet"};
    private static final CallMatcher TERMINAL_CALL = CallMatcher.instanceCall("java.util.stream.BaseStream", TERMINALS);
    private static final CallMatcher FOR_COLLECTION_TERMINAL = CallMatcher.instanceCall("java.lang.Iterable", "forEach").parameterCount(1);
    private static final CallMatcher COLLECTION_SOURCE = CallMatcher.anyOf(CallMatcher.staticCall("java.util.List", "of"), CallMatcher.staticCall("java.util.Arrays", "asList"));
    private static final CallMatcher FOR_TERMINAL = CallMatcher.instanceCall("java.util.stream.BaseStream", "forEach", "forEachOrdered").parameterCount(1);
    private static final CallMatcher MATCH_TERMINAL = CallMatcher.instanceCall("java.util.stream.BaseStream", "anyMatch", "allMatch", "noneMatch").parameterCount(1);
    private static final CallMatcher SUM_TERMINAL = CallMatcher.instanceCall("java.util.stream.BaseStream", "sum", "count").parameterCount(0);
    private static final CallMatcher TO_ARRAY_TERMINAL = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.stream.Stream", "toArray").parameterCount(0), CallMatcher.instanceCall("java.util.stream.Stream", "toArray").parameterTypes("java.util.function.IntFunction"));
    private static final CallMatcher OPTIONAL_TERMINAL = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.stream.BaseStream", "min", "max").parameterCount(0), CallMatcher.instanceCall("java.util.stream.BaseStream", "reduce").parameterCount(1), CallMatcher.instanceCall("java.util.stream.BaseStream", "findFirst", "findAny").parameterCount(0));
    private static final CallMatcher MIN_MAX_TERMINAL = CallMatcher.instanceCall("java.util.stream.BaseStream", "min", "max").parameterCount(1);
    private static final CallMatcher TWO_ARG_REDUCE = CallMatcher.instanceCall("java.util.stream.Stream", "reduce").parameterTypes("T", "java.util.function.BinaryOperator");
    private static final CallMatcher COLLECT_TERMINAL = CallMatcher.instanceCall("java.util.stream.Stream", "collect").parameterTypes("java.util.stream.Collector");
    private static final CallMatcher TO_LIST_TERMINAL = CallMatcher.instanceCall("java.util.stream.Stream", "toList").parameterCount(0).withLanguageLevelAtLeast(LanguageLevel.JDK_16);
    private static final CallMatcher COLLECT3_TERMINAL = CallMatcher.instanceCall("java.util.stream.Stream", "collect").parameterTypes("java.util.function.Supplier", "java.util.function.BiConsumer", "java.util.function.BiConsumer");
    private static final CallMatcher COUNTING_COLLECTOR = CallMatcher.staticCall("java.util.stream.Collectors", "counting").parameterCount(0);
    private static final CallMatcher COLLECTION_COLLECTOR = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Collectors", "toList", "toSet", "toUnmodifiableList", "toUnmodifiableSet").parameterCount(0), CallMatcher.staticCall("java.util.stream.Collectors", "toCollection").parameterCount(1));
    private static final CallMatcher MAP_COLLECTOR = CallMatcher.staticCall("java.util.stream.Collectors", "toMap", "toConcurrentMap", "toUnmodifiableMap");
    private static final CallMatcher GROUPING_COLLECTOR = CallMatcher.staticCall("java.util.stream.Collectors", "groupingBy", "partitioningBy", "groupingByConcurrent");
    private static final CallMatcher SKIP_STEP = CallMatcher.instanceCall("java.util.stream.BaseStream", "unordered", "parallel", "sequential").parameterCount(0);
    private static final CallMatcher SORTED = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.stream.Stream", "sorted").parameterCount(1), CallMatcher.instanceCall("java.util.stream.Stream", "sorted").parameterCount(0));
    private static final CallMatcher FILTER = CallMatcher.instanceCall("java.util.stream.BaseStream", "filter").parameterCount(1);
    private static final CallMatcher STATE_FILTER = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.stream.BaseStream", "distinct").parameterCount(0), CallMatcher.instanceCall("java.util.stream.BaseStream", "skip", "limit").parameterCount(1));
    private static final CallMatcher BOXED = CallMatcher.instanceCall("java.util.stream.BaseStream", "boxed").parameterCount(0);
    private static final CallMatcher AS_STREAM = CallMatcher.instanceCall("java.util.stream.BaseStream", "asLongStream", "asDoubleStream").parameterCount(0);
    private static final CallMatcher MAP = CallMatcher.instanceCall("java.util.stream.BaseStream", "map", "mapToInt", "mapToLong", "mapToDouble", "mapToObj").parameterCount(1);
    private static final CallMatcher FLAT_MAP = CallMatcher.instanceCall("java.util.stream.BaseStream", "flatMap", "flatMapToInt", "flatMapToLong", "flatMapToDouble").parameterCount(1);
    private static final CallMatcher PEEK = CallMatcher.instanceCall("java.util.stream.BaseStream", "peek").parameterCount(1);
    private static final CallMatcher TAKE_DROP_WHILE = CallMatcher.instanceCall("java.util.stream.BaseStream", "takeWhile", "dropWhile").parameterCount(1);
    private static final CallMatcher STREAM_GENERATE = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Stream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.IntStream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.LongStream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.DoubleStream", "generate").parameterCount(1));
    private static final CallMatcher STREAM_EMPTY = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Stream", "empty").parameterCount(0), CallMatcher.staticCall("java.util.stream.IntStream", "empty").parameterCount(0), CallMatcher.staticCall("java.util.stream.LongStream", "empty").parameterCount(0), CallMatcher.staticCall("java.util.stream.DoubleStream", "empty").parameterCount(0));
    private static final CallMatcher STREAM_OF = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Stream", "of").parameterTypes("T"), CallMatcher.staticCall("java.util.stream.IntStream", "of").parameterTypes("int"), CallMatcher.staticCall("java.util.stream.LongStream", "of").parameterTypes("long"), CallMatcher.staticCall("java.util.stream.DoubleStream", "of").parameterTypes("double"));
    private static final CallMatcher STREAM_OF_ARRAY = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Stream", "of").parameterTypes("T[]"), CallMatcher.staticCall("java.util.stream.IntStream", "of").parameterTypes("int[]"), CallMatcher.staticCall("java.util.stream.LongStream", "of").parameterTypes("long[]"), CallMatcher.staticCall("java.util.stream.DoubleStream", "of").parameterTypes("double[]"));
    private static final CallMatcher ARRAYS_STREAM = CallMatcher.staticCall("java.util.Arrays", "stream").parameterCount(1);
    private static final CallMatcher COLLECTION_STREAM = CallMatcher.instanceCall("java.util.Collection", "stream").parameterCount(0);
    private static final CallMatcher OPTIONAL_STREAM = CallMatcher.instanceCall("java.util.Optional", "stream").parameterCount(0);
    private static final CallMapper<UnaryOperator<Step>> INTERMEDIATE_STEP_MAPPER = new CallMapper<Function<PsiMethodCallExpression, UnaryOperator>>().register(FILTER, call -> next -> new FilterStep((PsiMethodCallExpression)call, (Step)next)).register(MAP, call -> next -> new MapStep((PsiMethodCallExpression)call, (Step)next)).register(FLAT_MAP, call -> next -> new FlatMapStep((PsiMethodCallExpression)call, (Step)next)).register(PEEK, call -> next -> new PeekStep((PsiMethodCallExpression)call, (Step)next)).register(SORTED, call -> next -> new SortedStep((PsiMethodCallExpression)call, (Step)next)).register(BOXED, call -> next -> new BoxedStep((PsiMethodCallExpression)call, (Step)next)).register(STATE_FILTER, call -> next -> new StateFilterStep((PsiMethodCallExpression)call, (Step)next)).register(TAKE_DROP_WHILE, call -> next -> new TakeWhileStep((PsiMethodCallExpression)call, (Step)next));
    private static final CallMapper<Step> TERMINAL_STEP_MAPPER = new CallMapper<Function<PsiMethodCallExpression, Step>>().register(FOR_TERMINAL, call -> new LambdaTerminalStep((PsiMethodCallExpression)call)).register(MATCH_TERMINAL, call -> new MatchTerminalStep((PsiMethodCallExpression)call)).register(SUM_TERMINAL, call -> new SumTerminalStep((PsiMethodCallExpression)call)).register(MIN_MAX_TERMINAL, call -> new MinMaxTerminalStep((PsiMethodCallExpression)call)).register(OPTIONAL_TERMINAL, call -> new OptionalTerminalStep((PsiMethodCallExpression)call)).register(TO_ARRAY_TERMINAL, call -> new ToArrayStep((PsiMethodCallExpression)call)).register(COLLECT3_TERMINAL, call -> new Collect3TerminalStep((PsiMethodCallExpression)call)).register(COLLECT_TERMINAL, call -> StreamChainInliner.createTerminalFromCollector(call)).register(TO_LIST_TERMINAL, call -> new ToCollectionStep((PsiMethodCallExpression)call, null, true)).register(TWO_ARG_REDUCE, call -> new TwoArgReduceStep((PsiMethodCallExpression)call));
    private static final Step NULL_TERMINAL_STEP = new Step(null, null, null){

        @Override
        void before(CFGBuilder builder) {
            builder.flushFields();
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.pop();
        }

        @Override
        void pushResult(CFGBuilder builder) {
            builder.pushUnknown();
        }
    };

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (builder == null) {
            StreamChainInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            StreamChainInliner.$$$reportNull$$$0(1);
        }
        if (FOR_COLLECTION_TERMINAL.test(call)) {
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
            if (qualifierCall == null || !InheritanceUtil.isInheritor((PsiType)qualifierCall.getType(), (String)"java.util.Collection")) {
                return false;
            }
            LambdaTerminalStep terminalStep = new LambdaTerminalStep(call);
            StreamChainInliner.startStreamFromCollection(builder, terminalStep, (PsiExpression)qualifierCall);
            terminalStep.pushResult(builder);
            return true;
        }
        if (TERMINAL_CALL.test(call)) {
            return StreamChainInliner.inlineCompleteStream(builder, call);
        }
        return StreamChainInliner.inlinePartialStream(builder, call);
    }

    private static boolean inlinePartialStream(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        Step firstStep;
        if (builder == null) {
            StreamChainInliner.$$$reportNull$$$0(2);
        }
        if (call == null) {
            StreamChainInliner.$$$reportNull$$$0(3);
        }
        if ((firstStep = StreamChainInliner.buildChain(call, NULL_TERMINAL_STEP)) == NULL_TERMINAL_STEP) {
            return false;
        }
        PsiExpression originalQualifier = firstStep.myCall.getMethodExpression().getQualifierExpression();
        if (originalQualifier == null) {
            return false;
        }
        builder.pushExpression(originalQualifier).chain(b -> StreamChainInliner.checkAndMarkConsumed(b, originalQualifier)).pop().pushUnknown().ifConditionIs(true).chain(b -> StreamChainInliner.buildStreamCFG(b, firstStep, originalQualifier, true)).end().push((DfaValue)builder.getFactory().fromDfType(SpecialField.CONSUMED_STREAM.asDfType(DfStreamStateType.OPEN).meet((DfType)DfTypes.LOCAL_OBJECT).meet((DfType)DfTypes.NOT_NULL_OBJECT)));
        return true;
    }

    private static boolean inlineCompleteStream(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (builder == null) {
            StreamChainInliner.$$$reportNull$$$0(4);
        }
        if (call == null) {
            StreamChainInliner.$$$reportNull$$$0(5);
        }
        PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
        Step terminalStep = StreamChainInliner.createTerminalStep(call);
        Step firstStep = StreamChainInliner.buildChain(qualifierCall, terminalStep);
        PsiExpression originalQualifier = firstStep.myCall.getMethodExpression().getQualifierExpression();
        if (originalQualifier == null) {
            return false;
        }
        StreamChainInliner.buildStreamCFG(builder, firstStep, originalQualifier, false);
        firstStep.pushResult(builder);
        return true;
    }

    private static void buildStreamCFG(CFGBuilder builder, Step firstStep, PsiExpression originalQualifier, boolean originalQualifierAlreadyChecked) {
        PsiType optValueType;
        PsiExpression qualifierExpression;
        PsiExpression collectionExpression;
        PsiType inType = StreamApiUtil.getStreamElementType(originalQualifier.getType(), false);
        PsiMethodCallExpression sourceCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)originalQualifier), PsiMethodCallExpression.class);
        if (STREAM_GENERATE.test(sourceCall)) {
            PsiExpression fn = sourceCall.getArgumentList().getExpressions()[0];
            builder.evaluateFunction(fn).chain(firstStep::before).doWhileUnknown().pushForWrite(builder.createTempVariable(inType)).invokeFunction(0, fn).assign().chain(firstStep::iteration).end();
            return;
        }
        boolean empty = STREAM_EMPTY.test(sourceCall);
        boolean array = ARRAYS_STREAM.test(sourceCall);
        boolean single = STREAM_OF.test(sourceCall);
        if (STREAM_OF_ARRAY.test(sourceCall)) {
            PsiExpression[] args = sourceCall.getArgumentList().getExpressions();
            if (args.length == 0) {
                empty = true;
            } else if (args.length == 1) {
                if (MethodCallUtils.isVarArgCall((PsiCall)sourceCall)) {
                    single = true;
                } else {
                    array = true;
                }
            } else {
                builder.chain(firstStep::before).loopOver(args, builder.createTempVariable(inType), inType).chain(firstStep::iteration).end();
                return;
            }
        }
        if (empty) {
            builder.chain(firstStep::before);
            return;
        }
        if (single) {
            PsiExpression arg = sourceCall.getArgumentList().getExpressions()[0];
            builder.pushForWrite(builder.createTempVariable(inType)).pushExpression(arg).boxUnbox(arg, inType).assign().chain(firstStep::before).chain(firstStep::iteration);
            return;
        }
        if (array) {
            PsiExpression arrayExpression = sourceCall.getArgumentList().getExpressions()[0];
            StreamChainInliner.startStreamFromContainer(builder, firstStep, arrayExpression, SpecialField.ARRAY_LENGTH, inType);
            return;
        }
        if (COLLECTION_STREAM.test(sourceCall) && (collectionExpression = sourceCall.getMethodExpression().getQualifierExpression()) != null) {
            StreamChainInliner.startStreamFromCollection(builder, firstStep, collectionExpression);
            return;
        }
        if (OPTIONAL_STREAM.test(sourceCall) && (qualifierExpression = sourceCall.getMethodExpression().getQualifierExpression()) != null && (optValueType = PsiUtil.substituteTypeParameter((PsiType)qualifierExpression.getType(), (String)"java.util.Optional", (int)0, (boolean)false)) != null) {
            builder.pushForWrite(builder.createTempVariable(optValueType)).pushExpression(qualifierExpression).unwrap(SpecialField.OPTIONAL_VALUE).assign().dup().chain(firstStep::before).ifNull().pop().elseBranch().chain(firstStep::iteration).end();
            return;
        }
        StreamChainInliner.startStreamUnknown(builder, firstStep, originalQualifier, originalQualifierAlreadyChecked, inType);
    }

    private static void startStreamFromCollection(CFGBuilder builder, Step firstStep, PsiExpression collectionExpression) {
        PsiMethodCallExpression call;
        PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)collectionExpression.getType(), (String)"java.util.Collection", (int)0, (boolean)false);
        if (collectionExpression instanceof PsiMethodCallExpression && COLLECTION_SOURCE.matches((PsiExpression)(call = (PsiMethodCallExpression)collectionExpression))) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == 1 && !MethodCallUtils.isVarArgCall((PsiCall)call)) {
                StreamChainInliner.startStreamFromContainer(builder, firstStep, args[0], SpecialField.ARRAY_LENGTH, elementType);
            } else {
                builder.chain(firstStep::before).loopOver(args, builder.createTempVariable(elementType), elementType).chain(firstStep::iteration).end();
            }
        } else {
            StreamChainInliner.startStreamFromContainer(builder, firstStep, collectionExpression, SpecialField.COLLECTION_SIZE, elementType);
        }
    }

    private static void startStreamUnknown(@NotNull CFGBuilder builder, @NotNull Step firstStep, @NotNull PsiExpression originalQualifier, boolean originalQualifierAlreadyChecked, @Nullable PsiType inType) {
        if (builder == null) {
            StreamChainInliner.$$$reportNull$$$0(6);
        }
        if (firstStep == null) {
            StreamChainInliner.$$$reportNull$$$0(7);
        }
        if (originalQualifier == null) {
            StreamChainInliner.$$$reportNull$$$0(8);
        }
        if (!originalQualifierAlreadyChecked) {
            builder.pushExpression(originalQualifier).chain(b -> StreamChainInliner.checkAndMarkConsumed(b, originalQualifier)).pop();
        }
        builder.chain(firstStep::before).pushUnknown().ifConditionIs(true).chain(b -> StreamChainInliner.makeMainLoop(b, firstStep, inType)).end();
    }

    private static void startStreamFromContainer(@NotNull CFGBuilder builder, @NotNull Step firstStep, @NotNull PsiExpression collectionExpression, @NotNull SpecialField sizeField, @Nullable PsiType inType) {
        if (builder == null) {
            StreamChainInliner.$$$reportNull$$$0(9);
        }
        if (firstStep == null) {
            StreamChainInliner.$$$reportNull$$$0(10);
        }
        if (collectionExpression == null) {
            StreamChainInliner.$$$reportNull$$$0(11);
        }
        if (sizeField == null) {
            StreamChainInliner.$$$reportNull$$$0(12);
        }
        builder.pushExpression(collectionExpression).chain(firstStep::before).unwrap(sizeField).push(DfTypes.intValue(0)).ifCondition(RelationType.GT).chain(b -> StreamChainInliner.makeMainLoop(b, firstStep, inType)).end();
    }

    private static void checkAndMarkConsumed(CFGBuilder builder, PsiExpression qualifier) {
        builder.dup().unwrap(SpecialField.CONSUMED_STREAM).ensure(RelationType.NE, DfStreamStateType.CONSUMED, new ConsumedStreamProblem((PsiElement)qualifier), "java.lang.IllegalStateException").push(DfStreamStateType.CONSUMED).assign().pop();
    }

    private static void makeMainLoop(CFGBuilder builder, Step firstStep, PsiType inType) {
        builder.doWhileUnknown().assign((DfaValue)builder.createTempVariable(inType), DfTypes.typedObject(inType, DfaPsiUtil.getTypeNullability(inType))).chain(firstStep::iteration).end();
    }

    private static Step buildChain(PsiMethodCallExpression qualifierCall, Step terminalStep) {
        Step curStep = terminalStep;
        while (qualifierCall != null) {
            if (!SKIP_STEP.test(qualifierCall)) {
                Step nextStep = StreamChainInliner.createIntermediateStep(curStep, qualifierCall);
                if (nextStep == null) break;
                curStep = nextStep;
            }
            qualifierCall = MethodCallUtils.getQualifierMethodCall(qualifierCall);
        }
        return curStep;
    }

    private static Step createIntermediateStep(Step nextStep, PsiMethodCallExpression call) {
        UnaryOperator<Step> stepFactory = INTERMEDIATE_STEP_MAPPER.mapFirst(call);
        if (stepFactory == null) {
            return null;
        }
        return (Step)stepFactory.apply(nextStep);
    }

    private static Step createTerminalStep(PsiMethodCallExpression call) {
        Step step = TERMINAL_STEP_MAPPER.mapFirst(call);
        return step == null ? new UnknownTerminalStep(call) : step;
    }

    private static Step createTerminalFromCollector(PsiMethodCallExpression call) {
        PsiExpression[] args;
        PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiMethodCallExpression.class);
        if (COUNTING_COLLECTOR.matches((PsiExpression)collectorCall)) {
            return new SumTerminalStep(call);
        }
        if (COLLECTION_COLLECTOR.matches((PsiExpression)collectorCall)) {
            String name = Objects.requireNonNull(collectorCall.getMethodExpression().getReferenceName());
            return new ToCollectionStep(call, (PsiExpression)ArrayUtil.getFirstElement((Object[])collectorCall.getArgumentList().getExpressions()), name.startsWith("toUnmodifiable"));
        }
        if (MAP_COLLECTOR.matches((PsiExpression)collectorCall) && (args = collectorCall.getArgumentList().getExpressions()).length >= 2 && args.length <= 4) {
            PsiExpression keyExtractor = args[0];
            PsiExpression valueExtractor = args[1];
            PsiExpression merger = args.length >= 3 ? args[2] : null;
            PsiExpression supplier = args.length >= 4 ? args[3] : null;
            return new ToMapStep(call, keyExtractor, valueExtractor, merger, supplier, "toUnmodifiableMap".equals(collectorCall.getMethodExpression().getReferenceName()));
        }
        if (GROUPING_COLLECTOR.matches((PsiExpression)collectorCall) && (args = collectorCall.getArgumentList().getExpressions()).length >= 1 && args.length <= 3) {
            PsiExpression keyExtractor = args[0];
            PsiExpression downstream = args.length > 1 ? args[args.length - 1] : null;
            PsiExpression supplier = args.length == 3 ? args[1] : null;
            return new GroupingStep(call, keyExtractor, downstream, supplier);
        }
        return new UnknownTerminalStep(call);
    }

    @Override
    public boolean mayInferPreciseType(@NotNull PsiExpression expression) {
        if (expression == null) {
            StreamChainInliner.$$$reportNull$$$0(13);
        }
        return InlinerUtil.isLambdaChainParameterReference(expression, type -> InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.stream.Stream"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstStep";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalQualifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionExpression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sizeField";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inlinePartialStream";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineCompleteStream";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "startStreamUnknown";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "startStreamFromContainer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "mayInferPreciseType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class LambdaTerminalStep
    extends Step {
        LambdaTerminalStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                LambdaTerminalStep.$$$reportNull$$$0(0);
            }
            super(call, null, call.getArgumentList().getExpressions()[0]);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.invokeFunction(1, this.myFunction).pop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$LambdaTerminalStep", "<init>"));
        }
    }

    static abstract class Step {
        final Step myNext;
        final PsiMethodCallExpression myCall;
        final PsiExpression myFunction;

        Step(PsiMethodCallExpression call, Step next, PsiExpression function) {
            this.myNext = next;
            this.myCall = call;
            this.myFunction = function;
        }

        void before(CFGBuilder builder) {
            if (this.myFunction != null) {
                builder.evaluateFunction(this.myFunction);
            }
            if (this.myNext != null) {
                this.myNext.before(builder);
            }
        }

        abstract void iteration(CFGBuilder var1);

        void pushResult(CFGBuilder builder) {
            if (this.myNext != null) {
                this.myNext.pushResult(builder);
            } else {
                builder.push(DfTypes.typedObject(this.myCall.getType()), (PsiExpression)this.myCall);
            }
        }

        boolean expectNotNull() {
            return false;
        }
    }

    static class UnknownTerminalStep
    extends Step {
        UnknownTerminalStep(PsiMethodCallExpression call) {
            super(call, null, null);
        }

        @Override
        void before(CFGBuilder builder) {
            builder.pushUnknown();
            for (PsiExpression arg : this.myCall.getArgumentList().getExpressions()) {
                builder.pushExpression(arg);
            }
            builder.call(this.myCall).pop();
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.pop().flushFields();
        }
    }

    static class SumTerminalStep
    extends TerminalStep {
        private DfType myResultRange;

        SumTerminalStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                SumTerminalStep.$$$reportNull$$$0(0);
            }
            super(call, null);
        }

        @Override
        protected void pushInitialValue(CFGBuilder builder) {
            this.myResultRange = "count".equals(this.myCall.getMethodExpression().getReferenceName()) ? DfTypes.longRange(SumTerminalStep.narrowCountResult(this.myCall)) : DfType.TOP;
            PsiType type = this.myCall.getType();
            if (!(type instanceof PsiPrimitiveType)) {
                type = PsiPrimitiveType.getUnboxedType((PsiType)type);
            }
            if (type == null) {
                builder.pushUnknown();
            } else {
                builder.push((DfType)DfTypes.defaultValue(type)).boxUnbox((PsiExpression)this.myCall, type, this.myCall.getType());
            }
        }

        private static LongRangeSet narrowCountResult(PsiMethodCallExpression call) {
            boolean exact = true;
            while (true) {
                if (FILTER.matches((PsiExpression)(call = MethodCallUtils.getQualifierMethodCall(call))) || STATE_FILTER.matches((PsiExpression)call)) {
                    exact = false;
                    continue;
                }
                if (ARRAYS_STREAM.matches((PsiExpression)call) || COLLECTION_STREAM.matches((PsiExpression)call)) {
                    return LongRangeSet.range((long)0L, (long)Integer.MAX_VALUE);
                }
                if (STREAM_OF.matches((PsiExpression)call)) {
                    return exact ? LongRangeSet.point((long)1L) : LongRangeSet.range((long)0L, (long)1L);
                }
                if (OPTIONAL_STREAM.matches((PsiExpression)call)) {
                    return LongRangeSet.range((long)0L, (long)1L);
                }
                if (STREAM_OF_ARRAY.matches((PsiExpression)call)) {
                    if (MethodCallUtils.isVarArgCall((PsiCall)call)) {
                        return exact ? LongRangeSet.point((long)call.getArgumentList().getExpressionCount()) : LongRangeSet.range((long)0L, (long)call.getArgumentList().getExpressionCount());
                    }
                    return JvmPsiRangeSetUtil.indexRange();
                }
                if (!(BOXED.matches((PsiExpression)call) || MAP.matches((PsiExpression)call) || PEEK.matches((PsiExpression)call) || SORTED.matches((PsiExpression)call) || SKIP_STEP.matches((PsiExpression)call) || AS_STREAM.matches((PsiExpression)call))) break;
            }
            return LongRangeSet.range((long)0L, (long)Long.MAX_VALUE);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.pop().assignAndPop((DfaValue)this.myResult, this.myResultRange);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$SumTerminalStep", "<init>"));
        }
    }

    static class ToCollectionStep
    extends AbstractCollectionStep {
        ToCollectionStep(@NotNull PsiMethodCallExpression call, @Nullable PsiExpression supplier, boolean immutable) {
            if (call == null) {
                ToCollectionStep.$$$reportNull$$$0(0);
            }
            super(call, supplier, immutable);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.flush(SpecialField.COLLECTION_SIZE.createValue(builder.getFactory(), (DfaValue)this.myResult)).pop();
        }

        @Override
        boolean expectNotNull() {
            if (this.myImmutable && !"toList".equals(this.myCall.getMethodExpression().getReferenceName())) {
                return true;
            }
            PsiType collectionType = ExpectedTypeUtils.findExpectedType((PsiExpression)this.myCall, false);
            PsiType itemType = JavaGenericsUtil.getCollectionItemType((PsiType)collectionType, (GlobalSearchScope)this.myCall.getResolveScope());
            return DfaPsiUtil.getTypeNullability(itemType) == Nullability.NOT_NULL;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$ToCollectionStep", "<init>"));
        }
    }

    static class ToMapStep
    extends AbstractCollectionStep {
        @NotNull
        private final PsiExpression myKeyExtractor;
        @NotNull
        private final PsiExpression myValueExtractor;
        @Nullable
        private final PsiExpression myMerger;

        ToMapStep(@NotNull PsiMethodCallExpression call, @NotNull PsiExpression keyExtractor, @NotNull PsiExpression valueExtractor, @Nullable PsiExpression merger, @Nullable PsiExpression supplier, boolean immutable) {
            if (call == null) {
                ToMapStep.$$$reportNull$$$0(0);
            }
            if (keyExtractor == null) {
                ToMapStep.$$$reportNull$$$0(1);
            }
            if (valueExtractor == null) {
                ToMapStep.$$$reportNull$$$0(2);
            }
            super(call, supplier, immutable);
            this.myKeyExtractor = keyExtractor;
            this.myValueExtractor = valueExtractor;
            this.myMerger = merger;
        }

        @Override
        void before(CFGBuilder builder) {
            builder.evaluateFunction(this.myKeyExtractor).evaluateFunction(this.myValueExtractor);
            if (this.myMerger != null) {
                builder.evaluateFunction(this.myMerger);
            }
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.dup().invokeFunction(1, this.myKeyExtractor, this.myImmutable ? Nullability.NOT_NULL : Nullability.NULLABLE).pop().invokeFunction(1, this.myValueExtractor, Nullability.NOT_NULL);
            if (this.myMerger != null) {
                builder.pushUnknown().ifConditionIs(true).pop().push(DfTypes.NOT_NULL_OBJECT).dup().invokeFunction(2, this.myMerger).end();
            }
            builder.flush(SpecialField.COLLECTION_SIZE.createValue(builder.getFactory(), (DfaValue)this.myResult)).pop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "call";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "keyExtractor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueExtractor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$ToMapStep";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class GroupingStep
    extends AbstractCollectionStep {
        @NotNull
        private final PsiExpression myKeyExtractor;
        @Nullable
        private final PsiExpression myDownstream;

        GroupingStep(@NotNull PsiMethodCallExpression call, @NotNull PsiExpression keyExtractor, @Nullable PsiExpression downstream, @Nullable PsiExpression supplier) {
            if (call == null) {
                GroupingStep.$$$reportNull$$$0(0);
            }
            if (keyExtractor == null) {
                GroupingStep.$$$reportNull$$$0(1);
            }
            super(call, supplier, false);
            this.myKeyExtractor = keyExtractor;
            this.myDownstream = downstream;
        }

        @Override
        void before(CFGBuilder builder) {
            builder.evaluateFunction(this.myKeyExtractor).evaluateFunction(this.myDownstream);
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.invokeFunction(1, this.myKeyExtractor, Nullability.NOT_NULL);
            builder.flush(SpecialField.COLLECTION_SIZE.createValue(builder.getFactory(), (DfaValue)this.myResult)).pop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "call";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "keyExtractor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$GroupingStep";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class TwoArgReduceStep
    extends TerminalStep {
        private final PsiExpression myInitialValue;

        TwoArgReduceStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                TwoArgReduceStep.$$$reportNull$$$0(0);
            }
            super(call, call.getArgumentList().getExpressions()[1]);
            this.myInitialValue = call.getArgumentList().getExpressions()[0];
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.push((DfaValue)this.myResult).swap().invokeFunction(2, this.myFunction).assignTo(this.myResult).pop();
        }

        @Override
        protected void pushInitialValue(CFGBuilder builder) {
            builder.pushExpression(this.myInitialValue).boxUnbox(this.myInitialValue, this.myCall.getType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$TwoArgReduceStep", "<init>"));
        }
    }

    static class Collect3TerminalStep
    extends TerminalStep {
        @NotNull
        private final PsiExpression mySupplier;
        @NotNull
        private final PsiExpression myAccumulator;

        Collect3TerminalStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                Collect3TerminalStep.$$$reportNull$$$0(0);
            }
            super(call, call.getArgumentList().getExpressions()[2]);
            PsiExpression[] args = call.getArgumentList().getExpressions();
            this.mySupplier = args[0];
            this.myAccumulator = args[1];
        }

        @Override
        void before(CFGBuilder builder) {
            builder.evaluateFunction(this.mySupplier).evaluateFunction(this.myAccumulator);
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.push((DfaValue)this.myResult).swap().invokeFunction(2, this.myAccumulator).pop();
        }

        @Override
        protected void pushInitialValue(CFGBuilder builder) {
            builder.invokeFunction(0, this.mySupplier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$Collect3TerminalStep", "<init>"));
        }
    }

    static class ToArrayStep
    extends ToCollectionStep {
        ToArrayStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                ToArrayStep.$$$reportNull$$$0(0);
            }
            super(call, (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions()), false);
        }

        @Override
        protected void pushInitialValue(CFGBuilder builder) {
            if (this.myFunction == null) {
                super.pushInitialValue(builder);
            } else {
                builder.pushUnknown().invokeFunction(1, this.myFunction, Nullability.NOT_NULL);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$ToArrayStep", "<init>"));
        }
    }

    static class OptionalTerminalStep
    extends TerminalStep {
        private final boolean myExpectNotNull;

        OptionalTerminalStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                OptionalTerminalStep.$$$reportNull$$$0(0);
            }
            super(call, (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions()));
            String methodName = call.getMethodExpression().getReferenceName();
            this.myExpectNotNull = "findFirst".equals(methodName) || "findAny".equals(methodName);
        }

        @Override
        protected void pushInitialValue(CFGBuilder builder) {
            builder.push(DfaOptionalSupport.getOptionalValue(false));
        }

        @Override
        void iteration(CFGBuilder builder) {
            if (this.myFunction != null) {
                DfaVariableValue optValue = (DfaVariableValue)SpecialField.OPTIONAL_VALUE.createValue(builder.getFactory(), (DfaValue)this.myResult);
                builder.push((DfaValue)optValue).ifNotNull().push(DfTypes.NOT_NULL_OBJECT).swap().invokeFunction(2, this.myFunction, Nullability.NOT_NULL).end();
            }
            DfType source = DfaOptionalSupport.getOptionalValue(true);
            builder.pushForWrite(this.myResult).push(source).assign().splice(2, new int[0]);
        }

        @Override
        boolean expectNotNull() {
            return this.myExpectNotNull;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$OptionalTerminalStep", "<init>"));
        }
    }

    static class MinMaxTerminalStep
    extends TerminalStep {
        private final ComparatorModel myComparatorModel;

        MinMaxTerminalStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                MinMaxTerminalStep.$$$reportNull$$$0(0);
            }
            super(call, null);
            this.myComparatorModel = ComparatorModel.from(call.getArgumentList().getExpressions()[0]);
        }

        @Override
        protected void pushInitialValue(CFGBuilder builder) {
            builder.push(DfaOptionalSupport.getOptionalValue(false));
        }

        @Override
        void before(CFGBuilder builder) {
            this.myComparatorModel.evaluate(builder);
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            this.myComparatorModel.invoke(builder);
            DfType source = DfaOptionalSupport.getOptionalValue(true);
            builder.pushForWrite(this.myResult).push(source).assign().pop();
        }

        @Override
        boolean expectNotNull() {
            return this.myComparatorModel.failsOnNull();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$MinMaxTerminalStep", "<init>"));
        }
    }

    static class MatchTerminalStep
    extends TerminalStep {
        MatchTerminalStep(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                MatchTerminalStep.$$$reportNull$$$0(0);
            }
            super(call, call.getArgumentList().getExpressions()[0]);
        }

        @Override
        protected void pushInitialValue(CFGBuilder builder) {
            builder.push(DfTypes.booleanValue(!"anyMatch".equals(this.myCall.getMethodExpression().getReferenceName())));
        }

        @Override
        void iteration(CFGBuilder builder) {
            DfBooleanConstantType result = DfTypes.booleanValue("anyMatch".equals(this.myCall.getMethodExpression().getReferenceName()));
            builder.invokeFunction(1, this.myFunction).ifConditionIs(!"allMatch".equals(this.myCall.getMethodExpression().getReferenceName())).assignAndPop((DfaValue)this.myResult, result).end();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$MatchTerminalStep", "<init>"));
        }
    }

    static class TakeWhileStep
    extends Step {
        private final boolean myIsTakeWhile;
        private DfaVariableValue myState;

        TakeWhileStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                TakeWhileStep.$$$reportNull$$$0(0);
            }
            super(call, next, call.getArgumentList().getExpressions()[0]);
            this.myIsTakeWhile = "takeWhile".equals(call.getMethodExpression().getReferenceName());
        }

        @Override
        void before(CFGBuilder builder) {
            this.myState = builder.createTempVariable((PsiType)PsiTypes.booleanType());
            builder.assignAndPop((DfaValue)this.myState, DfTypes.booleanValue(true));
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.push((DfaValue)this.myState).ifConditionIs(true).dup().invokeFunction(1, this.myFunction).assignTo(this.myState).pop().end().push((DfaValue)this.myState).ifConditionIs(this.myIsTakeWhile).chain(this.myNext::iteration).elseBranch().pop().end();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$TakeWhileStep", "<init>"));
        }
    }

    static class StateFilterStep
    extends Step {
        StateFilterStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                StateFilterStep.$$$reportNull$$$0(0);
            }
            super(call, next, null);
        }

        @Override
        void before(CFGBuilder builder) {
            for (PsiExpression arg : this.myCall.getArgumentList().getExpressions()) {
                builder.pushExpression(arg).pop();
            }
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.pushUnknown().ifConditionIs(true).chain(this.myNext::iteration).elseBranch().pop().end();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$StateFilterStep", "<init>"));
        }
    }

    static class BoxedStep
    extends Step {
        BoxedStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                BoxedStep.$$$reportNull$$$0(0);
            }
            super(call, next, null);
        }

        @Override
        void iteration(CFGBuilder builder) {
            PsiType outType = StreamApiUtil.getStreamElementType(this.myCall.getType());
            PsiPrimitiveType primitiveType = PsiPrimitiveType.getUnboxedType((PsiType)outType);
            if (primitiveType != null) {
                builder.boxUnbox((PsiExpression)this.myCall, (PsiType)primitiveType, outType).assignTo(builder.createTempVariable(outType));
            }
            this.myNext.iteration(builder);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$BoxedStep", "<init>"));
        }
    }

    static class SortedStep
    extends Step {
        private final ComparatorModel myComparatorModel;

        SortedStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                SortedStep.$$$reportNull$$$0(0);
            }
            super(call, next, null);
            this.myComparatorModel = ComparatorModel.from((PsiExpression)ArrayUtil.getFirstElement((Object[])this.myCall.getArgumentList().getExpressions()));
        }

        @Override
        void before(CFGBuilder builder) {
            this.myComparatorModel.evaluate(builder);
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.dup();
            this.myComparatorModel.invoke(builder);
            this.myNext.iteration(builder);
        }

        @Override
        boolean expectNotNull() {
            return this.myComparatorModel.failsOnNull() || this.myNext.expectNotNull();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$SortedStep", "<init>"));
        }
    }

    static class PeekStep
    extends Step {
        PeekStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                PeekStep.$$$reportNull$$$0(0);
            }
            super(call, next, call.getArgumentList().getExpressions()[0]);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.dup().invokeFunction(1, this.myFunction).pop().chain(this.myNext::iteration);
        }

        @Override
        boolean expectNotNull() {
            return this.myNext.expectNotNull();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$PeekStep", "<init>"));
        }
    }

    static class FlatMapStep
    extends Step {
        private final Step myChain;
        private final PsiParameter myParameter;
        private final PsiExpression myStreamSource;

        FlatMapStep(@NotNull PsiMethodCallExpression call, Step next) {
            PsiExpression body;
            if (call == null) {
                FlatMapStep.$$$reportNull$$$0(0);
            }
            super(call, next, null);
            PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myCall.getArgumentList().getExpressions()[0]), PsiLambdaExpression.class);
            Step chain = null;
            PsiParameter parameter = null;
            PsiExpression streamSource = null;
            if (lambda != null && (parameter = (PsiParameter)ArrayUtil.getFirstElement((Object[])lambda.getParameterList().getParameters())) != null && (body = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody()))) != null) {
                Step filteredNext;
                streamSource = body;
                chain = next;
                if (body instanceof PsiMethodCallExpression && (chain = StreamChainInliner.buildChain((PsiMethodCallExpression)body, filteredNext = new Step(this, call, next, null){

                    @Override
                    void before(CFGBuilder builder) {
                    }

                    @Override
                    void iteration(CFGBuilder builder) {
                        this.myNext.iteration(builder);
                    }
                })) != filteredNext) {
                    streamSource = chain.myCall.getMethodExpression().getQualifierExpression();
                }
            }
            this.myStreamSource = streamSource;
            this.myChain = chain;
            this.myParameter = parameter;
        }

        @Override
        void before(CFGBuilder builder) {
            if (this.myStreamSource == null) {
                PsiExpression arg = this.myCall.getArgumentList().getExpressions()[0];
                builder.evaluateFunction(arg);
            }
            super.before(builder);
        }

        @Override
        void iteration(CFGBuilder builder) {
            if (this.myStreamSource != null) {
                builder.assignTo((PsiVariable)this.myParameter).pop();
                StreamChainInliner.buildStreamCFG(builder, this.myChain, this.myStreamSource, false);
            } else {
                PsiExpression arg = this.myCall.getArgumentList().getExpressions()[0];
                PsiType outType = StreamApiUtil.getStreamElementType(this.myCall.getType());
                builder.invokeFunction(1, arg, Nullability.NULLABLE).ifNotNull().pushUnknown().ifConditionIs(true).doWhileUnknown().push(DfTypes.typedObject(outType, Nullability.UNKNOWN)).chain(this.myNext::iteration).end().end().end();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$FlatMapStep", "<init>"));
        }
    }

    static class MapStep
    extends Step {
        MapStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                MapStep.$$$reportNull$$$0(0);
            }
            super(call, next, call.getArgumentList().getExpressions()[0]);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.invokeFunction(1, this.myFunction, this.myNext.expectNotNull() ? Nullability.NOT_NULL : Nullability.UNKNOWN).assignTo(builder.createTempVariable(StreamApiUtil.getStreamElementType(this.myCall.getType()))).chain(this.myNext::iteration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$MapStep", "<init>"));
        }
    }

    static class FilterStep
    extends Step {
        FilterStep(@NotNull PsiMethodCallExpression call, Step next) {
            if (call == null) {
                FilterStep.$$$reportNull$$$0(0);
            }
            super(call, next, call.getArgumentList().getExpressions()[0]);
        }

        @Override
        void iteration(CFGBuilder builder) {
            builder.dup().invokeFunction(1, this.myFunction).ifConditionIs(true).chain(this.myNext::iteration).elseBranch().pop().end();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$FilterStep", "<init>"));
        }
    }

    static abstract class AbstractCollectionStep
    extends TerminalStep {
        final boolean myImmutable;

        AbstractCollectionStep(@NotNull PsiMethodCallExpression call, @Nullable PsiExpression supplier, boolean immutable) {
            if (call == null) {
                AbstractCollectionStep.$$$reportNull$$$0(0);
            }
            super(call, supplier);
            this.myImmutable = immutable;
        }

        @Override
        protected void pushInitialValue(CFGBuilder builder) {
            if (this.myFunction != null) {
                builder.invokeFunction(0, this.myFunction, Nullability.NOT_NULL);
            } else {
                DfType dfType = DfTypes.typedObject(this.myCall.getType(), Nullability.NOT_NULL);
                dfType = this.myImmutable ? dfType.meet((DfType)Mutability.UNMODIFIABLE.asDfType()) : dfType.meet((DfType)DfTypes.LOCAL_OBJECT);
                if (SpecialField.COLLECTION_SIZE.isMyQualifierType(dfType)) {
                    dfType = dfType.meet(SpecialField.COLLECTION_SIZE.asDfType(DfTypes.intValue(0)));
                }
                builder.push(dfType);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$AbstractCollectionStep", "<init>"));
        }
    }

    static abstract class TerminalStep
    extends Step {
        DfaVariableValue myResult;

        TerminalStep(@NotNull PsiMethodCallExpression call, PsiExpression function) {
            if (call == null) {
                TerminalStep.$$$reportNull$$$0(0);
            }
            super(call, null, function);
        }

        @Override
        void before(CFGBuilder builder) {
            this.myResult = builder.createTempVariable(this.myCall.getType());
            builder.pushForWrite(this.myResult).chain(this::pushInitialValue).assign().pop().chain(x$0 -> super.before((CFGBuilder)x$0));
        }

        protected abstract void pushInitialValue(CFGBuilder var1);

        @Override
        void pushResult(CFGBuilder builder) {
            builder.push((DfaValue)this.myResult, (PsiExpression)this.myCall);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/java/inliner/StreamChainInliner$TerminalStep", "<init>"));
        }
    }
}

