/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.CustomMethodHandlers;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaCallState;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.JavaDfaHelpers;
import com.intellij.codeInspection.dataFlow.java.JavaDfaValueFactory;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaMethodReferenceReturnAnchor;
import com.intellij.codeInspection.dataFlow.java.inst.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.MethodReferenceInstruction;
import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PlainDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.problems.MutabilityProblem;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfStreamStateType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallInstruction
extends ExpressionPushingInstruction {
    private static final Logger LOG = Logger.getInstance(MethodCallInstruction.class);
    private static final Nullability[] EMPTY_NULLABILITY_ARRAY = new Nullability[0];
    @Nullable
    private final PsiType myType;
    private final int myArgCount;
    @NotNull
    private final MutationSignature myMutation;
    @NotNull
    private final PsiElement myContext;
    @Nullable
    private final PsiMethod myTargetMethod;
    private final List<MethodContract> myContracts;
    private final Nullability[] myArgRequiredNullability;
    private final Nullability myReturnNullability;

    public MethodCallInstruction(@NotNull PsiMethodReferenceExpression reference, @NotNull List<? extends MethodContract> contracts) {
        if (reference == null) {
            MethodCallInstruction.$$$reportNull$$$0(0);
        }
        if (contracts == null) {
            MethodCallInstruction.$$$reportNull$$$0(1);
        }
        super((DfaAnchor)new JavaMethodReferenceReturnAnchor(reference));
        this.myContext = reference;
        JavaResolveResult resolveResult = reference.advancedResolve(false);
        this.myTargetMethod = (PsiMethod)ObjectUtils.tryCast((Object)resolveResult.getElement(), PsiMethod.class);
        this.myContracts = Collections.unmodifiableList(contracts);
        int n = this.myArgCount = this.myTargetMethod == null ? 0 : this.myTargetMethod.getParameterList().getParametersCount();
        if (this.myTargetMethod == null) {
            this.myType = null;
            this.myReturnNullability = Nullability.UNKNOWN;
        } else if (this.myTargetMethod.isConstructor()) {
            PsiClass containingClass = this.myTargetMethod.getContainingClass();
            this.myType = containingClass == null ? null : JavaPsiFacade.getElementFactory((Project)this.myTargetMethod.getProject()).createType(containingClass, resolveResult.getSubstitutor());
            this.myReturnNullability = Nullability.NOT_NULL;
        } else {
            this.myType = resolveResult.getSubstitutor().substitute(this.myTargetMethod.getReturnType());
            this.myReturnNullability = DfaPsiUtil.getElementNullabilityForRead(this.myType, (PsiModifierListOwner)this.myTargetMethod);
        }
        this.myArgRequiredNullability = this.myTargetMethod == null ? EMPTY_NULLABILITY_ARRAY : this.calcArgRequiredNullability(resolveResult.getSubstitutor(), this.myTargetMethod.getParameterList().getParameters());
        this.myMutation = MutationSignature.fromMethod(this.myTargetMethod);
    }

    public MethodCallInstruction(@NotNull PsiCall call, @NotNull List<? extends MethodContract> contracts) {
        PsiType psiType;
        PsiExpression[] args;
        JavaExpressionAnchor javaExpressionAnchor;
        if (call == null) {
            MethodCallInstruction.$$$reportNull$$$0(2);
        }
        if (contracts == null) {
            MethodCallInstruction.$$$reportNull$$$0(3);
        }
        if (call instanceof PsiExpression) {
            PsiExpression expr = (PsiExpression)call;
            javaExpressionAnchor = new JavaExpressionAnchor(expr);
        } else {
            javaExpressionAnchor = null;
        }
        super(javaExpressionAnchor);
        this.myContext = call;
        this.myContracts = Collections.unmodifiableList(contracts);
        PsiExpressionList argList = call.getArgumentList();
        PsiExpression[] psiExpressionArray = args = argList != null ? argList.getExpressions() : PsiExpression.EMPTY_ARRAY;
        if (call instanceof PsiExpression) {
            PsiExpression expr = (PsiExpression)call;
            psiType = expr.getType();
        } else {
            psiType = null;
        }
        this.myType = psiType;
        JavaResolveResult result = call.resolveMethodGenerics();
        this.myTargetMethod = (PsiMethod)result.getElement();
        this.myArgCount = this.myTargetMethod != null && MethodCallUtils.isVarArgCall(call) ? this.myTargetMethod.getParameterList().getParametersCount() : args.length;
        PsiSubstitutor substitutor = result.getSubstitutor();
        if (argList != null && this.myTargetMethod != null) {
            PsiParameter[] parameters = this.myTargetMethod.getParameterList().getParameters();
            this.myArgRequiredNullability = this.calcArgRequiredNullability(substitutor, parameters);
        } else {
            this.myArgRequiredNullability = EMPTY_NULLABILITY_ARRAY;
        }
        this.myMutation = MutationSignature.fromCall(call);
        this.myReturnNullability = call instanceof PsiNewExpression ? Nullability.NOT_NULL : DfaPsiUtil.getElementNullabilityForRead(this.myType, (PsiModifierListOwner)this.myTargetMethod);
    }

    public PsiElement getArgumentAnchor(int index) {
        PsiExpressionList argumentList;
        if (this.myContext instanceof PsiCall && (argumentList = ((PsiCall)this.myContext).getArgumentList()) != null) {
            return argumentList.getExpressions()[index];
        }
        if (this.myContext instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)this.myContext).getReferenceNameElement();
        }
        throw new AssertionError();
    }

    private Nullability[] calcArgRequiredNullability(PsiSubstitutor substitutor, PsiParameter[] parameters) {
        if (this.myArgCount == 0) {
            return EMPTY_NULLABILITY_ARRAY;
        }
        int checkedCount = Math.min(this.myArgCount, parameters.length);
        Nullability[] nullabilities = new Nullability[this.myArgCount];
        for (int i = 0; i < checkedCount; ++i) {
            nullabilities[i] = DfaPsiUtil.getElementNullabilityForWrite(substitutor.substitute(parameters[i].getType()), (PsiModifierListOwner)parameters[i]);
        }
        return nullabilities;
    }

    public static boolean isVarArgCall(PsiMethod method, PsiSubstitutor substitutor, PsiExpression[] args, PsiParameter[] parameters) {
        if (!method.isVarArgs()) {
            return false;
        }
        int argCount = args.length;
        int paramCount = parameters.length;
        if (argCount > paramCount || argCount == paramCount - 1) {
            return true;
        }
        if (paramCount > 0 && argCount == paramCount) {
            PsiType lastArgType = args[argCount - 1].getType();
            return lastArgType != null && !substitutor.substitute(parameters[paramCount - 1].getType()).isAssignableFrom(lastArgType);
        }
        return false;
    }

    @Nullable
    public PsiType getResultType() {
        return this.myType;
    }

    public int getArgCount() {
        return this.myArgCount;
    }

    @NotNull
    public MutationSignature getMutationSignature() {
        MutationSignature mutationSignature = this.myMutation;
        if (mutationSignature == null) {
            MethodCallInstruction.$$$reportNull$$$0(4);
        }
        return mutationSignature;
    }

    @Nullable
    public PsiMethod getTargetMethod() {
        return this.myTargetMethod;
    }

    @Nullable
    public Nullability getArgRequiredNullability(int index) {
        return index >= this.myArgRequiredNullability.length ? null : this.myArgRequiredNullability[index];
    }

    public List<MethodContract> getContracts() {
        return this.myContracts;
    }

    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        if (interpreter == null) {
            MethodCallInstruction.$$$reportNull$$$0(5);
        }
        if (stateBefore == null) {
            MethodCallInstruction.$$$reportNull$$$0(6);
        }
        DfaValueFactory factory = interpreter.getFactory();
        DfaCallArguments callArguments = this.popCall(interpreter, stateBefore);
        LinkedHashSet<DfaMemoryState> finalStates = new LinkedHashSet<DfaMemoryState>();
        DfaValue qualifier = callArguments.getQualifier();
        DfType qualifierDfType = stateBefore.getDfType(qualifier);
        PsiMethod realMethod = this.findSpecificMethod(DfaPsiUtil.dfTypeToPsiType(factory.getProject(), qualifierDfType));
        boolean stable = TypeConstraint.fromDfType(qualifierDfType).isExact();
        VariableDescriptor precomputed = JavaDfaValueFactory.getAccessedVariableOrGetter((PsiElement)realMethod, stable);
        if (realMethod != null && precomputed instanceof PlainDescriptor) {
            callArguments = callArguments.makeTransparent();
        }
        DfaValue defaultResult = this.getMethodResultValue(callArguments, stateBefore, factory, realMethod, precomputed);
        DfaCallState initialState = new DfaCallState(stateBefore, callArguments, defaultResult);
        Set<DfaCallState> currentStates = Collections.singleton(initialState);
        if (callArguments.getArguments() != null && !(defaultResult.getDfType() instanceof DfConstantType)) {
            for (MethodContract contract : this.getContracts()) {
                currentStates = MethodCallInstruction.addContractResults(contract, currentStates, factory, finalStates);
                if (currentStates.size() + finalStates.size() <= interpreter.getComplexityLimit()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Too complex contract on " + String.valueOf(this.getContext()) + ", skipping contract processing");
                }
                finalStates.clear();
                currentStates = Collections.singleton(initialState);
                break;
            }
        }
        for (DfaCallState callState : currentStates) {
            callState.getMemoryState().push(defaultResult);
            finalStates.add(callState.getMemoryState());
        }
        DfaInstructionState[] result = new DfaInstructionState[finalStates.size()];
        int i = 0;
        DfaValue[] args = callArguments.toArray();
        for (DfaMemoryState state : finalStates) {
            ContractValue.flushContractTempVariables(state);
            boolean keepNonFlushed = state.peek() instanceof DfaVariableValue;
            DfaValue tos = null;
            if (keepNonFlushed) {
                tos = state.pop();
            }
            callArguments.flush(state, factory, realMethod);
            if (!keepNonFlushed) {
                tos = state.pop();
            }
            this.pushResult(interpreter, state, tos, args);
            result[i++] = this.nextState(interpreter, state);
        }
        return result;
    }

    @Nullable
    public PsiCall getCallExpression() {
        return (PsiCall)ObjectUtils.tryCast((Object)this.myContext, PsiCall.class);
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            MethodCallInstruction.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    public String toString() {
        if (this.myContext instanceof PsiCall) {
            return "CALL_METHOD: " + this.myContext.getText();
        }
        return "CALL_METHOD_REFERENCE: " + this.myContext.getText();
    }

    static Set<DfaCallState> addContractResults(@NotNull MethodContract contract, @NotNull Set<DfaCallState> states, @NotNull DfaValueFactory factory, @NotNull Set<DfaMemoryState> finalStates) {
        if (contract == null) {
            MethodCallInstruction.$$$reportNull$$$0(8);
        }
        if (states == null) {
            MethodCallInstruction.$$$reportNull$$$0(9);
        }
        if (factory == null) {
            MethodCallInstruction.$$$reportNull$$$0(10);
        }
        if (finalStates == null) {
            MethodCallInstruction.$$$reportNull$$$0(11);
        }
        if (contract.isTrivial()) {
            for (DfaCallState callState : states) {
                DfaValue result = contract.getReturnValue().getDfaValue(factory, callState);
                callState.getMemoryState().push(result);
                finalStates.add(callState.getMemoryState());
            }
            return Collections.emptySet();
        }
        LinkedHashSet<DfaCallState> falseStates = new LinkedHashSet<DfaCallState>();
        for (DfaCallState callState : states) {
            for (ContractValue condition : contract.getConditions()) {
                callState = condition.updateState(callState);
            }
            DfaMemoryState state = callState.getMemoryState();
            DfaCallArguments arguments = callState.getCallArguments();
            for (ContractValue contractValue : contract.getConditions()) {
                DfaCondition condition = contractValue.makeCondition(factory, callState.getCallArguments());
                DfaMemoryState falseState = state.createCopy();
                DfaCondition falseCondition = condition.negate();
                if (contract.getReturnValue().isFail() ? falseState.applyCondition(falseCondition) : falseState.applyContractCondition(falseCondition)) {
                    falseStates.add(callState.withMemoryState(falseState).withArguments(arguments));
                }
                if (state.applyContractCondition(condition)) continue;
                state = null;
                break;
            }
            if (state == null) continue;
            DfaValue result = contract.getReturnValue().getDfaValue(factory, callState.withArguments(arguments));
            state.push(result);
            finalStates.add(state);
        }
        return falseStates;
    }

    private PsiMethod findSpecificMethod(@Nullable PsiType qualifierType) {
        PsiExpression qualifierExpression;
        if (this.myTargetMethod == null || qualifierType == null || !PsiUtil.canBeOverridden((PsiMethod)this.myTargetMethod)) {
            return this.myTargetMethod;
        }
        PsiElement psiElement = this.myContext;
        Objects.requireNonNull(psiElement);
        PsiElement psiElement2 = psiElement;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiMethodCallExpression.class, PsiMethodReferenceExpression.class}, (Object)psiElement2, n)) {
            case 0: {
                PsiMethodCallExpression expression = (PsiMethodCallExpression)psiElement2;
                PsiExpression psiExpression = expression.getMethodExpression().getQualifierExpression();
                break;
            }
            case 1: {
                PsiMethodReferenceExpression expression = (PsiMethodReferenceExpression)psiElement2;
                PsiExpression psiExpression = expression.getQualifierExpression();
                break;
            }
            default: {
                PsiExpression psiExpression = qualifierExpression = null;
            }
        }
        if (qualifierExpression instanceof PsiSuperExpression) {
            return this.myTargetMethod;
        }
        return MethodUtils.findSpecificMethod(this.myTargetMethod, qualifierType);
    }

    @NotNull
    private static PsiType narrowReturnType(@NotNull PsiType returnType, @Nullable PsiType qualifierType, @NotNull PsiMethod realMethod) {
        PsiSubstitutor substitutor;
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass subType;
        if (returnType == null) {
            MethodCallInstruction.$$$reportNull$$$0(12);
        }
        if (realMethod == null) {
            MethodCallInstruction.$$$reportNull$$$0(13);
        }
        PsiClass containingClass = realMethod.getContainingClass();
        PsiType realReturnType = realMethod.getReturnType();
        if (containingClass != null && qualifierType instanceof PsiClassType && (containingClass.hasTypeParameters() || containingClass.getContainingClass() != null) && (subType = (classResolveResult = ((PsiClassType)qualifierType).resolveGenerics()).getElement()) != null && !subType.equals((Object)containingClass) && (substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)subType, (PsiSubstitutor)classResolveResult.getSubstitutor())) != null) {
            realReturnType = substitutor.substitute(realReturnType);
        }
        if (realReturnType != null && !realReturnType.equals(returnType) && TypeConversionUtil.erasure((PsiType)returnType).isAssignableFrom(realReturnType)) {
            PsiType psiType = realReturnType;
            if (psiType == null) {
                MethodCallInstruction.$$$reportNull$$$0(14);
            }
            return psiType;
        }
        PsiType psiType = returnType;
        if (psiType == null) {
            MethodCallInstruction.$$$reportNull$$$0(15);
        }
        return psiType;
    }

    @NotNull
    private DfaValue getMethodResultValue(@NotNull DfaCallArguments callArguments, @NotNull DfaMemoryState state, @NotNull DfaValueFactory factory, PsiMethod realMethod, @Nullable VariableDescriptor precomputed) {
        DfaValue value;
        CustomMethodHandlers.CustomMethodHandler handler;
        DfaValue precomputedValue;
        if (callArguments == null) {
            MethodCallInstruction.$$$reportNull$$$0(16);
        }
        if (state == null) {
            MethodCallInstruction.$$$reportNull$$$0(17);
        }
        if (factory == null) {
            MethodCallInstruction.$$$reportNull$$$0(18);
        }
        DfaValue qualifierValue = callArguments.getQualifier();
        DfaValue dfaValue = precomputedValue = precomputed == null ? null : precomputed.createValue(factory, qualifierValue);
        if (callArguments.getArguments() != null && this.myTargetMethod != null && (handler = CustomMethodHandlers.find(this.myTargetMethod)) != null && (value = handler.getMethodResultValue(callArguments, state, factory, this.myTargetMethod)) != null) {
            DfaVariableValue var;
            if (precomputedValue != null && !state.applyCondition(precomputedValue.eq(value))) {
                throw new IllegalStateException("Precalculated value " + String.valueOf(precomputedValue) + " mismatches with method handler result " + String.valueOf(value) + "; method = " + PsiFormatUtil.formatMethod((PsiMethod)this.myTargetMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)2));
            }
            DfaValue dfaValue2 = precomputedValue instanceof DfaVariableValue && !(var = (DfaVariableValue)precomputedValue).isFlushableByCalls() ? precomputedValue : value;
            if (dfaValue2 == null) {
                MethodCallInstruction.$$$reportNull$$$0(19);
            }
            return dfaValue2;
        }
        if (precomputedValue != null) {
            if (this.myReturnNullability == Nullability.NOT_NULL) {
                if (precomputedValue instanceof DfaVariableValue) {
                    state.meetDfType(precomputedValue, (DfType)DfaNullability.NOT_NULL.asDfType());
                } else {
                    precomputedValue = factory.fromDfType(precomputedValue.getDfType().meet((DfType)DfaNullability.NOT_NULL.asDfType()));
                }
            }
            DfaValue dfaValue3 = precomputedValue;
            if (dfaValue3 == null) {
                MethodCallInstruction.$$$reportNull$$$0(20);
            }
            return dfaValue3;
        }
        DfType dfType = this.getMethodResultType(state, factory, realMethod, qualifierValue);
        DfaTypeValue dfaTypeValue = factory.fromDfType(dfType);
        if (dfaTypeValue == null) {
            MethodCallInstruction.$$$reportNull$$$0(21);
        }
        return dfaTypeValue;
    }

    @NotNull
    private DfType getMethodResultType(@NotNull DfaMemoryState state, @NotNull DfaValueFactory factory, PsiMethod realMethod, DfaValue qualifierValue) {
        PsiType type;
        if (state == null) {
            MethodCallInstruction.$$$reportNull$$$0(22);
        }
        if (factory == null) {
            MethodCallInstruction.$$$reportNull$$$0(23);
        }
        if ((type = this.getResultType()) != null && !(type instanceof PsiPrimitiveType)) {
            DfType dfType;
            PsiElement psiElement;
            Nullability nullability = this.myReturnNullability;
            Mutability mutable = Mutability.UNKNOWN;
            if (this.myTargetMethod != null) {
                if (realMethod != this.myTargetMethod) {
                    nullability = DfaPsiUtil.getElementNullabilityForRead(type, (PsiModifierListOwner)realMethod);
                    mutable = Mutability.getMutability((PsiModifierListOwner)realMethod);
                } else {
                    mutable = Mutability.getMutability((PsiModifierListOwner)this.myTargetMethod);
                }
                if (type.hasAnnotation(Mutability.UNMODIFIABLE_ANNOTATION)) {
                    mutable = Mutability.UNMODIFIABLE;
                } else if (type.hasAnnotation(Mutability.UNMODIFIABLE_VIEW_ANNOTATION)) {
                    mutable = Mutability.UNMODIFIABLE_VIEW;
                }
                PsiType qualifierType = DfaPsiUtil.dfTypeToPsiType(factory.getProject(), state.getDfType(qualifierValue));
                type = MethodCallInstruction.narrowReturnType(type, qualifierType, realMethod);
            }
            if ((psiElement = this.getContext()) instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)psiElement;
                dfType = TypeConstraints.exact(type).asDfType().meet((DfType)DfTypes.NOT_NULL_OBJECT);
                if (ConstructionUtils.isEmptyCollectionInitializer((PsiExpression)newExpression)) {
                    dfType = dfType.meet(SpecialField.COLLECTION_SIZE.asDfType(DfTypes.intValue(0)));
                }
                if (this.myMutation.isPure() && !TypeConstraint.fromDfType(dfType).isComparedByEquals()) {
                    dfType = dfType.meet((DfType)DfTypes.LOCAL_OBJECT);
                }
            } else {
                dfType = TypeConstraints.instanceOf(type).asDfType().meet((DfType)DfaNullability.fromNullability(nullability).asDfType());
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.stream.BaseStream")) {
                dfType = dfType.meet((DfType)((DfReferenceType)SpecialField.CONSUMED_STREAM.asDfType(DfStreamStateType.OPEN)).dropNullability());
                if (this.myReturnNullability == Nullability.NOT_NULL) {
                    dfType = dfType.meet((DfType)DfTypes.LOCAL_OBJECT);
                }
            }
            DfType dfType2 = dfType.meet((DfType)mutable.asDfType());
            if (dfType2 == null) {
                MethodCallInstruction.$$$reportNull$$$0(24);
            }
            return dfType2;
        }
        LongRangeSet range = JvmPsiRangeSetUtil.typeRange(type, true);
        if (range != null) {
            if (this.myTargetMethod != null) {
                range = range.meet(JvmPsiRangeSetUtil.fromPsiElement((PsiModifierListOwner)this.myTargetMethod));
            }
            DfType dfType = PsiTypes.longType().equals((Object)type) ? DfTypes.longRange(range) : DfTypes.intRangeClamped(range);
            if (dfType == null) {
                MethodCallInstruction.$$$reportNull$$$0(25);
            }
            return dfType;
        }
        DfType dfType = PsiTypes.voidType().equals((Object)type) ? DfType.TOP : DfTypes.typedObject(type, Nullability.UNKNOWN);
        if (dfType == null) {
            MethodCallInstruction.$$$reportNull$$$0(26);
        }
        return dfType;
    }

    private boolean mayLeakThis(@NotNull DfaMemoryState memState, DfaValue @Nullable [] argValues) {
        MutationSignature signature;
        if (memState == null) {
            MethodCallInstruction.$$$reportNull$$$0(27);
        }
        if ((signature = this.getMutationSignature()) == MutationSignature.unknown()) {
            return true;
        }
        if (JavaDfaHelpers.mayLeakFromType(DfTypes.typedObject(this.getResultType(), Nullability.UNKNOWN))) {
            return true;
        }
        if (argValues == null) {
            return signature.isPure() || signature.equals(MutationSignature.pure().alsoMutatesThis());
        }
        for (int i = 0; i < argValues.length; ++i) {
            DfType type;
            if (!signature.mutatesArg(i) || !JavaDfaHelpers.mayLeakFromType(type = memState.getDfType(argValues[i]))) continue;
            return true;
        }
        return false;
    }

    private DfaValue popQualifier(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState memState, DfaValue @Nullable [] argValues) {
        PsiMethod method;
        PsiMethodReferenceExpression context;
        if (interpreter == null) {
            MethodCallInstruction.$$$reportNull$$$0(28);
        }
        if (memState == null) {
            MethodCallInstruction.$$$reportNull$$$0(29);
        }
        DfaValue value = memState.pop();
        PsiElement psiElement = this.getContext();
        if (psiElement instanceof PsiMethodReferenceExpression && MethodReferenceInstruction.isQualifierDereferenced(context = (PsiMethodReferenceExpression)psiElement)) {
            value = CheckNotNullInstruction.dereference(interpreter, memState, value, NullabilityProblemKind.callMethodRefNPE.problem(context, null));
        }
        DfType dfType = memState.getDfType(value);
        if (this.getMutationSignature().mutatesThis() && !Mutability.fromDfType(dfType).canBeModified() && (method = this.getTargetMethod()) != null && JavaMethodContractUtil.hasExplicitContractAnnotation(method)) {
            interpreter.getListener().onCondition((UnsatisfiedConditionProblem)new MutabilityProblem(this.getContext(), true), value, ThreeState.YES, memState);
            memState.updateDfType(value, type -> {
                DfType dfType;
                if (type instanceof DfReferenceType) {
                    DfReferenceType refType = (DfReferenceType)type;
                    dfType = refType.dropMutability().meet(Mutability.MUTABLE.asDfType());
                } else {
                    dfType = type;
                }
                return dfType;
            });
        }
        TypeConstraint constraint = TypeConstraint.fromDfType(dfType);
        if (!HardcodedContracts.isKnownNoQualifierLeak(this.getTargetMethod()) && !constraint.isArray() && (constraint.isComparedByEquals() || this.mayLeakThis(memState, argValues))) {
            value = JavaDfaHelpers.dropLocality(value, memState);
        }
        return value;
    }

    private DfaValue @Nullable [] popCallArguments(DataFlowInterpreter interpreter, DfaMemoryState memState) {
        int paramCount;
        DfaValue[] argValues = null;
        PsiParameterList paramList = null;
        if (this.myTargetMethod != null && (paramCount = (paramList = this.myTargetMethod.getParameterList()).getParametersCount()) == this.myArgCount) {
            argValues = paramCount == 0 ? DfaValue.EMPTY_ARRAY : new DfaValue[paramCount];
        }
        for (int i = 0; i < this.myArgCount; ++i) {
            DfType dfType;
            PsiElement psiElement;
            boolean parameterMayNotLeak;
            DfaValue arg = memState.pop();
            int paramIndex = this.myArgCount - i - 1;
            boolean bl = parameterMayNotLeak = HardcodedContracts.isKnownNoParameterLeak(this.myTargetMethod) || (this.myMutation.isPure() || this.myMutation.equals(MutationSignature.pure().alsoMutatesArg(paramIndex))) && !JavaDfaHelpers.mayLeakFromType(DfTypes.typedObject(this.getResultType(), Nullability.UNKNOWN));
            if (!parameterMayNotLeak) {
                arg = JavaDfaHelpers.dropLocality(arg, memState);
            }
            if ((psiElement = this.getContext()) instanceof PsiMethodReferenceExpression) {
                PsiParameter parameter;
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)psiElement;
                if (paramList != null && (parameter = paramList.getParameter(paramIndex)) != null) {
                    Nullability nullability = this.getArgRequiredNullability(paramIndex);
                    arg = MethodReferenceInstruction.adaptMethodRefArgument(interpreter, memState, arg, methodRef, parameter, nullability);
                }
            }
            if (this.myMutation.mutatesArg(paramIndex) && !Mutability.fromDfType(dfType = memState.getDfType(arg)).canBeModified() && !memState.getDfType(SpecialField.ARRAY_LENGTH.createValue(interpreter.getFactory(), arg)).equals((Object)DfTypes.intValue(0))) {
                PsiElement anchor = this.getArgumentAnchor(paramIndex);
                interpreter.getListener().onCondition((UnsatisfiedConditionProblem)new MutabilityProblem(anchor, false), arg, ThreeState.YES, memState);
                memState.updateDfType(arg, type -> {
                    DfType dfType;
                    if (type instanceof DfReferenceType) {
                        DfReferenceType refType = (DfReferenceType)type;
                        dfType = refType.dropMutability().meet(Mutability.MUTABLE.asDfType());
                    } else {
                        dfType = type;
                    }
                    return dfType;
                });
            }
            if (argValues == null) continue;
            argValues[paramIndex] = arg;
        }
        return argValues;
    }

    @NotNull
    private DfaCallArguments popCall(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState memState) {
        if (interpreter == null) {
            MethodCallInstruction.$$$reportNull$$$0(30);
        }
        if (memState == null) {
            MethodCallInstruction.$$$reportNull$$$0(31);
        }
        DfaValue[] argValues = this.popCallArguments(interpreter, memState);
        DfaValue qualifier = this.popQualifier(interpreter, memState, argValues);
        return new DfaCallArguments(qualifier, argValues, this.getMutationSignature());
    }

    public List<VariableDescriptor> getRequiredDescriptors(@NotNull DfaValueFactory factory) {
        PsiField field;
        if (factory == null) {
            MethodCallInstruction.$$$reportNull$$$0(32);
        }
        if (this.myTargetMethod != null && (field = PropertyUtil.getFieldOfGetter(this.myTargetMethod)) != null) {
            return List.of(new PlainDescriptor((PsiVariable)field));
        }
        return List.of();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 14, 15, 19, 20, 21, 24, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contracts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/inst/MethodCallInstruction";
                break;
            }
            case 5: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateBefore";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contract";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 10: 
            case 18: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalStates";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realMethod";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callArguments";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/MethodCallInstruction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutationSignature";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowReturnType";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodResultValue";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodResultType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addContractResults";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "narrowReturnType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMethodResultValue";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMethodResultType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mayLeakThis";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "popQualifier";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "popCall";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredDescriptors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 14, 15, 19, 20, 21, 24, 25, 26 -> new IllegalStateException(string);
        };
    }
}

