/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.jvm;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmPsiRangeSetUtil {
    private static final LongRangeSet BYTE_RANGE = LongRangeSet.range((long)-128L, (long)127L);
    private static final LongRangeSet CHAR_RANGE = LongRangeSet.range((long)0L, (long)65535L);
    private static final LongRangeSet SHORT_RANGE = LongRangeSet.range((long)-32768L, (long)32767L);
    private static final LongRangeSet INT_RANGE = LongRangeSet.range((long)Integer.MIN_VALUE, (long)Integer.MAX_VALUE);
    private static final LongRangeSet INDEX_RANGE = LongRangeSet.range((long)0L, (long)Integer.MAX_VALUE);
    private static final String JETBRAINS_RANGE = "org.jetbrains.annotations.Range";
    private static final String CHECKER_RANGE = "org.checkerframework.common.value.qual.IntRange";
    private static final String CHECKER_GTE_NEGATIVE_ONE = "org.checkerframework.checker.index.qual.GTENegativeOne";
    private static final String CHECKER_NON_NEGATIVE = "org.checkerframework.checker.index.qual.NonNegative";
    private static final String CHECKER_POSITIVE = "org.checkerframework.checker.index.qual.Positive";
    private static final String JSR305_NONNEGATIVE = "javax.annotation.Nonnegative";
    private static final String VALIDATION_MIN = "javax.validation.constraints.Min";
    private static final String VALIDATION_MAX = "javax.validation.constraints.Max";
    private static final String JAKARTA_VALIDATION_MIN = "jakarta.validation.constraints.Min";
    private static final String JAKARTA_VALIDATION_MAX = "jakarta.validation.constraints.Max";
    private static final String JAKARTA_VALIDATION_NEGATIVE = "jakarta.validation.constraints.Negative";
    private static final String JAKARTA_VALIDATION_NEGATIVE_OR_ZERO = "jakarta.validation.constraints.NegativeOrZero";
    private static final String JAKARTA_VALIDATION_POSITIVE = "jakarta.validation.constraints.Positive";
    private static final String JAKARTA_VALIDATION_POSITIVE_OR_ZERO = "jakarta.validation.constraints.PositiveOrZero";
    private static final String JMH_PARAM = "org.openjdk.jmh.annotations.Param";
    private static final List<String> ANNOTATIONS = Arrays.asList("org.checkerframework.common.value.qual.IntRange", "org.checkerframework.checker.index.qual.GTENegativeOne", "org.checkerframework.checker.index.qual.NonNegative", "org.checkerframework.checker.index.qual.Positive", "javax.annotation.Nonnegative", "javax.validation.constraints.Min", "javax.validation.constraints.Max", "jakarta.validation.constraints.Min", "jakarta.validation.constraints.Max", "jakarta.validation.constraints.Negative", "jakarta.validation.constraints.NegativeOrZero", "jakarta.validation.constraints.Positive", "jakarta.validation.constraints.PositiveOrZero", "org.openjdk.jmh.annotations.Param");

    private JvmPsiRangeSetUtil() {
    }

    @NotNull
    public static LongRangeSet fromPsiElement(@Nullable PsiModifierListOwner owner) {
        if (owner == null) {
            LongRangeSet longRangeSet = LongRangeSet.all();
            if (longRangeSet == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(0);
            }
            return longRangeSet;
        }
        LongRangeSet longRangeSet = (LongRangeSet)StreamEx.of((Object[])new PsiAnnotation[]{AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{JETBRAINS_RANGE}), owner.getAnnotation(JETBRAINS_RANGE)}).nonNull().append((Object[])AnnotationUtil.findAnnotations((PsiModifierListOwner)owner, ANNOTATIONS)).map(JvmPsiRangeSetUtil::fromAnnotation).foldLeft((Object)LongRangeSet.all(), LongRangeSet::meet);
        if (longRangeSet == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(1);
        }
        return longRangeSet;
    }

    @NotNull
    private static LongRangeSet fromAnnotation(@NotNull PsiAnnotation annotation) {
        String qualifiedName;
        if (annotation == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(2);
        }
        if ((qualifiedName = annotation.getQualifiedName()) == null) {
            LongRangeSet longRangeSet = LongRangeSet.all();
            if (longRangeSet == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(3);
            }
            return longRangeSet;
        }
        switch (qualifiedName) {
            case "org.jetbrains.annotations.Range": 
            case "org.checkerframework.common.value.qual.IntRange": {
                Long from = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"from");
                Long to = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"to");
                if (from == null || to == null || to < from) break;
                LongRangeSet longRangeSet = LongRangeSet.range((long)from, (long)to);
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(4);
                }
                return longRangeSet;
            }
            case "javax.validation.constraints.Min": 
            case "jakarta.validation.constraints.Min": {
                Long minValue = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"value");
                if (minValue == null || annotation.findDeclaredAttributeValue("groups") != null) break;
                LongRangeSet longRangeSet = LongRangeSet.range((long)minValue, (long)Long.MAX_VALUE);
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(5);
                }
                return longRangeSet;
            }
            case "javax.validation.constraints.Max": 
            case "jakarta.validation.constraints.Max": {
                Long maxValue = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"value");
                if (maxValue == null || annotation.findDeclaredAttributeValue("groups") != null) break;
                LongRangeSet longRangeSet = LongRangeSet.range((long)Long.MIN_VALUE, (long)maxValue);
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(6);
                }
                return longRangeSet;
            }
            case "jakarta.validation.constraints.Negative": {
                if (annotation.findDeclaredAttributeValue("groups") != null) break;
                LongRangeSet longRangeSet = LongRangeSet.range((long)Long.MIN_VALUE, (long)-1L);
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(7);
                }
                return longRangeSet;
            }
            case "jakarta.validation.constraints.NegativeOrZero": {
                if (annotation.findDeclaredAttributeValue("groups") != null) break;
                LongRangeSet longRangeSet = LongRangeSet.range((long)Long.MIN_VALUE, (long)0L);
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(8);
                }
                return longRangeSet;
            }
            case "jakarta.validation.constraints.Positive": {
                if (annotation.findDeclaredAttributeValue("groups") != null) break;
                LongRangeSet longRangeSet = LongRangeSet.range((long)1L, (long)Long.MAX_VALUE);
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(9);
                }
                return longRangeSet;
            }
            case "jakarta.validation.constraints.PositiveOrZero": {
                if (annotation.findDeclaredAttributeValue("groups") != null) break;
                LongRangeSet longRangeSet = LongRangeSet.range((long)0L, (long)Long.MAX_VALUE);
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(10);
                }
                return longRangeSet;
            }
            case "org.checkerframework.checker.index.qual.GTENegativeOne": {
                LongRangeSet longRangeSet = LongRangeSet.range((long)-1L, (long)Long.MAX_VALUE);
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(11);
                }
                return longRangeSet;
            }
            case "javax.annotation.Nonnegative": 
            case "org.checkerframework.checker.index.qual.NonNegative": {
                LongRangeSet longRangeSet = LongRangeSet.range((long)0L, (long)Long.MAX_VALUE);
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(12);
                }
                return longRangeSet;
            }
            case "org.checkerframework.checker.index.qual.Positive": {
                LongRangeSet longRangeSet = LongRangeSet.range((long)1L, (long)Long.MAX_VALUE);
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(13);
                }
                return longRangeSet;
            }
            case "org.openjdk.jmh.annotations.Param": {
                Stream<PsiAnnotationMemberValue> stream;
                PsiAnnotationMemberValue attributeValue = annotation.findDeclaredAttributeValue("value");
                if (attributeValue instanceof PsiArrayInitializerMemberValue) {
                    PsiArrayInitializerMemberValue array = (PsiArrayInitializerMemberValue)attributeValue;
                    stream = Arrays.stream(array.getInitializers());
                } else {
                    stream = Stream.of(attributeValue);
                }
                Stream<PsiAnnotationMemberValue> stream2 = stream;
                LongRangeSet longRangeSet = stream2.map(value -> {
                    PsiExpression expr;
                    Object patt0$temp;
                    if (value instanceof PsiExpression && (patt0$temp = ExpressionUtils.computeConstantExpression(expr = (PsiExpression)value)) instanceof String) {
                        String str = (String)patt0$temp;
                        try {
                            return LongRangeSet.point((long)Long.parseLong(str));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return LongRangeSet.all();
                }).reduce(LongRangeSet::join).orElse(LongRangeSet.all());
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(14);
                }
                return longRangeSet;
            }
        }
        LongRangeSet longRangeSet = LongRangeSet.all();
        if (longRangeSet == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(15);
        }
        return longRangeSet;
    }

    @NotNull
    public static LongRangeSet castTo(@NotNull LongRangeSet range, @NotNull PsiPrimitiveType type) {
        if (range == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(16);
        }
        if (type == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(17);
        }
        if (!TypeConversionUtil.isIntegralNumberType((PsiType)type)) {
            throw new IllegalArgumentException(type.toString());
        }
        if (type.equals((Object)PsiTypes.longType())) {
            LongRangeSet longRangeSet = range;
            if (longRangeSet == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(18);
            }
            return longRangeSet;
        }
        if (range.isEmpty()) {
            LongRangeSet longRangeSet = range;
            if (longRangeSet == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(19);
            }
            return longRangeSet;
        }
        Long value = range.getConstantValue();
        if (value != null) {
            long newValue;
            long point = value;
            if (PsiTypes.charType().equals((Object)type)) {
                newValue = (char)point;
            } else if (PsiTypes.intType().equals((Object)type)) {
                newValue = (int)point;
            } else if (PsiTypes.shortType().equals((Object)type)) {
                newValue = (short)point;
            } else if (PsiTypes.byteType().equals((Object)type)) {
                newValue = (byte)point;
            } else {
                throw new IllegalArgumentException(type.toString());
            }
            LongRangeSet longRangeSet = newValue == point ? range : LongRangeSet.point((long)newValue);
            if (longRangeSet == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(20);
            }
            return longRangeSet;
        }
        LongRangeSet result = LongRangeSet.empty();
        for (LongRangeSet subRange : range.asRanges()) {
            result = result.join(JvmPsiRangeSetUtil.castContinuousRange(subRange, type));
        }
        LongRangeSet longRangeSet = result;
        if (longRangeSet == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(21);
        }
        return longRangeSet;
    }

    @NotNull
    private static LongRangeSet castContinuousRange(@NotNull LongRangeSet range, @NotNull PsiPrimitiveType type) {
        if (range == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(22);
        }
        if (type == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(23);
        }
        if (PsiTypes.byteType().equals((Object)type)) {
            LongRangeSet result = JvmPsiRangeSetUtil.mask(range, 8, type);
            assert (BYTE_RANGE.contains(result)) : range;
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(24);
            }
            return longRangeSet;
        }
        if (PsiTypes.shortType().equals((Object)type)) {
            LongRangeSet result = JvmPsiRangeSetUtil.mask(range, 16, type);
            assert (SHORT_RANGE.contains(result)) : range;
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(25);
            }
            return longRangeSet;
        }
        if (PsiTypes.intType().equals((Object)type)) {
            LongRangeSet result = JvmPsiRangeSetUtil.mask(range, 32, type);
            assert (INT_RANGE.contains(result)) : range;
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(26);
            }
            return longRangeSet;
        }
        if (PsiTypes.charType().equals((Object)type)) {
            if (range.min() <= 0L && range.max() >= 65535L) {
                LongRangeSet longRangeSet = CHAR_RANGE;
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(27);
                }
                return longRangeSet;
            }
            if (range.min() >= 0L && range.max() <= 65535L) {
                LongRangeSet longRangeSet = range;
                if (longRangeSet == null) {
                    JvmPsiRangeSetUtil.$$$reportNull$$$0(28);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = range.bitwiseAnd(LongRangeSet.point((long)65535L));
            if (longRangeSet == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(29);
            }
            return longRangeSet;
        }
        throw new IllegalArgumentException(type.toString());
    }

    @NotNull
    private static LongRangeSet mask(@NotNull LongRangeSet range, int size, @NotNull PsiPrimitiveType type) {
        if (range == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(30);
        }
        if (type == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(31);
        }
        long addend = 1L << size - 1;
        if (range.min() <= -addend && range.max() >= addend - 1L) {
            LongRangeSet longRangeSet = Objects.requireNonNull(JvmPsiRangeSetUtil.typeRange((PsiType)type));
            if (longRangeSet == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(32);
            }
            return longRangeSet;
        }
        if (range.min() >= -addend && range.max() <= addend - 1L) {
            LongRangeSet longRangeSet = range;
            if (longRangeSet == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(33);
            }
            return longRangeSet;
        }
        long mask = (1L << size) - 1L;
        LongRangeSet longRangeSet = range.plus(LongRangeSet.point((long)addend), LongRangeType.INT64).bitwiseAnd(LongRangeSet.point((long)mask)).plus(LongRangeSet.point((long)(-addend)), LongRangeType.INT64);
        if (longRangeSet == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(34);
        }
        return longRangeSet;
    }

    @Nullable
    public static LongRangeSet typeRange(@Nullable PsiType type) {
        return JvmPsiRangeSetUtil.typeRange(type, false);
    }

    @Nullable
    public static LongRangeSet typeRange(@Nullable PsiType type, boolean useAnnotations) {
        if (!(type instanceof PsiPrimitiveType) && !TypeConversionUtil.isPrimitiveWrapper((PsiType)type)) {
            return null;
        }
        if ((type = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)type)) != null) {
            LongRangeSet result = LongRangeSet.all();
            if (useAnnotations) {
                for (PsiAnnotation annotation : type.getAnnotations()) {
                    result = result.meet(JvmPsiRangeSetUtil.fromAnnotation(annotation));
                }
            }
            if (type.equals(PsiTypes.byteType())) {
                return BYTE_RANGE.meet(result);
            }
            if (type.equals(PsiTypes.charType())) {
                return CHAR_RANGE.meet(result);
            }
            if (type.equals(PsiTypes.shortType())) {
                return SHORT_RANGE.meet(result);
            }
            if (type.equals(PsiTypes.intType())) {
                return INT_RANGE.meet(result);
            }
            if (type.equals(PsiTypes.longType())) {
                return result;
            }
        }
        return null;
    }

    @NotNull
    public static LongRangeType getLongRangeType(@NotNull PsiType jvmType) {
        if (jvmType == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(35);
        }
        if (jvmType.equals(PsiTypes.longType())) {
            LongRangeType longRangeType = LongRangeType.INT64;
            if (longRangeType == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(36);
            }
            return longRangeType;
        }
        if (jvmType.equals(PsiTypes.intType())) {
            LongRangeType longRangeType = LongRangeType.INT32;
            if (longRangeType == null) {
                JvmPsiRangeSetUtil.$$$reportNull$$$0(37);
            }
            return longRangeType;
        }
        throw new UnsupportedOperationException();
    }

    public static LongRangeSet indexRange() {
        return INDEX_RANGE;
    }

    @NotNull
    @Nls
    public static String getPresentationText(@NotNull LongRangeSet range, PsiType type) {
        LongRangeSet fullTypeRange;
        if (range == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(38);
        }
        String string = range.getPresentationText((fullTypeRange = JvmPsiRangeSetUtil.typeRange(type)) == null ? LongRangeSet.all() : fullTypeRange);
        if (string == null) {
            JvmPsiRangeSetUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    public static LongRangeBinOp binOpFromToken(IElementType token) {
        if (token == null) {
            return null;
        }
        if (token.equals(JavaTokenType.PLUS)) {
            return LongRangeBinOp.PLUS;
        }
        if (token.equals(JavaTokenType.MINUS)) {
            return LongRangeBinOp.MINUS;
        }
        if (token.equals(JavaTokenType.AND)) {
            return LongRangeBinOp.AND;
        }
        if (token.equals(JavaTokenType.OR)) {
            return LongRangeBinOp.OR;
        }
        if (token.equals(JavaTokenType.XOR)) {
            return LongRangeBinOp.XOR;
        }
        if (token.equals(JavaTokenType.PERC)) {
            return LongRangeBinOp.MOD;
        }
        if (token.equals(JavaTokenType.DIV)) {
            return LongRangeBinOp.DIV;
        }
        if (token.equals(JavaTokenType.LTLT)) {
            return LongRangeBinOp.SHL;
        }
        if (token.equals(JavaTokenType.GTGT)) {
            return LongRangeBinOp.SHR;
        }
        if (token.equals(JavaTokenType.GTGTGT)) {
            return LongRangeBinOp.USHR;
        }
        if (token.equals(JavaTokenType.ASTERISK)) {
            return LongRangeBinOp.MUL;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 16, 17, 22, 23, 30, 31, 35, 38 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/JvmPsiRangeSetUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 16: 
            case 22: 
            case 30: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 17: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromPsiElement";
                break;
            }
            case 2: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 35: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/JvmPsiRangeSetUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotation";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "castTo";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "castContinuousRange";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "mask";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongRangeType";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromAnnotation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "castTo";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "castContinuousRange";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "mask";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getLongRangeType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 16, 17, 22, 23, 30, 31, 35, 38 -> new IllegalArgumentException(string);
        };
    }
}

