/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.jvm.descriptors;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.java.JavaDfaValueFactory;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.JvmVariableDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PlainDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PsiVarDescriptor;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.stream.LongStream;
import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrayElementDescriptor
extends JvmVariableDescriptor {
    private final int myIndex;

    private ArrayElementDescriptor(int index) {
        this.myIndex = index;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    public DfType getDfType(@Nullable DfaVariableValue qualifier) {
        if (qualifier == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(0);
            }
            return dfType;
        }
        TypeConstraint constraint = TypeConstraint.fromDfType(qualifier.getDfType());
        DfType dfType = constraint.getArrayComponentType();
        if (dfType == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(1);
        }
        return dfType;
    }

    @NotNull
    public DfType getInitialDfType(@NotNull DfaVariableValue thisValue, @Nullable PsiElement context) {
        if (thisValue == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(2);
        }
        DfaVariableValue qualifier = thisValue.getQualifier();
        DfType dfType = this.getDfType(qualifier);
        if (qualifier != null && dfType instanceof DfReferenceType) {
            PsiVarDescriptor descriptor;
            VariableDescriptor qualDescriptor = qualifier.getDescriptor();
            int depth = 1;
            while (qualDescriptor instanceof ArrayElementDescriptor) {
                ++depth;
                if ((qualifier = qualifier.getQualifier()) == null) break;
                qualDescriptor = qualifier.getDescriptor();
            }
            if ((descriptor = (PsiVarDescriptor)ObjectUtils.tryCast((Object)qualDescriptor, PsiVarDescriptor.class)) != null) {
                PsiType psiType = descriptor.getType(qualifier);
                for (int i = 0; i < depth; ++i) {
                    if (!(psiType instanceof PsiArrayType)) {
                        DfType dfType2 = dfType;
                        if (dfType2 == null) {
                            ArrayElementDescriptor.$$$reportNull$$$0(3);
                        }
                        return dfType2;
                    }
                    PsiArrayType arrayType = (PsiArrayType)psiType;
                    psiType = arrayType.getComponentType();
                }
                DfType dfType3 = dfType.meet((DfType)DfaNullability.fromNullability(DfaPsiUtil.getTypeNullability(psiType)).asDfType());
                if (dfType3 == null) {
                    ArrayElementDescriptor.$$$reportNull$$$0(4);
                }
                return dfType3;
            }
        }
        DfType dfType4 = dfType;
        if (dfType4 == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(5);
        }
        return dfType4;
    }

    @NotNull
    public String toString() {
        String string = "[" + this.myIndex + "]";
        if (string == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isStable() {
        return false;
    }

    public int hashCode() {
        return this.myIndex + 1234567;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ArrayElementDescriptor && ((ArrayElementDescriptor)obj).myIndex == this.myIndex;
    }

    @Contract(value="_, null, _ -> null")
    @Nullable
    public static DfaValue getArrayElementValue(@NotNull DfaValueFactory factory, @Nullable DfaValue array, int index) {
        PsiExpression constantArrayElement;
        DfaVariableValue arrayDfaVar;
        block8: {
            block7: {
                if (factory == null) {
                    ArrayElementDescriptor.$$$reportNull$$$0(7);
                }
                if (!(array instanceof DfaVariableValue)) break block7;
                arrayDfaVar = (DfaVariableValue)array;
                if (index >= 0) break block8;
            }
            return null;
        }
        DfType componentType = TypeConstraint.fromDfType(arrayDfaVar.getDfType()).getArrayComponentType();
        if (componentType == DfType.BOTTOM) {
            return null;
        }
        PsiVariable arrayPsiVar = (PsiVariable)ObjectUtils.tryCast((Object)arrayDfaVar.getPsiVariable(), PsiVariable.class);
        if (arrayPsiVar != null && (constantArrayElement = ExpressionUtils.getConstantArrayElement(arrayPsiVar, index)) != null) {
            PsiType elementType = constantArrayElement.getType();
            if (componentType instanceof DfReferenceType && elementType instanceof PsiPrimitiveType && !TypeConstraint.fromDfType(componentType).isPrimitiveWrapper()) {
                componentType = DfTypes.typedObject((PsiType)((PsiPrimitiveType)elementType).getBoxedType((PsiElement)constantArrayElement), Nullability.UNKNOWN).meet(componentType);
            }
            return ArrayElementDescriptor.getAdvancedExpressionDfaValue(factory, constantArrayElement, componentType);
        }
        return new ArrayElementDescriptor(index).createValue(factory, (DfaValue)arrayDfaVar);
    }

    @NotNull
    public static DfaValue getArrayElementValue(@NotNull DfaValueFactory factory, @Nullable DfaValue array, @NotNull LongRangeSet indexSet) {
        long max;
        PsiVariable var;
        if (factory == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(8);
        }
        if (indexSet == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(9);
        }
        if (array instanceof DfaTypeValue && (var = (PsiVariable)array.getDfType().getConstantOfType(PsiVariable.class)) != null) {
            array = new PlainDescriptor(var).createValue(factory, null);
        }
        if (!(array instanceof DfaVariableValue)) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            if (dfaTypeValue == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(10);
            }
            return dfaTypeValue;
        }
        DfaVariableValue arrayDfaVar = (DfaVariableValue)array;
        if (indexSet.isEmpty()) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            if (dfaTypeValue == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(11);
            }
            return dfaTypeValue;
        }
        long min = indexSet.min();
        if (min == (max = indexSet.max()) && min >= 0L && min < Integer.MAX_VALUE) {
            DfaValue value2 = ArrayElementDescriptor.getArrayElementValue(factory, array, (int)min);
            Object object = value2 == null ? factory.getUnknown() : value2;
            if (object == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(12);
            }
            return object;
        }
        PsiVariable arrayPsiVar = (PsiVariable)ObjectUtils.tryCast((Object)arrayDfaVar.getPsiVariable(), PsiVariable.class);
        if (arrayPsiVar == null) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            if (dfaTypeValue == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(13);
            }
            return dfaTypeValue;
        }
        DfType arrayType = arrayDfaVar.getDfType();
        DfType targetType = TypeConstraint.fromDfType(arrayType).getArrayComponentType();
        PsiExpression[] elements = ExpressionUtils.getConstantArrayElements(arrayPsiVar);
        if (elements == null || elements.length == 0) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            if (dfaTypeValue == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(14);
            }
            return dfaTypeValue;
        }
        if ((indexSet = indexSet.meet(LongRangeSet.range((long)0L, (long)(elements.length - 1)))).isEmpty() || indexSet.isCardinalityBigger(100L)) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            if (dfaTypeValue == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(15);
            }
            return dfaTypeValue;
        }
        DfaValue dfaValue = ((StreamEx)((StreamEx)LongStreamEx.of((LongStream)indexSet.stream()).mapToObj(idx -> ArrayElementDescriptor.getAdvancedExpressionDfaValue(factory, elements[(int)idx], targetType)).prefix(DfaValue::unite)).takeWhileInclusive(value -> !DfaTypeValue.isUnknown((DfaValue)value))).reduce((a, b) -> b).orElseGet(() -> ((DfaValueFactory)factory).getUnknown());
        if (dfaValue == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(16);
        }
        return dfaValue;
    }

    @NotNull
    private static DfaValue getAdvancedExpressionDfaValue(@NotNull DfaValueFactory factory, @Nullable PsiExpression expression, @NotNull DfType targetType) {
        if (factory == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(17);
        }
        if (targetType == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(18);
        }
        if (expression == null) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            if (dfaTypeValue == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(19);
            }
            return dfaTypeValue;
        }
        DfaValue value = JavaDfaValueFactory.getExpressionDfaValue(factory, expression);
        if (value != null) {
            if (value instanceof DfaVariableValue) {
                value = factory.fromDfType(value.getDfType());
            }
            DfaValue dfaValue = DfaUtil.boxUnbox(value, targetType);
            if (dfaValue == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(20);
            }
            return dfaValue;
        }
        if (expression instanceof PsiConditionalExpression) {
            DfaValue dfaValue = ArrayElementDescriptor.getAdvancedExpressionDfaValue(factory, ((PsiConditionalExpression)expression).getThenExpression(), targetType).unite(ArrayElementDescriptor.getAdvancedExpressionDfaValue(factory, ((PsiConditionalExpression)expression).getElseExpression(), targetType));
            if (dfaValue == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(21);
            }
            return dfaValue;
        }
        PsiType type = expression.getType();
        if (expression instanceof PsiArrayInitializerExpression) {
            int length = ((PsiArrayInitializerExpression)expression).getInitializerCount();
            DfaTypeValue dfaTypeValue = factory.fromDfType(SpecialField.ARRAY_LENGTH.asDfType(DfTypes.intValue(length)).meet(DfTypes.typedObject(type, Nullability.NOT_NULL)));
            if (dfaTypeValue == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(22);
            }
            return dfaTypeValue;
        }
        DfType dfType = DfTypes.typedObject(type, NullabilityUtil.getExpressionNullability(expression));
        if (dfType instanceof DfPrimitiveType && targetType instanceof DfPrimitiveType && dfType.meet(targetType) == DfType.BOTTOM) {
            if (targetType instanceof DfIntegralType && targetType instanceof DfLongType) {
                DfaTypeValue dfaTypeValue = factory.fromDfType(((DfPrimitiveType)dfType).castTo(PsiTypes.longType()));
                if (dfaTypeValue == null) {
                    ArrayElementDescriptor.$$$reportNull$$$0(23);
                }
                return dfaTypeValue;
            }
            DfaTypeValue dfaTypeValue = factory.fromDfType(targetType);
            if (dfaTypeValue == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(24);
            }
            return dfaTypeValue;
        }
        DfaValue dfaValue = DfaUtil.boxUnbox((DfaValue)factory.fromDfType(dfType), targetType);
        if (dfaValue == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(25);
        }
        return dfaValue;
    }

    @NotNull
    public static DfType getArrayComponentType(@NotNull DfaValue array) {
        PsiVarDescriptor varDescriptor;
        DfaVariableValue var;
        VariableDescriptor variableDescriptor;
        DfType componentType;
        if (array == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(26);
        }
        if ((componentType = TypeConstraint.fromDfType(array.getDfType()).getArrayComponentType()) instanceof DfReferenceType && array instanceof DfaVariableValue && (variableDescriptor = (var = (DfaVariableValue)array).getDescriptor()) instanceof PsiVarDescriptor && (variableDescriptor = (varDescriptor = (PsiVarDescriptor)variableDescriptor).getType(var.getQualifier())) instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)variableDescriptor;
            DfType dfType = componentType.meet((DfType)DfaNullability.fromNullability(DfaPsiUtil.getTypeNullability(arrayType.getComponentType())).asDfType());
            if (dfType == null) {
                ArrayElementDescriptor.$$$reportNull$$$0(27);
            }
            return dfType;
        }
        DfType dfType = componentType;
        if (dfType == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(28);
        }
        return dfType;
    }

    @Nullable
    public static ArrayElementDescriptor fromArrayAccess(@NotNull PsiArrayAccessExpression arrayAccess) {
        ArrayElementDescriptor arrayElementDescriptor;
        Object object;
        if (arrayAccess == null) {
            ArrayElementDescriptor.$$$reportNull$$$0(29);
        }
        if ((object = ExpressionUtils.computeConstantExpression(arrayAccess.getIndexExpression())) instanceof Integer) {
            Integer index = (Integer)object;
            arrayElementDescriptor = new ArrayElementDescriptor(index);
        } else {
            arrayElementDescriptor = null;
        }
        return arrayElementDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 7, 8, 9, 17, 18, 26, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/ArrayElementDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisValue";
                break;
            }
            case 7: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSet";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 26: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/ArrayElementDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialDfType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElementValue";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdvancedExpressionDfaValue";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayComponentType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInitialDfType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElementValue";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAdvancedExpressionDfaValue";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getArrayComponentType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fromArrayAccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 7, 8, 9, 17, 18, 26, 29 -> new IllegalArgumentException(string);
        };
    }
}

