/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.jvm.descriptors;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.jvm.FieldChecker;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PsiVarDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.ThisDescriptor;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlainDescriptor
extends PsiVarDescriptor {
    @NotNull
    private final PsiVariable myVariable;
    private final int myHash;
    private static final CallMatcher READ_OBJECT = CallMatcher.instanceCall("java.lang.Object", "readObject").parameterTypes("java.io.ObjectInputStream");

    public PlainDescriptor(@NotNull PsiVariable variable) {
        if (variable == null) {
            PlainDescriptor.$$$reportNull$$$0(0);
        }
        this.myVariable = variable;
        this.myHash = System.identityHashCode(variable);
    }

    @NotNull
    public String toString() {
        String string = PsiFormatUtil.formatVariable((PsiVariable)this.myVariable, (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (string == null) {
            PlainDescriptor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    PsiType getType(@Nullable DfaVariableValue qualifier) {
        PsiType type = this.myVariable.getType();
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).toArrayType();
        }
        return PlainDescriptor.getSubstitutor((PsiElement)this.myVariable, qualifier).substitute(type);
    }

    public PsiVariable getPsiElement() {
        return this.myVariable;
    }

    public boolean isStable() {
        return PsiUtil.isJvmLocalVariable((PsiElement)this.myVariable) || this.myVariable.hasModifierProperty("final") && !PlainDescriptor.hasInitializationHacks(this.myVariable);
    }

    @Override
    @NotNull
    public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier) {
        DfaTypeValue typeValue;
        PsiField field;
        if (factory == null) {
            PlainDescriptor.$$$reportNull$$$0(2);
        }
        if (this.myVariable.hasModifierProperty("volatile")) {
            PsiType type = this.getType((DfaVariableValue)ObjectUtils.tryCast((Object)qualifier, DfaVariableValue.class));
            DfaTypeValue dfaTypeValue = factory.fromDfType(DfTypes.typedObject(type, DfaPsiUtil.getElementNullabilityForRead(type, (PsiModifierListOwner)this.myVariable)));
            if (dfaTypeValue == null) {
                PlainDescriptor.$$$reportNull$$$0(3);
            }
            return dfaTypeValue;
        }
        if (PsiUtil.isJvmLocalVariable((PsiElement)this.myVariable) || this.myVariable instanceof PsiField && this.myVariable.hasModifierProperty("static")) {
            if (qualifier != null && qualifier != factory.getUnknown()) {
                DfaTypeValue dfaTypeValue = factory.getUnknown();
                if (dfaTypeValue == null) {
                    PlainDescriptor.$$$reportNull$$$0(4);
                }
                return dfaTypeValue;
            }
            DfaVariableValue dfaVariableValue = factory.getVarFactory().createVariableValue((VariableDescriptor)this);
            if (dfaVariableValue == null) {
                PlainDescriptor.$$$reportNull$$$0(5);
            }
            return dfaVariableValue;
        }
        if (qualifier instanceof DfaTypeValue && (field = (PsiField)(typeValue = (DfaTypeValue)qualifier).getDfType().getConstantOfType(PsiField.class)) != null) {
            qualifier = factory.getVarFactory().createVariableValue((VariableDescriptor)new PlainDescriptor((PsiVariable)field));
        }
        DfaValue dfaValue = super.createValue(factory, qualifier);
        if (dfaValue == null) {
            PlainDescriptor.$$$reportNull$$$0(6);
        }
        return dfaValue;
    }

    public int hashCode() {
        return this.myHash;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PlainDescriptor && ((PlainDescriptor)obj).myVariable == this.myVariable;
    }

    @NotNull
    public static DfaVariableValue createVariableValue(@NotNull DfaValueFactory factory, @NotNull PsiVariable variable) {
        if (factory == null) {
            PlainDescriptor.$$$reportNull$$$0(7);
        }
        if (variable == null) {
            PlainDescriptor.$$$reportNull$$$0(8);
        }
        DfaVariableValue qualifier = null;
        if (variable instanceof PsiField && !variable.hasModifierProperty("static")) {
            qualifier = ThisDescriptor.createThisValue(factory, ((PsiField)variable).getContainingClass());
        }
        DfaVariableValue dfaVariableValue = factory.getVarFactory().createVariableValue((VariableDescriptor)new PlainDescriptor(variable), qualifier);
        if (dfaVariableValue == null) {
            PlainDescriptor.$$$reportNull$$$0(9);
        }
        return dfaVariableValue;
    }

    @Override
    @NotNull
    DfaNullability calcCanBeNull(@NotNull DfaVariableValue value, @Nullable PsiElement context) {
        PsiType itemType;
        PsiForeachStatement forEach;
        PsiExpression iteratedValue;
        PsiType type;
        Nullability nullability;
        PsiElement qualifierDescriptor;
        PsiClass methodClass;
        PsiMember member;
        PsiField field;
        if (value == null) {
            PlainDescriptor.$$$reportNull$$$0(10);
        }
        if ((field = (PsiField)ObjectUtils.tryCast((Object)this.myVariable, PsiField.class)) != null && PlainDescriptor.hasInitializationHacks((PsiVariable)field)) {
            DfaNullability dfaNullability = DfaNullability.FLUSHED;
            if (dfaNullability == null) {
                PlainDescriptor.$$$reportNull$$$0(11);
            }
            return dfaNullability;
        }
        DfaVariableValue qualifier = value.getQualifier();
        if (field != null && context != null && (member = (PsiMember)ObjectUtils.tryCast((Object)context.getParent(), PsiMember.class)) != null && (methodClass = member.getContainingClass()) != null && methodClass.equals((Object)field.getContainingClass())) {
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)member, PsiMethod.class);
            VariableDescriptor variableDescriptor = qualifierDescriptor = qualifier == null ? null : qualifier.getDescriptor();
            if (qualifierDescriptor instanceof ThisDescriptor && ((ThisDescriptor)qualifierDescriptor).getPsiElement().equals((Object)methodClass)) {
                if (member instanceof PsiClassInitializer) {
                    DfaNullability dfaNullability = DfaNullability.UNKNOWN;
                    if (dfaNullability == null) {
                        PlainDescriptor.$$$reportNull$$$0(12);
                    }
                    return dfaNullability;
                }
                if (method != null) {
                    if (!method.isConstructor() && PlainDescriptor.isPossiblyNonInitialized(field, method)) {
                        DfaNullability dfaNullability = DfaNullability.NULLABLE;
                        if (dfaNullability == null) {
                            PlainDescriptor.$$$reportNull$$$0(13);
                        }
                        return dfaNullability;
                    }
                    if (method.isConstructor()) {
                        DfaNullability dfaNullability = DfaNullability.UNKNOWN;
                        if (dfaNullability == null) {
                            PlainDescriptor.$$$reportNull$$$0(14);
                        }
                        return dfaNullability;
                    }
                }
            }
            if (method != null && field.hasModifierProperty("static") && PlainDescriptor.isPossiblyNonInitialized(field, method)) {
                DfaNullability dfaNullability = DfaNullability.NULLABLE;
                if (dfaNullability == null) {
                    PlainDescriptor.$$$reportNull$$$0(15);
                }
                return dfaNullability;
            }
        }
        if ((nullability = DfaPsiUtil.getElementNullabilityForRead(type = this.getType(qualifier), (PsiModifierListOwner)this.myVariable)) != Nullability.UNKNOWN) {
            DfaNullability dfaNullability = DfaNullability.fromNullability(nullability);
            if (dfaNullability == null) {
                PlainDescriptor.$$$reportNull$$$0(16);
            }
            return dfaNullability;
        }
        if (this.myVariable instanceof PsiParameter && (qualifierDescriptor = this.myVariable.getParent()) instanceof PsiForeachStatement && (iteratedValue = (forEach = (PsiForeachStatement)qualifierDescriptor).getIteratedValue()) != null && (itemType = JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue)) != null) {
            DfaNullability dfaNullability = DfaNullability.fromNullability(DfaPsiUtil.getElementNullabilityForRead(itemType, (PsiModifierListOwner)this.myVariable));
            if (dfaNullability == null) {
                PlainDescriptor.$$$reportNull$$$0(17);
            }
            return dfaNullability;
        }
        if (field != null && FieldChecker.getChecker(context).canTrustFieldInitializer(field)) {
            DfaNullability dfaNullability = DfaNullability.fromNullability((Nullability)NullabilityUtil.getNullabilityFromFieldInitializers((PsiField)field).second);
            if (dfaNullability == null) {
                PlainDescriptor.$$$reportNull$$$0(18);
            }
            return dfaNullability;
        }
        DfaNullability dfaNullability = DfaNullability.UNKNOWN;
        if (dfaNullability == null) {
            PlainDescriptor.$$$reportNull$$$0(19);
        }
        return dfaNullability;
    }

    private static boolean isPossiblyNonInitialized(@NotNull PsiField target, @NotNull PsiMethod placeMethod) {
        if (target == null) {
            PlainDescriptor.$$$reportNull$$$0(20);
        }
        if (placeMethod == null) {
            PlainDescriptor.$$$reportNull$$$0(21);
        }
        if (target.getType() instanceof PsiPrimitiveType) {
            return false;
        }
        PsiClass placeClass = placeMethod.getContainingClass();
        if (placeClass == null || placeClass != target.getContainingClass()) {
            return false;
        }
        if (!placeMethod.hasModifierProperty("static") && target.hasModifierProperty("static")) {
            return false;
        }
        if (!target.hasModifierProperty("static") && !placeMethod.hasModifierProperty("static") && (PlainDescriptor.isReadResolveMethodWithoutReadObject(placeMethod, placeClass) || PlainDescriptor.methodCanBeCalledFromConstructorBeforeFieldInitializing(target, placeMethod, placeClass))) {
            return true;
        }
        return PlainDescriptor.getAccessOffset(placeMethod) < PlainDescriptor.getWriteOffset(target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isReadResolveMethodWithoutReadObject(@NotNull PsiMethod method, @NotNull PsiClass aClass) {
        if (method == null) {
            PlainDescriptor.$$$reportNull$$$0(22);
        }
        if (aClass == null) {
            PlainDescriptor.$$$reportNull$$$0(23);
        }
        if (!"readResolve".equals(method.getName())) return false;
        if (!method.getParameterList().isEmpty()) return false;
        if (aClass.isRecord()) return false;
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.io.Serializable")) return false;
        if (ContainerUtil.exists((Object[])aClass.findMethodsByName("readObject", false), READ_OBJECT::methodMatches)) return false;
        return true;
    }

    private static boolean methodCanBeCalledFromConstructorBeforeFieldInitializing(@NotNull PsiField target, @NotNull PsiMethod method, @NotNull PsiClass placeClass) {
        if (target == null) {
            PlainDescriptor.$$$reportNull$$$0(24);
        }
        if (method == null) {
            PlainDescriptor.$$$reportNull$$$0(25);
        }
        if (placeClass == null) {
            PlainDescriptor.$$$reportNull$$$0(26);
        }
        if (target.hasInitializer() || method.isConstructor()) {
            return false;
        }
        TargetCallInfo callInfo = PlainDescriptor.findTargetCallIn(target, placeClass, method);
        if (callInfo == null) {
            return false;
        }
        if (JavaPsiRecordUtil.isCompactConstructor((PsiMethod)callInfo.constructor())) {
            return true;
        }
        return !VariableAccessUtils.variableIsAssignedAtPoint((PsiVariable)target, (PsiElement)callInfo.constructor, (PsiElement)callInfo.call);
    }

    @Nullable
    private static TargetCallInfo findTargetCallIn(@NotNull PsiField field, @NotNull PsiClass contextClass, @NotNull PsiMethod method) {
        if (field == null) {
            PlainDescriptor.$$$reportNull$$$0(27);
        }
        if (contextClass == null) {
            PlainDescriptor.$$$reportNull$$$0(28);
        }
        if (method == null) {
            PlainDescriptor.$$$reportNull$$$0(29);
        }
        ConstructorMethodInfo constructorMethodInfo = PlainDescriptor.getConstructorMethodInfo(contextClass);
        PsiManager psiManager = contextClass.getManager();
        if (field.hasModifierProperty("final") || PlainDescriptor.hasOnlyOneInsideCall(constructorMethodInfo)) {
            Map<PsiMethod, PsiMethodCallExpression> methodsByCall = constructorMethodInfo.methods().get(method.getName());
            if (methodsByCall == null) {
                return null;
            }
            for (PsiMethod methodByCall : methodsByCall.keySet()) {
                if (!psiManager.areElementsEquivalent((PsiElement)methodByCall, (PsiElement)method)) continue;
                PsiMethodCallExpression call = methodsByCall.get(methodByCall);
                PsiMethod constructor = constructorMethodInfo.constructor();
                if (call == null || constructor == null) continue;
                return new TargetCallInfo(constructor, call);
            }
        }
        return null;
    }

    @NotNull
    private static ConstructorMethodInfo getConstructorMethodInfo(final @NotNull PsiClass contextClass) {
        if (contextClass == null) {
            PlainDescriptor.$$$reportNull$$$0(30);
        }
        ConstructorMethodInfo constructorMethodInfo = (ConstructorMethodInfo)CachedValuesManager.getCachedValue((PsiElement)contextClass, () -> {
            CachedValueProvider.Result emptyResult = CachedValueProvider.Result.create((Object)new ConstructorMethodInfo(Map.of(), null, false), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            PsiMethod context = PlainDescriptor.findOnlyOneNotChainConstructor(contextClass);
            if (context == null) {
                return emptyResult;
            }
            final PsiManager psiManager = context.getManager();
            var visitor2 = new JavaRecursiveElementWalkingVisitor(){
                final Map<String, Map<PsiMethod, PsiMethodCallExpression>> collectedMethods = new HashMap<String, Map<PsiMethod, PsiMethodCallExpression>>();
                boolean callsOutside = false;

                public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                public void visitClass(@NotNull PsiClass aClass) {
                    if (aClass == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
                    if (aClass == null) {
                        1.$$$reportNull$$$0(2);
                    }
                }

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression methodCallExpression) {
                    PsiExpression qualifier;
                    if (methodCallExpression == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if ((qualifier = methodCallExpression.getMethodExpression().getQualifierExpression()) == null || qualifier instanceof PsiThisExpression) {
                        PsiMethod resolvedMethod = methodCallExpression.resolveMethod();
                        if (resolvedMethod != null && resolvedMethod.getContainingClass() != null && psiManager.areElementsEquivalent((PsiElement)resolvedMethod.getContainingClass(), (PsiElement)contextClass)) {
                            this.collectedMethods.computeIfAbsent(resolvedMethod.getName(), k -> new HashMap()).putIfAbsent(resolvedMethod, methodCallExpression);
                        } else {
                            this.callsOutside = true;
                        }
                    } else {
                        this.callsOutside = true;
                    }
                    super.visitMethodCallExpression(methodCallExpression);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "aClass";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "methodCallExpression";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/PlainDescriptor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLambdaExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitClass";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitAnonymousClass";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethodCallExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            context.accept((PsiElementVisitor)visitor2);
            ConstructorMethodInfo info = new ConstructorMethodInfo(visitor2.collectedMethods, context, visitor2.callsOutside);
            return CachedValueProvider.Result.create((Object)info, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (constructorMethodInfo == null) {
            PlainDescriptor.$$$reportNull$$$0(31);
        }
        return constructorMethodInfo;
    }

    @Nullable
    private static PsiMethod findOnlyOneNotChainConstructor(@NotNull PsiClass contextClass) {
        if (contextClass == null) {
            PlainDescriptor.$$$reportNull$$$0(32);
        }
        ArrayList<PsiMethod> notChainConstructors = new ArrayList<PsiMethod>();
        for (PsiMethod constructor : contextClass.getConstructors()) {
            PsiMethodCallExpression callInConstructor = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor);
            if (JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)callInConstructor)) continue;
            notChainConstructors.add(constructor);
        }
        if (notChainConstructors.size() != 1) {
            return null;
        }
        PsiMethod targetConstructor = (PsiMethod)notChainConstructors.getFirst();
        PsiCodeBlock constructorBody = targetConstructor.getBody();
        if (constructorBody == null || constructorBody.getStatements().length == 0) {
            return null;
        }
        if (JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)targetConstructor) != null) {
            return null;
        }
        return targetConstructor;
    }

    private static boolean hasOnlyOneInsideCall(@NotNull ConstructorMethodInfo constructorMethodInfo) {
        if (constructorMethodInfo == null) {
            PlainDescriptor.$$$reportNull$$$0(33);
        }
        Map<String, Map<PsiMethod, PsiMethodCallExpression>> methods = constructorMethodInfo.methods();
        if (constructorMethodInfo.hasCallOutside() || methods.size() != 1) {
            return false;
        }
        Map<PsiMethod, PsiMethodCallExpression> callExpressionMap = methods.entrySet().iterator().next().getValue();
        return callExpressionMap.size() == 1;
    }

    private static int getWriteOffset(PsiField target) {
        boolean isFinal = target.hasModifierProperty("final");
        int offset = Integer.MAX_VALUE;
        PsiExpression fieldInitializer = target.getInitializer();
        if (fieldInitializer != null) {
            offset = fieldInitializer.getTextOffset();
            if (isFinal) {
                return offset;
            }
        }
        PsiClass aClass = Objects.requireNonNull(target.getContainingClass());
        PsiClassInitializer[] initializers = aClass.getInitializers();
        Predicate<PsiElement> writesToTarget = element -> !PsiTreeUtil.processElements((PsiElement)element, e -> !(e instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)e)) || !ExpressionUtils.isReferenceTo((PsiExpression)e, (PsiVariable)target));
        Predicate<PsiElement> hasSideEffectCall = element -> !PsiTreeUtil.findChildrenOfType((PsiElement)element, PsiMethodCallExpression.class).stream().map(PsiCall::resolveMethod).allMatch(method -> method != null && JavaMethodContractUtil.isPure(method));
        for (PsiClassInitializer psiClassInitializer : initializers) {
            if (psiClassInitializer.hasModifierProperty("static") != target.hasModifierProperty("static")) continue;
            if (!isFinal && hasSideEffectCall.test((PsiElement)psiClassInitializer)) {
                offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
                break;
            }
            if (!writesToTarget.test((PsiElement)psiClassInitializer)) continue;
            offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
            if (!isFinal) break;
            return offset;
        }
        if (!isFinal) {
            for (PsiClassInitializer psiClassInitializer : aClass.getFields()) {
                if (psiClassInitializer.hasModifierProperty("static") != target.hasModifierProperty("static") || !hasSideEffectCall.test((PsiElement)psiClassInitializer.getInitializer()) && !writesToTarget.test((PsiElement)psiClassInitializer)) continue;
                offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
                break;
            }
        }
        return offset;
    }

    private static int getAccessOffset(PsiMethod referrer) {
        PsiClass aClass = Objects.requireNonNull(referrer.getContainingClass());
        boolean isStatic = referrer.hasModifierProperty("static");
        for (PsiField field : aClass.getFields()) {
            Predicate<PsiExpression> callToMethod;
            PsiExpression initializer;
            if (field.hasModifierProperty("static") != isStatic || !ExpressionUtils.isMatchingChildAlwaysExecuted(initializer = field.getInitializer(), callToMethod = e -> {
                if (!(e instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)e;
                return call.getMethodExpression().isReferenceTo((PsiElement)referrer) && (isStatic || ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)call.getMethodExpression()));
            })) continue;
            return field.getTextRange().getStartOffset();
        }
        return Integer.MAX_VALUE;
    }

    public static boolean hasInitializationHacks(@NotNull PsiVariable var) {
        if (var == null) {
            PlainDescriptor.$$$reportNull$$$0(34);
        }
        if (!(var instanceof PsiField)) {
            return false;
        }
        PsiClass containingClass = ((PsiField)var).getContainingClass();
        return containingClass != null && System.class.getName().equals(containingClass.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/PlainDescriptor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeMethod";
                break;
            }
            case 22: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeClass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorMethodInfo";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/PlainDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableValue";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "calcCanBeNull";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorMethodInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 31: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createVariableValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcCanBeNull";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPossiblyNonInitialized";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isReadResolveMethodWithoutReadObject";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "methodCanBeCalledFromConstructorBeforeFieldInitializing";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findTargetCallIn";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorMethodInfo";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findOnlyOneNotChainConstructor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyOneInsideCall";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasInitializationHacks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 31 -> new IllegalStateException(string);
        };
    }

    private record TargetCallInfo(@NotNull PsiMethod constructor, @NotNull PsiMethodCallExpression call) {
        @NotNull
        private final PsiMethod constructor;
        @NotNull
        private final PsiMethodCallExpression call;

        private TargetCallInfo(@NotNull PsiMethod constructor, @NotNull PsiMethodCallExpression call) {
            if (constructor == null) {
                TargetCallInfo.$$$reportNull$$$0(0);
            }
            if (call == null) {
                TargetCallInfo.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public PsiMethod constructor() {
            PsiMethod psiMethod = this.constructor;
            if (psiMethod == null) {
                TargetCallInfo.$$$reportNull$$$0(2);
            }
            return psiMethod;
        }

        @NotNull
        public PsiMethodCallExpression call() {
            PsiMethodCallExpression psiMethodCallExpression = this.call;
            if (psiMethodCallExpression == null) {
                TargetCallInfo.$$$reportNull$$$0(3);
            }
            return psiMethodCallExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/PlainDescriptor$TargetCallInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/PlainDescriptor$TargetCallInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "constructor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private record ConstructorMethodInfo(@NotNull Map<String, Map<PsiMethod, PsiMethodCallExpression>> methods, @Nullable PsiMethod constructor, boolean hasCallOutside) {
        @NotNull
        private final Map<String, Map<PsiMethod, PsiMethodCallExpression>> methods;

        private ConstructorMethodInfo(@NotNull Map<String, Map<PsiMethod, PsiMethodCallExpression>> methods, @Nullable PsiMethod constructor, boolean hasCallOutside) {
            if (methods == null) {
                ConstructorMethodInfo.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public Map<String, Map<PsiMethod, PsiMethodCallExpression>> methods() {
            Map<String, Map<PsiMethod, PsiMethodCallExpression>> map = this.methods;
            if (map == null) {
                ConstructorMethodInfo.$$$reportNull$$$0(1);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methods";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/PlainDescriptor$ConstructorMethodInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/PlainDescriptor$ConstructorMethodInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "methods";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

