/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfFloatConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiTypes;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DfFloatRangeType
implements DfFloatType {
    private final float myFrom;
    private final float myTo;
    private final boolean myInvert;
    private final boolean myNaN;

    DfFloatRangeType(float from, float to, boolean invert, boolean nan) {
        this.myFrom = from;
        this.myTo = to;
        this.myInvert = invert;
        this.myNaN = nan;
    }

    static DfType create(float from, float to, boolean invert, boolean nan) {
        assert (!Float.isNaN(from));
        assert (!Float.isNaN(to));
        if (Float.compare(from, to) > 0) {
            return nan ? new DfFloatConstantType(Float.NaN) : DfType.BOTTOM;
        }
        if (to == Float.POSITIVE_INFINITY && from == Float.NEGATIVE_INFINITY) {
            if (invert) {
                return nan ? new DfFloatConstantType(Float.NaN) : DfType.BOTTOM;
            }
            return new DfFloatRangeType(from, to, false, nan);
        }
        if (to == Float.POSITIVE_INFINITY) {
            to = DfFloatRangeType.nextDown(from);
            from = Float.NEGATIVE_INFINITY;
            boolean bl = invert = !invert;
        }
        if (!nan && !invert && Float.compare(from, to) == 0) {
            return new DfFloatConstantType(from);
        }
        if (!nan && invert && from == Float.NEGATIVE_INFINITY && to == DfFloatRangeType.nextDown(Float.POSITIVE_INFINITY)) {
            return new DfFloatConstantType(Float.POSITIVE_INFINITY);
        }
        return new DfFloatRangeType(from, to, invert, nan);
    }

    public boolean isSuperType(@NotNull DfType other) {
        if (other == null) {
            DfFloatRangeType.$$$reportNull$$$0(0);
        }
        if (other == DfType.BOTTOM || other.equals((Object)this)) {
            return true;
        }
        if (other instanceof DfFloatConstantType) {
            float val = ((Float)((DfFloatConstantType)other).getValue()).floatValue();
            if (Float.isNaN(val)) {
                return this.myNaN;
            }
            int from = Float.compare(this.myFrom, val);
            int to = Float.compare(val, this.myTo);
            return (from <= 0 && to <= 0) != this.myInvert;
        }
        if (other instanceof DfFloatRangeType) {
            DfFloatRangeType range = (DfFloatRangeType)other;
            if (range.myNaN && !this.myNaN) {
                return false;
            }
            if (!this.myInvert && this.myFrom == Float.NEGATIVE_INFINITY && this.myTo == Float.POSITIVE_INFINITY) {
                return true;
            }
            int from = Float.compare(this.myFrom, range.myFrom);
            int to = Float.compare(range.myTo, this.myTo);
            if (this.myInvert) {
                if (range.myInvert) {
                    return from >= 0 && to >= 0;
                }
                return Float.compare(range.myTo, this.myFrom) < 0 || Float.compare(range.myFrom, this.myTo) > 0;
            }
            return !range.myInvert && from <= 0 && to <= 0;
        }
        return false;
    }

    @NotNull
    public DfType join(@NotNull DfType other) {
        if (other == null) {
            DfFloatRangeType.$$$reportNull$$$0(1);
        }
        DfType dfType = this.join(other, false);
        if (dfType == null) {
            DfFloatRangeType.$$$reportNull$$$0(2);
        }
        return dfType;
    }

    @Nullable
    public DfType tryJoinExactly(@NotNull DfType other) {
        if (other == null) {
            DfFloatRangeType.$$$reportNull$$$0(3);
        }
        return this.join(other, true);
    }

    DfType join(@NotNull DfType other, boolean exact) {
        DfFloatRangeType res;
        if (other == null) {
            DfFloatRangeType.$$$reportNull$$$0(4);
        }
        if (other.isSuperType((DfType)this)) {
            return other;
        }
        if (this.isSuperType(other)) {
            return this;
        }
        if (other instanceof DfFloatConstantType) {
            float value = ((Float)((DfFloatConstantType)other).getValue()).floatValue();
            if (Float.isNaN(value)) {
                return DfFloatRangeType.create(this.myFrom, this.myTo, this.myInvert, true);
            }
            return this.joinRange(value, value, exact);
        }
        if (!(other instanceof DfFloatRangeType)) {
            return exact ? null : TOP;
        }
        DfFloatRangeType range = (DfFloatRangeType)other;
        DfFloatRangeType dfFloatRangeType = res = range.myNaN && !this.myNaN ? new DfFloatRangeType(this.myFrom, this.myTo, this.myInvert, true) : this;
        if (range.myInvert) {
            if (range.myFrom > Float.NEGATIVE_INFINITY && (res = res.joinRange(Float.NEGATIVE_INFINITY, DfFloatRangeType.nextDown(range.myFrom), exact)) == null) {
                return null;
            }
            if (range.myTo < Float.POSITIVE_INFINITY && (res = res.joinRange(DfFloatRangeType.nextUp(range.myTo), Float.POSITIVE_INFINITY, exact)) == null) {
                return null;
            }
        } else {
            res = res.joinRange(range.myFrom, range.myTo, exact);
        }
        return res;
    }

    private DfFloatRangeType joinRange(float from, float to, boolean exact) {
        if (Float.compare(from, to) > 0) {
            return this;
        }
        if (this.myInvert) {
            if (Float.compare(to, this.myFrom) < 0 || Float.compare(from, this.myTo) > 0) {
                return this;
            }
            int fromCmp = Float.compare(this.myFrom, from);
            int toCmp = Float.compare(to, this.myTo);
            if (fromCmp >= 0 && toCmp >= 0 || fromCmp < 0 && toCmp < 0) {
                return exact ? null : (DfFloatRangeType)DfFloatRangeType.create(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, false, this.myNaN);
            }
            if (fromCmp >= 0) {
                return (DfFloatRangeType)DfFloatRangeType.create(DfFloatRangeType.nextUp(to), this.myTo, true, this.myNaN);
            }
            return (DfFloatRangeType)DfFloatRangeType.create(this.myFrom, DfFloatRangeType.nextDown(from), true, this.myNaN);
        }
        if (Float.compare(this.myTo, DfFloatRangeType.nextDown(from)) < 0 || Float.compare(to, DfFloatRangeType.nextDown(this.myFrom)) < 0) {
            if (this.myFrom == Float.NEGATIVE_INFINITY && to == Float.POSITIVE_INFINITY) {
                return (DfFloatRangeType)DfFloatRangeType.create(DfFloatRangeType.nextUp(this.myTo), DfFloatRangeType.nextDown(from), true, this.myNaN);
            }
            if (exact) {
                return null;
            }
        }
        return (DfFloatRangeType)DfFloatRangeType.create(Math.min(this.myFrom, from), Math.max(this.myTo, to), false, this.myNaN);
    }

    @NotNull
    public DfType meet(@NotNull DfType other) {
        boolean nan;
        if (other == null) {
            DfFloatRangeType.$$$reportNull$$$0(5);
        }
        if (other.isSuperType((DfType)this)) {
            DfFloatRangeType dfFloatRangeType = this;
            if (dfFloatRangeType == null) {
                DfFloatRangeType.$$$reportNull$$$0(6);
            }
            return dfFloatRangeType;
        }
        if (this.isSuperType(other)) {
            DfType dfType = other;
            if (dfType == null) {
                DfFloatRangeType.$$$reportNull$$$0(7);
            }
            return dfType;
        }
        if (!(other instanceof DfFloatRangeType)) {
            DfType dfType = DfType.BOTTOM;
            if (dfType == null) {
                DfFloatRangeType.$$$reportNull$$$0(8);
            }
            return dfType;
        }
        DfFloatRangeType range = (DfFloatRangeType)other;
        boolean bl = nan = range.myNaN && this.myNaN;
        if (!this.myInvert) {
            if (!range.myInvert) {
                float from = Math.max(this.myFrom, range.myFrom);
                float to = Math.min(this.myTo, range.myTo);
                DfType dfType = DfFloatRangeType.create(from, to, false, nan);
                if (dfType == null) {
                    DfFloatRangeType.$$$reportNull$$$0(9);
                }
                return dfType;
            }
            int fromCmp = Float.compare(this.myFrom, range.myFrom);
            int toCmp = Float.compare(range.myTo, this.myTo);
            if (fromCmp >= 0) {
                DfType dfType = DfFloatRangeType.create(Math.max(this.myFrom, DfFloatRangeType.nextUp(range.myTo)), this.myTo, false, nan);
                if (dfType == null) {
                    DfFloatRangeType.$$$reportNull$$$0(10);
                }
                return dfType;
            }
            if (toCmp >= 0) {
                DfType dfType = DfFloatRangeType.create(this.myFrom, Math.min(this.myTo, DfFloatRangeType.nextDown(range.myFrom)), false, nan);
                if (dfType == null) {
                    DfFloatRangeType.$$$reportNull$$$0(11);
                }
                return dfType;
            }
            if (this.myFrom == Float.NEGATIVE_INFINITY && this.myTo == Float.POSITIVE_INFINITY) {
                DfType dfType = DfFloatRangeType.create(range.myFrom, range.myTo, true, nan);
                if (dfType == null) {
                    DfFloatRangeType.$$$reportNull$$$0(12);
                }
                return dfType;
            }
            DfType dfType = DfFloatRangeType.create(this.myFrom, this.myTo, false, nan);
            if (dfType == null) {
                DfFloatRangeType.$$$reportNull$$$0(13);
            }
            return dfType;
        }
        if (!range.myInvert) {
            DfType dfType = range.meet(this);
            if (dfType == null) {
                DfFloatRangeType.$$$reportNull$$$0(14);
            }
            return dfType;
        }
        if (this.myTo >= Math.nextDown(range.myFrom) && range.myTo >= Math.nextDown(this.myFrom)) {
            float from = Math.min(this.myFrom, range.myFrom);
            float to = Math.max(this.myTo, range.myTo);
            DfType dfType = DfFloatRangeType.create(from, to, true, nan);
            if (dfType == null) {
                DfFloatRangeType.$$$reportNull$$$0(15);
            }
            return dfType;
        }
        if (this.myFrom < range.myFrom) {
            DfType dfType = DfFloatRangeType.create(this.myFrom, this.myTo, true, nan);
            if (dfType == null) {
                DfFloatRangeType.$$$reportNull$$$0(16);
            }
            return dfType;
        }
        DfType dfType = DfFloatRangeType.create(range.myFrom, range.myTo, true, nan);
        if (dfType == null) {
            DfFloatRangeType.$$$reportNull$$$0(17);
        }
        return dfType;
    }

    @NotNull
    public DfType fromRelation(@NotNull RelationType relationType) {
        if (relationType == null) {
            DfFloatRangeType.$$$reportNull$$$0(18);
        }
        if (relationType == RelationType.EQ) {
            DfFloatRangeType result = this.myNaN ? this : DfFloatRangeType.create(this.myFrom, this.myTo, this.myInvert, true);
            DfType zero = DfTypes.floatRange(-0.0f, 0.0f);
            DfFloatRangeType dfFloatRangeType = this.meet(zero) != BOTTOM ? result.join(zero) : result;
            if (dfFloatRangeType == null) {
                DfFloatRangeType.$$$reportNull$$$0(19);
            }
            return dfFloatRangeType;
        }
        if (this.myInvert) {
            float max = this.myTo == Float.POSITIVE_INFINITY ? DfFloatRangeType.nextDown(this.myFrom) : Float.POSITIVE_INFINITY;
            float min = this.myFrom == Float.NEGATIVE_INFINITY ? DfFloatRangeType.nextUp(this.myTo) : Float.NEGATIVE_INFINITY;
            return DfFloatRangeType.fromRelation(relationType, min, max);
        }
        return DfFloatRangeType.fromRelation(relationType, this.myFrom, this.myTo);
    }

    @NotNull
    static DfType fromRelation(@NotNull RelationType relationType, float min, float max) {
        if (relationType == null) {
            DfFloatRangeType.$$$reportNull$$$0(20);
        }
        assert (!Float.isNaN(min));
        assert (!Float.isNaN(max));
        DfFloatType dfFloatType = switch (relationType) {
            case RelationType.LE -> DfFloatRangeType.create(Float.NEGATIVE_INFINITY, max == 0.0f ? 0.0f : max, false, true);
            case RelationType.LT -> {
                if (max == Float.NEGATIVE_INFINITY) {
                    yield DfTypes.FLOAT_NAN;
                }
                yield DfFloatRangeType.create(Float.NEGATIVE_INFINITY, Math.nextDown(max), false, true);
            }
            case RelationType.GE -> DfFloatRangeType.create(min == 0.0f ? -0.0f : min, Float.POSITIVE_INFINITY, false, true);
            case RelationType.GT -> {
                if (min == Float.POSITIVE_INFINITY) {
                    yield DfTypes.FLOAT_NAN;
                }
                yield DfFloatRangeType.create(Math.nextUp(min), Float.POSITIVE_INFINITY, false, true);
            }
            case RelationType.EQ -> {
                if (min == 0.0f) {
                    min = -0.0f;
                }
                if (max == 0.0f) {
                    max = 0.0f;
                }
                yield DfFloatRangeType.create(min, max, false, true);
            }
            case RelationType.NE -> {
                if (min == max) {
                    if (min == 0.0f) {
                        yield DfFloatRangeType.create(-0.0f, 0.0f, true, true);
                    }
                    yield DfFloatRangeType.create(min, min, true, true);
                }
                yield DfTypes.FLOAT;
            }
            default -> DfTypes.FLOAT;
        };
        if (dfFloatType == null) {
            DfFloatRangeType.$$$reportNull$$$0(21);
        }
        return dfFloatType;
    }

    @NotNull
    public DfType tryNegate() {
        DfType dfType = DfFloatRangeType.create(this.myFrom, this.myTo, !this.myInvert, !this.myNaN);
        if (dfType == null) {
            DfFloatRangeType.$$$reportNull$$$0(22);
        }
        return dfType;
    }

    @Override
    @NotNull
    public DfType castTo(@NotNull PsiPrimitiveType type) {
        if (type == null) {
            DfFloatRangeType.$$$reportNull$$$0(23);
        }
        if (type.equals((Object)PsiTypes.longType())) {
            LongRangeSet range;
            if (!this.myInvert) {
                range = LongRangeSet.range((long)((long)this.myFrom), (long)((long)this.myTo));
            } else {
                range = LongRangeSet.empty();
                if (this.myFrom > Float.NEGATIVE_INFINITY) {
                    range = range.join(LongRangeSet.range((long)Long.MIN_VALUE, (long)((long)DfFloatRangeType.nextDown(this.myFrom))));
                }
                if (this.myTo < Float.POSITIVE_INFINITY) {
                    range = range.join(LongRangeSet.range((long)((long)DfFloatRangeType.nextUp(this.myTo)), (long)Long.MAX_VALUE));
                }
            }
            if (this.myNaN) {
                range = range.join(LongRangeSet.point((long)0L));
            }
            DfType dfType = DfTypes.longRange(range);
            if (dfType == null) {
                DfFloatRangeType.$$$reportNull$$$0(24);
            }
            return dfType;
        }
        if (type.equals((Object)PsiTypes.intType()) || type.equals((Object)PsiTypes.shortType()) || type.equals((Object)PsiTypes.byteType()) || type.equals((Object)PsiTypes.charType())) {
            DfType result;
            LongRangeSet range;
            if (!this.myInvert) {
                range = LongRangeSet.range((long)((int)this.myFrom), (long)((int)this.myTo));
            } else {
                range = LongRangeSet.empty();
                if (this.myFrom > Float.NEGATIVE_INFINITY) {
                    range = range.join(LongRangeSet.range((long)Integer.MIN_VALUE, (long)((int)DfFloatRangeType.nextDown(this.myFrom))));
                }
                if (this.myTo < Float.POSITIVE_INFINITY) {
                    range = range.join(LongRangeSet.range((long)((int)DfFloatRangeType.nextUp(this.myTo)), (long)Integer.MAX_VALUE));
                }
            }
            if (this.myNaN) {
                range = range.join(LongRangeSet.point((long)0L));
            }
            if ((result = DfTypes.intRange(range)) instanceof DfPrimitiveType && !type.equals((Object)PsiTypes.intType())) {
                DfType dfType = ((DfPrimitiveType)result).castTo(type);
                if (dfType == null) {
                    DfFloatRangeType.$$$reportNull$$$0(25);
                }
                return dfType;
            }
            DfType dfType = result;
            if (dfType == null) {
                DfFloatRangeType.$$$reportNull$$$0(26);
            }
            return dfType;
        }
        if (type.equals((Object)PsiTypes.floatType())) {
            DfFloatRangeType dfFloatRangeType = this;
            if (dfFloatRangeType == null) {
                DfFloatRangeType.$$$reportNull$$$0(27);
            }
            return dfFloatRangeType;
        }
        DfType dfType = DfType.TOP;
        if (dfType == null) {
            DfFloatRangeType.$$$reportNull$$$0(28);
        }
        return dfType;
    }

    @NotNull
    public String toString() {
        Object range;
        if (this.myInvert) {
            if (this.myFrom == this.myTo) {
                range = "!= " + String.valueOf(Float.compare(this.myFrom, -0.0f) == 0 && Float.compare(this.myTo, 0.0f) == 0 ? "\u00b10.0f" : Float.valueOf(this.myFrom));
            } else {
                String first = this.myFrom == Float.NEGATIVE_INFINITY ? "" : DfFloatRangeType.formatRange(Float.NEGATIVE_INFINITY, DfFloatRangeType.nextDown(this.myFrom));
                String second = this.myTo == Float.POSITIVE_INFINITY ? "" : DfFloatRangeType.formatRange(DfFloatRangeType.nextUp(this.myTo), Float.POSITIVE_INFINITY);
                range = StreamEx.of((Object[])new String[]{first, second}).without((Object)"").joining((CharSequence)" || ");
            }
        } else {
            range = DfFloatRangeType.formatRange(this.myFrom, this.myTo);
        }
        Object result = "float";
        if (!((String)range).isEmpty()) {
            result = (String)result + " " + (String)range;
        }
        if (!this.myNaN) {
            result = (String)result + " not NaN";
        } else if (!((String)range).isEmpty()) {
            result = (String)result + " (or NaN)";
        }
        Object object = result;
        if (object == null) {
            DfFloatRangeType.$$$reportNull$$$0(29);
        }
        return object;
    }

    private static float nextDown(float val) {
        if (Float.compare(val, 0.0f) == 0) {
            return -0.0f;
        }
        return Math.nextDown(val);
    }

    private static float nextUp(float val) {
        if (Float.compare(val, -0.0f) == 0) {
            return 0.0f;
        }
        return Math.nextUp(val);
    }

    private static String formatRange(float from, float to) {
        int cmp = Float.compare(from, to);
        if (cmp == 0) {
            return Float.toString(from);
        }
        if (Float.compare(from, -0.0f) == 0 && Float.compare(to, 0.0f) == 0) {
            return "\u00b10.0f";
        }
        if (from == Float.NEGATIVE_INFINITY) {
            if (to == Float.POSITIVE_INFINITY) {
                return "";
            }
            return DfFloatRangeType.formatTo(to);
        }
        if (to == Float.POSITIVE_INFINITY) {
            return DfFloatRangeType.formatFrom(from);
        }
        return DfFloatRangeType.formatFrom(from) + " && " + DfFloatRangeType.formatTo(to);
    }

    @NotNull
    private static String formatFrom(float from) {
        float prev = DfFloatRangeType.nextDown(from);
        if (Float.toString(prev).length() < Float.toString(from).length()) {
            String string = "> " + prev;
            if (string == null) {
                DfFloatRangeType.$$$reportNull$$$0(30);
            }
            return string;
        }
        String string = ">= " + from;
        if (string == null) {
            DfFloatRangeType.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    private static String formatTo(float to) {
        float next = DfFloatRangeType.nextUp(to);
        if (Float.toString(next).length() < Float.toString(to).length()) {
            String string = "< " + next;
            if (string == null) {
                DfFloatRangeType.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = "<= " + to;
        if (string == null) {
            DfFloatRangeType.$$$reportNull$$$0(33);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DfFloatRangeType type = (DfFloatRangeType)o;
        return Float.compare(type.myFrom, this.myFrom) == 0 && Float.compare(type.myTo, this.myTo) == 0 && this.myInvert == type.myInvert && this.myNaN == type.myNaN;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.myFrom), Float.valueOf(this.myTo), this.myInvert, this.myNaN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfFloatRangeType";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfFloatRangeType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "meet";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fromRelation";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "tryNegate";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "castTo";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFrom";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuperType";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryJoinExactly";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "meet";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fromRelation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "castTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 -> new IllegalStateException(string);
        };
    }
}

