/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastVisibility;

@ApiStatus.Internal
public final class RefSerializationUtil {
    private RefSerializationUtil() {
    }

    private static boolean isExternalizableNoParameterConstructor(@NotNull UMethod method, @Nullable RefClass refClass) {
        if (method == null) {
            RefSerializationUtil.$$$reportNull$$$0(0);
        }
        if (!method.isConstructor()) {
            return false;
        }
        if (method.getVisibility() != UastVisibility.PUBLIC) {
            return false;
        }
        List parameterList = method.getUastParameters();
        if (!parameterList.isEmpty()) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)method, UClass.class);
        return aClass == null || RefSerializationUtil.isExternalizable(aClass, refClass);
    }

    public static boolean isSerializationImplicitlyUsedField(@NotNull UField field) {
        String name;
        if (field == null) {
            RefSerializationUtil.$$$reportNull$$$0(1);
        }
        if ("serialVersionUID".equals(name = field.getName())) {
            if (!PsiTypes.longType().equals((Object)field.getType())) {
                return false;
            }
        } else if ("serialPersistentFields".equals(name)) {
            PsiArrayType arrayType;
            if (field.getVisibility() != UastVisibility.PRIVATE) {
                return false;
            }
            PsiType psiType = field.getType();
            if (!(psiType instanceof PsiArrayType) || (arrayType = (PsiArrayType)psiType).getArrayDimensions() != 1) {
                return false;
            }
            PsiType componentType = arrayType.getComponentType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)componentType);
            if (aClass != null && !"java.io.ObjectStreamField".equals(aClass.getQualifiedName())) {
                return false;
            }
        } else {
            return false;
        }
        if (!field.isStatic() || !field.isFinal()) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)field, UClass.class);
        return aClass == null || RefSerializationUtil.isSerializable(aClass, null);
    }

    private static boolean isWriteObjectMethod(@NotNull UMethod method, @Nullable RefClass refClass) {
        if (method == null) {
            RefSerializationUtil.$$$reportNull$$$0(2);
        }
        if (!"writeObject".equals(method.getName())) {
            return false;
        }
        if (method.isStatic() || method.getVisibility() != UastVisibility.PRIVATE) {
            return false;
        }
        List parameters = method.getUastParameters();
        if (parameters.size() != 1) {
            return false;
        }
        if (!RefSerializationUtil.equalsToText(((UParameter)parameters.get(0)).getType(), "java.io.ObjectOutputStream")) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)method, UClass.class);
        return aClass == null || RefSerializationUtil.isSerializable(aClass, refClass);
    }

    private static boolean isReadObjectMethod(@NotNull UMethod method, @Nullable RefClass refClass) {
        if (method == null) {
            RefSerializationUtil.$$$reportNull$$$0(3);
        }
        if (!"readObject".equals(method.getName())) {
            return false;
        }
        if (method.isStatic() || method.getVisibility() != UastVisibility.PRIVATE) {
            return false;
        }
        List parameters = method.getUastParameters();
        if (parameters.size() != 1) {
            return false;
        }
        if (!RefSerializationUtil.equalsToText(((UParameter)parameters.get(0)).getType(), "java.io.ObjectInputStream")) {
            return false;
        }
        if (!RefSerializationUtil.equalsToText(method.getReturnType(), "void")) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)method, UClass.class);
        return aClass == null || RefSerializationUtil.isSerializable(aClass, refClass);
    }

    private static boolean isReadObjectNoDataMethod(@NotNull UMethod method, @Nullable RefClass refClass) {
        if (method == null) {
            RefSerializationUtil.$$$reportNull$$$0(4);
        }
        if (!"readObjectNoData".equals(method.getName())) {
            return false;
        }
        if (method.isStatic() || method.getVisibility() != UastVisibility.PRIVATE) {
            return false;
        }
        if (!method.getUastParameters().isEmpty()) {
            return false;
        }
        if (!RefSerializationUtil.equalsToText(method.getReturnType(), "void")) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)method, UClass.class);
        return aClass == null || RefSerializationUtil.isSerializable(aClass, refClass);
    }

    private static boolean isWriteReplaceMethod(@NotNull UMethod method, @Nullable RefClass refClass) {
        if (method == null) {
            RefSerializationUtil.$$$reportNull$$$0(5);
        }
        if (!"writeReplace".equals(method.getName())) {
            return false;
        }
        if (method.isStatic()) {
            return false;
        }
        if (!method.getUastParameters().isEmpty()) {
            return false;
        }
        if (!RefSerializationUtil.equalsToText(method.getReturnType(), "java.lang.Object")) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)method, UClass.class);
        return aClass == null || RefSerializationUtil.isSerializable(aClass, refClass);
    }

    private static boolean isReadResolveMethod(@NotNull UMethod method, @Nullable RefClass refClass) {
        if (method == null) {
            RefSerializationUtil.$$$reportNull$$$0(6);
        }
        if (!"readResolve".equals(method.getName())) {
            return false;
        }
        if (method.isStatic()) {
            return false;
        }
        if (!method.getUastParameters().isEmpty()) {
            return false;
        }
        if (!RefSerializationUtil.equalsToText(method.getReturnType(), "java.lang.Object")) {
            return false;
        }
        UClass aClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)method, UClass.class);
        return aClass == null || RefSerializationUtil.isSerializable(aClass, refClass);
    }

    private static boolean equalsToText(PsiType type, @NotNull String text) {
        if (text == null) {
            RefSerializationUtil.$$$reportNull$$$0(7);
        }
        return type != null && type.equalsToText(text);
    }

    private static boolean isSerializable(@NotNull UClass aClass, @Nullable RefClass refClass) {
        if (aClass == null) {
            RefSerializationUtil.$$$reportNull$$$0(8);
        }
        return RefSerializationUtil.isSerializable(aClass, refClass, "java.io.Serializable");
    }

    private static boolean isExternalizable(@NotNull UClass aClass, @Nullable RefClass refClass) {
        if (aClass == null) {
            RefSerializationUtil.$$$reportNull$$$0(9);
        }
        return RefSerializationUtil.isSerializable(aClass, refClass, "java.io.Externalizable");
    }

    private static boolean isSerializable(@NotNull UClass aClass, @Nullable RefClass refClass, @NotNull String fqn) {
        PsiClass psiClass;
        Project project;
        PsiClass serializableClass;
        if (aClass == null) {
            RefSerializationUtil.$$$reportNull$$$0(10);
        }
        if (fqn == null) {
            RefSerializationUtil.$$$reportNull$$$0(11);
        }
        return (serializableClass = (PsiClass)DumbService.getInstance((Project)(project = (psiClass = aClass.getJavaPsi()).getProject())).computeWithAlternativeResolveEnabled(() -> JavaPsiFacade.getInstance((Project)project).findClass(fqn, psiClass.getResolveScope()))) != null && RefSerializationUtil.isSerializable(aClass, refClass, serializableClass);
    }

    private static boolean isSerializable(@Nullable UClass aClass, @Nullable RefClass refClass, @NotNull PsiClass serializableClass) {
        if (serializableClass == null) {
            RefSerializationUtil.$$$reportNull$$$0(12);
        }
        if (aClass == null) {
            return false;
        }
        if (aClass.getJavaPsi().isInheritor(serializableClass, true)) {
            return true;
        }
        if (refClass != null) {
            Set subClasses = refClass.getSubClasses();
            for (RefClass subClass : subClasses) {
                if (!RefSerializationUtil.isSerializable(subClass.getUastElement(), subClass, serializableClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSerializationMethod(@NotNull UMethod method, @Nullable RefClass refClass) {
        if (method == null) {
            RefSerializationUtil.$$$reportNull$$$0(13);
        }
        return RefSerializationUtil.isReadObjectMethod(method, refClass) || RefSerializationUtil.isReadObjectNoDataMethod(method, refClass) || RefSerializationUtil.isWriteObjectMethod(method, refClass) || RefSerializationUtil.isReadResolveMethod(method, refClass) || RefSerializationUtil.isWriteReplaceMethod(method, refClass) || RefSerializationUtil.isExternalizableNoParameterConstructor(method, refClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializableClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/deadCode/RefSerializationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isExternalizableNoParameterConstructor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSerializationImplicitlyUsedField";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isWriteObjectMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadObjectMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadObjectNoDataMethod";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isWriteReplaceMethod";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadResolveMethod";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "equalsToText";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isSerializable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isExternalizable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isSerializationMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

