/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInspection/deprecation/RedundantScheduledForRemovalAnnotationInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ReplaceAnnotationByForRemovalAttributeFix", "intellij.java.analysis.impl"})
public final class RedundantScheduledForRemovalAnnotationInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)((PsiElement)holder.getFile()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new JavaElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitClass(PsiClass aClass) {
                Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
                this.visitAnnotatedElement((PsiModifierListOwner)aClass);
            }

            public void visitMethod(PsiMethod method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                this.visitAnnotatedElement((PsiModifierListOwner)method);
            }

            public void visitField(PsiField field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                this.visitAnnotatedElement((PsiModifierListOwner)field);
            }

            private final void visitAnnotatedElement(PsiModifierListOwner element) {
                boolean alreadyHasAttribute;
                PsiAnnotation psiAnnotation = element.getAnnotation(ApiStatus.ScheduledForRemoval.class.getCanonicalName());
                if (psiAnnotation == null) {
                    return;
                }
                PsiAnnotation forRemovalAnnotation = psiAnnotation;
                if (forRemovalAnnotation.hasAttribute("inVersion")) {
                    return;
                }
                PsiAnnotation psiAnnotation2 = element.getAnnotation("java.lang.Deprecated");
                if (psiAnnotation2 == null) {
                    return;
                }
                PsiAnnotation deprecatedAnnotation = psiAnnotation2;
                JvmAnnotationAttribute jvmAnnotationAttribute = deprecatedAnnotation.findAttribute("forRemoval");
                JvmAnnotationAttributeValue forRemovalAttribute = jvmAnnotationAttribute != null ? jvmAnnotationAttribute.getAttributeValue() : null;
                JvmAnnotationConstantValue jvmAnnotationConstantValue = forRemovalAttribute instanceof JvmAnnotationConstantValue ? (JvmAnnotationConstantValue)forRemovalAttribute : null;
                boolean bl = alreadyHasAttribute = jvmAnnotationConstantValue != null ? Intrinsics.areEqual((Object)jvmAnnotationConstantValue.getConstantValue(), (Object)true) : false;
                if (alreadyHasAttribute) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveAnnotationQuickFix(forRemovalAnnotation, element)};
                    this.$holder.registerProblem((PsiElement)forRemovalAnnotation, JavaAnalysisBundle.message((String)"inspection.message.scheduled.for.removal.annotation.can.be.removed", (Object[])new Object[0]), localQuickFixArray);
                } else {
                    ReplaceAnnotationByForRemovalAttributeFix fix = new ReplaceAnnotationByForRemovalAttributeFix();
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                    this.$holder.registerProblem((PsiElement)forRemovalAnnotation, JavaAnalysisBundle.message((String)"inspection.message.scheduled.for.removal.annotation.can.be.replaced.by.attribute", (Object[])new Object[0]), localQuickFixArray);
                }
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInspection/deprecation/RedundantScheduledForRemovalAnnotationInspection$ReplaceAnnotationByForRemovalAttributeFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "<init>", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getName", "", "getFamilyName", "intellij.java.analysis.impl"})
    public static final class ReplaceAnnotationByForRemovalAttributeFix
    extends PsiUpdateModCommandQuickFix {
        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            PsiAnnotation psiAnnotation = element instanceof PsiAnnotation ? (PsiAnnotation)element : null;
            if (psiAnnotation == null) {
                return;
            }
            PsiAnnotation forRemovalAnnotation = psiAnnotation;
            PsiAnnotationOwner psiAnnotationOwner = forRemovalAnnotation.getOwner();
            if (psiAnnotationOwner == null || (psiAnnotationOwner = psiAnnotationOwner.findAnnotation("java.lang.Deprecated")) == null) {
                return;
            }
            PsiAnnotationOwner deprecatedAnnotation = psiAnnotationOwner;
            PsiFile psiFile = forRemovalAnnotation.getContainingFile();
            PsiJavaFile javaFile = psiFile instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null;
            forRemovalAnnotation.delete();
            PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("true", null);
            Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"createExpressionFromText(...)");
            PsiExpression trueLiteral = psiExpression;
            deprecatedAnnotation.setDeclaredAttributeValue("forRemoval", (PsiAnnotationMemberValue)trueLiteral);
            if (javaFile != null) {
                JavaCodeStyleManager.getInstance((Project)project).removeRedundantImports(javaFile);
            }
        }

        @NotNull
        public String getName() {
            return this.getFamilyName();
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.fix.name.remove.scheduled.for.removal.annotation.by.attribute", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }
}

