/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInspection.deprecation.DeprecationInspectionQuickFixesKt;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.siyeh.InspectionGadgetsBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\b\u0010\u0014\u001a\u00020\rH\u0017J!\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0094\u0002R!\u0010\b\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u00050\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014 \n*\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000e0\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInspection/deprecation/ReplaceMethodCallFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lcom/intellij/psi/PsiMethodCallExpression;", "expr", "replacementMethod", "Lcom/intellij/psi/PsiMethod;", "<init>", "(Lcom/intellij/psi/PsiMethodCallExpression;Lcom/intellij/psi/PsiMethod;)V", "myReplacementMethodPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "myReplacementText", "", "Lcom/intellij/openapi/util/NlsSafe;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "getFamilyName", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.java.analysis.impl"})
public final class ReplaceMethodCallFix
extends PsiUpdateModCommandAction<PsiMethodCallExpression> {
    @NotNull
    private final SmartPsiElementPointer<PsiMethod> myReplacementMethodPointer;
    private final String myReplacementText;

    public ReplaceMethodCallFix(@NotNull PsiMethodCallExpression expr, @NotNull PsiMethod replacementMethod) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)replacementMethod, (String)"replacementMethod");
        super((PsiElement)expr);
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)replacementMethod.getProject()).createSmartPsiElementPointer((PsiElement)replacementMethod);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        this.myReplacementMethodPointer = smartPsiElementPointer;
        this.myReplacementText = PsiFormatUtil.formatMethod((PsiMethod)replacementMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiMethodCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object[] objectArray = new Object[]{this.myReplacementText};
        Presentation presentation = Presentation.of((String)InspectionGadgetsBundle.message("replace.method.call.fix.text", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
        return presentation;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("replace.method.call.fix.family.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiMethodCallExpression expr, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        PsiMethod psiMethod = (PsiMethod)this.myReplacementMethodPointer.getElement();
        if (psiMethod == null) {
            return;
        }
        PsiMethod replacementMethod = psiMethod;
        PsiReferenceExpression psiReferenceExpression = expr.getMethodExpression();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression, (String)"getMethodExpression(...)");
        String qualifierText = DeprecationInspectionQuickFixesKt.access$generateQualifierText(psiReferenceExpression, (PsiMember)replacementMethod);
        Project project = context.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        Project project2 = project;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiExpression psiExpression = elementFactory.createExpressionFromText(qualifierText + replacementMethod.getName() + expr.getArgumentList().getText(), (PsiElement)expr);
        Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"createExpressionFromText(...)");
        PsiExpression newMethodCall = psiExpression;
        PsiElement psiElement = expr.replace((PsiElement)newMethodCall);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        PsiMethodCallExpression replaced = (PsiMethodCallExpression)psiElement;
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)replaced.getMethodExpression());
    }
}

