/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateThrows;

import com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public final class DuplicateThrowsInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    public boolean ignoreSubclassing;

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
        if (string == null) {
            DuplicateThrowsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "DuplicateThrows";
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreSubclassing", (String)JavaAnalysisBundle.message((String)"inspection.duplicate.throws.ignore.subclassing.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            DuplicateThrowsInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DuplicateThrowsInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiReferenceList throwsList = method.getThrowsList();
                PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
                PsiClassType[] types = throwsList.getReferencedTypes();
                for (int i = 0; i < types.length; ++i) {
                    for (int j = i + 1; j < types.length; ++j) {
                        PsiClassType type = types[i];
                        PsiClassType otherType = types[j];
                        String problem = null;
                        PsiJavaCodeReferenceElement ref = refs[i];
                        if (type.equals((Object)otherType)) {
                            problem = JavaAnalysisBundle.message((String)"inspection.duplicate.throws.problem", (Object[])new Object[0]);
                        } else if (!DuplicateThrowsInspection.this.ignoreSubclassing) {
                            PsiDocTag[] docTags;
                            PsiDocComment comment;
                            if (otherType.isAssignableFrom((PsiType)type)) {
                                problem = JavaAnalysisBundle.message((String)"inspection.duplicate.throws.more.general.problem", (Object[])new Object[]{otherType.getCanonicalText()});
                            } else if (type.isAssignableFrom((PsiType)otherType)) {
                                problem = JavaAnalysisBundle.message((String)"inspection.duplicate.throws.more.general.problem", (Object[])new Object[]{type.getCanonicalText()});
                                ref = refs[j];
                                type = otherType;
                            }
                            if (problem != null && (comment = method.getDocComment()) != null && (docTags = comment.findTagsByName("throws")).length >= 2 && DuplicateThrowsInspection.refersTo(docTags, type) && DuplicateThrowsInspection.refersTo(docTags, otherType)) {
                                return;
                            }
                        }
                        if (problem == null) continue;
                        holder.problem((PsiElement)ref, problem).fix((ModCommandAction)new MethodThrowsFix.RemoveFirst(method, type, false)).register();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection$1", "visitMethod"));
            }
        };
    }

    private static boolean refersTo(PsiDocTag[] tags, PsiClassType exceptionType) {
        for (PsiDocTag tag : tags) {
            PsiJavaCodeReferenceElement ref;
            PsiDocTagValue element = tag.getValueElement();
            if (element == null || (ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findChildOfType((PsiElement)element, PsiJavaCodeReferenceElement.class)) == null || ref.resolve() != exceptionType.resolve()) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

