/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.nullable.MultipleElementsModCommandAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;

@NotNullByDefault
public final class AnnotateAsNullMarkedFix
implements ModCommandAction {
    private static final String NULL_MARKED_FQN = "org.jspecify.annotations.NullMarked";
    private static final String NULL_UNMARKED_FQN = "org.jspecify.annotations.NullUnmarked";
    @Nls
    private final String familyName;
    private final List<ModCommandAction> actions;

    public static ModCommandAction createAnnotateAsNullMarkedFix(PsiTypeElement typeElement, List<String> nullables) {
        return new AnnotateAsNullMarkedFix(AnnotateAsNullMarkedFix.provideNullMarkedFixes(typeElement, nullables));
    }

    private AnnotateAsNullMarkedFix(List<ModCommandAction> actions) {
        this.actions = actions;
        this.familyName = JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate.container.as", (Object[])new Object[]{StringUtil.getShortName((String)NULL_MARKED_FQN)});
    }

    @Nullable
    public Presentation getPresentation(ActionContext context) {
        return switch (this.actions.size()) {
            case 0 -> null;
            case 1 -> this.actions.getFirst().getPresentation(context);
            default -> Presentation.of((String)this.familyName);
        };
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public ModCommand perform(ActionContext context) {
        return ModCommand.chooseAction((String)JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate.choose.container", (Object[])new Object[0]), this.actions);
    }

    private static List<ModCommandAction> provideNullMarkedFixes(PsiTypeElement typeElement, List<String> nullables) {
        if (!AnnotateAsNullMarkedFix.isJSpecifyLibraryAvailable(typeElement.getContainingFile())) {
            return List.of();
        }
        List<MultipleElementsModCommandAction.Change<Object>> childrenChanges = new ArrayList<MultipleElementsModCommandAction.Change<? extends PsiElement>>();
        AnnotateAsNullMarkedFix.addChangesThatRemoveNullableAnnotations(typeElement, nullables, childrenChanges);
        List<? extends Container<? extends PsiElement>> containers = AnnotateAsNullMarkedFix.getContainersThatCanBeAnnotatedWithNullMarked((PsiElement)typeElement);
        ArrayList<ModCommandAction> modCommandActions = new ArrayList<ModCommandAction>();
        for (int i = 0; i < containers.size(); ++i) {
            String text;
            Container<? extends PsiElement> container = containers.get(i);
            if (container.hasNullMarkedAnnotation()) {
                if (!container.hasNullUnmarkedAnnotation()) break;
                text = container.textForRemoveAnnotationAction(NULL_UNMARKED_FQN);
                MultipleElementsModCommandAction.Change<? extends PsiElement> removeUnmarked = container.newChangeThatRemovesAnnotation(NULL_UNMARKED_FQN);
                modCommandActions.add(new MultipleElementsModCommandAction(text, ContainerUtil.append(childrenChanges, (Object[])new MultipleElementsModCommandAction.Change[]{removeUnmarked})));
                continue;
            }
            if (container.hasNullUnmarkedAnnotation()) {
                String text2;
                MultipleElementsModCommandAction.Change<? extends PsiElement> removeUnmarked = container.newChangeThatRemovesAnnotation(NULL_UNMARKED_FQN);
                String enclosing = AnnotateAsNullMarkedFix.annotationFromNearestAnnotatedParentContainer(containers, i);
                if (enclosing != null && enclosing.equals(NULL_MARKED_FQN)) {
                    text2 = container.textForRemoveAnnotationAction(NULL_UNMARKED_FQN);
                    modCommandActions.add(new MultipleElementsModCommandAction(text2, ContainerUtil.append(childrenChanges, (Object[])new MultipleElementsModCommandAction.Change[]{removeUnmarked})));
                    break;
                }
                text2 = container.textForAddAnnotationAction(NULL_MARKED_FQN);
                MultipleElementsModCommandAction.Change<? extends PsiElement> addMarked = container.newChangeThatAddsAnnotation(NULL_MARKED_FQN);
                List changes = ContainerUtil.append(childrenChanges, (Object[])new MultipleElementsModCommandAction.Change[]{removeUnmarked, addMarked});
                modCommandActions.add(new MultipleElementsModCommandAction(text2, changes));
                childrenChanges = ContainerUtil.append(childrenChanges, (Object[])new MultipleElementsModCommandAction.Change[]{removeUnmarked});
                continue;
            }
            text = container.textForAddAnnotationAction(NULL_MARKED_FQN);
            MultipleElementsModCommandAction.Change<? extends PsiElement> addMarked = container.newChangeThatAddsAnnotation(NULL_MARKED_FQN);
            modCommandActions.add(new MultipleElementsModCommandAction(text, ContainerUtil.append(childrenChanges, (Object[])new MultipleElementsModCommandAction.Change[]{addMarked})));
        }
        return modCommandActions;
    }

    private static boolean isJSpecifyLibraryAvailable(PsiFile file) {
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (module == null) {
            return false;
        }
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)NULL_MARKED_FQN) && JavaLibraryUtil.hasLibraryClass((Module)module, (String)NULL_UNMARKED_FQN);
    }

    @Nullable
    private static String annotationFromNearestAnnotatedParentContainer(List<? extends Container<? extends PsiElement>> containers, int i) {
        for (int j = i + 1; j < containers.size(); ++j) {
            Container<? extends PsiElement> container = containers.get(j);
            String annotation = container.getEffectiveAnnotation();
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private static List<? extends Container<? extends PsiElement>> getContainersThatCanBeAnnotatedWithNullMarked(PsiElement element) {
        ArrayList<Container> result = new ArrayList<Container>();
        PsiModifierListOwner parent = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)true);
        while (parent != null) {
            if (parent.getModifierList() != null && (parent instanceof PsiClass || parent instanceof PsiMethod)) {
                result.add(new ModifierListOwnerContainer(parent, parent.getModifierList()));
            }
            parent = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiModifierListOwner.class, (boolean)true);
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return result;
        }
        PsiDirectory directory = containingFile.getContainingDirectory();
        if (directory == null) {
            return result;
        }
        PsiPackageStatement packageStatement = (PsiPackageStatement)PsiTreeUtil.getChildOfType((PsiElement)containingFile, PsiPackageStatement.class);
        if (packageStatement == null) {
            return result;
        }
        String packageFqn = packageStatement.getPackageName();
        result.add(new PackageContainer(directory, packageFqn));
        return result;
    }

    private static void addChangesThatRemoveNullableAnnotations(PsiTypeElement typeElement, List<String> nullables, List<MultipleElementsModCommandAction.Change<? extends PsiElement>> changes) {
        List annotationFqn = ContainerUtil.filter(nullables, annotation -> typeElement.hasAnnotation(annotation));
        changes.addAll(ContainerUtil.map((Collection)annotationFqn, a -> new MultipleElementsModCommandAction.Change<PsiTypeElement>(typeElement, (updater, element) -> AnnotateAsNullMarkedFix.removeAnnotation((PsiAnnotationOwner)element, a))));
    }

    private static void removeAnnotation(PsiAnnotationOwner annotationOwner, String annotationFqn) {
        PsiAnnotation annotation = annotationOwner.findAnnotation(annotationFqn);
        if (annotation != null) {
            annotation.delete();
        }
    }

    @Nls
    private static String createTextForRemoveAnnotationAction(String annotationFqn, String name, JavaElementKind elementKind) {
        String shortName = StringUtil.getShortName((String)annotationFqn);
        return JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.remove.annotation.from.element", (Object[])new Object[]{shortName, elementKind.object(), name});
    }

    private static abstract sealed class Container<T extends PsiElement>
    permits PackageContainer, ModifierListOwnerContainer {
        private final boolean hasNullMarkedAnnotation;
        private final boolean hasNullUnmarkedAnnotation;

        private Container(@Nullable PsiModifierList modifierList) {
            this.hasNullMarkedAnnotation = Container.hasAnnotation(modifierList, AnnotateAsNullMarkedFix.NULL_MARKED_FQN);
            this.hasNullUnmarkedAnnotation = Container.hasAnnotation(modifierList, AnnotateAsNullMarkedFix.NULL_UNMARKED_FQN);
        }

        private static boolean hasAnnotation(@Nullable PsiModifierList modifierList, String annotationFqn) {
            return modifierList != null && modifierList.hasAnnotation(annotationFqn);
        }

        private boolean hasNullMarkedAnnotation() {
            return this.hasNullMarkedAnnotation;
        }

        private boolean hasNullUnmarkedAnnotation() {
            return this.hasNullUnmarkedAnnotation;
        }

        @Nullable
        public String getEffectiveAnnotation() {
            if (this.hasNullMarkedAnnotation && this.hasNullUnmarkedAnnotation) {
                return null;
            }
            if (this.hasNullMarkedAnnotation) {
                return AnnotateAsNullMarkedFix.NULL_MARKED_FQN;
            }
            if (this.hasNullUnmarkedAnnotation) {
                return AnnotateAsNullMarkedFix.NULL_UNMARKED_FQN;
            }
            return null;
        }

        public abstract MultipleElementsModCommandAction.Change<T> newChangeThatAddsAnnotation(String var1);

        public abstract MultipleElementsModCommandAction.Change<T> newChangeThatRemovesAnnotation(String var1);

        @IntentionName
        public abstract String textForAddAnnotationAction(String var1);

        @IntentionName
        public abstract String textForRemoveAnnotationAction(String var1);
    }

    private static final class ModifierListOwnerContainer
    extends Container<PsiModifierList> {
        private final PsiModifierListOwner modifierListOwner;
        private final PsiModifierList modifierList;

        private ModifierListOwnerContainer(PsiModifierListOwner modifierListOwner, PsiModifierList modifierList) {
            super(modifierList);
            this.modifierListOwner = modifierListOwner;
            this.modifierList = modifierList;
        }

        @Override
        public MultipleElementsModCommandAction.Change<PsiModifierList> newChangeThatAddsAnnotation(String annotationFqn) {
            return new MultipleElementsModCommandAction.Change<PsiModifierList>(this.modifierList, (updater, m) -> updater.highlight(JavaCodeStyleManager.getInstance((Project)m.getProject()).shortenClassReferences((PsiElement)m.addAnnotation(annotationFqn))));
        }

        @Override
        public MultipleElementsModCommandAction.Change<PsiModifierList> newChangeThatRemovesAnnotation(String annotationFqn) {
            return new MultipleElementsModCommandAction.Change<PsiModifierList>(this.modifierList, (updater, modifierList) -> AnnotateAsNullMarkedFix.removeAnnotation((PsiAnnotationOwner)modifierList, annotationFqn));
        }

        @Override
        public String textForAddAnnotationAction(String annotationFqn) {
            return AddAnnotationPsiFix.calcText(this.modifierListOwner, annotationFqn);
        }

        @Override
        public String textForRemoveAnnotationAction(String annotationFqn) {
            String name;
            if (this.modifierListOwner instanceof PsiNamedElement && (name = PsiFormatUtil.formatSimple((PsiNamedElement)((PsiNamedElement)this.modifierListOwner))) != null) {
                JavaElementKind javaElementKind = JavaElementKind.fromElement((PsiElement)this.modifierListOwner).lessDescriptive();
                return AnnotateAsNullMarkedFix.createTextForRemoveAnnotationAction(annotationFqn, name, javaElementKind);
            }
            return JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.remove.annotation", (Object[])new Object[]{StringUtil.getShortName((String)annotationFqn)});
        }
    }

    private static final class PackageContainer
    extends Container<PsiDirectory> {
        private final PsiDirectory directory;
        private final String packageFqn;

        private PackageContainer(PsiDirectory directory, String packageFqn) {
            super(PackageContainer.getPackageInfoModifierList(directory));
            this.directory = directory;
            this.packageFqn = packageFqn;
        }

        @Nullable
        private static PsiModifierList getPackageInfoModifierList(PsiDirectory directory) {
            directory.findFile("package-info.java");
            PsiFile packageInfoFile = directory.findFile("package-info.java");
            if (packageInfoFile == null) {
                return null;
            }
            if (!(packageInfoFile instanceof PsiJavaFile)) {
                return null;
            }
            PsiJavaFile packageInfoJavaFile = (PsiJavaFile)packageInfoFile;
            PsiPackageStatement packageStatement = packageInfoJavaFile.getPackageStatement();
            if (packageStatement == null) {
                return null;
            }
            return packageStatement.getAnnotationList();
        }

        @Override
        public MultipleElementsModCommandAction.Change<PsiDirectory> newChangeThatAddsAnnotation(String annotationFqn) {
            return new MultipleElementsModCommandAction.Change<PsiDirectory>(this.directory, (updater, dir) -> {
                PsiFile packageInfoFile = (PsiFile)updater.getWritable((PsiElement)PackageContainer.getPackageInfoFile(updater, dir));
                PsiPackageStatement packageStatement = this.getPackageStatement(packageInfoFile, dir.getProject());
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)dir.getProject());
                PsiAnnotation annotation = elementFactory.createAnnotationFromText("@" + annotationFqn, (PsiElement)packageStatement);
                PsiElement addedAnnotation = packageInfoFile.addBefore((PsiElement)annotation, (PsiElement)packageStatement);
                JavaCodeStyleManager.getInstance((Project)dir.getProject()).shortenClassReferences(addedAnnotation);
                CodeStyleManager.getInstance((Project)this.directory.getProject()).reformat((PsiElement)packageInfoFile);
                updater.moveCaretTo((PsiElement)packageStatement);
                updater.highlight(addedAnnotation);
            });
        }

        private PsiPackageStatement getPackageStatement(PsiFile packageInfoFile, Project project) {
            PsiJavaFile packageInfoJavaFile;
            PsiPackageStatement packageStatement;
            if (packageInfoFile instanceof PsiJavaFile && (packageStatement = (packageInfoJavaFile = (PsiJavaFile)packageInfoFile).getPackageStatement()) != null) {
                return packageStatement;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            packageStatement = elementFactory.createPackageStatement(this.packageFqn);
            return (PsiPackageStatement)packageInfoFile.addBefore((PsiElement)packageStatement, packageInfoFile.getFirstChild());
        }

        private static PsiFile getPackageInfoFile(ModPsiUpdater updater, PsiDirectory directory) {
            PsiFile packageInfoFile = directory.findFile("package-info.java");
            if (packageInfoFile == null) {
                packageInfoFile = ((PsiDirectory)updater.getWritable((PsiElement)directory)).createFile("package-info.java");
            }
            return packageInfoFile;
        }

        @Override
        public MultipleElementsModCommandAction.Change<PsiDirectory> newChangeThatRemovesAnnotation(String annotationFqn) {
            return new MultipleElementsModCommandAction.Change<PsiDirectory>(this.directory, (updater, dir) -> {
                PsiFile packageInfoFile = (PsiFile)updater.getWritable((PsiElement)PackageContainer.getPackageInfoFile(updater, dir));
                PsiPackageStatement packageStatement = this.getPackageStatement(packageInfoFile, dir.getProject());
                PsiModifierList modifierList = packageStatement.getAnnotationList();
                if (modifierList == null) {
                    return;
                }
                AnnotateAsNullMarkedFix.removeAnnotation((PsiAnnotationOwner)modifierList, annotationFqn);
            });
        }

        @Override
        public String textForAddAnnotationAction(String annotationFqn) {
            return AddAnnotationPsiFix.calcText(StringUtil.getShortName((String)annotationFqn), JavaElementKind.PACKAGE, this.packageFqn);
        }

        @Override
        public String textForRemoveAnnotationAction(String annotationFqn) {
            return AnnotateAsNullMarkedFix.createTextForRemoveAnnotationAction(annotationFqn, this.packageFqn, JavaElementKind.PACKAGE);
        }
    }
}

