/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;

@NotNullByDefault
class MultipleElementsModCommandAction
implements ModCommandAction {
    @IntentionName
    private final String familyName;
    private final List<SmartChange<? extends PsiElement>> changes;

    MultipleElementsModCommandAction(@IntentionName String familyName, List<Change<? extends PsiElement>> changes) {
        this.changes = ContainerUtil.map(changes, change -> change.toSmartChange());
        this.familyName = familyName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public Presentation getPresentation(ActionContext context) {
        return Presentation.of((String)this.familyName);
    }

    public ModCommand perform(ActionContext context) {
        return ModCommand.psiUpdate((ActionContext)context, updater -> MultipleElementsModCommandAction.applyOperations(this.changes, updater));
    }

    private static <T extends PsiElement> void applyOperations(List<SmartChange<? extends T>> smartChanges, ModPsiUpdater updater) {
        List<Change<T>> changes = MultipleElementsModCommandAction.convertSmartChangesToChanges(updater, smartChanges);
        if (changes == null) {
            return;
        }
        for (Change<T> change : changes) {
            change.invokeOperation(updater);
        }
    }

    @Nullable
    private static <T extends PsiElement> List<? extends Change<? extends T>> convertSmartChangesToChanges(ModPsiUpdater updater, List<SmartChange<? extends T>> smartChanges) {
        ArrayList<Change<? extends T>> changes = new ArrayList<Change<? extends T>>();
        for (SmartChange<T> smartChange : smartChanges) {
            Change<? extends T> change = smartChange.toChange(updater);
            if (change == null) {
                return null;
            }
            changes.add(change);
        }
        return changes;
    }

    public record Change<T extends PsiElement>(T target, BiConsumer<ModPsiUpdater, T> operation) {
        SmartChange<T> toSmartChange() {
            return new SmartChange<T>(SmartPointerManager.createPointer(this.target), this.operation);
        }

        public void invokeOperation(ModPsiUpdater updater) {
            this.operation().accept(updater, (ModPsiUpdater)this.target());
        }
    }

    private record SmartChange<T extends PsiElement>(SmartPsiElementPointer<T> target, BiConsumer<ModPsiUpdater, T> operation) {
        @Nullable
        private Change<T> toChange(ModPsiUpdater updater) {
            PsiElement writable = updater.getWritable(this.target.getElement());
            if (writable == null) {
                return null;
            }
            return new Change<PsiElement>(writable, this.operation);
        }
    }
}

