/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullabilitySource;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.TypeNullability;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveAnnotationOnStaticMemberQualifyingTypeFix;
import com.intellij.codeInsight.intention.AddAnnotationModCommandAction;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.AddTypeAnnotationFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.java.inst.MethodCallInstruction;
import com.intellij.codeInspection.nullable.AnnotateAsNullMarkedFix;
import com.intellij.codeInspection.nullable.AnnotateOverriddenMethodParameterFix;
import com.intellij.codeInspection.nullable.MoveAnnotationToArrayFix;
import com.intellij.codeInspection.nullable.MoveAnnotationToBoundFix;
import com.intellij.codeInspection.nullable.NullableStuffInspectionUtil;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.psi.impl.search.JavaOverridingMethodsSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.JavaTypeNullabilityUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class NullableStuffInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    @Deprecated
    public boolean REPORT_NULLABLE_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE = true;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_GETTER = true;
    public boolean IGNORE_EXTERNAL_SUPER_NOTNULL;
    public boolean REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED;
    public boolean REPORT_NULLABILITY_ANNOTATION_ON_LOCALS = true;
    public boolean REPORT_NOT_ANNOTATED_INSTANTIATION_NOT_NULL_TYPE = false;
    public boolean REPORT_NOT_NULL_TO_NULLABLE_CONFLICTS_IN_ASSIGNMENTS = false;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_SETTER_PARAMETER = true;
    @Deprecated
    public boolean REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS = true;
    @Deprecated
    public boolean REPORT_NULLS_PASSED_TO_NON_ANNOTATED_METHOD = true;
    public boolean REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = true;
    public boolean REPORT_REDUNDANT_NULLABILITY_ANNOTATION_IN_THE_SCOPE_OF_ANNOTATED_CONTAINER = true;
    private static final Logger LOG = Logger.getInstance(NullableStuffInspectionBase.class);

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(0);
        }
        super.writeSettings(node);
        for (Element child : new ArrayList(node.getChildren())) {
            String name = child.getAttributeValue("name");
            String value = child.getAttributeValue("value");
            if (!("IGNORE_EXTERNAL_SUPER_NOTNULL".equals(name) && "false".equals(value) || "REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED".equals(name) && "false".equals(value) || "REQUIRE_NOTNULL_FIELDS_INITIALIZED".equals(name) && "true".equals(value) || "REPORT_NULLABILITY_ANNOTATION_ON_LOCALS".equals(name) && "true".equals(value) || "REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER".equals(name) && "true".equals(value) || "REPORT_NOT_NULL_TO_NULLABLE_CONFLICTS_IN_ASSIGNMENTS".equals(name) && "false".equals(value) || "REPORT_NOT_ANNOTATED_INSTANTIATION_NOT_NULL_TYPE".equals(name) && "false".equals(value)) && (!"REPORT_REDUNDANT_NULLABILITY_ANNOTATION_IN_THE_SCOPE_OF_ANNOTATED_CONTAINER".equals(name) || !"true".equals(value))) continue;
            node.removeContent((Content)child);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(1);
        }
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.ANNOTATIONS, (PsiElement)(file = holder.getFile())) || NullableStuffInspectionBase.nullabilityAnnotationsNotAvailable(file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                NullableStuffInspectionBase.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){
            private final NullableNotNullManager manager;
            private final List<String> nullables;
            private final List<String> notNulls;
            {
                this.manager = NullableNotNullManager.getInstance((Project)holder.getProject());
                this.nullables = this.manager.getNullables();
                this.notNulls = this.manager.getNotNulls();
            }

            public void visitMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                NullableStuffInspectionBase.this.checkNullableStuffForMethod(method, holder);
            }

            public void visitClass(@NotNull PsiClass aClass) {
                PsiMethod constructor;
                if (aClass == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (aClass.isRecord() && (constructor = JavaPsiRecordUtil.findCanonicalConstructor((PsiClass)aClass)) instanceof SyntheticElement) {
                    NullableStuffInspectionBase.this.checkParameters(constructor, holder, List.of(), this.manager);
                }
                NullableStuffInspectionBase.this.checkConflictingContainerAnnotations(holder, aClass.getModifierList());
            }

            public void visitPackageStatement(@NotNull PsiPackageStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(2);
                }
                NullableStuffInspectionBase.this.checkConflictingContainerAnnotations(holder, statement.getAnnotationList());
            }

            public void visitModule(@NotNull PsiJavaModule module) {
                if (module == null) {
                    1.$$$reportNull$$$0(3);
                }
                NullableStuffInspectionBase.this.checkConflictingContainerAnnotations(holder, module.getModifierList());
            }

            public void visitNewExpression(@NotNull PsiNewExpression expression) {
                PsiTypeElement typeElement;
                PsiJavaCodeReferenceElement typeRef;
                boolean matched;
                PsiClassType classType;
                PsiExpressionList list;
                String qualifiedName;
                block26: {
                    block25: {
                        PsiClassType type;
                        if (expression == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        if (expression.isArrayCreation()) {
                            return;
                        }
                        PsiJavaCodeReferenceElement ref = expression.getClassOrAnonymousClassReference();
                        if (ref == null) {
                            return;
                        }
                        PsiElement psiElement = ref.resolve();
                        if (!(psiElement instanceof PsiClass)) {
                            return;
                        }
                        PsiClass cls = (PsiClass)psiElement;
                        qualifiedName = cls.getQualifiedName();
                        if (qualifiedName == null) {
                            return;
                        }
                        list = expression.getArgumentList();
                        if (list == null) {
                            return;
                        }
                        PsiType psiType = expression.getType();
                        if (!(psiType instanceof PsiClassType) || (type = (PsiClassType)psiType).getParameterCount() != 1) {
                            return;
                        }
                        PsiType typeParameter = type.getParameters()[0];
                        if (!(typeParameter instanceof PsiClassType)) break block25;
                        classType = (PsiClassType)typeParameter;
                        if (DfaPsiUtil.getTypeNullability(typeParameter) == Nullability.NOT_NULL) break block26;
                    }
                    return;
                }
                switch (qualifiedName) {
                    case "java.util.concurrent.atomic.AtomicReference": {
                        boolean bl;
                        if (list.getExpressionCount() == 0) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case "java.util.concurrent.atomic.AtomicReferenceArray": {
                        boolean bl;
                        if (list.getExpressionCount() == 1 && PsiTypes.intType().equals((Object)list.getExpressionTypes()[0])) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case "java.lang.ThreadLocal": {
                        boolean bl;
                        if (list.getExpressionCount() == 0 && expression.getAnonymousClass() == null) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        boolean bl = matched = false;
                    }
                }
                if (!matched) {
                    return;
                }
                AddTypeAnnotationFix fix = null;
                PsiElement psiElement = classType.getPsiContext();
                if (psiElement instanceof PsiJavaCodeReferenceElement && (psiElement = (typeRef = (PsiJavaCodeReferenceElement)psiElement).getParent()) instanceof PsiTypeElement && (typeElement = (PsiTypeElement)psiElement).getType().equals(classType) && typeElement.acceptsAnnotations()) {
                    fix = new AddTypeAnnotationFix(typeElement, this.manager.getDefaultAnnotation(Nullability.NULLABLE, (PsiElement)expression), this.notNulls);
                }
                holder.problem((PsiElement)expression, JavaAnalysisBundle.message((String)"inspection.nullable.problems.constructor.not.compatible.non.null.type.argument", (Object[])new Object[0])).maybeFix(fix).register();
            }

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(5);
                }
                NullableStuffInspectionBase.this.checkMethodReference(expression, holder);
                JavaResolveResult result = expression.advancedResolve(false);
                PsiElement target = result.getElement();
                if (target instanceof PsiMethod) {
                    NullableStuffInspectionBase.this.checkNestedGenericClasses(holder, (PsiElement)expression, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression), result.getSubstitutor().substitute(((PsiMethod)target).getReturnType()), ConflictNestedTypeProblem.ASSIGNMENT_NESTED_TYPE_PROBLEM);
                }
            }

            public void visitField(@NotNull PsiField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(6);
                }
                PsiType type = field.getType();
                Annotated annotated = NullableStuffInspectionBase.this.check((PsiModifierListOwner)field, holder, type);
                if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type)) {
                    return;
                }
                Project project = holder.getProject();
                if (annotated.isDeclaredNotNull ^ annotated.isDeclaredNullable) {
                    String anno = this.manager.getDefaultAnnotation(annotated.isDeclaredNotNull ? Nullability.NOT_NULL : Nullability.NULLABLE, (PsiElement)field);
                    List<String> annoToRemove = annotated.isDeclaredNotNull ? this.nullables : this.notNulls;
                    NullableStuffInspectionBase.this.checkAccessors(field, annotated, project, this.manager, anno, annoToRemove, holder);
                    NullableStuffInspectionBase.this.checkConstructorParameters(field, annotated, anno, annoToRemove, holder);
                }
                PsiExpression initializer = field.getInitializer();
                PsiElement identifyingElement = field.getIdentifyingElement();
                if (initializer != null && identifyingElement != null) {
                    NullableStuffInspectionBase.this.checkNestedGenericClasses(holder, identifyingElement, field.getType(), initializer.getType(), ConflictNestedTypeProblem.ASSIGNMENT_NESTED_TYPE_PROBLEM);
                }
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(7);
                }
                super.visitMethodCallExpression(call);
                PsiReferenceParameterList parameterList = call.getMethodExpression().getParameterList();
                if (parameterList == null) {
                    return;
                }
                PsiType[] parameterization = parameterList.getTypeArguments();
                if (parameterization.length == 0) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiTypeParameter[] typeParameters = method.getTypeParameters();
                if (typeParameters.length != parameterization.length) {
                    return;
                }
                for (int i = 0; i < typeParameters.length; ++i) {
                    PsiJavaCodeReferenceElement ref;
                    PsiAnnotation anchor;
                    TypeNullability instanceNullability;
                    PsiTypeParameter typeParameter = typeParameters[i];
                    PsiType instance = parameterization[i];
                    TypeNullability nullability = TypeNullability.ofTypeParameter((PsiTypeParameter)typeParameter);
                    if (nullability.nullability() != Nullability.NOT_NULL || (instanceNullability = instance.getNullability()).nullability() == Nullability.NOT_NULL) continue;
                    NullabilitySource source = instanceNullability.source();
                    if (source instanceof NullabilitySource.ExplicitAnnotation) {
                        NullabilitySource.ExplicitAnnotation explicit = (NullabilitySource.ExplicitAnnotation)source;
                        anchor = explicit.annotation();
                        ref = anchor.getNameReferenceElement();
                        if (ref == null) continue;
                        NullableStuffInspectionBase.this.reportProblem(holder, (PsiElement)anchor, "inspection.nullable.problems.nullable.instantiation.of.notnull", typeParameter.getName(), ref.getReferenceName());
                        continue;
                    }
                    if (!(source instanceof NullabilitySource.ContainerAnnotation)) continue;
                    NullabilitySource.ContainerAnnotation container = (NullabilitySource.ContainerAnnotation)source;
                    anchor = parameterList.getTypeParameterElements()[i];
                    ref = container.annotation().getNameReferenceElement();
                    if (ref == null) continue;
                    NullableStuffInspectionBase.this.reportProblem(holder, (PsiElement)anchor, "inspection.nullable.problems.nullable.instantiation.of.notnull.container", typeParameter.getName(), ref.getReferenceName());
                }
            }

            public void visitParameter(@NotNull PsiParameter parameter) {
                if (parameter == null) {
                    1.$$$reportNull$$$0(8);
                }
                NullableStuffInspectionBase.this.check((PsiModifierListOwner)parameter, holder, parameter.getType());
            }

            public void visitAnnotation(@NotNull PsiAnnotation annotation) {
                PsiClassObjectAccessExpression classObjectAccessExpression;
                PsiClass psiClass;
                PsiAnnotationMemberValue value;
                PsiMethod method;
                PsiTypeElement parent;
                PsiClassType classType;
                PsiElement context;
                PsiType notAnnotated;
                TypeNullability notAnnotatedNullability;
                PsiType targetType;
                PsiModifierListOwner psiModifierListOwner;
                String qualifiedName;
                if (annotation == null) {
                    1.$$$reportNull$$$0(9);
                }
                if ((qualifiedName = annotation.getQualifiedName()) == null) {
                    return;
                }
                Optional nullabilityOptional = this.manager.getAnnotationNullability(qualifiedName);
                if (nullabilityOptional.isEmpty()) {
                    return;
                }
                Nullability nullability = (Nullability)nullabilityOptional.get();
                PsiType type = AnnotationUtil.getRelatedType((PsiAnnotation)annotation);
                PsiAnnotationOwner owner = annotation.getOwner();
                if (owner instanceof PsiModifierList) {
                    PsiModifierList modifierList = (PsiModifierList)owner;
                    psiModifierListOwner = (PsiModifierListOwner)ObjectUtils.tryCast((Object)modifierList.getParent(), PsiModifierListOwner.class);
                } else {
                    psiModifierListOwner = null;
                }
                PsiModifierListOwner listOwner = psiModifierListOwner;
                PsiType psiType = targetType = listOwner == null ? null : PsiUtil.getTypeByPsiElement(listOwner);
                if (listOwner != null && targetType != null) {
                    this.checkRedundantInContainerScope(annotation, this.manager.findContainerAnnotation(listOwner), nullability);
                } else if (type != null) {
                    PsiAnnotation context2;
                    if (type instanceof PsiClassType) {
                        PsiClassType classType2 = (PsiClassType)type;
                        v2 = classType2.getPsiContext();
                    } else {
                        v2 = context2 = annotation;
                    }
                    if (context2 != null) {
                        this.checkRedundantInContainerScope(annotation, this.manager.findDefaultTypeUseNullability((PsiElement)context2), nullability);
                    }
                }
                if (type != null && nullability == Nullability.NOT_NULL && PsiUtil.resolveClassInClassTypeOnly((PsiType)type) instanceof PsiTypeParameter && (notAnnotatedNullability = (notAnnotated = type.annotate(TypeAnnotationProvider.EMPTY)).getNullability()).nullability() == Nullability.NOT_NULL && notAnnotatedNullability.source() instanceof NullabilitySource.ExtendsBound) {
                    NullableStuffInspectionBase.this.reportProblem(holder, (PsiElement)annotation, (LocalQuickFix)new RemoveAnnotationQuickFix(annotation, null), "inspection.nullable.problems.redundant.annotation.inherited.notnull", new Object[0]);
                }
                if (type instanceof PsiPrimitiveType) {
                    MoveAnnotationToArrayFix additionalFix = null;
                    if (targetType instanceof PsiArrayType && !targetType.hasAnnotations()) {
                        additionalFix = new MoveAnnotationToArrayFix();
                    }
                    NullableStuffInspectionBase.this.reportIncorrectLocation(holder, annotation, listOwner, "inspection.nullable.problems.primitive.type.annotation", LocalQuickFix.notNullElements((LocalQuickFix)additionalFix));
                }
                if (type instanceof PsiClassType && (context = (classType = (PsiClassType)type).getPsiContext()) instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement outerCtx = (PsiJavaCodeReferenceElement)context;
                    PsiElement parent2 = context.getParent();
                    if (parent2 instanceof PsiJavaCodeReferenceElement) {
                        if (outerCtx.resolve() instanceof PsiPackage) {
                            action = new MoveAnnotationOnStaticMemberQualifyingTypeFix(annotation);
                            NullableStuffInspectionBase.this.reportIncorrectLocation(holder, annotation, listOwner, "inspection.nullable.problems.applied.to.package", LocalQuickFix.from((ModCommandAction)action));
                        } else {
                            action = new MoveAnnotationOnStaticMemberQualifyingTypeFix(annotation);
                            NullableStuffInspectionBase.this.reportIncorrectLocation(holder, annotation, listOwner, "inspection.nullable.problems.outer.type", LocalQuickFix.from((ModCommandAction)action));
                        }
                    }
                    if (parent2 instanceof PsiReferenceList) {
                        PsiElement firstChild = parent2.getFirstChild();
                        if ((PsiUtil.isJavaToken((PsiElement)firstChild, (IElementType)JavaTokenType.EXTENDS_KEYWORD) || PsiUtil.isJavaToken((PsiElement)firstChild, (IElementType)JavaTokenType.IMPLEMENTS_KEYWORD)) && !(parent2.getParent() instanceof PsiTypeParameter)) {
                            NullableStuffInspectionBase.this.reportIncorrectLocation(holder, annotation, listOwner, "inspection.nullable.problems.at.reference.list", new LocalQuickFix[0]);
                        }
                        if (PsiUtil.isJavaToken((PsiElement)firstChild, (IElementType)JavaTokenType.THROWS_KEYWORD)) {
                            NullableStuffInspectionBase.this.reportIncorrectLocation(holder, annotation, listOwner, "inspection.nullable.problems.at.throws", new LocalQuickFix[0]);
                        }
                    }
                }
                if (type instanceof PsiArrayType && (context = annotation.getParent()) instanceof PsiTypeElement && (parent = (PsiTypeElement)context).getType().equals(type) && !this.manager.canAnnotateLocals(qualifiedName)) {
                    this.checkIllegalLocalAnnotation(annotation, parent.getParent());
                }
                if (listOwner instanceof PsiMethod && (method = (PsiMethod)listOwner).isConstructor()) {
                    NullableStuffInspectionBase.this.reportIncorrectLocation(holder, annotation, listOwner, "inspection.nullable.problems.at.constructor", new LocalQuickFix[0]);
                }
                if (listOwner instanceof PsiClass && AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE}) == null) {
                    NullableStuffInspectionBase.this.reportIncorrectLocation(holder, annotation, listOwner, "inspection.nullable.problems.at.class", new LocalQuickFix[0]);
                }
                if (listOwner instanceof PsiEnumConstant) {
                    NullableStuffInspectionBase.this.reportIncorrectLocation(holder, annotation, listOwner, "inspection.nullable.problems.at.enum.constant", new LocalQuickFix[0]);
                }
                if (!this.manager.canAnnotateLocals(qualifiedName) && !(targetType instanceof PsiArrayType)) {
                    this.checkIllegalLocalAnnotation(annotation, (PsiElement)listOwner);
                }
                if (type instanceof PsiWildcardType && this.manager.isTypeUseAnnotationLocationRestricted(qualifiedName)) {
                    NullableStuffInspectionBase.this.reportIncorrectLocation(holder, annotation, listOwner, "inspection.nullable.problems.at.wildcard", new LocalQuickFix[0]);
                }
                if (owner instanceof PsiTypeParameter && this.manager.isTypeUseAnnotationLocationRestricted(qualifiedName)) {
                    NullableStuffInspectionBase.this.reportIncorrectLocation(holder, annotation, listOwner, "inspection.nullable.problems.at.type.parameter", new LocalQuickFix[0]);
                }
                if (listOwner instanceof PsiReceiverParameter && nullability != Nullability.NOT_NULL) {
                    NullableStuffInspectionBase.this.reportIncorrectLocation(holder, annotation, listOwner, "inspection.nullable.problems.receiver.annotation", new LocalQuickFix[0]);
                }
                this.checkOppositeAnnotationConflict(annotation, nullability);
                if ("org.jetbrains.annotations.NotNull".equals(qualifiedName) && (value = annotation.findDeclaredAttributeValue("exception")) instanceof PsiClassObjectAccessExpression && (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)(classObjectAccessExpression = (PsiClassObjectAccessExpression)value).getOperand().getType())) != null && !1.hasStringConstructor(psiClass)) {
                    NullableStuffInspectionBase.this.reportProblem(holder, (PsiElement)value, "custom.exception.class.should.have.a.constructor", new Object[0]);
                }
            }

            private void checkRedundantInContainerScope(@NotNull PsiAnnotation annotation, @Nullable NullabilityAnnotationInfo containerInfo, @NotNull Nullability nullability) {
                PsiJavaCodeReferenceElement containerName;
                if (annotation == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (nullability == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (!NullableStuffInspectionBase.this.REPORT_REDUNDANT_NULLABILITY_ANNOTATION_IN_THE_SCOPE_OF_ANNOTATED_CONTAINER) {
                    return;
                }
                if (containerInfo != null && !containerInfo.getAnnotation().equals((Object)annotation) && containerInfo.getNullability() == nullability && (containerName = containerInfo.getAnnotation().getNameReferenceElement()) != null) {
                    LocalQuickFix updateOptionFix = LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)NullableStuffInspectionBase.this, "REPORT_REDUNDANT_NULLABILITY_ANNOTATION_IN_THE_SCOPE_OF_ANNOTATED_CONTAINER", JavaAnalysisBundle.message((String)"inspection.nullable.problems.turn.off.redundant.annotation.under.container", (Object[])new Object[0]), false));
                    NullableStuffInspectionBase.this.reportProblem(holder, (PsiElement)annotation, LocalQuickFix.notNullElements((LocalQuickFix[])new LocalQuickFix[]{new RemoveAnnotationQuickFix(annotation, null), updateOptionFix}), "inspection.nullable.problems.redundant.annotation.under.container", containerName.getReferenceName());
                }
            }

            private void checkIllegalLocalAnnotation(@NotNull PsiAnnotation annotation, @Nullable PsiElement owner) {
                PsiParameter parameter;
                if (annotation == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (!NullableStuffInspectionBase.this.REPORT_NULLABILITY_ANNOTATION_ON_LOCALS) {
                    return;
                }
                if (owner instanceof PsiLocalVariable || owner instanceof PsiParameter && (parameter = (PsiParameter)owner).getDeclarationScope() instanceof PsiCatchSection) {
                    NullableStuffInspectionBase.this.reportIncorrectLocation(holder, annotation, (PsiModifierListOwner)((PsiVariable)owner), "inspection.nullable.problems.at.local.variable", new LocalQuickFix[0]);
                }
            }

            private void checkOppositeAnnotationConflict(PsiAnnotation annotation, Nullability nullability) {
                PsiModifierListOwner psiModifierListOwner;
                PsiAnnotationOwner owner = annotation.getOwner();
                if (owner == null) {
                    return;
                }
                if (owner instanceof PsiModifierList) {
                    PsiModifierList modifierList = (PsiModifierList)owner;
                    psiModifierListOwner = (PsiModifierListOwner)ObjectUtils.tryCast((Object)modifierList.getParent(), PsiModifierListOwner.class);
                } else {
                    psiModifierListOwner = null;
                }
                PsiModifierListOwner listOwner = psiModifierListOwner;
                Condition filter = anno -> anno != annotation && this.manager.getAnnotationNullability(anno.getQualifiedName()).filter(n -> n != nullability).isPresent();
                PsiAnnotation oppositeAnno = (PsiAnnotation)ContainerUtil.find((Object[])owner.getAnnotations(), (Condition)filter);
                if (oppositeAnno == null && listOwner != null) {
                    NullabilityAnnotationInfo result = this.manager.findNullabilityAnnotationInfo(listOwner, (Collection)ContainerUtil.filter((Object[])Nullability.values(), n -> n != nullability));
                    PsiAnnotation psiAnnotation = oppositeAnno = result == null || result.isContainer() ? null : result.getAnnotation();
                }
                if (oppositeAnno != null && Objects.equals(AnnotationUtil.getRelatedType((PsiAnnotation)annotation), AnnotationUtil.getRelatedType((PsiAnnotation)oppositeAnno))) {
                    NullableStuffInspectionBase.this.reportProblem(holder, (PsiElement)annotation, (LocalQuickFix)new RemoveAnnotationQuickFix(annotation, listOwner), "inspection.nullable.problems.Nullable.NotNull.conflict", NullableStuffInspectionBase.getPresentableAnnoName(annotation), NullableStuffInspectionBase.getPresentableAnnoName(oppositeAnno));
                }
            }

            private static boolean hasStringConstructor(PsiClass aClass) {
                for (PsiMethod method : aClass.getConstructors()) {
                    PsiParameterList list = method.getParameterList();
                    if (list.getParametersCount() != 1 || !Objects.requireNonNull(list.getParameter(0)).getType().equalsToText("java.lang.String")) continue;
                    return true;
                }
                return false;
            }

            public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
                String error;
                if (reference == null) {
                    1.$$$reportNull$$$0(13);
                }
                super.visitReferenceElement(reference);
                this.checkNullableNotNullInstantiationConflict(reference);
                PsiElement list = reference.getParent();
                PsiElement psiClass = list instanceof PsiReferenceList ? list.getParent() : null;
                PsiElement intf = reference.resolve();
                if (psiClass instanceof PsiClass && list == ((PsiClass)psiClass).getImplementsList() && intf instanceof PsiClass && ((PsiClass)intf).isInterface() && (error = NullableStuffInspectionBase.this.checkIndirectInheritance(psiClass, (PsiClass)intf)) != null) {
                    holder.registerProblem((PsiElement)reference, error, new LocalQuickFix[0]);
                }
            }

            private void checkNullableNotNullInstantiationConflict(PsiJavaCodeReferenceElement reference) {
                PsiElement element = reference.resolve();
                if (element instanceof PsiClass) {
                    PsiTypeParameter[] typeParameters = ((PsiClass)element).getTypeParameters();
                    PsiTypeElement[] typeArguments = 1.getReferenceTypeArguments(reference);
                    if (typeParameters.length > 0 && typeParameters.length == typeArguments.length && !(typeArguments[0].getType() instanceof PsiDiamondType)) {
                        for (int i = 0; i < typeParameters.length; ++i) {
                            ProblemHighlightType level;
                            PsiWildcardType wildcardType;
                            TypeNullability nullability;
                            Nullability typeNullability;
                            PsiTypeElement typeArgument = typeArguments[i];
                            Project project = element.getProject();
                            PsiType type = typeArgument.getType();
                            if (TypeNullability.ofTypeParameter((PsiTypeParameter)typeParameters[i]).nullability() != Nullability.NOT_NULL || (typeNullability = (nullability = type.getNullability()).nullability()) == Nullability.NOT_NULL || typeNullability == Nullability.UNKNOWN && type instanceof PsiWildcardType && !(wildcardType = (PsiWildcardType)type).isExtends()) continue;
                            String annotationToAdd = this.manager.getDefaultAnnotation(Nullability.NOT_NULL, (PsiElement)reference);
                            PsiClass annotationClass = JavaPsiFacade.getInstance((Project)project).findClass(annotationToAdd, element.getResolveScope());
                            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
                            if (annotationClass != null && AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE}) != null) {
                                fixes.add(LocalQuickFix.from((ModCommandAction)new AddTypeAnnotationFix(typeArgument, annotationToAdd, this.manager.getNullables())));
                            }
                            fixes.add(LocalQuickFix.from((ModCommandAction)AnnotateAsNullMarkedFix.createAnnotateAsNullMarkedFix(typeArgument, this.manager.getNullables()), (boolean)false));
                            ProblemHighlightType problemHighlightType = level = nullability == TypeNullability.UNKNOWN && !NullableStuffInspectionBase.this.REPORT_NOT_ANNOTATED_INSTANTIATION_NOT_NULL_TYPE ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                            if (!isOnTheFly && level == ProblemHighlightType.INFORMATION) continue;
                            holder.registerProblem((PsiElement)typeArgument, JavaAnalysisBundle.message((String)"non.null.type.argument.is.expected", (Object[])new Object[0]), level, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                        }
                    }
                }
            }

            private static PsiTypeElement[] getReferenceTypeArguments(PsiJavaCodeReferenceElement reference) {
                PsiReferenceParameterList typeArgList = reference.getParameterList();
                return typeArgList == null ? PsiTypeElement.EMPTY_ARRAY : typeArgList.getTypeParameterElements();
            }

            public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
                PsiExpression rExpression;
                if (expression == null) {
                    1.$$$reportNull$$$0(14);
                }
                if ((rExpression = expression.getRExpression()) == null) {
                    return;
                }
                NullableStuffInspectionBase.this.checkNestedGenericClasses(holder, (PsiElement)expression.getOperationSign(), expression.getLExpression().getType(), rExpression.getType(), ConflictNestedTypeProblem.ASSIGNMENT_NESTED_TYPE_PROBLEM);
            }

            public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
                PsiIdentifier identifier;
                if (variable == null) {
                    1.$$$reportNull$$$0(15);
                }
                if ((identifier = variable.getNameIdentifier()) == null) {
                    return;
                }
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) {
                    return;
                }
                NullableStuffInspectionBase.this.checkNestedGenericClasses(holder, (PsiElement)identifier, variable.getType(), initializer.getType(), ConflictNestedTypeProblem.ASSIGNMENT_NESTED_TYPE_PROBLEM);
            }

            public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
                PsiExpression returnValue;
                if (statement == null) {
                    1.$$$reportNull$$$0(16);
                }
                if ((returnValue = statement.getReturnValue()) == null) {
                    return;
                }
                NullableStuffInspectionBase.this.checkNestedGenericClasses(holder, (PsiElement)returnValue, PsiTypesUtil.getMethodReturnType((PsiElement)statement), returnValue.getType(), ConflictNestedTypeProblem.RETURN_NESTED_TYPE_PROBLEM);
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression lambda) {
                if (lambda == null) {
                    1.$$$reportNull$$$0(17);
                }
                super.visitLambdaExpression(lambda);
                PsiElement body = lambda.getBody();
                if (body instanceof PsiExpression) {
                    PsiExpression psiExpression = (PsiExpression)body;
                    NullableStuffInspectionBase.this.checkNestedGenericClasses(holder, body, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda), psiExpression.getType(), ConflictNestedTypeProblem.ASSIGNMENT_NESTED_TYPE_PROBLEM);
                }
            }

            public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
                if (callExpression == null) {
                    1.$$$reportNull$$$0(18);
                }
                PsiExpressionList argList = callExpression.getArgumentList();
                JavaResolveResult result = callExpression.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)result.getElement();
                if (method == null || argList == null) {
                    return;
                }
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiParameter[] parameters = method.getParameterList().getParameters();
                PsiExpression[] arguments = argList.getExpressions();
                for (int i = 0; i < arguments.length; ++i) {
                    PsiExpression argument = arguments[i];
                    if (i >= parameters.length || i >= parameters.length - 1 && MethodCallInstruction.isVarArgCall(method, substitutor, arguments, parameters)) continue;
                    PsiType expectedType = substitutor.substitute(parameters[i].getType());
                    NullableStuffInspectionBase.this.checkNestedGenericClasses(holder, (PsiElement)argument, expectedType, argument.getType(), ConflictNestedTypeProblem.ASSIGNMENT_NESTED_TYPE_PROBLEM);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 2: 
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "annotation";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nullability";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lambda";
                        break;
                    }
                    case 18: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callExpression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPackageStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitModule";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceExpression";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitParameter";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnnotation";
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkRedundantInContainerScope";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkIllegalLocalAnnotation";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceElement";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentExpression";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLocalVariable";
                        break;
                    }
                    case 16: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReturnStatement";
                        break;
                    }
                    case 17: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                    case 18: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private boolean checkNestedGenericClasses(@NotNull ProblemsHolder holder, @NotNull PsiElement errorElement, @Nullable PsiType expectedType, @Nullable PsiType actualType, @NotNull ConflictNestedTypeProblem problem) {
        String messageKey;
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(3);
        }
        if (errorElement == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(4);
        }
        if (problem == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(5);
        }
        if (expectedType == null || actualType == null) {
            return false;
        }
        JavaTypeNullabilityUtil.NullabilityConflictContext context = JavaTypeNullabilityUtil.getNullabilityConflictInAssignment((PsiType)expectedType, (PsiType)actualType, (boolean)this.REPORT_NOT_NULL_TO_NULLABLE_CONFLICTS_IN_ASSIGNMENTS);
        JavaTypeNullabilityUtil.NullabilityConflict conflict = context.nullabilityConflict();
        switch (conflict) {
            default: {
                throw new MatchException(null, null);
            }
            case UNKNOWN: {
                String string = null;
                break;
            }
            case NOT_NULL_TO_NULL: {
                String string = problem.notNullToNullProblem();
                break;
            }
            case NULL_TO_NOT_NULL: {
                String string = problem.nullToNotNullProblem();
                break;
            }
            case COMPLEX: {
                String string = messageKey = problem.complexProblem();
            }
        }
        if (messageKey == null) {
            return false;
        }
        this.reportProblem(holder, errorElement, LocalQuickFix.EMPTY_ARRAY, messageKey, new Object[]{""}, messageKey, new Object[]{NullableStuffInspectionUtil.getNullabilityConflictPresentation(context)});
        return true;
    }

    private void checkConflictingContainerAnnotations(@NotNull ProblemsHolder holder, @Nullable PsiModifierList list) {
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(6);
        }
        if (list == null || !list.hasAnnotations()) {
            return;
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)holder.getProject());
        List conflictingAnnotations = manager.getConflictingContainerAnnotations(list);
        if (!conflictingAnnotations.isEmpty()) {
            for (PsiAnnotation annotation : conflictingAnnotations) {
                this.reportProblem(holder, (PsiElement)annotation, "conflicting.nullability.annotations", new Object[0]);
            }
        }
    }

    private void reportProblem(@NotNull ProblemsHolder holder, PsiElement anchor, String messageKey, Object ... args) {
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(7);
        }
        this.reportProblem(holder, anchor, LocalQuickFix.EMPTY_ARRAY, messageKey, args);
    }

    private void reportProblem(@NotNull ProblemsHolder holder, @NotNull PsiElement anchor, @Nullable LocalQuickFix fix, @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String messageKey, Object ... args) {
        LocalQuickFix[] localQuickFixArray;
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(8);
        }
        if (anchor == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(9);
        }
        if (messageKey == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(10);
        }
        if (fix == null) {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        } else {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = fix;
        }
        this.reportProblem(holder, anchor, localQuickFixArray, messageKey, args);
    }

    private void reportProblem(@NotNull ProblemsHolder holder, @NotNull PsiElement anchor, @Nullable ModCommandAction fix, @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String messageKey, Object ... args) {
        LocalQuickFix[] localQuickFixArray;
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(11);
        }
        if (anchor == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(12);
        }
        if (messageKey == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(13);
        }
        if (fix == null) {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        } else {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = LocalQuickFix.from((ModCommandAction)fix);
        }
        this.reportProblem(holder, anchor, localQuickFixArray, messageKey, args);
    }

    protected void reportProblem(@NotNull ProblemsHolder holder, @NotNull PsiElement anchor, @NotNull @NotNull LocalQuickFix @NotNull [] fixes, @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String messageKey, Object ... args) {
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(14);
        }
        if (anchor == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(15);
        }
        if (messageKey == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(16);
        }
        if (fixes == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(17);
        }
        this.reportProblem(holder, anchor, fixes, messageKey, args, messageKey, args);
    }

    protected void reportProblem(@NotNull ProblemsHolder holder, @NotNull PsiElement anchor, @NotNull @NotNull LocalQuickFix @NotNull [] fixes, @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String descriptionKey, @NotNull @NotNull Object @NotNull [] descriptionArgs, @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String tooltipKey, @NotNull @NotNull Object @NotNull [] tooltipArgs) {
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(18);
        }
        if (anchor == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(19);
        }
        if (descriptionKey == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(20);
        }
        if (tooltipKey == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(21);
        }
        if (fixes == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(22);
        }
        if (descriptionArgs == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(23);
        }
        if (tooltipArgs == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(24);
        }
        ProblemsHolder.ProblemBuilder builder = holder.problem(anchor, JavaAnalysisBundle.message((String)descriptionKey, (Object[])descriptionArgs)).tooltip(JavaAnalysisBundle.message((String)tooltipKey, (Object[])tooltipArgs)).highlight(ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        for (LocalQuickFix quickFix : fixes) {
            builder.fix(quickFix);
        }
        builder.register();
    }

    @Nullable
    @InspectionMessage
    private String checkIndirectInheritance(PsiElement psiClass, PsiClass intf) {
        for (PsiMethod intfMethod : intf.getAllMethods()) {
            String error;
            PsiClass overridingMethodClass;
            PsiClass intfMethodClass = intfMethod.getContainingClass();
            PsiMethod overridingMethod = intfMethodClass == null ? null : JavaOverridingMethodsSearcher.findOverridingMethod((PsiClass)((PsiClass)psiClass), (PsiMethod)intfMethod, (PsiClass)intfMethodClass);
            PsiClass psiClass2 = overridingMethodClass = overridingMethod == null ? null : overridingMethod.getContainingClass();
            if (overridingMethodClass == null || overridingMethodClass == psiClass || (error = this.checkIndirectInheritance(intfMethod, intfMethodClass, overridingMethod, overridingMethodClass)) == null) continue;
            return error;
        }
        return null;
    }

    @Nullable
    @InspectionMessage
    private String checkIndirectInheritance(PsiMethod intfMethod, PsiClass intfMethodClass, PsiMethod overridingMethod, PsiClass overridingMethodClass) {
        PsiParameter[] superParameters;
        if (this.isNullableOverridingNotNull(Annotated.from((PsiModifierListOwner)overridingMethod), intfMethod)) {
            return JavaAnalysisBundle.message((String)"inspection.message.nullable.method.implements.non.null.method", (Object[])new Object[]{overridingMethod.getName(), overridingMethodClass.getName(), intfMethodClass.getName()});
        }
        if (this.isNonAnnotatedOverridingNotNull(overridingMethod, intfMethod)) {
            return JavaAnalysisBundle.message((String)"inspection.message.non.annotated.method.implements.non.null.method", (Object[])new Object[]{overridingMethod.getName(), overridingMethodClass.getName(), intfMethodClass.getName()});
        }
        PsiParameter[] overridingParameters = overridingMethod.getParameterList().getParameters();
        if (overridingParameters.length == (superParameters = intfMethod.getParameterList().getParameters()).length) {
            NullableNotNullManager manager = NullableStuffInspectionBase.getNullityManager(intfMethod);
            for (int i = 0; i < overridingParameters.length; ++i) {
                PsiParameter parameter = overridingParameters[i];
                List<PsiParameter> supers = Collections.singletonList(superParameters[i]);
                if (this.findNullableSuperForNotNullParameter(parameter, supers) != null) {
                    return JavaAnalysisBundle.message((String)"inspection.message.non.null.parameter.should.not.override.nullable.parameter", (Object[])new Object[]{parameter.getName(), overridingMethod.getName(), overridingMethodClass.getName(), intfMethodClass.getName()});
                }
                if (this.findNotNullSuperForNonAnnotatedParameter(manager, parameter, supers) != null) {
                    return JavaAnalysisBundle.message((String)"inspection.message.non.annotated.parameter.should.not.override.non.null.parameter", (Object[])new Object[]{parameter.getName(), overridingMethod.getName(), overridingMethodClass.getName(), intfMethodClass.getName()});
                }
                if (!this.isNotNullParameterOverridingNonAnnotated(manager, parameter, supers)) continue;
                return JavaAnalysisBundle.message((String)"inspection.message.non.null.parameter.should.not.override.non.annotated.parameter", (Object[])new Object[]{parameter.getName(), overridingMethod.getName(), overridingMethodClass.getName(), intfMethodClass.getName()});
            }
        }
        return null;
    }

    private void checkMethodReference(PsiMethodReferenceExpression expression, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(25);
        }
        PsiMethod superMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)expression);
        PsiMethod targetMethod = (PsiMethod)ObjectUtils.tryCast((Object)expression.resolve(), PsiMethod.class);
        if (superMethod == null || targetMethod == null) {
            return;
        }
        PsiElement refName = expression.getReferenceNameElement();
        assert (refName != null);
        if (this.isNullableOverridingNotNull(this.check((PsiModifierListOwner)targetMethod, holder, expression.getType()), superMethod)) {
            this.reportProblem(holder, refName, "inspection.nullable.problems.Nullable.method.overrides.NotNull", NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)targetMethod), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod));
        }
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter) {
        return null;
    }

    private static boolean nullabilityAnnotationsNotAvailable(PsiFile file) {
        Project project = file.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        return ContainerUtil.find((Iterable)NullableNotNullManager.getInstance((Project)project).getNullables(), s -> facade.findClass(s, scope) != null) == null;
    }

    private void checkAccessors(PsiField field, Annotated annotated, Project project, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        PsiClass containingClass;
        PsiMethod setter;
        PsiIdentifier nameIdentifier;
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(26);
        }
        String propName = JavaCodeStyleManager.getInstance((Project)project).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
        boolean isStatic = field.hasModifierProperty("static");
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)field.getContainingClass(), (String)propName, (boolean)isStatic, (boolean)false);
        PsiIdentifier psiIdentifier = nameIdentifier = getter == null ? null : getter.getNameIdentifier();
        if (nameIdentifier != null && nameIdentifier.isPhysical() && PropertyUtil.getFieldOfGetter(getter) == field) {
            AddAnnotationModCommandAction getterAnnoFix = new AddAnnotationModCommandAction(anno, (PsiModifierListOwner)getter, ArrayUtilRt.toStringArray(annoToRemove));
            if (this.REPORT_NOT_ANNOTATED_GETTER && !NullableStuffInspectionBase.hasNullability(manager, (PsiModifierListOwner)getter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)getter.getReturnType())) {
                this.reportProblem(holder, (PsiElement)nameIdentifier, (ModCommandAction)getterAnnoFix, "inspection.nullable.problems.annotated.field.getter.not.annotated", StringUtil.getShortName((String)anno));
            }
            if (annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)getter, false) || annotated.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)getter, false, false)) {
                this.reportProblem(holder, (PsiElement)nameIdentifier, (ModCommandAction)getterAnnoFix, "inspection.nullable.problems.annotated.field.getter.conflict", NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)getter));
            }
        }
        if ((setter = PropertyUtilBase.findPropertySetter((PsiClass)(containingClass = field.getContainingClass()), (String)propName, (boolean)isStatic, (boolean)false)) != null && setter.isPhysical() && PropertyUtil.getFieldOfSetter(setter) == field) {
            PsiIdentifier parameterName;
            PsiParameter[] parameters = setter.getParameterList().getParameters();
            assert (parameters.length == 1) : setter.getText();
            PsiParameter parameter = parameters[0];
            LOG.assertTrue(parameter != null, (Object)setter.getText());
            @NotNull ModCommandAction addAnnoFix = NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter);
            if (this.REPORT_NOT_ANNOTATED_GETTER && !NullableStuffInspectionBase.hasNullability(manager, (PsiModifierListOwner)parameter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter.getType())) {
                parameterName = parameter.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter, parameter, parameterName);
                this.reportProblem(holder, (PsiElement)parameterName, addAnnoFix, "inspection.nullable.problems.annotated.field.setter.parameter.not.annotated", NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field));
            }
            if (PropertyUtil.isSimpleSetter(setter) && annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)parameter, false)) {
                parameterName = parameter.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter, parameter, parameterName);
                this.reportProblem(holder, (PsiElement)parameterName, addAnnoFix, "inspection.nullable.problems.annotated.field.setter.parameter.conflict", NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter));
            }
        }
    }

    @NotNull
    private static ModCommandAction createAddAnnotationFix(@NotNull String anno, @NotNull List<String> annoToRemove, @NotNull PsiParameter parameter) {
        if (anno == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(27);
        }
        if (annoToRemove == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(28);
        }
        if (parameter == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(29);
        }
        return new AddAnnotationModCommandAction(anno, (PsiModifierListOwner)parameter, ArrayUtilRt.toStringArray(annoToRemove));
    }

    @Contract(value="_,_,null -> fail")
    private static void assertValidElement(PsiMethod setter, PsiParameter parameter, PsiIdentifier nameIdentifier1) {
        LOG.assertTrue(nameIdentifier1 != null && nameIdentifier1.isPhysical(), (Object)setter.getText());
        LOG.assertTrue(parameter.isPhysical(), (Object)setter.getText());
    }

    private void checkConstructorParameters(PsiField field, Annotated annotated, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        List<PsiExpression> initializers;
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(30);
        }
        if ((initializers = DfaPsiUtil.findAllConstructorInitializers(field)).isEmpty()) {
            return;
        }
        if (this.REPORT_NOT_ANNOTATED_GETTER) {
            this.reportConstructorParameterFromField(field, anno, annoToRemove, holder, initializers);
        }
        if (field.hasModifierProperty("final")) {
            this.checkFinalFieldInitializedNotNull(field, annotated, holder, initializers);
        }
    }

    private void checkFinalFieldInitializedNotNull(@NotNull PsiField field, @NotNull Annotated annotated, @NotNull ProblemsHolder holder, @NotNull List<PsiExpression> initializers) {
        if (field == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(31);
        }
        if (annotated == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(32);
        }
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(33);
        }
        if (initializers == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(34);
        }
        ArrayList<PsiParameter> notNullParams = new ArrayList<PsiParameter>();
        for (PsiExpression rhs : initializers) {
            PsiReferenceExpression ref;
            PsiElement target;
            if (!(rhs instanceof PsiReferenceExpression) || !NullableStuffInspectionBase.isConstructorParameter(target = (ref = (PsiReferenceExpression)rhs).resolve()) || !target.isPhysical()) continue;
            PsiParameter parameter = (PsiParameter)target;
            if (!annotated.isDeclaredNullable || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false)) continue;
            notNullParams.add(parameter);
        }
        if (notNullParams.size() != initializers.size()) {
            return;
        }
        PsiIdentifier nameIdentifier = field.getNameIdentifier();
        if (nameIdentifier.isPhysical()) {
            this.reportProblem(holder, (PsiElement)nameIdentifier, AddAnnotationModCommandAction.createAddNotNullFix((PsiModifierListOwner)field), "0.field.is.always.initialized.not.null", NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field));
        }
    }

    private void reportConstructorParameterFromField(@NotNull PsiField field, @NotNull String anno, @NotNull List<String> annoToRemove, @NotNull ProblemsHolder holder, @NotNull List<PsiExpression> initializers) {
        if (field == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(35);
        }
        if (anno == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(36);
        }
        if (annoToRemove == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(37);
        }
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(38);
        }
        if (initializers == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(39);
        }
        Map ctorToInitializers = StreamEx.of(initializers).mapToEntry(e -> (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)e, PsiMethod.class), e -> e).nonNullKeys().filterKeys(PsiMethod::isConstructor).grouping();
        ctorToInitializers.forEach((ctor, exprs) -> {
            PsiIdentifier nameIdentifier;
            List parameters = ((StreamEx)((StreamEx)StreamEx.of((Collection)exprs).map(e -> {
                PsiParameter psiParameter;
                PsiExpression patt0$temp = PsiUtil.skipParenthesizedExprDown((PsiExpression)e);
                if (patt0$temp instanceof PsiReferenceExpression) {
                    PsiReferenceExpression ref = (PsiReferenceExpression)patt0$temp;
                    psiParameter = (PsiParameter)ObjectUtils.tryCast((Object)ref.resolve(), PsiParameter.class);
                } else {
                    psiParameter = null;
                }
                return psiParameter;
            }).distinct()).limit(2L)).toList();
            if (parameters.size() != 1) {
                return;
            }
            PsiParameter parameter = (PsiParameter)parameters.getFirst();
            if (parameter != null && parameter.getDeclarationScope() == ctor && !NullableStuffInspectionBase.hasNullability(NullableNotNullManager.getInstance((Project)field.getProject()), (PsiModifierListOwner)parameter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter.getType()) && (nameIdentifier = parameter.getNameIdentifier()) != null && nameIdentifier.isPhysical()) {
                this.reportProblem(holder, (PsiElement)nameIdentifier, NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter), "inspection.nullable.problems.annotated.field.constructor.parameter.not.annotated", StringUtil.getShortName((String)anno));
            }
        });
    }

    private static boolean isConstructorParameter(@Nullable PsiElement parameter) {
        return parameter instanceof PsiParameter && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiParameterList.class).withParent((ElementPattern)PsiJavaPatterns.psiMethod().constructor(true))).accepts((Object)parameter.getParent());
    }

    @NotNull
    private static String getPresentableAnnoName(@NotNull PsiModifierListOwner owner) {
        NullableNotNullManager manager;
        NullabilityAnnotationInfo info;
        String name;
        if (owner == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(40);
        }
        String string = name = (info = (manager = NullableNotNullManager.getInstance((Project)owner.getProject())).findEffectiveNullabilityInfo(owner)) == null ? null : info.getAnnotation().getQualifiedName();
        if (name == null) {
            return "???";
        }
        String string2 = StringUtil.getShortName((String)name);
        if (string2 == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(41);
        }
        return string2;
    }

    public static String getPresentableAnnoName(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(42);
        }
        return StringUtil.getShortName((String)StringUtil.notNullize((String)annotation.getQualifiedName(), (String)"???"));
    }

    private static boolean hasNullability(@NotNull NullableNotNullManager manager, @NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info;
        if (manager == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(43);
        }
        if (owner == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(44);
        }
        return (info = manager.findEffectiveNullabilityInfo(owner)) != null && info.getNullability() != Nullability.UNKNOWN && info.getInheritedFrom() == null;
    }

    private Annotated check(PsiModifierListOwner owner, ProblemsHolder holder, PsiType type) {
        PsiAnnotation annotation;
        Annotated annotated = Annotated.from(owner);
        PsiAnnotation psiAnnotation = annotation = annotated.notNull == null ? annotated.nullable : annotated.notNull;
        if (annotation != null && !annotation.isPhysical() && type instanceof PsiPrimitiveType) {
            this.reportIncorrectLocation(holder, annotation, owner, "inspection.nullable.problems.primitive.type.annotation", new LocalQuickFix[0]);
        }
        if (owner instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)owner;
            Nullability expectedNullability = DfaPsiUtil.inferParameterNullability(parameter);
            if (annotated.notNull != null && expectedNullability == Nullability.NULLABLE) {
                this.reportParameterNullabilityMismatch(parameter, annotated.notNull, holder, "parameter.can.be.null");
            } else if (annotated.nullable != null && expectedNullability == Nullability.NOT_NULL) {
                this.reportParameterNullabilityMismatch(parameter, annotated.nullable, holder, "parameter.is.always.not.null");
            }
        }
        return annotated;
    }

    private void reportParameterNullabilityMismatch(@NotNull PsiParameter owner, @NotNull PsiAnnotation annotation, @NotNull ProblemsHolder holder, @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String messageKey) {
        PsiAnnotation anchor;
        if (owner == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(45);
        }
        if (annotation == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(46);
        }
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(47);
        }
        if (messageKey == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(48);
        }
        if (annotation.isPhysical() && !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)annotation, (boolean)true)) {
            return;
        }
        Object object = anchor = annotation.isPhysical() ? annotation : owner.getNameIdentifier();
        if (anchor != null && !anchor.getTextRange().isEmpty()) {
            this.reportProblem(holder, (PsiElement)anchor, (LocalQuickFix)new RemoveAnnotationQuickFix(annotation, (PsiModifierListOwner)owner), messageKey, new Object[0]);
        }
    }

    private void reportIncorrectLocation(ProblemsHolder holder, PsiAnnotation annotation, @Nullable PsiModifierListOwner listOwner, @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String messageKey, LocalQuickFix ... additionalFixes) {
        Object[] objectArray;
        if (messageKey == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(49);
        }
        if (additionalFixes == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(50);
        }
        RemoveAnnotationQuickFix removeFix = new RemoveAnnotationQuickFix(annotation, listOwner, true);
        MoveAnnotationToBoundFix moveToBoundFix = MoveAnnotationToBoundFix.create(annotation);
        if (moveToBoundFix == null) {
            Object[] objectArray2 = new LocalQuickFix[1];
            objectArray = objectArray2;
            objectArray2[0] = removeFix;
        } else {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[2];
            localQuickFixArray[0] = moveToBoundFix;
            objectArray = localQuickFixArray;
            localQuickFixArray[1] = removeFix;
        }
        Object[] fixes = objectArray;
        this.reportProblem(holder, (PsiElement)(!annotation.isPhysical() && listOwner != null ? listOwner.getNavigationElement() : annotation), (LocalQuickFix[])ArrayUtil.mergeArrays((Object[])additionalFixes, (Object[])fixes), messageKey, new Object[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.probable.bugs", (Object[])new Object[0]);
        if (string == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "NullableProblems";
    }

    private void checkNullableStuffForMethod(PsiMethod method, ProblemsHolder holder) {
        Annotated annotated = this.check((PsiModifierListOwner)method, holder, method.getReturnType());
        List superMethods = ContainerUtil.map((Collection)method.findSuperMethodSignaturesIncludingStatic(true), MethodSignatureBackedByPsiMethod::getMethod);
        NullableNotNullManager nullableManager = NullableNotNullManager.getInstance((Project)holder.getProject());
        this.checkSupers(method, holder, annotated, superMethods);
        this.checkParameters(method, holder, superMethods, nullableManager);
        this.checkOverriders(method, holder, annotated, nullableManager);
        this.checkConflictingContainerAnnotations(holder, method.getModifierList());
    }

    private void checkSupers(PsiMethod method, ProblemsHolder holder, Annotated annotated, List<? extends PsiMethod> superMethods) {
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier == null) {
            return;
        }
        for (PsiMethod psiMethod : superMethods) {
            if (this.isNullableOverridingNotNull(annotated, psiMethod)) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (Collection)NullableStuffInspectionBase.getNullityManager(method).getNullables(), (boolean)true);
                this.reportProblem(holder, (PsiElement)(annotation != null ? annotation : identifier), "inspection.nullable.problems.Nullable.method.overrides.NotNull", NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)method), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)psiMethod));
                break;
            }
            if (this.isNonAnnotatedOverridingNotNull(method, psiMethod)) {
                this.reportProblem(holder, (PsiElement)identifier, NullableStuffInspectionBase.createFixForNonAnnotatedOverridesNotNull(method), "inspection.nullable.problems.method.overrides.NotNull", NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)psiMethod));
                break;
            }
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnTypeElement == null || !this.checkNestedGenericClasses(holder, (PsiElement)returnTypeElement, psiMethod.getReturnType(), method.getReturnType(), ConflictNestedTypeProblem.OVERRIDING_NESTED_TYPE_PROBLEM)) continue;
            break;
        }
    }

    private static NullableNotNullManager getNullityManager(PsiMethod method) {
        return NullableNotNullManager.getInstance((Project)method.getProject());
    }

    @Nullable
    private static LocalQuickFix createFixForNonAnnotatedOverridesNotNull(PsiMethod method) {
        NullableNotNullManager nullableManager = NullableStuffInspectionBase.getNullityManager(method);
        return AnnotationUtil.isAnnotatingApplicable((PsiElement)method, (String)nullableManager.getDefaultNotNull()) ? LocalQuickFix.from((ModCommandAction)AddAnnotationModCommandAction.createAddNotNullFix((PsiModifierListOwner)method)) : null;
    }

    private boolean isNullableOverridingNotNull(Annotated methodInfo, PsiMethod superMethod) {
        return this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE && methodInfo.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superMethod, true, false);
    }

    private boolean isNonAnnotatedOverridingNotNull(PsiMethod method, PsiMethod superMethod) {
        NullableNotNullManager manager;
        NullabilityAnnotationInfo info;
        return this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL && !(method.getReturnType() instanceof PsiPrimitiveType) && !method.isConstructor() && ((info = (manager = NullableStuffInspectionBase.getNullityManager(method)).findEffectiveNullabilityInfo((PsiModifierListOwner)method)) == null || info.isInferred() || info.getInheritedFrom() != null && manager.findContainerAnnotation((PsiModifierListOwner)method) == null) && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superMethod, true, this.IGNORE_EXTERNAL_SUPER_NOTNULL) && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)superMethod);
    }

    private static boolean hasInheritableNotNull(PsiModifierListOwner owner) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"javax.annotation.constraints.NotNull", (int)9);
    }

    private void checkParameters(PsiMethod method, ProblemsHolder holder, List<? extends PsiMethod> superMethods, NullableNotNullManager nullableManager) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            if (parameter.getType() instanceof PsiPrimitiveType) continue;
            List<PsiParameter> superParameters = NullableStuffInspectionBase.getSuperParameters(superMethods, parameters, i);
            this.checkSuperParameterAnnotations(holder, nullableManager, parameter, superParameters);
            this.checkNullLiteralArgumentOfNotNullParameterUsages(method, holder, nullableManager, i, parameter);
        }
    }

    @NotNull
    private static List<PsiParameter> getSuperParameters(List<? extends PsiMethod> superMethods, PsiParameter[] parameters, int i) {
        ArrayList<PsiParameter> superParameters = new ArrayList<PsiParameter>();
        for (PsiMethod psiMethod : superMethods) {
            PsiParameter[] _superParameters = psiMethod.getParameterList().getParameters();
            if (_superParameters.length != parameters.length) continue;
            superParameters.add(_superParameters[i]);
        }
        ArrayList<PsiParameter> arrayList = superParameters;
        if (arrayList == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    private void checkSuperParameterAnnotations(ProblemsHolder holder, NullableNotNullManager nullableManager, PsiParameter parameter, List<PsiParameter> superParameters) {
        PsiTypeElement typeElement;
        PsiParameter notNullSuper;
        PsiIdentifier nameIdentifier = parameter.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        PsiParameter nullableSuper = this.findNullableSuperForNotNullParameter(parameter, superParameters);
        if (nullableSuper != null) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)nullableManager.getNotNulls(), (boolean)true);
            this.reportProblem(holder, (PsiElement)(annotation != null ? annotation : nameIdentifier), "inspection.nullable.problems.NotNull.parameter.overrides.Nullable", NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)nullableSuper));
        }
        if ((notNullSuper = this.findNotNullSuperForNonAnnotatedParameter(nullableManager, parameter, superParameters)) != null) {
            LocalQuickFix fix = AnnotationUtil.isAnnotatingApplicable((PsiElement)parameter, (String)nullableManager.getDefaultAnnotation(Nullability.NOT_NULL, (PsiElement)parameter)) ? LocalQuickFix.from((ModCommandAction)AddAnnotationModCommandAction.createAddNotNullFix((PsiModifierListOwner)parameter)) : null;
            this.reportProblem(holder, (PsiElement)nameIdentifier, fix, "inspection.nullable.problems.parameter.overrides.NotNull", NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)notNullSuper));
        }
        if (this.isNotNullParameterOverridingNonAnnotated(nullableManager, parameter, superParameters)) {
            NullabilityAnnotationInfo info = nullableManager.findOwnNullabilityInfo((PsiModifierListOwner)parameter);
            assert (info != null);
            PsiAnnotation notNullAnnotation = info.getAnnotation();
            boolean physical = PsiTreeUtil.isAncestor((PsiElement)parameter, (PsiElement)notNullAnnotation, (boolean)true);
            RemoveAnnotationQuickFix fix = physical ? new RemoveAnnotationQuickFix(notNullAnnotation, (PsiModifierListOwner)parameter) : null;
            this.reportProblem(holder, (PsiElement)(physical ? notNullAnnotation : nameIdentifier), (LocalQuickFix)fix, "inspection.nullable.problems.NotNull.parameter.overrides.not.annotated", NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter));
        }
        if ((typeElement = parameter.getTypeElement()) != null) {
            for (PsiParameter superParameter : superParameters) {
                if (!this.checkNestedGenericClasses(holder, (PsiElement)typeElement, parameter.getType(), superParameter.getType(), ConflictNestedTypeProblem.OVERRIDING_NESTED_TYPE_PROBLEM)) continue;
                break;
            }
        }
    }

    @Nullable
    private PsiParameter findNotNullSuperForNonAnnotatedParameter(NullableNotNullManager nullableManager, PsiParameter parameter, List<? extends PsiParameter> superParameters) {
        return this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL && !NullableStuffInspectionBase.hasNullability(nullableManager, (PsiModifierListOwner)parameter) ? (PsiParameter)ContainerUtil.find(superParameters, sp -> NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)sp, false, this.IGNORE_EXTERNAL_SUPER_NOTNULL) && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)sp)) : null;
    }

    @Nullable
    private PsiParameter findNullableSuperForNotNullParameter(PsiParameter parameter, List<? extends PsiParameter> superParameters) {
        if (!this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false)) {
            return null;
        }
        PsiClass derived = PsiUtil.getContainingClass((PsiElement)parameter);
        for (PsiParameter psiParameter : superParameters) {
            PsiClass base = PsiUtil.getContainingClass((PsiElement)psiParameter);
            PsiSubstitutor substitutor = base == null || derived == null ? PsiSubstitutor.EMPTY : TypeConversionUtil.getSuperClassSubstitutor((PsiClass)base, (PsiClass)derived, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiType superType = substitutor.substitute(psiParameter.getType());
            if (DfaPsiUtil.getElementNullabilityForRead(superType, (PsiModifierListOwner)psiParameter) != Nullability.NULLABLE) continue;
            return psiParameter;
        }
        return null;
    }

    private boolean isNotNullParameterOverridingNonAnnotated(NullableNotNullManager nullableManager, PsiParameter parameter, List<? extends PsiParameter> superParameters) {
        if (!this.REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED) {
            return false;
        }
        NullabilityAnnotationInfo info = nullableManager.findOwnNullabilityInfo((PsiModifierListOwner)parameter);
        return info != null && info.getNullability() == Nullability.NOT_NULL && !info.isInferred() && ContainerUtil.exists(superParameters, sp -> NullableStuffInspectionBase.isSuperNotAnnotated(nullableManager, parameter, sp));
    }

    private static boolean isSuperNotAnnotated(NullableNotNullManager nullableManager, PsiParameter parameter, PsiParameter superParameter) {
        if (NullableStuffInspectionBase.hasNullability(nullableManager, (PsiModifierListOwner)superParameter)) {
            return false;
        }
        if (ContainerUtil.exists((Iterable)AnnotationUtil.getSuperAnnotationOwners((PsiModifierListOwner)superParameter), superSuperParameter -> NullableStuffInspectionBase.hasNullability(nullableManager, (PsiModifierListOwner)superSuperParameter))) {
            return false;
        }
        PsiType type = superParameter.getType();
        if (TypeUtils.isTypeParameter(type)) {
            PsiClass childClass = PsiUtil.getContainingClass((PsiElement)parameter);
            PsiClass superClass = PsiUtil.getContainingClass((PsiElement)superParameter);
            if (superClass != null && childClass != null) {
                PsiType substituted = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)childClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).substitute(type);
                return DfaPsiUtil.getTypeNullability(substituted) == Nullability.UNKNOWN;
            }
        }
        return true;
    }

    private void checkNullLiteralArgumentOfNotNullParameterUsages(PsiMethod method, ProblemsHolder holder, NullableNotNullManager nullableManager, int parameterIdx, PsiParameter parameter) {
        PsiParameter owner;
        if (!this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER || !holder.isOnTheFly()) {
            return;
        }
        Object object = owner = parameter.isPhysical() ? parameter : JavaPsiRecordUtil.getComponentForCanonicalConstructorParameter((PsiParameter)parameter);
        if (owner == null) {
            return;
        }
        PsiIdentifier elementToHighlight = null;
        NullabilityAnnotationInfo info = nullableManager.findOwnNullabilityInfo((PsiModifierListOwner)owner);
        if (info != null && !info.isInferred()) {
            if (info.getNullability() == Nullability.NOT_NULL) {
                PsiAnnotation notNullAnnotation = info.getAnnotation();
                boolean physical = PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)notNullAnnotation, (boolean)true);
                elementToHighlight = physical ? notNullAnnotation : owner.getNameIdentifier();
            }
        } else {
            info = DfaPsiUtil.getTypeNullabilityInfo(owner.getType());
            if (info != null && info.getNullability() == Nullability.NOT_NULL) {
                elementToHighlight = owner.getNameIdentifier();
            }
        }
        if (elementToHighlight == null || !JavaNullMethodArgumentUtil.hasNullArgument(method, parameterIdx)) {
            return;
        }
        this.reportProblem(holder, (PsiElement)elementToHighlight, this.createNavigateToNullParameterUsagesFix(parameter), "inspection.nullable.problems.NotNull.parameter.receives.null.literal", StringUtil.getShortName((String)Objects.requireNonNull(info.getAnnotation().getQualifiedName())));
    }

    private void checkOverriders(@NotNull PsiMethod method, @NotNull ProblemsHolder holder, @NotNull Annotated annotated, @NotNull NullableNotNullManager nullableManager) {
        if (method == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(53);
        }
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(54);
        }
        if (annotated == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(55);
        }
        if (nullableManager == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(56);
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS) {
            boolean checkReturnType;
            boolean[] checkParameter = new boolean[parameters.length];
            boolean[] parameterQuickFixSuggested = new boolean[parameters.length];
            boolean hasAnnotatedParameter = false;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                checkParameter[i] = NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false) && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)parameter) && !(parameter.getType() instanceof PsiPrimitiveType);
                hasAnnotatedParameter |= checkParameter[i];
            }
            boolean bl = checkReturnType = annotated.isDeclaredNotNull && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)method) && !(method.getReturnType() instanceof PsiPrimitiveType);
            if (hasAnnotatedParameter || checkReturnType) {
                PsiMethod[] overridings = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY);
                boolean methodQuickFixSuggested = false;
                for (PsiMethod overriding : overridings) {
                    PsiAnnotation psiElement;
                    if (NullableStuffInspectionBase.shouldSkipOverriderAsGenerated(overriding)) continue;
                    String defaultNotNull = nullableManager.getDefaultAnnotation(Nullability.NOT_NULL, (PsiElement)overriding);
                    if (!methodQuickFixSuggested && checkReturnType && !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)overriding, false, false) && (NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)overriding, false) || !NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)overriding, true)) && AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)overriding, defaultNotNull)) {
                        PsiIdentifier identifier = method.getNameIdentifier();
                        NullabilityAnnotationInfo info = nullableManager.findOwnNullabilityInfo((PsiModifierListOwner)method);
                        if (info != null) {
                            PsiAnnotation annotation = info.getAnnotation();
                            String[] annotationsToRemove = ArrayUtilRt.toStringArray((Collection)nullableManager.getNullables());
                            MyAnnotateMethodFix fix = AnnotationUtil.isAnnotatingApplicable((PsiElement)overriding, (String)defaultNotNull) ? new MyAnnotateMethodFix(Nullability.NOT_NULL, annotationsToRemove) : null;
                            psiElement = annotation;
                            if ((!annotation.isPhysical() || !PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)annotation, (boolean)true)) && (psiElement = identifier) == null) continue;
                            this.reportProblem(holder, (PsiElement)psiElement, fix, "nullable.stuff.problems.overridden.methods.are.not.annotated", new Object[0]);
                            methodQuickFixSuggested = true;
                        }
                    }
                    if (!hasAnnotatedParameter) continue;
                    PsiParameter[] psiParameters = overriding.getParameterList().getParameters();
                    for (int i = 0; i < psiParameters.length; ++i) {
                        if (parameterQuickFixSuggested[i]) continue;
                        PsiParameter parameter = psiParameters[i];
                        if (!checkParameter[i] || NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false) || NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)parameter, false) || !AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)parameter, defaultNotNull)) continue;
                        PsiIdentifier identifier = parameters[i].getNameIdentifier();
                        NullabilityAnnotationInfo info = nullableManager.findOwnNullabilityInfo((PsiModifierListOwner)parameters[i]);
                        PsiAnnotation psiAnnotation = psiElement = info == null ? null : info.getAnnotation();
                        if ((psiElement == null || !psiElement.isPhysical()) && (psiElement = identifier) == null) continue;
                        AnnotateOverriddenMethodParameterFix fix = AnnotationUtil.isAnnotatingApplicable((PsiElement)parameter, (String)defaultNotNull) ? new AnnotateOverriddenMethodParameterFix(Nullability.NOT_NULL) : null;
                        this.reportProblem(holder, (PsiElement)psiElement, fix, "nullable.stuff.problems.overridden.method.parameters.are.not.annotated", new Object[0]);
                        parameterQuickFixSuggested[i] = true;
                    }
                }
            }
        }
    }

    public static boolean shouldSkipOverriderAsGenerated(PsiMethod overriding) {
        if (Registry.is((String)"idea.report.nullity.missing.in.generated.overriders")) {
            return false;
        }
        PsiFile file = overriding.getContainingFile();
        VirtualFile virtualFile = file != null ? file.getVirtualFile() : null;
        return virtualFile != null && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile, (Project)overriding.getProject());
    }

    private static boolean isNotNullNotInferred(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean skipExternal) {
        Project project;
        NullableNotNullManager manager;
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(57);
        }
        if ((info = (manager = NullableNotNullManager.getInstance((Project)(project = owner.getProject()))).findEffectiveNullabilityInfo(owner)) == null || info.isInferred() || info.getNullability() != Nullability.NOT_NULL) {
            return false;
        }
        if (!checkBases && info.getInheritedFrom() != null) {
            return false;
        }
        return !skipExternal || !info.isExternal();
    }

    public static boolean isNullableNotInferred(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        Project project;
        NullableNotNullManager manager;
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(58);
        }
        return (info = (manager = NullableNotNullManager.getInstance((Project)(project = owner.getProject()))).findEffectiveNullabilityInfo(owner)) != null && !info.isInferred() && info.getNullability() == Nullability.NULLABLE && (checkBases || info.getInheritedFrom() == null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 41, 51, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 25: 
            case 26: 
            case 30: 
            case 33: 
            case 38: 
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 41: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/nullable/NullableStuffInspectionBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionKey";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipKey";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionArgs";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipArgs";
                break;
            }
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoToRemove";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 32: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotated";
                break;
            }
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializers";
                break;
            }
            case 40: 
            case 44: 
            case 45: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFixes";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullableManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/nullable/NullableStuffInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableAnnoName";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 41: 
            case 51: 
            case 52: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkNestedGenericClasses";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkConflictingContainerAnnotations";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "reportProblem";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodReference";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkAccessors";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createAddAnnotationFix";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorParameters";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkFinalFieldInitializedNotNull";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "reportConstructorParameterFromField";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableAnnoName";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "hasNullability";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "reportParameterNullabilityMismatch";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "reportIncorrectLocation";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "checkOverriders";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullNotInferred";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isNullableNotInferred";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 41, 51, 52 -> new IllegalStateException(string);
        };
    }

    private static enum ConflictNestedTypeProblem {
        RETURN_NESTED_TYPE_PROBLEM("returning.a.class.with.notnull.arguments", "returning.a.class.with.nullable.arguments"),
        ASSIGNMENT_NESTED_TYPE_PROBLEM("assigning.a.class.with.notnull.elements", "assigning.a.class.with.nullable.elements"),
        OVERRIDING_NESTED_TYPE_PROBLEM("overriding.a.class.with.notnull.elements", "overriding.a.class.with.nullable.elements");

        @NotNull
        @PropertyKey(resourceBundle="messages.JavaAnalysisBundle")
        private final @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String notNullToNullProblemMessage;
        @NotNull
        @PropertyKey(resourceBundle="messages.JavaAnalysisBundle")
        private final @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String nullToNotNullProblemMessage;
        @NotNull
        @PropertyKey(resourceBundle="messages.JavaAnalysisBundle")
        private final @NotNull @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String complexProblem;

        private ConflictNestedTypeProblem(String notNullToNullProblemMessage, String nullToNotNullProblemMessage) {
            if (notNullToNullProblemMessage == null) {
                ConflictNestedTypeProblem.$$$reportNull$$$0(0);
            }
            if (nullToNotNullProblemMessage == null) {
                ConflictNestedTypeProblem.$$$reportNull$$$0(1);
            }
            this.notNullToNullProblemMessage = notNullToNullProblemMessage;
            this.nullToNotNullProblemMessage = nullToNotNullProblemMessage;
            this.complexProblem = "complex.problem.with.nullability";
        }

        @NotNull
        @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String notNullToNullProblem() {
            String string = this.notNullToNullProblemMessage;
            if (string == null) {
                ConflictNestedTypeProblem.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String nullToNotNullProblem() {
            String string = this.nullToNotNullProblemMessage;
            if (string == null) {
                ConflictNestedTypeProblem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String complexProblem() {
            String string = this.complexProblem;
            if (string == null) {
                ConflictNestedTypeProblem.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notNullToNullProblemMessage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullToNotNullProblemMessage";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$ConflictNestedTypeProblem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$ConflictNestedTypeProblem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "notNullToNullProblem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nullToNotNullProblem";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "complexProblem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class Annotated {
        private final boolean isDeclaredNotNull;
        private final boolean isDeclaredNullable;
        @Nullable
        private final PsiAnnotation notNull;
        @Nullable
        private final PsiAnnotation nullable;

        private Annotated(@Nullable PsiAnnotation notNull, @Nullable PsiAnnotation nullable) {
            this.isDeclaredNotNull = notNull != null;
            this.isDeclaredNullable = nullable != null;
            this.notNull = notNull;
            this.nullable = nullable;
        }

        @NotNull
        static Annotated from(@NotNull PsiModifierListOwner owner) {
            if (owner == null) {
                Annotated.$$$reportNull$$$0(0);
            }
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner.getProject());
            NullabilityAnnotationInfo notNullInfo = manager.findNullabilityAnnotationInfo(owner, Collections.singleton(Nullability.NOT_NULL));
            NullabilityAnnotationInfo nullableInfo = manager.findNullabilityAnnotationInfo(owner, Collections.singleton(Nullability.NULLABLE));
            PsiAnnotation notNullAnno = notNullInfo == null || notNullInfo.isContainer() && nullableInfo != null && !nullableInfo.isContainer() ? null : notNullInfo.getAnnotation();
            PsiAnnotation nullableAnno = nullableInfo == null || nullableInfo.isContainer() && notNullInfo != null && !notNullInfo.isContainer() ? null : nullableInfo.getAnnotation();
            return new Annotated(notNullAnno, nullableAnno);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$Annotated", "from"));
        }
    }

    private static class MyAnnotateMethodFix
    implements LocalQuickFix {
        @NotNull
        private final Nullability myNullability;
        private final String[] myAnnotationsToRemove;

        MyAnnotateMethodFix(@NotNull Nullability nullability, String ... annotationsToRemove) {
            if (nullability == null) {
                MyAnnotateMethodFix.$$$reportNull$$$0(0);
            }
            if (annotationsToRemove == null) {
                MyAnnotateMethodFix.$$$reportNull$$$0(1);
            }
            this.myNullability = nullability;
            this.myAnnotationsToRemove = annotationsToRemove.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : annotationsToRemove;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.annotate.overridden.method.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyAnnotateMethodFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            PsiMethod method;
            if (project == null) {
                MyAnnotateMethodFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyAnnotateMethodFix.$$$reportNull$$$0(4);
            }
            if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(psiElement = descriptor.getPsiElement()), PsiMethod.class)) == null) {
                return;
            }
            ArrayList toAnnotate = new ArrayList();
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
            if (!AnnotateOverriddenMethodParameterFix.processModifiableInheritorsUnderProgress(method, psiMethod -> {
                NullabilityAnnotationInfo info = manager.findEffectiveNullabilityInfo((PsiModifierListOwner)psiMethod);
                if (info != null && info.getNullability() == this.myNullability && !info.isInferred() && info.getInheritedFrom() == null) {
                    return;
                }
                String annotation = manager.getDefaultAnnotation(this.myNullability, (PsiElement)psiMethod);
                if (AnnotationUtil.isAnnotatingApplicable((PsiElement)psiMethod, (String)annotation) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)annotation, (int)10)) {
                    toAnnotate.add(psiMethod);
                }
            })) {
                return;
            }
            FileModificationService.getInstance().preparePsiElementsForWrite(toAnnotate);
            for (PsiMethod psiMethod2 : toAnnotate) {
                String annotation = manager.getDefaultAnnotation(this.myNullability, (PsiElement)psiMethod2);
                AddAnnotationPsiFix fix = new AddAnnotationPsiFix(annotation, (PsiModifierListOwner)psiMethod2, this.myAnnotationsToRemove);
                fix.invoke(psiMethod2.getProject(), psiMethod2.getContainingFile(), (PsiElement)psiMethod2, (PsiElement)psiMethod2);
            }
            UndoUtil.markPsiFileForUndo((PsiFile)method.getContainingFile());
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                MyAnnotateMethodFix.$$$reportNull$$$0(5);
            }
            if (previewDescriptor == null) {
                MyAnnotateMethodFix.$$$reportNull$$$0(6);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                MyAnnotateMethodFix.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }

        @NotNull
        public String getName() {
            String string = JavaAnalysisBundle.message((String)"inspection.annotate.overridden.method.nullable.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                MyAnnotateMethodFix.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullability";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotationsToRemove";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$MyAnnotateMethodFix";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$MyAnnotateMethodFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

