/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JavaTypeNullabilityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NullableStuffInspectionUtil {
    NullableStuffInspectionUtil() {
    }

    @NotNull
    @NlsSafe
    static HtmlChunk getNullabilityConflictPresentation(@NotNull JavaTypeNullabilityUtil.NullabilityConflictContext context) {
        if (context == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(0);
        }
        HtmlChunk expectedChunk = NullableStuffInspectionUtil.getSideChunk(context, JavaTypeNullabilityUtil.Side.EXPECTED);
        HtmlChunk actualChunk = NullableStuffInspectionUtil.getSideChunk(context, JavaTypeNullabilityUtil.Side.ACTUAL);
        if (expectedChunk.isEmpty() || actualChunk.isEmpty()) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                NullableStuffInspectionUtil.$$$reportNull$$$0(1);
            }
            return htmlChunk;
        }
        HtmlChunk.Element element = HtmlChunk.tag((String)"table").children(new HtmlChunk[]{expectedChunk, actualChunk});
        if (element == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(2);
        }
        return element;
    }

    @NotNull
    private static HtmlChunk getSideChunk(@NotNull JavaTypeNullabilityUtil.NullabilityConflictContext context, @NotNull JavaTypeNullabilityUtil.Side side) {
        HtmlChunk result;
        int n;
        PsiElement place;
        if (context == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(3);
        }
        if (side == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(4);
        }
        if ((place = context.getPlace(side)) == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                NullableStuffInspectionUtil.$$$reportNull$$$0(5);
            }
            return htmlChunk;
        }
        PsiType psiType = context.getType(side);
        if (psiType instanceof PsiArrayType) {
            PsiArrayType type = (PsiArrayType)psiType;
            n = type.getArrayDimensions();
        } else {
            n = 0;
        }
        int dimensionsInArray = n;
        PsiTypeElement topmostType = (PsiTypeElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)place, PsiTypeElement.class);
        if (topmostType == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                NullableStuffInspectionUtil.$$$reportNull$$$0(6);
            }
            return htmlChunk;
        }
        PsiTypeElement target = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)place, PsiTypeElement.class, (boolean)false);
        if (target == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                NullableStuffInspectionUtil.$$$reportNull$$$0(7);
            }
            return htmlChunk;
        }
        PsiType outerType = topmostType.getType();
        if (target == topmostType) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                NullableStuffInspectionUtil.$$$reportNull$$$0(8);
            }
            return htmlChunk;
        }
        List<Integer> path = NullableStuffInspectionUtil.computeTypeArgumentPath(topmostType, target, dimensionsInArray);
        if (path == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                NullableStuffInspectionUtil.$$$reportNull$$$0(9);
            }
            return htmlChunk;
        }
        Context presentationContext = NullableStuffInspectionUtil.getPresentationContext(outerType, path, outerType instanceof PsiArrayType);
        String typeText = presentationContext.sb.toString();
        String annotationText = NullableStuffInspectionUtil.getAnnotationText(context, side);
        if (presentationContext.position == null || annotationText == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                NullableStuffInspectionUtil.$$$reportNull$$$0(10);
            }
            return htmlChunk;
        }
        HtmlChunk htmlChunk = result = NullableStuffInspectionUtil.generateHtmlChunk(typeText, "@" + annotationText, side, presentationContext.position);
        if (htmlChunk == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(11);
        }
        return htmlChunk;
    }

    @Nullable
    private static String getAnnotationText(@NotNull JavaTypeNullabilityUtil.NullabilityConflictContext context, @NotNull JavaTypeNullabilityUtil.Side side) {
        PsiAnnotation annotation;
        if (context == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(12);
        }
        if (side == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(13);
        }
        if ((annotation = context.getAnnotation(side)) == null) {
            return null;
        }
        PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
        if (ref == null) {
            return null;
        }
        return ref.getReferenceName();
    }

    @NotNull
    private static HtmlChunk generateHtmlChunk(@NlsSafe String text, @NlsSafe String annotationText, @NotNull JavaTypeNullabilityUtil.Side side, int position) {
        if (side == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(14);
        }
        HtmlChunk.Element element = HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{HtmlChunk.tag((String)"td").addText(JavaAnalysisBundle.message((String)(side == JavaTypeNullabilityUtil.Side.EXPECTED ? "expected.type.nullability.conflict.message" : "actual.type.nullability.conflict.message"), (Object[])new Object[0])), HtmlChunk.tag((String)"td").children(new HtmlChunk[]{HtmlChunk.text((String)text.substring(0, position)), HtmlChunk.tag((String)"b").addText(annotationText), HtmlChunk.text((String)" "), HtmlChunk.text((String)text.substring(position))})});
        if (element == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(15);
        }
        return element;
    }

    private static @Nullable List<@NotNull Integer> computeTypeArgumentPath(@NotNull PsiTypeElement top, @NotNull PsiTypeElement target, int firstArrayDepth) {
        if (top == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(16);
        }
        if (target == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(17);
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        PsiTypeElement current = target;
        boolean isFirstArrayOccurence = true;
        while (true) {
            PsiTypeElement parentTypeElement;
            if ((parentTypeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)current, PsiTypeElement.class, (boolean)true)) == null) {
                return null;
            }
            PsiType parentType = parentTypeElement.getType();
            if (parentType instanceof PsiClassType) {
                PsiJavaCodeReferenceElement ref = parentTypeElement.getInnermostComponentReferenceElement();
                if (ref == null) {
                    return null;
                }
                PsiReferenceParameterList params = ref.getParameterList();
                if (params == null) {
                    return null;
                }
                Object[] args = params.getTypeParameterElements();
                int found = ArrayUtil.indexOf((Object[])args, (Object)current);
                if (found < 0) {
                    return null;
                }
                indices.add(found);
            } else if (parentType instanceof PsiWildcardType || parentType instanceof PsiCapturedWildcardType) {
                indices.add(0);
            } else if (parentType instanceof PsiArrayType) {
                PsiArrayType arrayType = (PsiArrayType)parentType;
                int candidateArrayDepth = arrayType.getArrayDimensions();
                int numberToAdd = isFirstArrayOccurence && candidateArrayDepth == firstArrayDepth ? 0 : (isFirstArrayOccurence && firstArrayDepth > 0 ? firstArrayDepth : candidateArrayDepth);
                for (int i = 0; i < numberToAdd; ++i) {
                    indices.add(0);
                }
            }
            if (parentTypeElement == top) break;
            current = parentTypeElement;
            isFirstArrayOccurence = false;
        }
        Collections.reverse(indices);
        return indices;
    }

    @NotNull
    private static Context getPresentationContext(@NotNull PsiType type, List<Integer> path, boolean isInsideArray) {
        if (type == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(18);
        }
        Context context = new Context();
        NullableStuffInspectionUtil.buildTextRepresentation(type, context, path, 0, isInsideArray);
        Context context2 = context;
        if (context2 == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(19);
        }
        return context2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void buildTextRepresentation(@NotNull PsiType type, @NotNull Context context, @NotNull @NotNull List<@NotNull Integer> path, int depth, boolean isInsideArray) {
        if (type == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(20);
        }
        if (context == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(21);
        }
        if (path == null) {
            NullableStuffInspectionUtil.$$$reportNull$$$0(22);
        }
        if (depth == path.size()) {
            if (type instanceof PsiArrayType) {
                PsiArrayType arrayType = (PsiArrayType)type;
                if (isInsideArray) {
                    context.sb.append(arrayType.getPresentableText(false));
                    context.sb.append(" ");
                    context.position = context.sb.length();
                    return;
                }
            }
            if (type instanceof PsiArrayType) {
                PsiArrayType arrayType = (PsiArrayType)type;
                context.sb.append(arrayType.getDeepComponentType().getPresentableText(false));
                context.sb.append(" ");
                context.position = context.sb.length();
                context.sb.repeat("[]", Math.max(0, arrayType.getArrayDimensions()));
                return;
            }
            String text = type.getPresentableText(false);
            context.position = context.sb.length();
            context.sb.append(text);
            return;
        }
        if (type instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type;
            PsiType component = arrayType.getComponentType();
            NullableStuffInspectionUtil.buildTextRepresentation(component, context, path, depth + 1, true);
            context.sb.append("[]");
            return;
        }
        if (type instanceof PsiWildcardType) {
            PsiWildcardType wc = (PsiWildcardType)type;
            String prefix = wc.isExtends() ? "? extends " : (wc.isSuper() ? "? super " : "?");
            context.sb.append(prefix);
            PsiType bound = wc.getBound();
            if (bound == null) return;
            NullableStuffInspectionUtil.buildTextRepresentation(bound, context, path, depth + 1, false);
            return;
        }
        if (!(type instanceof PsiClassType)) {
            context.sb.append(type.getPresentableText(false));
            return;
        }
        PsiClassType cls = (PsiClassType)type;
        String name = cls.getClassName();
        if (name == null) {
            name = cls.getPresentableText(false);
        }
        context.sb.append(name);
        PsiType[] params = cls.getParameters();
        if (params.length <= 0) return;
        context.sb.append('<');
        int i = 0;
        while (true) {
            if (i >= params.length) {
                context.sb.append('>');
                return;
            }
            if (i > 0) {
                context.sb.append(", ");
            }
            if (i == path.get(depth)) {
                NullableStuffInspectionUtil.buildTextRepresentation(params[i], context, path, depth + 1, false);
            } else {
                context.sb.append(params[i].getPresentableText(false));
            }
            ++i;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 7, 8, 9, 10, 11, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/nullable/NullableStuffInspectionUtil";
                break;
            }
            case 4: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "top";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/nullable/NullableStuffInspectionUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityConflictPresentation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSideChunk";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "generateHtmlChunk";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityConflictPresentation";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSideChunk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateHtmlChunk";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeTypeArgumentPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationContext";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildTextRepresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 7, 8, 9, 10, 11, 15, 19 -> new IllegalStateException(string);
        };
    }

    private static final class Context {
        @Nullable
        private Integer position = null;
        @NotNull
        private final StringBuilder sb = new StringBuilder();

        private Context() {
        }
    }
}

