/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.icons.AllIcons;
import com.intellij.java.codeserver.core.JavaServiceProviderUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;

public final class RefJavaModuleImpl
extends RefElementImpl
implements RefJavaModule {
    private final RefModule myRefModule;
    private Map<String, List<String>> myExportedPackageNames;
    private Set<RefClass> myServiceInterfaces;
    private Set<RefClass> myServiceImplementations;
    private Set<RefClass> myUsedServices;
    private List<RefJavaModule.RequiredModule> myRequiredModules;

    RefJavaModuleImpl(@NotNull PsiJavaModule javaModule, @NotNull RefManagerImpl manager) {
        if (javaModule == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(1);
        }
        super(javaModule.getName(), (PsiElement)javaModule, (RefManager)manager);
        this.myRefModule = manager.getRefModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)javaModule));
        JAVA_MODULE.set((UserDataHolder)this.myRefModule, (Object)this);
    }

    protected synchronized void initialize() {
        ((WritableRefEntity)this.myRefModule).add((RefEntity)this);
    }

    public void accept(@NotNull RefVisitor visitor2) {
        if (visitor2 == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(2);
        }
        if (visitor2 instanceof RefJavaVisitor) {
            RefJavaVisitor javaVisitor = (RefJavaVisitor)visitor2;
            ReadAction.run(() -> javaVisitor.visitJavaModule((RefJavaModule)this));
        } else {
            super.accept(visitor2);
        }
    }

    @Nullable
    public PsiJavaModule getPsiElement() {
        return (PsiJavaModule)super.getPsiElement();
    }

    @Nullable
    public RefModule getModule() {
        return this.myRefModule;
    }

    @NotNull
    public Map<String, List<String>> getExportedPackageNames() {
        Map<String, List<String>> map = this.myExportedPackageNames != null ? this.myExportedPackageNames : Collections.emptyMap();
        if (map == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public Set<RefClass> getServiceInterfaces() {
        Set<Object> set = this.myServiceInterfaces != null ? this.myServiceInterfaces : Collections.emptySet();
        if (set == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<RefClass> getServiceImplementations() {
        Set<Object> set = this.myServiceImplementations != null ? this.myServiceImplementations : Collections.emptySet();
        if (set == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Set<RefClass> getUsedServices() {
        Set<Object> set = this.myUsedServices != null ? this.myUsedServices : Collections.emptySet();
        if (set == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public List<RefJavaModule.RequiredModule> getRequiredModules() {
        List<Object> list = this.myRequiredModules != null ? this.myRequiredModules : Collections.emptyList();
        if (list == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public Icon getIcon(boolean expanded) {
        Icon icon = AllIcons.Nodes.JavaModule;
        if (icon == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(8);
        }
        return icon;
    }

    private void buildRequiresReferences(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(9);
        }
        for (PsiRequiresStatement statement : javaModule.getRequires()) {
            PsiElement element = this.addReference((PsiPolyVariantReference)statement.getModuleReference());
            if (!(element instanceof PsiJavaModule)) continue;
            PsiJavaModule requiredModule = (PsiJavaModule)element;
            Map<String, List<String>> packagesExportedByModule = RefJavaModuleImpl.getPackagesExportedByModule(requiredModule);
            if (this.myRequiredModules == null) {
                this.myRequiredModules = new ArrayList<RefJavaModule.RequiredModule>(1);
            }
            this.myRequiredModules.add(new RefJavaModule.RequiredModule(requiredModule.getName(), packagesExportedByModule, statement.hasModifierProperty("transitive")));
        }
    }

    private void buildExportsReferences(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(10);
        }
        List emptyList = Collections.emptyList();
        for (PsiPackageAccessibilityStatement statement : javaModule.getExports()) {
            PsiElement element = this.addReference((PsiPolyVariantReference)statement.getPackageReference());
            String packageName = null;
            if (element instanceof PsiPackage) {
                PsiPackage psiPackage = (PsiPackage)element;
                packageName = psiPackage.getQualifiedName();
                if (this.myExportedPackageNames == null) {
                    this.myExportedPackageNames = new HashMap<String, List<String>>(1);
                }
                this.myExportedPackageNames.put(packageName, emptyList);
            }
            for (PsiJavaModuleReferenceElement referenceElement : statement.getModuleReferences()) {
                if (referenceElement == null) continue;
                PsiElement moduleElement = this.addReference((PsiPolyVariantReference)referenceElement.getReference());
                if (packageName == null || !(moduleElement instanceof PsiJavaModule)) continue;
                PsiJavaModule psiJavaModule = (PsiJavaModule)moduleElement;
                List<String> toModuleNames = this.myExportedPackageNames.get(packageName);
                if (toModuleNames == emptyList) {
                    toModuleNames = new ArrayList<String>(1);
                    this.myExportedPackageNames.put(packageName, toModuleNames);
                }
                toModuleNames.add(psiJavaModule.getName());
            }
        }
    }

    private void buildProvidesReferences(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(11);
        }
        for (PsiProvidesStatement statement : javaModule.getProvides()) {
            RefElement refInterface;
            PsiElement providerInterface;
            PsiJavaCodeReferenceElement interfaceReference = statement.getInterfaceReference();
            PsiReferenceList implementationList = statement.getImplementationList();
            if (interfaceReference == null || implementationList == null || !((providerInterface = interfaceReference.resolve()) instanceof PsiClass) || !((refInterface = this.getRefManager().getReference(providerInterface)) instanceof RefClassImpl)) continue;
            if (this.myServiceInterfaces == null) {
                this.myServiceInterfaces = new HashSet<RefClass>();
            }
            this.myServiceInterfaces.add((RefClass)refInterface);
            for (PsiJavaCodeReferenceElement implementationReference : implementationList.getReferenceElements()) {
                UDeclaration element;
                RefElement refElement;
                PsiElement implementationClass = implementationReference.resolve();
                if (!(implementationClass instanceof PsiClass)) continue;
                PsiClass psiClass = (PsiClass)implementationClass;
                RefElement refTargetElement = null;
                PsiMethod targetElement = JavaServiceProviderUtil.findServiceProviderMethod((PsiClass)psiClass);
                if (targetElement == null && (refElement = this.getRefManager().getReference((PsiElement)psiClass)) instanceof RefClassImpl) {
                    PsiElement constructorElement;
                    RefClassImpl refClass = (RefClassImpl)refElement;
                    refClass.initializeIfNeeded();
                    if (this.myServiceImplementations == null) {
                        this.myServiceImplementations = new HashSet<RefClass>();
                    }
                    this.myServiceImplementations.add(refClass);
                    RefMethod refConstructor = refClass.getDefaultConstructor();
                    if (refConstructor != null && (constructorElement = refConstructor.getPsiElement()) instanceof PsiModifierListOwner && ((PsiModifierListOwner)constructorElement).hasModifierProperty("public")) {
                        refTargetElement = refConstructor;
                        targetElement = constructorElement;
                    }
                }
                if (targetElement == null) {
                    targetElement = psiClass;
                }
                if (refTargetElement == null) {
                    refTargetElement = this.getRefManager().getReference((PsiElement)targetElement);
                }
                if (refTargetElement == null || (element = (UDeclaration)UastContextKt.toUElement((PsiElement)providerInterface, UDeclaration.class)) == null) continue;
                ((RefClassImpl)refInterface).addReference(refTargetElement, (PsiElement)targetElement, (UElement)element, false, true, null);
            }
        }
    }

    private void buildUsesReferences(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(12);
        }
        for (PsiUsesStatement statement : javaModule.getUses()) {
            RefElement refClass;
            PsiElement usedInterface;
            PsiJavaCodeReferenceElement reference = statement.getClassReference();
            if (reference == null || !((usedInterface = reference.resolve()) instanceof PsiClass) || !((refClass = this.getRefManager().getReference(usedInterface)) instanceof RefClass)) continue;
            if (this.myUsedServices == null) {
                this.myUsedServices = new HashSet<RefClass>();
            }
            this.myUsedServices.add((RefClass)refClass);
        }
    }

    public void buildReferences() {
        PsiJavaModule javaModule = this.getPsiElement();
        if (javaModule != null) {
            this.buildRequiresReferences(javaModule);
            this.buildExportsReferences(javaModule);
            this.buildProvidesReferences(javaModule);
            this.buildUsesReferences(javaModule);
        }
    }

    @Nullable
    private PsiElement addReference(@Nullable PsiPolyVariantReference reference) {
        ResolveResult[] resolveResults;
        if (reference == null) {
            return null;
        }
        ArrayList<PsiElement> resolvedElements = new ArrayList<PsiElement>();
        for (ResolveResult resolveResult : resolveResults = reference.multiResolve(false)) {
            PsiElement element = resolveResult.getElement();
            if (element == null) continue;
            resolvedElements.add(element);
            RefElement refElement = this.getRefManager().getReference(element);
            if (refElement == null) continue;
            this.addOutReference(refElement);
            ((WritableRefElement)refElement).addInReference((RefElement)this);
        }
        return resolvedElements.size() == 1 ? (PsiElement)resolvedElements.get(0) : null;
    }

    @Nullable
    public static RefJavaModule moduleFromExternalName(@NotNull RefManagerImpl manager, @NotNull String fqName) {
        Project project;
        PsiJavaModule javaModule;
        if (manager == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(13);
        }
        if (fqName == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(14);
        }
        return (javaModule = JavaPsiFacade.getInstance((Project)(project = manager.getProject())).findModule(fqName, GlobalSearchScope.projectScope((Project)project))) == null ? null : (RefJavaModule)manager.getReference((PsiElement)javaModule);
    }

    @NotNull
    private static Map<String, List<String>> getPackagesExportedByModule(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(15);
        }
        HashMap<String, List> exportedPackages = new HashMap<String, List>();
        for (PsiPackageAccessibilityStatement statement : javaModule.getExports()) {
            String packageName = statement.getPackageName();
            if (packageName == null) continue;
            exportedPackages.put(packageName, statement.getModuleNames());
        }
        Map<String, List<Object>> map = !exportedPackages.isEmpty() ? exportedPackages : Collections.emptyMap();
        if (map == null) {
            RefJavaModuleImpl.$$$reportNull$$$0(16);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModule";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefJavaModuleImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefJavaModuleImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedPackageNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceInterfaces";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceImplementations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedServices";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredModules";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesExportedByModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildRequiresReferences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildExportsReferences";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildProvidesReferences";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildUsesReferences";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moduleFromExternalName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPackagesExportedByModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 16 -> new IllegalStateException(string);
        };
    }
}

