/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefImplicitConstructorImpl;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaUtilImpl;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefOverridable;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

public sealed class RefMethodImpl
extends RefJavaElementImpl
implements RefMethod
permits RefImplicitConstructorImpl {
    private static final int IS_APPMAIN_MASK = 65536;
    private static final int IS_LIBRARY_OVERRIDE_MASK = 131072;
    private static final int IS_CONSTRUCTOR_MASK = 262144;
    private static final int IS_ABSTRACT_MASK = 524288;
    private static final int IS_BODY_EMPTY_MASK = 0x100000;
    private static final int IS_ONLY_CALLS_SUPER_MASK = 0x200000;
    private static final int IS_RETURN_VALUE_USED_MASK = 0x400000;
    private static final int IS_RECORD_ACCESSOR_MASK = 0x800000;
    private static final int HAS_BODY_MASK = 0x1000000;
    private static final int IS_CALLED_ON_SUBCLASS_MASK = 0x8000000;
    private static final String RETURN_VALUE_UNDEFINED = "#";
    private Object mySuperMethods;
    private List<RefOverridable> myDerivedReferences;
    private List<String> myUnThrownExceptions;
    private volatile String myReturnValueTemplate;

    RefMethodImpl(UMethod method, PsiElement psi, RefManager manager) {
        super((UDeclaration)method, psi, manager);
        this.myReturnValueTemplate = RETURN_VALUE_UNDEFINED;
        this.setConstructor(method.isConstructor());
        PsiType returnType = method.getReturnType();
        this.setFlag(returnType == null || PsiTypes.voidType().equals((Object)returnType) || returnType.equalsToText("java.lang.Void"), 0x400000L);
    }

    protected RefMethodImpl(@NotNull String name, @NotNull RefClass ownerClass) {
        if (name == null) {
            RefMethodImpl.$$$reportNull$$$0(0);
        }
        if (ownerClass == null) {
            RefMethodImpl.$$$reportNull$$$0(1);
        }
        super(name, (RefJavaElement)ownerClass);
        this.myReturnValueTemplate = RETURN_VALUE_UNDEFINED;
        ((RefClassImpl)ownerClass).add((RefEntity)this);
        this.addOutReference((RefElement)ownerClass);
        ((WritableRefElement)ownerClass).addInReference((RefElement)this);
        this.setConstructor(true);
    }

    protected synchronized void initialize() {
        WritableRefEntity parentRef;
        UMethod method = this.getUastElement();
        LOG.assertTrue(method != null);
        PsiElement sourcePsi = method.getSourcePsi();
        LOG.assertTrue(sourcePsi != null);
        List paramList = method.getUastParameters();
        if (!paramList.isEmpty()) {
            boolean markParametersUsed = method.isConstructor() && method.getUastBody() == null;
            for (int i = 0; i < paramList.size(); ++i) {
                UParameter param = (UParameter)paramList.get(i);
                if (param.getSourcePsi() == null) continue;
                RefParameterImpl parameter = (RefParameterImpl)this.getRefJavaManager().getParameterReference(param, i, (RefElement)this);
                if (!markParametersUsed || parameter == null) continue;
                parameter.setUsedForReading();
            }
        }
        if ((parentRef = (WritableRefEntity)RefMethodImpl.findParentRef(sourcePsi, (UElement)method, this.myManager)) != null) {
            if (!this.myManager.isDeclarationsFound()) {
                parentRef.add((RefEntity)this);
                return;
            }
            this.setOwner(parentRef);
        }
        if (!method.isConstructor()) {
            PsiMethod javaPsi = method.getJavaPsi();
            this.setAbstract(javaPsi.hasModifierProperty("abstract"));
            this.setLibraryOverride(javaPsi.hasModifierProperty("native"));
            this.setAppMain(RefMethodImpl.isAppMain(javaPsi, this));
            if (!"private".equals(this.getAccessModifier()) && !this.isStatic()) {
                this.initializeSuperMethods(javaPsi);
            }
        }
        if (sourcePsi instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)sourcePsi;
            if (sourcePsi.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
                if (!method.isConstructor() && JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)psiMethod) != null) {
                    this.setRecordAccessor(true);
                }
                this.collectUncaughtExceptions(psiMethod);
            }
        }
    }

    public void setParametersAreUnknown() {
        for (RefParameter parameter : this.getParameters()) {
            parameter.initializeIfNeeded();
            ((RefParameterImpl)parameter).clearTemplateValue();
        }
        for (RefMethod method : this.getSuperMethods()) {
            method.initializeIfNeeded();
            ((RefMethodImpl)method).setParametersAreUnknown();
        }
    }

    private static boolean isAppMain(PsiMethod psiMethod, RefMethod refMethod) {
        if ("main".equals(psiMethod.getName()) && PsiClassImplUtil.isMainOrPremainMethod((PsiMethod)psiMethod)) {
            return true;
        }
        if (!refMethod.isStatic()) {
            return false;
        }
        if (!PsiTypes.voidType().equals((Object)psiMethod.getReturnType())) {
            return false;
        }
        if ("main".equals(psiMethod.getName()) && psiMethod.getParameterList().isEmpty() && psiMethod.getLanguage().isKindOf("kotlin")) {
            return true;
        }
        PsiMethod appPremainPattern = ((RefMethodImpl)refMethod).getRefJavaManager().getAppPremainPattern();
        if (MethodSignatureUtil.areSignaturesEqual((PsiMethod)psiMethod, (PsiMethod)appPremainPattern)) {
            return true;
        }
        PsiMethod appAgentmainPattern = ((RefMethodImpl)refMethod).getRefJavaManager().getAppAgentmainPattern();
        return MethodSignatureUtil.areSignaturesEqual((PsiMethod)psiMethod, (PsiMethod)appAgentmainPattern);
    }

    private void checkForSuperCall(UMethod method) {
        if (this.isConstructor()) {
            RefClass ownerClass;
            UCallExpression callExpression;
            UExpression first;
            List list;
            UExpression body = method.getUastBody();
            if (body == null) {
                return;
            }
            if (body instanceof UBlockExpression) {
                UBlockExpression blockExpression = (UBlockExpression)body;
                list = blockExpression.getExpressions();
            } else {
                list = Collections.singletonList(body);
            }
            List statements = list;
            boolean isBaseExplicitlyCalled = false;
            if (!statements.isEmpty() && (first = (UExpression)statements.get(0)) instanceof UCallExpression && (callExpression = (UCallExpression)first).getKind() == UastCallKind.CONSTRUCTOR_CALL) {
                isBaseExplicitlyCalled = true;
            }
            if (!isBaseExplicitlyCalled && (ownerClass = this.getOwnerClass()) != null) {
                for (RefClass superClass : ownerClass.getBaseClasses()) {
                    superClass.initializeIfNeeded();
                    WritableRefElement superDefaultConstructor = (WritableRefElement)superClass.getDefaultConstructor();
                    if (superDefaultConstructor == null) continue;
                    superDefaultConstructor.addInReference((RefElement)this);
                    this.addOutReference((RefElement)superDefaultConstructor);
                }
            }
        }
    }

    @NotNull
    public synchronized Collection<RefMethod> getSuperMethods() {
        if (this.mySuperMethods instanceof Collection) {
            Collection collection = (Collection)this.mySuperMethods;
            if (collection == null) {
                RefMethodImpl.$$$reportNull$$$0(2);
            }
            return collection;
        }
        List<RefMethod> list = this.mySuperMethods != null ? List.of((RefMethod)this.mySuperMethods) : List.of();
        if (list == null) {
            RefMethodImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public synchronized @Unmodifiable Collection<RefMethod> getDerivedMethods() {
        if (this.myDerivedReferences == null) {
            List<RefMethod> list = Collections.emptyList();
            if (list == null) {
                RefMethodImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = ContainerUtil.filterIsInstance(this.myDerivedReferences, RefMethod.class);
        if (list == null) {
            RefMethodImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    private synchronized void removeDerivedMethod(@NotNull RefMethod toRemove) {
        if (toRemove == null) {
            RefMethodImpl.$$$reportNull$$$0(6);
        }
        if (this.myDerivedReferences == null) {
            return;
        }
        this.myDerivedReferences.remove(toRemove);
    }

    @NotNull
    public synchronized Collection<? extends RefOverridable> getDerivedReferences() {
        List<Object> list = this.myDerivedReferences == null ? Collections.emptyList() : this.myDerivedReferences;
        if (list == null) {
            RefMethodImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDerivedReference(@NotNull RefOverridable reference) {
        if (reference == null) {
            RefMethodImpl.$$$reportNull$$$0(8);
        }
        if (this.isConstructor() || this.isStatic()) {
            throw new AssertionError((Object)"Constructors and static methods cannot have derived references");
        }
        if (reference.getDerivedReferences().contains((Object)this)) {
            return;
        }
        RefMethodImpl refMethodImpl = this;
        synchronized (refMethodImpl) {
            if (this.myDerivedReferences == null) {
                this.myDerivedReferences = new ArrayList<RefOverridable>(1);
            }
            if (!this.myDerivedReferences.contains(reference)) {
                this.myDerivedReferences.add(reference);
            }
        }
    }

    public boolean isBodyEmpty() {
        return this.checkFlag(0x100000L);
    }

    public boolean isOnlyCallsSuper() {
        return this.checkFlag(0x200000L);
    }

    public boolean hasBody() {
        return this.checkFlag(0x1000000L);
    }

    private void initializeSuperMethods(PsiMethod method) {
        RefManagerImpl refManager = this.getRefManager();
        if (refManager.isOfflineView()) {
            return;
        }
        for (PsiMethod psiSuperMethod : method.findSuperMethods()) {
            if (refManager.belongsToScope((PsiElement)psiSuperMethod)) {
                PsiElement sourceElement = RefJavaUtilImpl.returnToPhysical((PsiElement)psiSuperMethod);
                RefElement refElement = refManager.getReference(sourceElement);
                if (refElement instanceof RefMethodImpl) {
                    RefMethodImpl refSuperMethod = (RefMethodImpl)refElement;
                    this.addSuperMethod(refSuperMethod);
                    refManager.executeTask(() -> refSuperMethod.markExtended(this));
                    continue;
                }
                this.setLibraryOverride(true);
                continue;
            }
            this.setLibraryOverride(true);
        }
    }

    public synchronized void addSuperMethod(RefMethodImpl refSuperMethod) {
        if (refSuperMethod.checkFlag(131072L)) {
            this.setLibraryOverride(true);
        }
        if (this.mySuperMethods == null) {
            this.mySuperMethods = refSuperMethod;
        } else {
            Object object = this.mySuperMethods;
            if (object instanceof RefMethod) {
                RefMethod refMethod = (RefMethod)object;
                ArrayList<RefMethod> list = new ArrayList<RefMethod>(2);
                list.add(refMethod);
                list.add(refSuperMethod);
                this.mySuperMethods = list;
            } else {
                ((List)this.mySuperMethods).add(refSuperMethod);
            }
        }
    }

    public void markExtended(RefMethodImpl method) {
        this.addDerivedReference((RefOverridable)method);
    }

    public synchronized RefParameter @NotNull [] getParameters() {
        LOG.assertTrue(this.isInitialized());
        RefParameter[] refParameterArray = ContainerUtil.filterIsInstance((Collection)this.getChildren(), RefParameter.class).toArray(RefParameter.EMPTY_ARRAY);
        if (refParameterArray == null) {
            RefMethodImpl.$$$reportNull$$$0(9);
        }
        return refParameterArray;
    }

    public void buildReferences() {
        UMethod method = this.getUastElement();
        if (method == null) {
            return;
        }
        RefClass ownerClass = this.getOwnerClass();
        if (this.isConstructor() && ownerClass != null) {
            ownerClass.initializeIfNeeded();
            this.addReference((RefElement)ownerClass, ownerClass.getPsiElement(), (UElement)method, false, true, null);
        }
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        refUtil.addReferencesTo((UElement)method, (RefJavaElement)this, new UElement[]{method});
        this.checkForSuperCall(method);
        this.setOnlyCallsSuper(refUtil.isMethodOnlyCallsSuper(method));
        this.setHasBody(method.getUastBody() != null);
        this.setBodyEmpty(this.isOnlyCallsSuper() || !this.isExternalOverride() && RefMethodImpl.isEmptyExpression(method.getUastBody()));
        refUtil.addTypeReference((UElement)method, method.getReturnType(), (RefManager)this.getRefManager(), (RefJavaElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectUncaughtExceptions(@NotNull PsiMethod method) {
        if (method == null) {
            RefMethodImpl.$$$reportNull$$$0(10);
        }
        if (this.getRefManager().isOfflineView()) {
            return;
        }
        PsiClassType[] throwsList = method.getThrowsList().getReferencedTypes();
        if (throwsList.length > 0) {
            Object unThrownExceptions = throwsList.length == 1 ? new SmartList() : new ArrayList(throwsList.length);
            for (PsiClassType type : throwsList) {
                String fqn;
                PsiClass aClass = type.resolve();
                String string = fqn = aClass == null ? null : aClass.getQualifiedName();
                if (fqn == null) continue;
                unThrownExceptions.add(fqn);
            }
            RefMethodImpl refMethodImpl = this;
            synchronized (refMethodImpl) {
                this.myUnThrownExceptions = unThrownExceptions;
            }
        }
    }

    public synchronized void removeUnThrownExceptions(PsiClass unThrownException) {
        if (this.myUnThrownExceptions != null) {
            this.myUnThrownExceptions.remove(unThrownException.getQualifiedName());
        }
    }

    public void accept(@NotNull RefVisitor visitor2) {
        if (visitor2 == null) {
            RefMethodImpl.$$$reportNull$$$0(11);
        }
        if (visitor2 instanceof RefJavaVisitor) {
            RefJavaVisitor javaVisitor = (RefJavaVisitor)visitor2;
            ReadAction.run(() -> javaVisitor.visitMethod((RefMethod)this));
        } else {
            super.accept(visitor2);
        }
    }

    public boolean isExternalOverride() {
        return this.isLibraryOverride(new HashSet());
    }

    private synchronized boolean isLibraryOverride(@NotNull Collection<? super RefMethod> processed) {
        if (processed == null) {
            RefMethodImpl.$$$reportNull$$$0(12);
        }
        if (!processed.add(this)) {
            return false;
        }
        if (this.checkFlag(131072L)) {
            return true;
        }
        for (RefMethod superMethod : this.getSuperMethods()) {
            if (!((RefMethodImpl)superMethod).isLibraryOverride(processed)) continue;
            this.setLibraryOverride(true);
            return true;
        }
        return false;
    }

    public boolean isAppMain() {
        return this.checkFlag(65536L);
    }

    public boolean isAbstract() {
        return this.checkFlag(524288L);
    }

    public boolean hasSuperMethods() {
        return !this.getSuperMethods().isEmpty() || this.isExternalOverride();
    }

    public synchronized boolean isReferenced() {
        for (RefElement refCaller : this.getInReferences()) {
            if (this.getDerivedReferences().contains(refCaller)) continue;
            return true;
        }
        return this.isExternalOverride();
    }

    public synchronized boolean hasSuspiciousCallers() {
        for (RefElement refCaller : this.getInReferences()) {
            if (!((RefElementImpl)refCaller).isSuspicious() || this.getDerivedReferences().contains(refCaller)) continue;
            return true;
        }
        if (this.isExternalOverride()) {
            return true;
        }
        if (!this.isStatic() && !this.isConstructor()) {
            for (RefMethod refSuper : this.getSuperMethods()) {
                if (!((RefMethodImpl)refSuper).isSuspicious()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConstructor() {
        return this.checkFlag(262144L);
    }

    @Nullable
    public RefClass getOwnerClass() {
        RefClass aClass;
        WritableRefEntity writableRefEntity = this.getOwner();
        return writableRefEntity instanceof RefClass ? (aClass = (RefClass)writableRefEntity) : null;
    }

    public String getExternalName() {
        return (String)ReadAction.compute(() -> {
            UMethod uMethod = this.getUastElement();
            LOG.assertTrue(uMethod != null);
            PsiMethod javaMethod = uMethod.getJavaPsi();
            return PsiFormatUtil.getExternalName((PsiModifierListOwner)javaMethod, (boolean)true, (int)Integer.MAX_VALUE);
        });
    }

    @Nullable
    static RefJavaElement methodFromExternalName(RefManager manager, String externalName) {
        PsiElement method = RefJavaUtilImpl.returnToPhysical((PsiElement)RefMethodImpl.findPsiMethod(PsiManager.getInstance((Project)manager.getProject()), externalName));
        RefElement reference = manager.getReference(method);
        if (!(reference instanceof RefJavaElement) && reference != null) {
            LOG.error("Expected refMethod but found: " + reference.getClass().getName() + "; for externalName: " + externalName);
            return null;
        }
        return (RefJavaElement)reference;
    }

    @Nullable
    public static PsiMethod findPsiMethod(PsiManager manager, String externalName) {
        int spaceIdx = externalName.indexOf(32);
        String className = externalName.substring(0, spaceIdx);
        PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)manager, (String)className);
        if (psiClass == null) {
            return null;
        }
        try {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
            String methodSignature = externalName.substring(spaceIdx + 1);
            MethodSignature patternSignature = factory.createMethodFromText(methodSignature, (PsiElement)psiClass).getSignature(PsiSubstitutor.EMPTY);
            return (PsiMethod)ContainerUtil.find((Object[])psiClass.findMethodsByName(patternSignature.getName(), false), m -> {
                MethodSignature s = m.getSignature(PsiSubstitutor.EMPTY);
                MethodSignature refinedPatternSignature = factory.createMethodFromText(methodSignature, (PsiElement)m).getSignature(s.getSubstitutor());
                return MethodSignatureUtil.areErasedParametersEqual((MethodSignature)s, (MethodSignature)refinedPatternSignature);
            });
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public void referenceRemoved() {
        if (this.getOwnerClass() != null) {
            ((RefClassImpl)this.getOwnerClass()).methodRemoved(this);
        }
        super.referenceRemoved();
        for (RefMethod superMethod : this.getSuperMethods()) {
            ((RefMethodImpl)superMethod).removeDerivedMethod(this);
        }
        for (RefMethod subMethod : this.getDerivedMethods()) {
            ((RefMethodImpl)subMethod).removeDerivedMethod(this);
        }
    }

    public boolean isSuspicious() {
        if (this.isConstructor() && "private".equals(this.getAccessModifier()) && this.getParameters().length == 0 && Objects.requireNonNull(this.getOwnerClass()).getConstructors().size() == 1) {
            return false;
        }
        return super.isSuspicious();
    }

    void setReturnValueUsed(boolean value) {
        LOG.assertTrue(this.isInitialized());
        if (this.checkFlag(0x400000L) == value) {
            return;
        }
        this.setFlag(value, 0x400000L);
        for (RefMethod refSuper : this.getSuperMethods()) {
            refSuper.initializeIfNeeded();
            ((RefMethodImpl)refSuper).setReturnValueUsed(value);
        }
    }

    public boolean isReturnValueUsed() {
        return this.checkFlag(0x400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateReturnValueTemplate(UExpression expression) {
        LOG.assertTrue(this.isInitialized());
        if (expression == null) {
            return;
        }
        RefMethodImpl refMethodImpl = this;
        synchronized (refMethodImpl) {
            if (this.myReturnValueTemplate == null) {
                return;
            }
        }
        if (!this.getSuperMethods().isEmpty()) {
            for (RefMethod refMethod : this.getSuperMethods()) {
                RefMethodImpl refSuper = (RefMethodImpl)refMethod;
                refSuper.initializeIfNeeded();
                refSuper.updateReturnValueTemplate(expression);
            }
        } else {
            if (RefJavaUtil.getInstance().isCallToSuperMethod(expression, this.getUastElement())) {
                return;
            }
            String newTemplate = RefMethodImpl.createReturnValueTemplate(expression, this);
            RefMethodImpl refMethodImpl2 = this;
            synchronized (refMethodImpl2) {
                if (Strings.areSameInstance((String)this.myReturnValueTemplate, (String)RETURN_VALUE_UNDEFINED)) {
                    this.myReturnValueTemplate = newTemplate;
                } else if (!Objects.equals(this.myReturnValueTemplate, newTemplate)) {
                    this.myReturnValueTemplate = null;
                }
            }
        }
    }

    void updateParameterValues(@NotNull UCallExpression call, @Nullable PsiElement elementPlace) {
        if (call == null) {
            RefMethodImpl.$$$reportNull$$$0(13);
        }
        LOG.assertTrue(this.isInitialized());
        if (this.isExternalOverride()) {
            return;
        }
        if (!this.getSuperMethods().isEmpty()) {
            for (RefMethod refSuper : this.getSuperMethods()) {
                refSuper.initializeIfNeeded();
                ((RefMethodImpl)refSuper).updateParameterValues(call, null);
            }
        } else {
            RefParameter[] params = this.getParameters();
            for (int i = 0; i < params.length; ++i) {
                ((RefParameterImpl)params[i]).updateTemplateValue(call.getArgumentForParameter(i), elementPlace);
            }
        }
    }

    public synchronized String getReturnValueIfSame() {
        if (Strings.areSameInstance((String)this.myReturnValueTemplate, (String)RETURN_VALUE_UNDEFINED)) {
            return null;
        }
        return this.myReturnValueTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThrowsList(PsiClassType exceptionType) {
        LOG.assertTrue(this.isInitialized());
        this.myManager.executeTask(() -> {
            for (RefMethod refSuper : this.getSuperMethods()) {
                refSuper.initializeIfNeeded();
                ((RefMethodImpl)refSuper).updateThrowsList(exceptionType);
            }
        });
        RefMethodImpl refMethodImpl = this;
        synchronized (refMethodImpl) {
            List<String> unThrownExceptions = this.myUnThrownExceptions;
            if (unThrownExceptions != null) {
                if (exceptionType == null) {
                    this.myUnThrownExceptions = null;
                } else {
                    PsiClass exceptionClass = exceptionType.resolve();
                    JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myManager.getProject());
                    for (int i = unThrownExceptions.size() - 1; i >= 0; --i) {
                        String exceptionFqn = unThrownExceptions.get(i);
                        PsiClass classType = facade.findClass(exceptionFqn, GlobalSearchScope.allScope((Project)this.getRefManager().getProject()));
                        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)exceptionClass, (PsiClass)classType, (boolean)true) && !InheritanceUtil.isInheritorOrSelf((PsiClass)classType, (PsiClass)exceptionClass, (boolean)true)) continue;
                        unThrownExceptions.remove(i);
                    }
                    if (unThrownExceptions.isEmpty()) {
                        this.myUnThrownExceptions = null;
                    }
                }
            }
        }
    }

    public synchronized PsiClass @Nullable [] getUnThrownExceptions() {
        List<String> unThrownExceptions;
        if (this.getRefManager().isOfflineView()) {
            LOG.debug("Should not traverse graph offline");
        }
        if ((unThrownExceptions = this.myUnThrownExceptions) == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myManager.getProject());
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(unThrownExceptions.size());
        for (String exception : unThrownExceptions) {
            PsiClass element = facade.findClass(exception, GlobalSearchScope.allScope((Project)this.myManager.getProject()));
            if (element == null) continue;
            result.add(element);
        }
        return result.toArray(PsiClass.EMPTY_ARRAY);
    }

    public void setLibraryOverride(boolean libraryOverride) {
        this.setFlag(libraryOverride, 131072L);
    }

    private void setAppMain(boolean appMain) {
        this.setFlag(appMain, 65536L);
    }

    private void setAbstract(boolean anAbstract) {
        this.setFlag(anAbstract, 524288L);
    }

    public void setBodyEmpty(boolean bodyEmpty) {
        this.setFlag(bodyEmpty, 0x100000L);
    }

    private void setHasBody(boolean hasBody) {
        this.setFlag(hasBody, 0x1000000L);
    }

    private void setOnlyCallsSuper(boolean onlyCallsSuper) {
        this.setFlag(onlyCallsSuper, 0x200000L);
    }

    private void setConstructor(boolean constructor) {
        this.setFlag(constructor, 262144L);
    }

    private void setRecordAccessor(boolean accessor) {
        this.setFlag(accessor, 0x800000L);
    }

    public boolean isTestMethod() {
        return TestFrameworks.getInstance().isTestMethod(this.getUastElement().getJavaPsi());
    }

    public boolean isRecordAccessor() {
        return this.checkFlag(0x800000L);
    }

    public UMethod getUastElement() {
        return (UMethod)UastContextKt.toUElement((PsiElement)this.getPsiElement(), UMethod.class);
    }

    public boolean isCalledOnSubClass() {
        return this.checkFlag(0x8000000L);
    }

    void setCalledOnSubClass(boolean isCalledOnSubClass) {
        this.setFlag(isCalledOnSubClass, 0x8000000L);
    }

    public static boolean isEmptyExpression(@Nullable UExpression expression) {
        UBlockExpression blockExpression;
        if (expression == null) {
            return true;
        }
        return expression instanceof UBlockExpression && (blockExpression = (UBlockExpression)expression).getExpressions().isEmpty();
    }

    @Nullable
    static RefElement findParentRef(@NotNull PsiElement psiElement, @NotNull UElement uElement, @NotNull RefManagerImpl refManager) {
        UDeclaration containingUDecl;
        if (psiElement == null) {
            RefMethodImpl.$$$reportNull$$$0(14);
        }
        if (uElement == null) {
            RefMethodImpl.$$$reportNull$$$0(15);
        }
        if (refManager == null) {
            RefMethodImpl.$$$reportNull$$$0(16);
        }
        PsiElement containingDeclaration = RefJavaUtilImpl.returnToPhysical((containingUDecl = UDeclarationKt.getContainingDeclaration((UElement)uElement)) == null ? null : containingUDecl.getSourcePsi());
        return containingDeclaration == null || containingDeclaration instanceof LightElement ? refManager.getReference((PsiElement)psiElement.getContainingFile(), true) : refManager.getReference(containingDeclaration, true);
    }

    @Contract(value="null -> null")
    @Nullable
    public static String createReturnValueTemplate(@Nullable UExpression expression) {
        return RefMethodImpl.createReturnValueTemplate(expression, Predicates.alwaysTrue());
    }

    @Nullable
    private static String createReturnValueTemplate(UExpression expression, @NotNull RefMethodImpl refMethod) {
        if (refMethod == null) {
            RefMethodImpl.$$$reportNull$$$0(17);
        }
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        return RefMethodImpl.createReturnValueTemplate(expression, (PsiField field) -> refUtil.compareAccess(refUtil.getAccessModifier((PsiModifierListOwner)field), refMethod.getAccessModifier()) >= 0);
    }

    @Nullable
    private static String createReturnValueTemplate(UExpression expression, @NotNull Predicate<PsiField> predicate) {
        PsiField psi;
        UField uField;
        UResolvable resolvable;
        UElement resolved;
        if (predicate == null) {
            RefMethodImpl.$$$reportNull$$$0(18);
        }
        if (expression instanceof ULiteralExpression) {
            ULiteralExpression literalExpression = (ULiteralExpression)expression;
            return String.valueOf(literalExpression.getValue());
        }
        if (expression instanceof UInjectionHost) {
            UInjectionHost injectionHost = (UInjectionHost)expression;
            return injectionHost.evaluateToString();
        }
        if (expression instanceof UResolvable && (resolved = UResolvableKt.resolveToUElement((UResolvable)(resolvable = (UResolvable)expression))) instanceof UField && (uField = (UField)resolved).isStatic() && uField.isFinal() && (psi = (PsiField)uField.getJavaPsi()) != null && predicate.test(psi)) {
            return PsiFormatUtil.formatVariable((PsiVariable)psi, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefMethodImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refMethod";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefMethodImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperMethods";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedMethods";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeDerivedMethod";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDerivedReference";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectUncaughtExceptions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryOverride";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterValues";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findParentRef";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createReturnValueTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7, 9 -> new IllegalStateException(string);
        };
    }
}

