/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedImport;

import com.intellij.codeInspection.unusedImport.ImportStatementComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImportsAreUsedVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiJavaFile myFile;
    private final List<PsiImportStatementBase> importStatements;
    private final List<PsiImportStatementBase> usedImportStatements;
    private final List<PsiImportStatementBase> implicitlyUsedImportStatements;
    private final Set<PsiImportStatementBase> highLevelModuleImports;
    private final JavaCodeStyleSettings settings;

    ImportsAreUsedVisitor(@NotNull PsiJavaFile file) {
        if (file == null) {
            ImportsAreUsedVisitor.$$$reportNull$$$0(0);
        }
        this.usedImportStatements = new ArrayList<PsiImportStatementBase>();
        this.implicitlyUsedImportStatements = new ArrayList<PsiImportStatementBase>();
        this.highLevelModuleImports = new HashSet<PsiImportStatementBase>();
        this.myFile = file;
        this.settings = JavaCodeStyleSettings.getInstance((PsiFile)file);
        PsiImportList importList = file.getImportList();
        if (importList == null) {
            this.importStatements = Collections.emptyList();
        } else {
            PsiImportStatementBase[] importStatements = importList.getAllImportStatements();
            this.importStatements = new ArrayList<PsiImportStatementBase>(Arrays.asList(importStatements));
            this.implicitlyUsedImportStatements.addAll(ImportsUtil.getAllImplicitImports((PsiJavaFile)file));
            this.importStatements.sort(ImportStatementComparator.getInstance());
            this.highLevelModuleImports.addAll(ImportUtils.optimizeModuleImports(this.myFile));
            List unusedModuleImports = ContainerUtil.filter(this.importStatements, t -> {
                PsiImportModuleStatement importModuleStatement;
                return t instanceof PsiImportModuleStatement && !this.highLevelModuleImports.contains(importModuleStatement = (PsiImportModuleStatement)t);
            });
            this.importStatements.removeAll(unusedModuleImports);
            this.importStatements.addAll(unusedModuleImports);
        }
    }

    public void visitImportList(@NotNull PsiImportList list) {
        if (list == null) {
            ImportsAreUsedVisitor.$$$reportNull$$$0(1);
        }
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            ImportsAreUsedVisitor.$$$reportNull$$$0(2);
        }
        if (this.importStatements.isEmpty()) {
            return;
        }
        super.visitElement(element);
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            ImportsAreUsedVisitor.$$$reportNull$$$0(3);
        }
        this.followReferenceToImport(reference);
        super.visitReferenceElement(reference);
    }

    private void followReferenceToImport(PsiJavaCodeReferenceElement reference) {
        JavaResolveResult[] results;
        if (reference.getQualifier() != null) {
            return;
        }
        JavaResolveResult resolveResult = reference.advancedResolve(true);
        PsiElement element = resolveResult.getElement();
        if (element == null && (results = reference.multiResolve(false)).length > 0) {
            element = results[0].getElement();
        }
        if (!(element instanceof PsiMember)) {
            return;
        }
        PsiMember member = (PsiMember)element;
        if (this.findImport(member, this.usedImportStatements) != null) {
            return;
        }
        if (this.findImport(member, this.implicitlyUsedImportStatements) != null) {
            return;
        }
        PsiImportStatementBase foundImport = this.findImport(member, this.importStatements);
        if (foundImport != null) {
            this.importStatements.remove(foundImport);
            this.usedImportStatements.add(foundImport);
        }
    }

    @Nullable
    private PsiImportStatementBase findImport(@NotNull PsiMember member, List<? extends PsiImportStatementBase> importStatements) {
        String memberPackageName;
        Object memberQualifiedName;
        if (member == null) {
            ImportsAreUsedVisitor.$$$reportNull$$$0(4);
        }
        PsiClass containingClass = member.getContainingClass();
        if (member instanceof PsiClass) {
            PsiClass referencedClass = (PsiClass)member;
            memberQualifiedName = referencedClass.getQualifiedName();
            memberPackageName = memberQualifiedName != null ? StringUtil.getPackageName((String)memberQualifiedName) : null;
        } else {
            if (!member.hasModifierProperty("static") || containingClass == null) {
                return null;
            }
            memberPackageName = containingClass.getQualifiedName();
            memberQualifiedName = memberPackageName + "." + member.getName();
        }
        if (memberPackageName == null) {
            return null;
        }
        ImportUtils.OnDemandImportConflict conflicts = ImportUtils.findOnDemandImportConflict((String)memberQualifiedName, (PsiElement)this.myFile);
        for (PsiImportStatementBase psiImportStatementBase : importStatements) {
            PsiManager manager;
            PsiElement target;
            if (!psiImportStatementBase.isOnDemand()) {
                JavaResolveResult[] targets;
                PsiJavaCodeReferenceElement reference = psiImportStatementBase.getImportReference();
                if (reference == null) continue;
                for (JavaResolveResult target2 : targets = reference.multiResolve(false)) {
                    if (!member.equals((Object)target2.getElement())) continue;
                    return psiImportStatementBase;
                }
                continue;
            }
            if (psiImportStatementBase instanceof PsiImportModuleStatement && conflicts.hasConflictForModules() || !(psiImportStatementBase instanceof PsiImportModuleStatement) && psiImportStatementBase.isOnDemand() && conflicts.hasConflictForOnDemand()) continue;
            if (psiImportStatementBase instanceof PsiImportModuleStatement) {
                PsiImportModuleStatement psiImportModuleStatement = (PsiImportModuleStatement)psiImportStatementBase;
                if (!member.hasModifierProperty("static") && psiImportModuleStatement.findImportedPackage(memberPackageName) != null) {
                    return psiImportStatementBase;
                }
            }
            if ((target = psiImportStatementBase.resolve()) instanceof PsiPackage) {
                PsiPackage aPackage = (PsiPackage)target;
                if (!memberPackageName.equals(aPackage.getQualifiedName())) continue;
                return psiImportStatementBase;
            }
            if (!(target instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)target;
            if (!(psiImportStatementBase instanceof PsiImportStaticStatement ? member.hasModifierProperty("static") && ((manager = aClass.getManager()).areElementsEquivalent((PsiElement)aClass, (PsiElement)containingClass) || containingClass != null && (!(member instanceof PsiMethod) || !containingClass.isInterface()) && aClass.isInheritor(containingClass, true)) : psiImportStatementBase instanceof PsiImportStatement && member instanceof PsiClass && aClass.equals((Object)containingClass))) continue;
            return psiImportStatementBase;
        }
        return null;
    }

    PsiImportStatementBase @NotNull [] getUnusedImportStatements() {
        if (this.importStatements.isEmpty()) {
            if (PsiImportStatementBase.EMPTY_ARRAY == null) {
                ImportsAreUsedVisitor.$$$reportNull$$$0(5);
            }
            return PsiImportStatementBase.EMPTY_ARRAY;
        }
        if (!this.settings.isDeleteUnusedModuleImports()) {
            this.importStatements.removeAll(this.highLevelModuleImports);
        }
        PsiImportStatementBase[] psiImportStatementBaseArray = this.importStatements.toArray(PsiImportStatementBase.EMPTY_ARRAY);
        if (psiImportStatementBaseArray == null) {
            ImportsAreUsedVisitor.$$$reportNull$$$0(6);
        }
        return psiImportStatementBaseArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unusedImport/ImportsAreUsedVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unusedImport/ImportsAreUsedVisitor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedImportStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitImportList";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findImport";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

