/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.visibility;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.inheritance.ImplicitSubclassProvider;
import com.intellij.codeInspection.visibility.VisibilityInspection;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.visibility.ClassEscapesItsScopeInspection;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessCanBeTightenedInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AccessCanBeTightenedInspection.class);
    private final VisibilityInspection myVisibilityInspection;

    AccessCanBeTightenedInspection(@NotNull VisibilityInspection visibilityInspection) {
        if (visibilityInspection == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(0);
        }
        this.myVisibilityInspection = visibilityInspection;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.visibility.issues", (Object[])new Object[0]);
        if (string == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "WeakerAccess";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(2);
        }
        return new MyVisitor(holder);
    }

    @Nullable
    private static PsiPackage getPackage(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(3);
        }
        PsiDirectory directory = (file = element.getContainingFile()) == null ? null : file.getContainingDirectory();
        return directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
    }

    private static boolean samePackage(PsiPackage package1, PsiPackage package2) {
        if (package2 == package1) {
            return true;
        }
        return package2 != null && package1 != null && package1.getQualifiedName().equals(package2.getQualifiedName());
    }

    private static boolean sameModule(PsiFile file1, PsiFile file2) {
        Module module2;
        if (file1 == file2) {
            return true;
        }
        if (file1 == null || file2 == null) {
            return false;
        }
        VirtualFile virtualFile1 = file1.getVirtualFile();
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile1 == null || virtualFile2 == null) {
            return virtualFile1 == null && virtualFile2 == null;
        }
        Module module1 = ProjectRootManager.getInstance((Project)file1.getProject()).getFileIndex().getModuleForFile(virtualFile1);
        return module1 == (module2 = ProjectRootManager.getInstance((Project)file2.getProject()).getFileIndex().getModuleForFile(virtualFile2));
    }

    private static PsiExpression getQualifier(@NotNull PsiElement element) {
        if (element == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(4);
        }
        PsiExpression qualifier = null;
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)element;
            qualifier = ref.getQualifierExpression();
        } else if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)element;
            qualifier = call.getMethodExpression().getQualifierExpression();
        }
        return qualifier instanceof PsiQualifiedExpression ? null : qualifier;
    }

    private static boolean isInnerClass(@NotNull PsiClass memberClass) {
        if (memberClass == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(5);
        }
        return memberClass.getContainingClass() != null || memberClass instanceof PsiAnonymousClass;
    }

    private static boolean isConstantField(PsiMember member) {
        PsiField f;
        return member instanceof PsiField && (f = (PsiField)member).hasInitializer() && f.hasModifierProperty("static") && f.hasModifierProperty("final");
    }

    @PsiUtil.AccessLevel
    private int suggestPackageLocal(@NotNull PsiMember member) {
        PsiClass aClass;
        if (member == null) {
            AccessCanBeTightenedInspection.$$$reportNull$$$0(6);
        }
        boolean suggestPackageLocal = member instanceof PsiClass && ClassUtil.isTopLevelClass((PsiClass)(aClass = (PsiClass)member)) ? this.myVisibilityInspection.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES : this.myVisibilityInspection.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS;
        return suggestPackageLocal ? 2 : 4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInnerClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestPackageLocal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final UnusedDeclarationInspectionBase myDeadCodeInspection;
        private final Object2IntMap<PsiClass> maxSuggestedLevelForChildMembers;

        MyVisitor(ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.maxSuggestedLevelForChildMembers = new Object2IntOpenHashMap();
            this.myHolder = holder;
            this.myDeadCodeInspection = UnusedDeclarationInspectionBase.findUnusedDeclarationInspection((PsiElement)holder.getFile());
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.checkMember((PsiMember)aClass);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.checkMember((PsiMember)method);
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            this.checkMember((PsiMember)field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkMember(@NotNull PsiMember member) {
            if (member == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if (!AccessCanBeTightenedInspection.this.myVisibilityInspection.SUGGEST_FOR_CONSTANTS && AccessCanBeTightenedInspection.isConstantField(member)) {
                return;
            }
            PsiClass memberClass = member.getContainingClass();
            PsiModifierList memberModifierList = member.getModifierList();
            if (memberModifierList == null) {
                return;
            }
            int currentLevel = PsiUtil.getAccessLevel((PsiModifierList)memberModifierList);
            int suggestedLevel = this.suggestLevel(member, memberClass, currentLevel);
            if (memberClass != null) {
                if (memberClass instanceof PsiImplicitClass && currentLevel == 2) {
                    return;
                }
                Object2IntMap<PsiClass> object2IntMap = this.maxSuggestedLevelForChildMembers;
                synchronized (object2IntMap) {
                    int prevMax = this.maxSuggestedLevelForChildMembers.getInt((Object)memberClass);
                    this.maxSuggestedLevelForChildMembers.put((Object)memberClass, Math.max(prevMax, suggestedLevel));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(member.getName() + ": effective level is '" + PsiUtil.getAccessModifier((int)suggestedLevel) + "'");
            }
            if (suggestedLevel < currentLevel) {
                PsiElement toHighlight;
                if (member instanceof PsiClass) {
                    int memberMaxLevel;
                    Object2IntMap<PsiClass> prevMax = this.maxSuggestedLevelForChildMembers;
                    synchronized (prevMax) {
                        memberMaxLevel = this.maxSuggestedLevelForChildMembers.getInt((Object)member);
                    }
                    if (memberMaxLevel > suggestedLevel) {
                        return;
                    }
                }
                PsiElement psiElement = toHighlight = currentLevel == 2 ? ((PsiNameIdentifierOwner)member).getNameIdentifier() : (PsiElement)ContainerUtil.find((Object[])memberModifierList.getChildren(), element -> element instanceof PsiKeyword && element.getText().equals(PsiUtil.getAccessModifier((int)currentLevel)));
                if (toHighlight != null) {
                    String suggestedModifier = PsiUtil.getAccessModifier((int)suggestedLevel);
                    String message = "packageLocal".equals(suggestedModifier) ? JavaAnalysisBundle.message((String)"access.can.be.package.private", (Object[])new Object[0]) : JavaAnalysisBundle.message((String)"access.can.be.0", (Object[])new Object[]{suggestedModifier});
                    this.myHolder.registerProblem(toHighlight, message, new LocalQuickFix[]{new ChangeModifierFix(suggestedModifier)});
                }
            }
        }

        @PsiUtil.AccessLevel
        private int suggestLevel(@NotNull PsiMember member, PsiClass memberClass, @PsiUtil.AccessLevel int currentLevel) {
            PsiClass aClass;
            AtomicBoolean foundUsage;
            int minLevel;
            AtomicInteger maxLevel;
            boolean proceed;
            PsiField f;
            boolean entryPoint;
            PsiMethod method;
            if (member == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if (member.hasModifierProperty("private") || member.hasModifierProperty("native")) {
                return currentLevel;
            }
            if (member instanceof PsiMethod && member instanceof SyntheticElement || !member.isPhysical()) {
                return currentLevel;
            }
            if (member instanceof PsiMethod) {
                method = (PsiMethod)member;
                if (!method.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(member.getName() + " overrides");
                    }
                    return currentLevel;
                }
                if (MethodUtils.isOverridden(method)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(member.getName() + " overridden");
                    }
                    return currentLevel;
                }
                if (FindSuperElementsHelper.getSiblingInfoInheritedViaSubClass(method) != null || JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)method) != null) {
                    return currentLevel;
                }
            }
            if (member instanceof PsiEnumConstant) {
                return currentLevel;
            }
            if (member instanceof PsiClass) {
                PsiClass aClass2 = (PsiClass)member;
                if (member instanceof PsiAnonymousClass || member instanceof PsiTypeParameter || member instanceof PsiSyntheticClass || PsiUtil.isLocalClass((PsiClass)aClass2)) {
                    return currentLevel;
                }
            }
            if (memberClass != null && (memberClass.isInterface() || PsiUtil.isLocalClass((PsiClass)memberClass) && member instanceof PsiClass)) {
                return currentLevel;
            }
            if (memberClass != null && member instanceof PsiMethod) {
                method = (PsiMethod)member;
                if (memberClass.isRecord() && method.isConstructor()) {
                    PsiModifierList modifierList = memberClass.getModifierList();
                    assert (modifierList != null);
                    int level = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
                    if (level == 1 && !AccessCanBeTightenedInspection.this.myVisibilityInspection.SUGGEST_PRIVATE_FOR_INNERS) {
                        level = 2;
                    }
                    if (level == 2 && !AccessCanBeTightenedInspection.this.myVisibilityInspection.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS) {
                        level = 4;
                    }
                    return level;
                }
                for (ImplicitSubclassProvider subclassProvider : ImplicitSubclassProvider.EP_NAME.getExtensionList()) {
                    Map<PsiMethod, ImplicitSubclassProvider.OverridingInfo> methodsInfo;
                    ImplicitSubclassProvider.SubclassingInfo info;
                    if (!subclassProvider.isApplicableTo(memberClass) || (info = subclassProvider.getSubclassingInfo(memberClass)) == null || (methodsInfo = info.getMethodsInfo()) != null && !methodsInfo.containsKey(member)) continue;
                    return currentLevel;
                }
            }
            PsiFile memberFile = member.getContainingFile();
            Project project = memberFile.getProject();
            int level = AccessCanBeTightenedInspection.this.myVisibilityInspection.getMinVisibilityLevel(member);
            boolean bl = entryPoint = this.myDeadCodeInspection.isEntryPoint((PsiElement)member) || member instanceof PsiField && (UnusedSymbolUtil.isImplicitWrite((PsiVariable)(f = (PsiField)member)) || UnusedSymbolUtil.isImplicitRead((PsiVariable)f));
            if (entryPoint && level <= 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(member.getName() + " is entry point");
                }
                return currentLevel;
            }
            PsiPackage memberPackage = AccessCanBeTightenedInspection.getPackage((PsiElement)memberFile);
            if (LOG.isDebugEnabled()) {
                LOG.debug(member.getName() + ": checking effective level for " + String.valueOf(member));
            }
            if ((proceed = UnusedSymbolUtil.processUsages(project, memberFile, member, null, (Processor<? super UsageInfo>)((Processor)arg_0 -> this.lambda$suggestLevel$1(member, memberClass, maxLevel = new AtomicInteger(minLevel = Math.max(1, level)), memberPackage, foundUsage = new AtomicBoolean(), arg_0)))) && member instanceof PsiClass && LambdaUtil.isFunctionalClass((PsiClass)(aClass = (PsiClass)member))) {
                FunctionalExpressionSearch.search((PsiClass)aClass).forEach(functionalExpression -> {
                    PsiFile psiFile = functionalExpression.getContainingFile();
                    return this.handleUsage(member, memberClass, maxLevel, memberPackage, (PsiElement)functionalExpression, psiFile, foundUsage);
                });
            }
            if (!foundUsage.get() && !entryPoint) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(member.getName() + " unused; ignore");
                }
                return currentLevel;
            }
            int suggestedLevel = maxLevel.get();
            if (suggestedLevel == 1 && memberClass == null) {
                suggestedLevel = AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
            }
            String suggestedModifier = PsiUtil.getAccessModifier((int)suggestedLevel);
            if (LOG.isDebugEnabled()) {
                LOG.debug(member.getName() + ": effective level is '" + suggestedModifier + "'");
            }
            return suggestedLevel;
        }

        private boolean handleUsage(@NotNull PsiMember member, @Nullable PsiClass memberClass, @NotNull AtomicInteger maxLevel, @Nullable PsiPackage memberPackage, @NotNull PsiElement element, @NotNull PsiFile psiFile, @NotNull AtomicBoolean foundUsage) {
            if (member == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if (maxLevel == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            if (psiFile == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            if (foundUsage == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            foundUsage.set(true);
            if (!(psiFile instanceof PsiJavaFile)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("     refd from " + psiFile.getName() + "; set to public");
                }
                maxLevel.set(4);
                return false;
            }
            int level = this.getEffectiveLevel(element, psiFile, member, memberClass, memberPackage);
            if (LOG.isDebugEnabled()) {
                LOG.debug("    ref in file " + psiFile.getName() + "; level = " + PsiUtil.getAccessModifier((int)level) + "; (" + String.valueOf(element) + ")");
            }
            maxLevel.getAndAccumulate(level, Math::max);
            return level != 4;
        }

        @PsiUtil.AccessLevel
        private int getEffectiveLevel(@NotNull PsiElement element, @NotNull PsiFile file, @NotNull PsiMember member, PsiClass memberClass, PsiPackage memberPackage) {
            PsiElement resolvedQualifier;
            PsiJavaCodeReferenceElement ref;
            PsiMember exportingMember;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            if (file == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            if (member == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            if (member instanceof PsiClass && element instanceof PsiJavaCodeReferenceElement && (exportingMember = ClassEscapesItsScopeInspection.getExportingMember(ref = (PsiJavaCodeReferenceElement)element)) != null) {
                PsiModifierList modifierList = exportingMember.getModifierList();
                assert (modifierList != null);
                return PsiUtil.getAccessLevel((PsiModifierList)modifierList);
            }
            PsiClass innerClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (memberClass != null && PsiTreeUtil.isAncestor((PsiElement)innerClass, (PsiElement)memberClass, (boolean)false) || innerClass != null && PsiTreeUtil.isAncestor((PsiElement)memberClass, (PsiElement)innerClass, (boolean)false)) {
                if (VisibilityInspection.containsReferenceTo((PsiElement)innerClass.getModifierList(), (PsiElement)member) || VisibilityInspection.containsReferenceTo((PsiElement)innerClass.getImplementsList(), (PsiElement)member) || VisibilityInspection.containsReferenceTo((PsiElement)innerClass.getExtendsList(), (PsiElement)member)) {
                    return AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
                }
                return !(member.hasModifierProperty("abstract") || !AccessCanBeTightenedInspection.this.myVisibilityInspection.SUGGEST_PRIVATE_FOR_INNERS && AccessCanBeTightenedInspection.isInnerClass(memberClass) || !member.hasModifierProperty("static") && MyVisitor.calledOnInheritor(element, memberClass)) ? 1 : AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
            }
            PsiExpression qualifier = AccessCanBeTightenedInspection.getQualifier(element);
            if (qualifier instanceof PsiReference) {
                PsiReference ref2 = (PsiReference)qualifier;
                v0 = ref2.resolve();
            } else {
                v0 = resolvedQualifier = null;
            }
            if (resolvedQualifier instanceof PsiVariable) {
                PsiVariable var = (PsiVariable)resolvedQualifier;
                resolvedQualifier = PsiUtil.resolveClassInClassTypeOnly((PsiType)var.getType());
            }
            PsiPackage qualifierPackage = resolvedQualifier == null ? null : AccessCanBeTightenedInspection.getPackage(resolvedQualifier);
            PsiPackage aPackage = AccessCanBeTightenedInspection.getPackage((PsiElement)file);
            if (AccessCanBeTightenedInspection.samePackage(memberPackage, aPackage) && (qualifierPackage == null || AccessCanBeTightenedInspection.samePackage(qualifierPackage, aPackage)) && AccessCanBeTightenedInspection.sameModule(member.getContainingFile(), file)) {
                return AccessCanBeTightenedInspection.this.suggestPackageLocal(member);
            }
            if (qualifier != null) {
                return 4;
            }
            if (innerClass != null && memberClass != null && innerClass.isInheritor(memberClass, true)) {
                PsiMethod m;
                boolean isConstructor;
                PsiElement psiElement;
                if (element instanceof PsiReference) {
                    PsiReference ref3 = (PsiReference)element;
                    psiElement = ref3.resolve();
                } else {
                    psiElement = null;
                }
                PsiElement resolved = psiElement;
                boolean bl = isConstructor = resolved instanceof PsiClass && element.getParent() instanceof PsiNewExpression || resolved instanceof PsiMethod && (m = (PsiMethod)resolved).isConstructor();
                if (!isConstructor) {
                    return 3;
                }
            }
            return 4;
        }

        private static boolean calledOnInheritor(@NotNull PsiElement element, PsiClass memberClass) {
            PsiExpression qualifier;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(14);
            }
            if ((qualifier = AccessCanBeTightenedInspection.getQualifier(element)) == null) {
                PsiClass enclosingInstance = InheritanceUtil.findEnclosingInstanceInScope((PsiClass)memberClass, (PsiElement)element, (Condition)Conditions.alwaysTrue(), (boolean)true);
                return enclosingInstance != null && enclosingInstance != memberClass;
            }
            PsiClass qClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
            return qClass != null && qClass.isInheritor(memberClass, true);
        }

        private /* synthetic */ boolean lambda$suggestLevel$1(PsiMember member, PsiClass memberClass, AtomicInteger maxLevel, PsiPackage memberPackage, AtomicBoolean foundUsage, UsageInfo info) {
            PsiElement element = info.getElement();
            if (element == null) {
                return true;
            }
            PsiFile psiFile = info.getFile();
            if (psiFile == null) {
                return true;
            }
            return this.handleUsage(member, memberClass, maxLevel, memberPackage, element, psiFile, foundUsage);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxLevel";
                    break;
                }
                case 8: 
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foundUsage";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/visibility/AccessCanBeTightenedInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkMember";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "suggestLevel";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleUsage";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEffectiveLevel";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calledOnInheritor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

