/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.visibility;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.codeInspection.visibility.AccessCanBeTightenedInspection;
import com.intellij.codeInspection.visibility.EntryPointWithVisibilityLevel;
import com.intellij.codeInspection.visibility.VisibilityExtension;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import one.util.streamex.StreamEx;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class VisibilityInspection
extends GlobalJavaBatchInspectionTool {
    private static final ExtensionPointName<VisibilityExtension> EP_NAME = new ExtensionPointName("com.intellij.visibility");
    private static final Logger LOG = Logger.getInstance(VisibilityInspection.class);
    public boolean SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS = true;
    public boolean SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES = true;
    public boolean SUGGEST_PRIVATE_FOR_INNERS;
    public boolean SUGGEST_FOR_CONSTANTS = true;
    private final Map<String, Boolean> myExtensions = new TreeMap<String, Boolean>();
    @NonNls
    public static final String SHORT_NAME = "WeakerAccess";

    @NotNull
    public OptPane getOptionsPane() {
        ArrayList<OptCheckbox> checkboxes = new ArrayList<OptCheckbox>(List.of(OptPane.checkbox((String)"SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS", (String)JavaAnalysisBundle.message((String)"inspection.visibility.option.package.private.members", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES", (String)JavaAnalysisBundle.message((String)"inspection.visibility.package.private.top.level.classes", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"SUGGEST_PRIVATE_FOR_INNERS", (String)JavaAnalysisBundle.message((String)"inspection.visibility.private.inner.members", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"SUGGEST_FOR_CONSTANTS", (String)JavaAnalysisBundle.message((String)"inspection.visibility.option.constants", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])));
        for (EntryPoint entryPoint : EntryPointsManagerBase.DEAD_CODE_EP_NAME.getExtensionList()) {
            if (!(entryPoint instanceof EntryPointWithVisibilityLevel)) continue;
            EntryPointWithVisibilityLevel epWithLevel = (EntryPointWithVisibilityLevel)entryPoint;
            checkboxes.add(OptPane.checkbox((String)epWithLevel.getId(), (String)epWithLevel.getTitle(), (OptRegularComponent[])new OptRegularComponent[0]).prefix("ep"));
        }
        return new OptPane(checkboxes);
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onPrefix("ep", bindId -> this.myExtensions.getOrDefault(bindId, true), (bindId, value) -> this.myExtensions.put((String)bindId, (Boolean)value));
        if (optionController == null) {
            VisibilityInspection.$$$reportNull$$$0(0);
        }
        return optionController;
    }

    @NotNull
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new AccessCanBeTightenedInspection(this);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
        if (string == null) {
            VisibilityInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        RefClass refClass;
        RefMethod refMethod;
        RefField refField;
        RefElementImpl element;
        PsiFile containingFile;
        if (refEntity == null) {
            VisibilityInspection.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            VisibilityInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            VisibilityInspection.$$$reportNull$$$0(4);
        }
        if (globalContext == null) {
            VisibilityInspection.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            VisibilityInspection.$$$reportNull$$$0(6);
        }
        if (!(refEntity instanceof RefJavaElement)) {
            return null;
        }
        RefJavaElement refElement = (RefJavaElement)refEntity;
        if (refElement instanceof RefParameter) {
            return null;
        }
        if (refElement.isSyntheticJSP()) {
            return null;
        }
        if (refElement instanceof RefElementImpl && ((containingFile = (element = (RefElementImpl)refElement).getContainingFile()) == null || !containingFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE))) {
            return null;
        }
        if (!this.SUGGEST_FOR_CONSTANTS && refEntity instanceof RefField && (refField = (RefField)refEntity).isFinal() && refField.isStatic() && refField.isOnlyAssignedInInitializer()) {
            return null;
        }
        if (refElement instanceof RefField) {
            refField = (RefField)refElement;
            if (refField.isImplicitlyWritten() || refField.isImplicitlyRead()) {
                return null;
            }
            if (refField.isEnumConstant()) {
                return null;
            }
        }
        if (refElement instanceof RefImplicitConstructor) {
            return null;
        }
        if (refElement instanceof RefMethod && ((refMethod = (RefMethod)refElement).isExternalOverride() || refMethod.isRecordAccessor())) {
            return null;
        }
        if (refElement instanceof RefClass && ((refClass = (RefClass)refElement).isAnonymous() || refClass.isServlet() || refClass.isApplet() || refClass.isLocalClass())) {
            return null;
        }
        containingFile = refElement.getOwner();
        if (containingFile instanceof RefClass && (refClass = (RefClass)containingFile).isInterface()) {
            return null;
        }
        if (this.keepVisibilityLevel(refElement)) {
            return null;
        }
        int minLevel = this.getMinVisibilityLevel(refElement);
        if (refElement.isEntry() && minLevel == -1) {
            return null;
        }
        if (refElement.getInReferences().isEmpty()) {
            if (minLevel == -1 && (minLevel = this.getMinVisibilityLevel(refElement)) == -1) {
                return null;
            }
            String weakestAccess = PsiUtil.getAccessModifier((int)minLevel);
            if (!weakestAccess.equals(refElement.getAccessModifier())) {
                return VisibilityInspection.createDescriptions((RefElement)refElement, weakestAccess, manager);
            }
        }
        if (refElement instanceof RefClass && VisibilityInspection.isTopLevelClass((RefElement)refElement) && minLevel <= 0 && !this.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES) {
            return null;
        }
        String access = this.getPossibleAccess(refElement, minLevel <= 0 ? 1 : minLevel);
        if (!access.equals(refElement.getAccessModifier())) {
            return VisibilityInspection.createDescriptions((RefElement)refElement, access, manager);
        }
        return null;
    }

    private boolean keepVisibilityLevel(@NotNull RefJavaElement refElement) {
        if (refElement == null) {
            VisibilityInspection.$$$reportNull$$$0(7);
        }
        return StreamEx.of((Collection)EntryPointsManagerBase.DEAD_CODE_EP_NAME.getExtensionList()).select(EntryPointWithVisibilityLevel.class).anyMatch(point -> point.keepVisibilityLevel(this.isEntryPointEnabled((EntryPointWithVisibilityLevel)((Object)point)), refElement));
    }

    private static CommonProblemDescriptor @NotNull [] createDescriptions(RefElement refElement, @PsiModifier.ModifierConstant String access, @NotNull InspectionManager manager) {
        PsiElement element;
        PsiElement nameIdentifier;
        if (manager == null) {
            VisibilityInspection.$$$reportNull$$$0(8);
        }
        PsiElement psiElement = nameIdentifier = (element = refElement.getPsiElement()) != null ? IdentifierUtil.getNameIdentifier((PsiElement)element) : null;
        if (nameIdentifier != null) {
            String targetVisibility = VisibilityUtil.toPresentableText((String)access);
            String message = JavaAnalysisBundle.message((String)"inspection.visibility.compose.suggestion", (Object[])new Object[]{targetVisibility});
            String elementDescription = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
            String quickFixName = JavaAnalysisBundle.message((String)"change.visibility.level", (Object[])new Object[]{elementDescription, targetVisibility});
            AcceptSuggestedAccess fix = new AcceptSuggestedAccess(access, quickFixName);
            ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[]{manager.createProblemDescriptor(nameIdentifier, message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
            if (problemDescriptorArray == null) {
                VisibilityInspection.$$$reportNull$$$0(9);
            }
            return problemDescriptorArray;
        }
        if (CommonProblemDescriptor.EMPTY_ARRAY == null) {
            VisibilityInspection.$$$reportNull$$$0(10);
        }
        return CommonProblemDescriptor.EMPTY_ARRAY;
    }

    @EntryPointWithVisibilityLevel.VisibilityLevelResult
    int getMinVisibilityLevel(@NotNull PsiMember member) {
        if (member == null) {
            VisibilityInspection.$$$reportNull$$$0(11);
        }
        return ((StreamEx)StreamEx.of((Collection)EntryPointsManagerBase.DEAD_CODE_EP_NAME.getExtensionList()).select(EntryPointWithVisibilityLevel.class).filter(point -> this.isEntryPointEnabled((EntryPointWithVisibilityLevel)((Object)point)))).mapToInt(point -> point.getMinVisibilityLevel(member)).max().orElse(-1);
    }

    private boolean isEntryPointEnabled(EntryPointWithVisibilityLevel point) {
        return this.myExtensions.getOrDefault(point.getId(), true);
    }

    @EntryPointWithVisibilityLevel.VisibilityLevelResult
    private int getMinVisibilityLevel(@NotNull RefJavaElement refElement) {
        int n;
        PsiElement psiElement;
        if (refElement == null) {
            VisibilityInspection.$$$reportNull$$$0(12);
        }
        if (refElement.isEntry() && (psiElement = refElement.getPsiElement()) instanceof PsiMember) {
            PsiMember member = (PsiMember)psiElement;
            n = this.getMinVisibilityLevel(member);
        } else {
            n = -1;
        }
        return n;
    }

    @PsiModifier.ModifierConstant
    @NotNull
    private String getPossibleAccess(@NotNull RefJavaElement refElement, @PsiUtil.AccessLevel int minLevel) {
        String weakerAccess;
        RefClass ownerClass;
        RefMethod refMethod;
        if (refElement == null) {
            VisibilityInspection.$$$reportNull$$$0(13);
        }
        String curAccess = refElement.getAccessModifier();
        String weakestAccess = PsiUtil.getAccessModifier((int)minLevel);
        if (VisibilityInspection.isTopLevelClass((RefElement)refElement) || VisibilityInspection.isCalledOnSubClasses((RefElement)refElement)) {
            weakestAccess = "packageLocal";
        }
        if (VisibilityInspection.isAbstractMethod((RefElement)refElement)) {
            weakestAccess = "protected";
        }
        if (refElement instanceof RefMethod && (refMethod = (RefMethod)refElement).isConstructor() && (ownerClass = refMethod.getOwnerClass()) != null && ownerClass.isRecord()) {
            weakestAccess = ownerClass.getAccessModifier();
        }
        if (curAccess.equals(weakestAccess)) {
            String string = curAccess;
            if (string == null) {
                VisibilityInspection.$$$reportNull$$$0(14);
            }
            return string;
        }
        while ((weakerAccess = this.getWeakerAccess(curAccess, (RefElement)refElement)) != null && RefJavaUtil.getInstance().compareAccess(weakerAccess, weakestAccess) >= 0 && this.isAccessible(refElement, weakerAccess)) {
            curAccess = weakerAccess;
        }
        String string = curAccess;
        if (string == null) {
            VisibilityInspection.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static boolean isCalledOnSubClasses(RefElement refElement) {
        RefMethod method;
        return refElement instanceof RefMethod && (method = (RefMethod)refElement).isCalledOnSubClass();
    }

    private static boolean isAbstractMethod(RefElement refElement) {
        RefMethod method;
        return refElement instanceof RefMethod && (method = (RefMethod)refElement).isAbstract();
    }

    private static boolean isTopLevelClass(RefElement refElement) {
        return refElement instanceof RefClass && refElement.getOwner() instanceof RefPackage;
    }

    @PsiModifier.ModifierConstant
    @Nullable
    private String getWeakerAccess(@PsiModifier.ModifierConstant String curAccess, RefElement refElement) {
        if ("public".equals(curAccess)) {
            return VisibilityInspection.isTopLevelClass(refElement) ? "packageLocal" : "protected";
        }
        if ("protected".equals(curAccess)) {
            return this.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS ? "packageLocal" : "private";
        }
        if ("packageLocal".equals(curAccess)) {
            return "private";
        }
        return null;
    }

    private boolean isAccessible(@NotNull RefJavaElement to, @NotNull @PsiModifier.ModifierConstant String accessModifier) {
        if (to == null) {
            VisibilityInspection.$$$reportNull$$$0(16);
        }
        if (accessModifier == null) {
            VisibilityInspection.$$$reportNull$$$0(17);
        }
        for (Object refElement : to.getInReferences()) {
            if (this.isAccessibleFrom((RefElement)refElement, to, accessModifier)) continue;
            return false;
        }
        if (to instanceof RefMethod) {
            RefMethod method = (RefMethod)to;
            if (method.isAbstract() && (method.getDerivedMethods().isEmpty() || "private".equals(method.getAccessModifier()))) {
                return false;
            }
            for (RefMethod refOverride : method.getDerivedMethods()) {
                if ("private".equals(accessModifier)) {
                    return false;
                }
                if (this.isAccessibleFrom((RefElement)refOverride, to, accessModifier)) continue;
                return false;
            }
            for (RefMethod refSuper : method.getSuperMethods()) {
                if (RefJavaUtil.getInstance().compareAccess(refSuper.getAccessModifier(), accessModifier) <= 0) continue;
                return false;
            }
        }
        if (to instanceof RefClass) {
            RefClass refClass = (RefClass)to;
            for (RefClass subClass : refClass.getSubClasses()) {
                if (this.isAccessibleFrom((RefElement)subClass, to, accessModifier)) continue;
                return false;
            }
            for (RefEntity refElement : refClass.getChildren()) {
                if (this.isAccessible((RefJavaElement)refElement, accessModifier)) continue;
                return false;
            }
            for (RefEntity refElement : refClass.getInTypeReferences()) {
                if (this.isAccessibleFrom((RefElement)refElement, (RefJavaElement)refClass, accessModifier)) continue;
                return false;
            }
            assert (refClass instanceof RefClassImpl);
            List<RefJavaElement> classExporters = ((RefClassImpl)refClass).getClassExporters();
            if (classExporters != null) {
                for (RefJavaElement refExporter : classExporters) {
                    if (VisibilityInspection.getAccessLevel(accessModifier) >= VisibilityInspection.getAccessLevel(refExporter.getAccessModifier())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static int getAccessLevel(@PsiModifier.ModifierConstant String access) {
        if ("private".equals(access)) {
            return 1;
        }
        if ("packageLocal".equals(access)) {
            return 2;
        }
        if ("protected".equals(access)) {
            return 3;
        }
        return 4;
    }

    private boolean isAccessibleFrom(RefElement from, RefJavaElement to, String accessModifier) {
        if ("public".equals(accessModifier)) {
            return true;
        }
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        if ("packageLocal".equals(accessModifier)) {
            return RefJavaUtil.getPackage((RefEntity)from) == RefJavaUtil.getPackage((RefEntity)to);
        }
        RefClass fromTopLevel = refUtil.getTopLevelClass(from);
        RefClass toTopLevel = refUtil.getTopLevelClass((RefElement)to);
        RefClass fromOwner = refUtil.getOwnerClass(from);
        RefClass toOwner = refUtil.getOwnerClass((RefElement)to);
        if ("protected".equals(accessModifier)) {
            RefJavaElementImpl ref;
            if (to instanceof RefJavaElementImpl && (ref = (RefJavaElementImpl)to).isProtectedAccessForbidden()) {
                return false;
            }
            return fromTopLevel != null && refUtil.isInheritor(fromTopLevel, toOwner) || fromOwner != null && refUtil.isInheritor(fromOwner, toTopLevel) || toTopLevel != null && toTopLevel == fromTopLevel;
        }
        if ("private".equals(accessModifier)) {
            if (this.SUGGEST_PRIVATE_FOR_INNERS) {
                RefField field;
                RefMethod method;
                PsiClass fromTopLevelElement = fromTopLevel != null ? (PsiClass)fromTopLevel.getPsiElement() : null;
                PsiElement target = to.getPsiElement();
                if (fromTopLevelElement != null) {
                    if (VisibilityInspection.containsReferenceTo((PsiElement)fromTopLevelElement.getExtendsList(), target)) {
                        return false;
                    }
                    if (VisibilityInspection.containsReferenceTo((PsiElement)fromTopLevelElement.getImplementsList(), target)) {
                        return false;
                    }
                    if (VisibilityInspection.containsReferenceTo((PsiElement)fromTopLevelElement.getModifierList(), target)) {
                        return false;
                    }
                }
                return fromTopLevel == toOwner || fromOwner == toTopLevel || toOwner != null && (refUtil.getOwnerClass((RefElement)toOwner) == from || from instanceof RefMethod && toOwner == (method = (RefMethod)from).getOwnerClass() || from instanceof RefField && toOwner == (field = (RefField)from).getOwnerClass());
            }
            if (fromOwner != null && fromOwner.isStatic() && !to.isStatic() && refUtil.isInheritor(fromOwner, toOwner)) {
                return false;
            }
            if (fromTopLevel == toOwner) {
                if (from instanceof RefClass) {
                    RefClass aClass = (RefClass)from;
                    PsiClass fromClass = aClass.getUastElement().getJavaPsi();
                    PsiElement target = to.getPsiElement();
                    if ((to instanceof RefClass || to instanceof RefField) && VisibilityInspection.containsReferenceTo((PsiElement)fromClass.getModifierList(), target)) {
                        return false;
                    }
                    if (to instanceof RefClass) {
                        if (VisibilityInspection.containsReferenceTo((PsiElement)fromClass.getExtendsList(), target)) {
                            return false;
                        }
                        if (VisibilityInspection.containsReferenceTo((PsiElement)fromClass.getImplementsList(), target)) {
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static boolean containsReferenceTo(PsiElement source, PsiElement target) {
        return SyntaxTraverser.psiTraverser((PsiElement)source).filter(PsiJavaCodeReferenceElement.class).filter(ref -> ref.isReferenceTo(target)).isNotEmpty();
    }

    protected boolean queryExternalUsagesRequests(final @NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        if (manager == null) {
            VisibilityInspection.$$$reportNull$$$0(18);
        }
        if (globalContext == null) {
            VisibilityInspection.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            VisibilityInspection.$$$reportNull$$$0(20);
        }
        final EntryPointsManager entryPointsManager = globalContext.getEntryPointsManager(manager);
        for (RefElement entryPoint : entryPointsManager.getEntryPoints(manager)) {
            if (((Boolean)ReadAction.nonBlocking(() -> {
                RefJavaElement element;
                return entryPoint instanceof RefJavaElement && this.getMinVisibilityLevel(element = (RefJavaElement)entryPoint) > 0;
            }).executeSynchronously()).booleanValue()) continue;
            VisibilityInspection.ignoreElement(processor, (RefEntity)entryPoint);
        }
        for (VisibilityExtension addin : EP_NAME.getExtensionList()) {
            addin.fillIgnoreList(manager, processor);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(this){

            public void visitField(@NotNull RefField refField) {
                if (refField == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processor.getDescriptions((RefEntity)refField) == null) {
                    return;
                }
                if (!"private".equals(refField.getAccessModifier())) {
                    globalContext.enqueueFieldUsagesProcessor(refField, psiReference -> {
                        VisibilityInspection.ignoreElement(processor, (RefEntity)refField);
                        return false;
                    });
                }
            }

            public void visitMethod(@NotNull RefMethod refMethod) {
                if (refMethod == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (processor.getDescriptions((RefEntity)refMethod) == null) {
                    return;
                }
                if (!(refMethod.isExternalOverride() || "private".equals(refMethod.getAccessModifier()) || refMethod instanceof RefImplicitConstructor)) {
                    globalContext.enqueueDerivedMethodsProcessor(refMethod, derivedMethod -> {
                        VisibilityInspection.ignoreElement(processor, (RefEntity)refMethod);
                        return false;
                    });
                    globalContext.enqueueMethodUsagesProcessor(refMethod, psiReference -> {
                        VisibilityInspection.ignoreElement(processor, (RefEntity)refMethod);
                        return false;
                    });
                }
            }

            public void visitClass(@NotNull RefClass refClass) {
                if (refClass == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (processor.getDescriptions((RefEntity)refClass) == null) {
                    return;
                }
                if (!refClass.isAnonymous() && !"private".equals(refClass.getAccessModifier())) {
                    globalContext.enqueueDerivedClassesProcessor(refClass, inheritor -> {
                        VisibilityInspection.ignoreElement(processor, (RefEntity)refClass);
                        return false;
                    });
                    globalContext.enqueueClassUsagesProcessor(refClass, psiReference -> {
                        VisibilityInspection.ignoreElement(processor, (RefEntity)refClass);
                        return false;
                    });
                    RefMethod defaultConstructor = refClass.getDefaultConstructor();
                    if (entryPointsManager.isAddNonJavaEntries() && defaultConstructor != null) {
                        String qualifiedName;
                        PsiElement psiElement = refClass.getPsiElement();
                        if (psiElement instanceof PsiClass) {
                            PsiClass c = (PsiClass)psiElement;
                            v0 = c.getQualifiedName();
                        } else {
                            v0 = qualifiedName = null;
                        }
                        if (qualifiedName != null) {
                            Project project = manager.getProject();
                            PsiSearchHelper.getInstance((Project)project).processUsagesInNonJavaFiles(qualifiedName, (file, startOffset, endOffset) -> {
                                entryPointsManager.addEntryPoint((RefElement)defaultConstructor, false);
                                VisibilityInspection.ignoreElement(processor, (RefEntity)defaultConstructor);
                                return false;
                            }, GlobalSearchScope.projectScope((Project)project));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refField";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refMethod";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refClass";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/visibility/VisibilityInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return false;
    }

    private static void ignoreElement(@NotNull ProblemDescriptionsProcessor processor, @NotNull RefEntity refElement) {
        RefClass refClass;
        RefMethod defaultConstructor;
        if (processor == null) {
            VisibilityInspection.$$$reportNull$$$0(21);
        }
        if (refElement == null) {
            VisibilityInspection.$$$reportNull$$$0(22);
        }
        processor.ignoreElement(refElement);
        if (refElement instanceof RefClass && (defaultConstructor = (refClass = (RefClass)refElement).getDefaultConstructor()) != null) {
            processor.ignoreElement((RefEntity)defaultConstructor);
            return;
        }
        RefEntity owner = refElement.getOwner();
        if (owner instanceof RefElement) {
            processor.ignoreElement(owner);
        }
    }

    public void compose(@NotNull StringBuilder buf, @NotNull RefEntity refEntity, @NotNull HTMLComposer composer) {
        if (buf == null) {
            VisibilityInspection.$$$reportNull$$$0(23);
        }
        if (refEntity == null) {
            VisibilityInspection.$$$reportNull$$$0(24);
        }
        if (composer == null) {
            VisibilityInspection.$$$reportNull$$$0(25);
        }
        composer.appendElementInReferences(buf, (RefElement)refEntity);
    }

    @NotNull
    public QuickFix<?> getQuickFix(@PsiModifier.ModifierConstant String hint) {
        return new AcceptSuggestedAccess(hint, null);
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        if (fix == null) {
            VisibilityInspection.$$$reportNull$$$0(26);
        }
        return ((AcceptSuggestedAccess)fix).myHint;
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            VisibilityInspection.$$$reportNull$$$0(27);
        }
        super.writeSettings(node);
        for (Map.Entry<String, Boolean> entry : this.myExtensions.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            node.addContent(new Element("disabledExtension").setAttribute("id", entry.getKey()));
        }
        for (Element child : node.getChildren()) {
            if (!"SUGGEST_FOR_CONSTANTS".equals(child.getAttributeValue("name")) || !"true".equals(child.getAttributeValue("value"))) continue;
            node.removeContent((Content)child);
            break;
        }
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            VisibilityInspection.$$$reportNull$$$0(28);
        }
        super.readSettings(node);
        for (Element extension : node.getChildren("disabledExtension")) {
            String id = extension.getAttributeValue("id");
            if (id == null) continue;
            this.myExtensions.put(id, false);
        }
    }

    @TestOnly
    public void setEntryPointEnabled(@NotNull String entryPointId, boolean enabled) {
        if (entryPointId == null) {
            VisibilityInspection.$$$reportNull$$$0(29);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode());
        this.myExtensions.put(entryPointId, enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 11, 12, 13, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/visibility/VisibilityInspection";
                break;
            }
            case 2: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 6: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessModifier";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPointId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/visibility/VisibilityInspection";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptions";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleAccess";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "keepVisibilityLevel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMinVisibilityLevel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleAccess";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "ignoreElement";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "compose";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setEntryPointEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 11, 12, 13, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> new IllegalArgumentException(string);
        };
    }

    private static final class AcceptSuggestedAccess
    extends PsiUpdateModCommandQuickFix {
        @PsiModifier.ModifierConstant
        private final String myHint;
        @IntentionName
        private final String myName;

        private AcceptSuggestedAccess(@PsiModifier.ModifierConstant String hint, @IntentionName String name) {
            this.myHint = hint;
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName != null ? this.myName : this.getFamilyName();
            if (string == null) {
                AcceptSuggestedAccess.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.visibility.accept.quickfix", (Object[])new Object[0]);
            if (string == null) {
                AcceptSuggestedAccess.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiModifierListOwner element;
            if (project == null) {
                AcceptSuggestedAccess.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                AcceptSuggestedAccess.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                AcceptSuggestedAccess.$$$reportNull$$$0(4);
            }
            if ((element = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiModifierListOwner.class)) != null) {
                PsiMethod method;
                PsiClass containingClass;
                PsiModifierList list;
                if (element instanceof PsiVariable) {
                    PsiVariable variable = (PsiVariable)element;
                    variable.normalizeDeclaration();
                }
                LOG.assertTrue((list = element.getModifierList()) != null);
                if (element instanceof PsiMethod && (containingClass = (method = (PsiMethod)element).getContainingClass()) != null && containingClass.getParent() instanceof PsiFile && "private".equals(this.myHint) && list.hasModifierProperty("final")) {
                    list.setModifierProperty("final", false);
                }
                list.setModifierProperty(this.myHint, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/visibility/VisibilityInspection$AcceptSuggestedAccess";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/visibility/VisibilityInspection$AcceptSuggestedAccess";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

