/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightDefaultConstructor;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.ImplicitToStringSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetMapper;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.LambdaMetafactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaFindUsagesHelper {
    private static final Logger LOG = Logger.getInstance(JavaFindUsagesHelper.class);

    @NotNull
    public static Set<String> getElementNames(@NotNull PsiElement element) {
        if (element == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)element;
            PsiPackage aPackage = (PsiPackage)ReadAction.compute(() -> JavaDirectoryService.getInstance().getPackage(psiDirectory));
            return aPackage == null ? Collections.emptySet() : JavaFindUsagesHelper.getElementNames((PsiElement)aPackage);
        }
        HashSet<String> result = new HashSet<String>();
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiElement psiElement = element;
            Objects.requireNonNull(psiElement);
            PsiElement selector0$temp = psiElement;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiPackage.class, PsiClass.class, PsiMethod.class, PsiVariable.class, PsiMetaOwner.class, PsiNamedElement.class, XmlAttributeValue.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    PsiPackage psiPackage = (PsiPackage)selector0$temp;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)psiPackage.getQualifiedName());
                    break;
                }
                case 1: {
                    PsiClass psiClass = (PsiClass)selector0$temp;
                    String qname = psiClass.getQualifiedName();
                    if (qname == null) break;
                    result.add(qname);
                    PsiClass topLevelClass = PsiUtil.getTopLevelClass((PsiElement)element);
                    if (topLevelClass == null || topLevelClass instanceof PsiSyntheticClass) break;
                    String topName = topLevelClass.getQualifiedName();
                    assert (topName != null) : "topLevelClass : " + String.valueOf(topLevelClass) + "; element: " + String.valueOf(element) + " (" + qname + ") top level file: " + String.valueOf(InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element));
                    if (qname.length() <= topName.length()) break;
                    result.add(topName + qname.substring(topName.length()).replace('.', '$'));
                    break;
                }
                case 2: {
                    PsiMethod psiMethod = (PsiMethod)selector0$temp;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)psiMethod.getName());
                    break;
                }
                case 3: {
                    PsiVariable psiVariable = (PsiVariable)selector0$temp;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)psiVariable.getName());
                    break;
                }
                case 4: {
                    PsiMetaOwner psiMetaOwner = (PsiMetaOwner)selector0$temp;
                    PsiMetaData metaData = psiMetaOwner.getMetaData();
                    if (metaData == null) break;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)metaData.getName());
                    break;
                }
                case 5: {
                    PsiNamedElement psiNamedElement = (PsiNamedElement)selector0$temp;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)psiNamedElement.getName());
                    break;
                }
                case 6: {
                    XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)selector0$temp;
                    ContainerUtil.addIfNotNull((Collection)result, (Object)xmlAttributeValue.getValue());
                    break;
                }
                default: {
                    LOG.error("Unknown element type: " + String.valueOf(element));
                }
            }
        });
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public static boolean processElementUsages(@NotNull PsiElement element, @NotNull FindUsagesOptions options, @NotNull Processor<? super UsageInfo> processor) {
        SearchScope isAbstract2;
        PomTarget pomTarget;
        boolean success;
        if (element == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(2);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(4);
        }
        if (options instanceof JavaVariableFindUsagesOptions) {
            JavaVariableFindUsagesOptions varOptions = (JavaVariableFindUsagesOptions)options;
            if ((varOptions.isReadAccess || varOptions.isWriteAccess) && (varOptions.isReadAccess && varOptions.isWriteAccess ? !JavaFindUsagesHelper.addElementUsages(element, options, processor) : !JavaFindUsagesHelper.addElementUsages(element, (FindUsagesOptions)varOptions, (Processor<? super UsageInfo>)((Processor)info -> {
                PsiExpression expression;
                PsiElement patt0$temp = info.getElement();
                boolean isWrite = patt0$temp instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)(expression = (PsiExpression)patt0$temp));
                return isWrite != varOptions.isWriteAccess || processor.process(info);
            })))) {
                return false;
            }
        } else if (options.isUsages && !JavaFindUsagesHelper.addElementUsages(element, options, processor)) {
            return false;
        }
        if (!(success = ((Boolean)ReadAction.compute(() -> {
            if (ThrowSearchUtil.isSearchable(element) && options instanceof JavaThrowFindUsagesOptions) {
                JavaThrowFindUsagesOptions javaOptions = (JavaThrowFindUsagesOptions)options;
                if (options.isUsages) {
                    ThrowSearchUtil.Root[] roots;
                    ThrowSearchUtil.Root root = javaOptions.getRoot();
                    if (root == null && (roots = ThrowSearchUtil.getSearchRoots(element)) != null && roots.length > 0) {
                        root = roots[0];
                    }
                    if (root != null) {
                        return ThrowSearchUtil.addThrowUsages(processor, root, options);
                    }
                }
            }
            return true;
        })).booleanValue())) {
            return false;
        }
        if (options instanceof JavaPackageFindUsagesOptions) {
            JavaPackageFindUsagesOptions javaOptions = (JavaPackageFindUsagesOptions)options;
            if (javaOptions.isClassesUsages && !JavaFindUsagesHelper.addClassesUsages((PsiPackage)element, javaOptions, processor)) {
                return false;
            }
        }
        if (options instanceof JavaClassFindUsagesOptions) {
            JavaClassFindUsagesOptions classOptions = (JavaClassFindUsagesOptions)options;
            if (element instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)element;
                PsiManager manager = (PsiManager)ReadAction.compute(() -> psiClass.getManager());
                if ((classOptions.isMethodsUsages || classOptions.isConstructorUsages) && !JavaFindUsagesHelper.addMethodUsages(psiClass, manager, classOptions, processor)) {
                    return false;
                }
                if (classOptions.isFieldsUsages && !JavaFindUsagesHelper.addFieldsUsages(psiClass, manager, classOptions, processor)) {
                    return false;
                }
                if (((Boolean)ReadAction.compute(() -> psiClass.isInterface())).booleanValue()) {
                    if (classOptions.isDerivedInterfaces ? (classOptions.isImplementingClasses ? !JavaFindUsagesHelper.addInheritors(psiClass, classOptions, processor) : !JavaFindUsagesHelper.addDerivedInterfaces(psiClass, classOptions, processor)) : classOptions.isImplementingClasses && !JavaFindUsagesHelper.addImplementingClasses(psiClass, classOptions, processor)) {
                        return false;
                    }
                    if (classOptions.isImplementingClasses) {
                        FunctionalExpressionSearch.search((PsiClass)psiClass, (SearchScope)classOptions.searchScope).forEach((Processor)new PsiElementProcessorAdapter(expression -> JavaFindUsagesHelper.addResult(expression, options, processor)));
                    }
                } else if (classOptions.isDerivedClasses && !JavaFindUsagesHelper.addInheritors(psiClass, classOptions, processor)) {
                    return false;
                }
            }
        }
        if (options instanceof JavaMethodFindUsagesOptions) {
            JavaMethodFindUsagesOptions methodOptions = (JavaMethodFindUsagesOptions)options;
            PsiMethod psiMethod = (PsiMethod)element;
            boolean isAbstract2 = (Boolean)ReadAction.compute(() -> psiMethod.hasModifierProperty("abstract"));
            if (isAbstract2 ? methodOptions.isImplementingMethods : methodOptions.isOverridingMethods) {
                if (!JavaFindUsagesHelper.processOverridingMethods(psiMethod, processor, methodOptions)) {
                    return false;
                }
                FunctionalExpressionSearch.search((PsiMethod)psiMethod, (SearchScope)methodOptions.searchScope).forEach((Processor)new PsiElementProcessorAdapter(expression -> JavaFindUsagesHelper.addResult(expression, options, processor)));
            }
            if (((Boolean)ReadAction.compute(() -> ImplicitToStringSearch.isToStringMethod((PsiElement)psiMethod))).booleanValue() && methodOptions.isImplicitToString) {
                ImplicitToStringSearch.search((PsiMethod)psiMethod, (SearchScope)methodOptions.searchScope).forEach((Processor)new PsiElementProcessorAdapter(ref -> JavaFindUsagesHelper.addResult(ref, options, processor)));
            }
        }
        if (element instanceof PomTarget && !JavaFindUsagesHelper.addAliasingUsages(pomTarget = (PomTarget)element, options, processor)) {
            return false;
        }
        Boolean isSearchable = (Boolean)ReadAction.compute(() -> ThrowSearchUtil.isSearchable(element));
        if (!isSearchable.booleanValue() && options.isSearchForTextOccurrences && (isAbstract2 = options.searchScope) instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)isAbstract2;
            Collection stringsToSearch = (Collection)ReadAction.compute(() -> JavaFindUsagesHelper.getElementNames(element));
            return FindUsagesHelper.processUsagesInText((PsiElement)element, (Collection)stringsToSearch, (boolean)false, (GlobalSearchScope)globalSearchScope, processor);
        }
        return true;
    }

    private static boolean addAliasingUsages(@NotNull PomTarget pomTarget, final @NotNull FindUsagesOptions options, final @NotNull Processor<? super UsageInfo> processor) {
        if (pomTarget == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(5);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(7);
        }
        for (AliasingPsiTargetMapper aliasingPsiTargetMapper : AliasingPsiTargetMapper.EP_NAME.getExtensionList()) {
            for (AliasingPsiTarget psiTarget : aliasingPsiTargetMapper.getTargets(pomTarget)) {
                PsiElement element = (PsiElement)ReadAction.compute(() -> PomService.convertToPsi((PsiTarget)psiTarget));
                boolean success = ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters(element, options.searchScope, false, options.fastTrack)).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                    public boolean processInReadAction(PsiReference reference) {
                        return JavaFindUsagesHelper.addResult(reference, options, (Processor<? super UsageInfo>)processor);
                    }
                });
                if (success) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processOverridingMethods(@NotNull PsiMethod psiMethod, @NotNull Processor<? super UsageInfo> processor, @NotNull JavaMethodFindUsagesOptions options) {
        if (psiMethod == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(9);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(10);
        }
        return OverridingMethodsSearch.search((PsiMethod)psiMethod, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter(element -> JavaFindUsagesHelper.addResult(element.getNavigationElement(), (FindUsagesOptions)options, processor)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addClassesUsages(@NotNull PsiPackage aPackage, final @NotNull JavaPackageFindUsagesOptions options, final @NotNull Processor<? super UsageInfo> processor) {
        ProgressIndicator progress;
        if (aPackage == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(11);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(13);
        }
        if ((progress = ProgressManager.getInstance().getProgressIndicator()) != null) {
            progress.pushState();
        }
        try {
            ArrayList classes = new ArrayList();
            JavaFindUsagesHelper.addClassesInPackage(aPackage, options.isIncludeSubpackages, classes);
            for (PsiClass aClass : classes) {
                if (progress != null) {
                    String name = (String)ReadAction.compute(() -> aClass.getName());
                    progress.setText(JavaAnalysisBundle.message((String)"find.searching.for.references.to.class.progress", (Object[])new Object[]{name}));
                }
                ProgressManager.checkCanceled();
                boolean success = ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters((PsiElement)aClass, options.searchScope, false, options.fastTrack)).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                    public boolean processInReadAction(PsiReference psiReference) {
                        return JavaFindUsagesHelper.addResult(psiReference, (FindUsagesOptions)options, (Processor<? super UsageInfo>)processor);
                    }
                });
                if (success) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
        return true;
    }

    private static void addClassesInPackage(@NotNull PsiPackage aPackage, boolean includeSubpackages, @NotNull List<? super PsiClass> array) {
        if (aPackage == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(14);
        }
        if (array == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(15);
        }
        for (PsiDirectory dir : (PsiDirectory[])ReadAction.compute(() -> aPackage.getDirectories())) {
            JavaFindUsagesHelper.addClassesInDirectory(dir, includeSubpackages, array);
        }
    }

    private static void addClassesInDirectory(@NotNull PsiDirectory dir, boolean includeSubdirs, @NotNull List<? super PsiClass> array) {
        if (dir == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(16);
        }
        if (array == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            ContainerUtil.addAll((Collection)array, (Object[])JavaDirectoryService.getInstance().getClasses(dir));
            if (includeSubdirs) {
                for (PsiDirectory directory : dir.getSubdirectories()) {
                    JavaFindUsagesHelper.addClassesInDirectory(directory, true, array);
                }
            }
        });
    }

    private static boolean addMethodUsages(@NotNull PsiClass aClass, @NotNull PsiManager manager, @NotNull JavaClassFindUsagesOptions options, @NotNull Processor<? super UsageInfo> processor) {
        if (aClass == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(18);
        }
        if (manager == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(19);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(21);
        }
        if (options.isIncludeInherited) {
            PsiMethod[] methods = (PsiMethod[])ReadAction.compute(() -> aClass.getAllMethods());
            for (int i = 0; i < methods.length; ++i) {
                MethodReferencesSearch.SearchParameters parameters;
                boolean success;
                boolean equivalent;
                int finalI;
                PsiClass methodClass;
                boolean include;
                PsiMethod method = methods[i];
                boolean bl = include = (Boolean)ReadAction.compute(() -> method.isConstructor()) != false ? options.isConstructorUsages : options.isMethodsUsages;
                if (!include || (methodClass = (PsiClass)ReadAction.compute(() -> JavaFindUsagesHelper.lambda$addMethodUsages$20(method, finalI = i, methods))) == null || !((equivalent = ((Boolean)ReadAction.compute(() -> manager.areElementsEquivalent((PsiElement)methodClass, (PsiElement)aClass))).booleanValue()) ? !JavaFindUsagesHelper.addElementUsages((PsiElement)method, (FindUsagesOptions)options, processor) : !(success = MethodReferencesSearch.search((MethodReferencesSearch.SearchParameters)(parameters = new MethodReferencesSearch.SearchParameters(method, options.searchScope, true, options.fastTrack))).forEach((Processor)new PsiReferenceProcessorAdapter(reference -> {
                    JavaFindUsagesHelper.addResultFromReference(reference, methodClass, manager, aClass, (FindUsagesOptions)options, processor);
                    return true;
                }))))) continue;
                return false;
            }
        } else {
            PsiMethod defaultConstructor;
            for (PsiMethod method : (PsiMethod[])ReadAction.compute(() -> aClass.getMethods())) {
                boolean include;
                boolean bl = include = (Boolean)ReadAction.compute(() -> method.isConstructor()) != false ? options.isConstructorUsages : options.isMethodsUsages;
                if (!include || JavaFindUsagesHelper.addElementUsages((PsiElement)method, (FindUsagesOptions)options, processor)) continue;
                return false;
            }
            if (!options.isUsages && options.isConstructorUsages && (defaultConstructor = (PsiMethod)ReadAction.compute(() -> LightDefaultConstructor.create((PsiClass)aClass))) != null && !JavaFindUsagesHelper.addElementUsages((PsiElement)defaultConstructor, (FindUsagesOptions)options, processor)) {
                return false;
            }
        }
        return true;
    }

    private static boolean addFieldsUsages(final @NotNull PsiClass aClass, final @NotNull PsiManager manager, final @NotNull JavaClassFindUsagesOptions options, final @NotNull Processor<? super UsageInfo> processor) {
        if (aClass == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(22);
        }
        if (manager == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(23);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(24);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(25);
        }
        if (options.isIncludeInherited) {
            PsiField[] fields = (PsiField[])ReadAction.compute(() -> aClass.getAllFields());
            for (int i = 0; i < fields.length; ++i) {
                boolean success;
                boolean equivalent;
                int finalI = i;
                PsiField field = fields[i];
                final PsiClass fieldClass = (PsiClass)ReadAction.compute(() -> {
                    for (int j = 0; j < finalI; ++j) {
                        if (!Comparing.strEqual((String)field.getName(), (String)fields[j].getName())) continue;
                        return null;
                    }
                    return field.getContainingClass();
                });
                if (fieldClass == null || !((equivalent = ((Boolean)ReadAction.compute(() -> manager.areElementsEquivalent((PsiElement)fieldClass, (PsiElement)aClass))).booleanValue()) ? !JavaFindUsagesHelper.addElementUsages((PsiElement)fields[i], (FindUsagesOptions)options, processor) : !(success = ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters((PsiElement)field, options.searchScope, false, options.fastTrack)).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                    public boolean processInReadAction(PsiReference reference) {
                        return JavaFindUsagesHelper.addResultFromReference(reference, fieldClass, manager, aClass, (FindUsagesOptions)options, (Processor<? super UsageInfo>)processor);
                    }
                })))) continue;
                return false;
            }
        } else {
            for (PsiField field : (PsiField[])ReadAction.compute(() -> aClass.getFields())) {
                if (JavaFindUsagesHelper.addElementUsages((PsiElement)field, (FindUsagesOptions)options, processor)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static PsiClass getFieldOrMethodAccessedClass(@NotNull PsiReferenceExpression ref, @NotNull PsiClass fieldOrMethodClass) {
        PsiElement psiElement;
        PsiElement[] children;
        if (ref == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(26);
        }
        if (fieldOrMethodClass == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(27);
        }
        if ((children = ref.getChildren()).length > 1 && (psiElement = children[0]) instanceof PsiExpression) {
            PsiReferenceExpression referenceExpression;
            PsiElement psiElement2;
            PsiExpression expr = (PsiExpression)psiElement;
            PsiType type = expr.getType();
            if (type != null) {
                if (type instanceof PsiClassType) {
                    PsiClassType classType = (PsiClassType)type;
                    return classType.resolve();
                }
            } else if (expr instanceof PsiReferenceExpression && (psiElement2 = (referenceExpression = (PsiReferenceExpression)expr).resolve()) instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)psiElement2;
                return psiClass;
            }
            return null;
        }
        PsiManager manager = ref.getManager();
        for (PsiReferenceExpression parent = ref; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PsiClass)) continue;
            PsiClass psiClass = (PsiClass)parent;
            if (!manager.areElementsEquivalent((PsiElement)parent, (PsiElement)fieldOrMethodClass) && !psiClass.isInheritor(fieldOrMethodClass, true)) continue;
            return psiClass;
        }
        return null;
    }

    private static boolean addInheritors(@NotNull PsiClass aClass, @NotNull JavaClassFindUsagesOptions options, @NotNull Processor<? super UsageInfo> processor) {
        if (aClass == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(28);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(30);
        }
        return ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter(element -> JavaFindUsagesHelper.addResult(element, (FindUsagesOptions)options, processor)));
    }

    private static boolean addDerivedInterfaces(@NotNull PsiClass anInterface, @NotNull JavaClassFindUsagesOptions options, @NotNull Processor<? super UsageInfo> processor) {
        if (anInterface == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(31);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(32);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(33);
        }
        return ClassInheritorsSearch.search((PsiClass)anInterface, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter(inheritor -> !inheritor.isInterface() || JavaFindUsagesHelper.addResult(inheritor, (FindUsagesOptions)options, processor)));
    }

    private static boolean addImplementingClasses(@NotNull PsiClass anInterface, @NotNull JavaClassFindUsagesOptions options, @NotNull Processor<? super UsageInfo> processor) {
        if (anInterface == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(34);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(35);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(36);
        }
        return ClassInheritorsSearch.search((PsiClass)anInterface, (SearchScope)options.searchScope, (boolean)options.isCheckDeepInheritance).forEach((Processor)new PsiElementProcessorAdapter(inheritor -> inheritor.isInterface() || JavaFindUsagesHelper.addResult(inheritor, (FindUsagesOptions)options, processor)));
    }

    private static boolean addResultFromReference(@NotNull PsiReference reference, @NotNull PsiClass methodClass, @NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull FindUsagesOptions options, @NotNull Processor<? super UsageInfo> processor) {
        PsiReferenceExpression referenceExpression;
        PsiClass usedClass;
        PsiElement refElement;
        if (reference == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(37);
        }
        if (methodClass == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(38);
        }
        if (manager == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(39);
        }
        if (aClass == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(40);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(41);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(42);
        }
        if ((refElement = reference.getElement()) instanceof PsiReferenceExpression && (usedClass = JavaFindUsagesHelper.getFieldOrMethodAccessedClass(referenceExpression = (PsiReferenceExpression)refElement, methodClass)) != null && (manager.areElementsEquivalent((PsiElement)usedClass, (PsiElement)aClass) || usedClass.isInheritor(aClass, true))) {
            return JavaFindUsagesHelper.addResult(refElement, options, processor);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean addElementUsages(@NotNull PsiElement element, final @NotNull FindUsagesOptions options, final @NotNull Processor<? super UsageInfo> processor) {
        block9: {
            block7: {
                block8: {
                    if (element == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(43);
                    }
                    if (options == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(44);
                    }
                    if (processor == null) {
                        JavaFindUsagesHelper.$$$reportNull$$$0(45);
                    }
                    searchScope = options.searchScope;
                    parentClass = new PsiClass[1];
                    if (!(element instanceof PsiMethod)) break block7;
                    psiMethod = (PsiMethod)element;
                    if (!((Boolean)ReadAction.compute((ThrowableComputable)(ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$addElementUsages$33(com.intellij.psi.PsiElement com.intellij.psi.PsiClass[] ), ()Ljava/lang/Boolean;)((PsiElement)element, (PsiClass[])parentClass))).booleanValue()) break block7;
                    if (parentClass[0] == null) break block8;
                    if (!(options instanceof JavaMethodFindUsagesOptions)) ** GOTO lbl-1000
                    javaOptions = (JavaMethodFindUsagesOptions)options;
                    if (!javaOptions.isIncludeOverloadUsages) lbl-1000:
                    // 2 sources

                    {
                        v0 = true;
                    } else {
                        v0 = false;
                    }
                    strictSignatureSearch = v0;
                    return MethodReferencesSearch.search((MethodReferencesSearch.SearchParameters)new MethodReferencesSearch.SearchParameters(psiMethod, searchScope, strictSignatureSearch, options.fastTrack)).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                        public boolean processInReadAction(PsiReference ref) {
                            return JavaFindUsagesHelper.addResult(ref, options, (Processor<? super UsageInfo>)processor);
                        }
                    });
                }
                return true;
            }
            consumer = new ReadActionProcessor<PsiReference>(){

                public boolean processInReadAction(PsiReference ref) {
                    return JavaFindUsagesHelper.addResult(ref, options, (Processor<? super UsageInfo>)processor);
                }
            };
            if (!(element instanceof PsiMethod)) break block9;
            psiMethod = (PsiMethod)element;
            if (!(options instanceof JavaMethodFindUsagesOptions)) ** GOTO lbl-1000
            javaOptions = (JavaMethodFindUsagesOptions)options;
            if (!javaOptions.isIncludeOverloadUsages) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            strictSignatureSearch = v1;
            return MethodReferencesSearch.search((MethodReferencesSearch.SearchParameters)new MethodReferencesSearch.SearchParameters(psiMethod, searchScope, strictSignatureSearch, options.fastTrack)).forEach((Processor)consumer);
        }
        return ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters(element, searchScope, false, options.fastTrack)).forEach((Processor)consumer);
    }

    private static boolean addResult(@NotNull PsiElement element, @NotNull FindUsagesOptions options, @NotNull Processor<? super UsageInfo> processor) {
        if (element == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(46);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(47);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(48);
        }
        return !JavaFindUsagesHelper.acceptUsage(element, options) || processor.process((Object)new UsageInfo(element));
    }

    private static boolean addResult(@NotNull PsiReference ref, @NotNull FindUsagesOptions options, @NotNull Processor<? super UsageInfo> processor) {
        if (ref == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(49);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(50);
        }
        if (processor == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(51);
        }
        return !JavaFindUsagesHelper.acceptUsage(ref.getElement(), options) || processor.process((Object)new UsageInfo(ref.getElement(), ref.getRangeInElement(), false));
    }

    private static boolean acceptUsage(@NotNull PsiElement usage, @NotNull FindUsagesOptions options) {
        JavaFindUsagesOptions javaOptions;
        if (usage == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(52);
        }
        if (options == null) {
            JavaFindUsagesHelper.$$$reportNull$$$0(53);
        }
        if (!(usage instanceof PsiJavaCodeReferenceElement)) {
            return true;
        }
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)usage;
        if (options instanceof JavaPackageFindUsagesOptions) {
            PsiJavaCodeReferenceElement parentReference;
            PsiElement psiElement;
            javaOptions = (JavaPackageFindUsagesOptions)options;
            if (!javaOptions.isIncludeSubpackages && referenceElement.resolve() instanceof PsiPackage && (psiElement = usage.getParent()) instanceof PsiJavaCodeReferenceElement && (parentReference = (PsiJavaCodeReferenceElement)psiElement).resolve() instanceof PsiPackage) {
                return false;
            }
        }
        if (!(usage instanceof PsiReferenceExpression)) {
            PsiElement parent;
            if (options instanceof JavaFindUsagesOptions) {
                javaOptions = (JavaFindUsagesOptions)options;
                if (javaOptions.isSkipImportStatements) {
                    parent = usage.getParent();
                    while (parent instanceof PsiJavaCodeReferenceElement) {
                        parent = parent.getParent();
                    }
                    if (parent instanceof PsiImportStatement) {
                        return false;
                    }
                }
            }
            if (options instanceof JavaPackageFindUsagesOptions) {
                JavaPackageFindUsagesOptions packageOptions = (JavaPackageFindUsagesOptions)options;
                if (packageOptions.isSkipPackageStatements) {
                    parent = usage.getParent();
                    while (parent instanceof PsiJavaCodeReferenceElement) {
                        parent = parent.getParent();
                    }
                    return !(parent instanceof PsiPackageStatement);
                }
            }
        }
        return true;
    }

    private static /* synthetic */ Boolean lambda$addElementUsages$33(PsiElement element, PsiClass[] parentClass) throws RuntimeException {
        PsiMethod method = (PsiMethod)element;
        parentClass[0] = method.getContainingClass();
        return method.isConstructor();
    }

    private static /* synthetic */ PsiClass lambda$addMethodUsages$20(PsiMethod method, int finalI, PsiMethod[] methods) throws RuntimeException {
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        for (int j = 0; j < finalI; ++j) {
            if (!methodSignature.equals((Object)methods[j].getSignature(PsiSubstitutor.EMPTY))) continue;
            return null;
        }
        return method.getContainingClass();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/JavaFindUsagesHelper";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: 
            case 20: 
            case 24: 
            case 29: 
            case 32: 
            case 35: 
            case 41: 
            case 44: 
            case 47: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 21: 
            case 25: 
            case 30: 
            case 33: 
            case 36: 
            case 42: 
            case 45: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomTarget";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 18: 
            case 22: 
            case 28: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 19: 
            case 23: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 26: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldOrMethodClass";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodClass";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/JavaFindUsagesHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementNames";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processElementUsages";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAliasingUsages";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processOverridingMethods";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addClassesUsages";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addClassesInPackage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addClassesInDirectory";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addMethodUsages";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addFieldsUsages";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFieldOrMethodAccessedClass";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addInheritors";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addDerivedInterfaces";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addImplementingClasses";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addResultFromReference";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addElementUsages";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addResult";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "acceptUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

