/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.analysis.impl.bytecode;

import com.intellij.java.analysis.impl.bytecode.ClassFileEntry;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001aD\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032'\u0010\u0004\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u0002H\u00010\u0005H\u0000\u00a2\u0006\u0002\u0010\u000b\u001a>\u0010\f\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\r\u0012\u0004\u0012\u0002H\u00010\u0005H\u0000\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\u000e"}, d2={"withClassRootEntries", "R", "classRoot", "Ljava/nio/file/Path;", "block", "Lkotlin/Function1;", "Lkotlin/sequences/Sequence;", "Lcom/intellij/java/analysis/impl/bytecode/ClassFileEntry;", "Lkotlin/ParameterName;", "name", "entries", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withClassRoot", "root", "intellij.java.analysis.impl"})
public final class ClassFileAnalyzerImplKt {
    public static final <R> R withClassRootEntries(@NotNull Path classRoot, @NotNull Function1<? super Sequence<ClassFileEntry>, ? extends R> block) {
        Intrinsics.checkNotNullParameter((Object)classRoot, (String)"classRoot");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return ClassFileAnalyzerImplKt.withClassRoot(classRoot, arg_0 -> ClassFileAnalyzerImplKt.withClassRootEntries$lambda$0(block, classRoot, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <R> R withClassRoot(@NotNull Path classRoot, @NotNull Function1<? super Path, ? extends R> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)classRoot, (String)"classRoot");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(classRoot, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            object = block.invoke((Object)classRoot);
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isRegularFile(classRoot, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && Intrinsics.areEqual((Object)PathsKt.getExtension((Path)classRoot), (Object)"jar")) {
                Closeable closeable = FileSystems.newFileSystem(classRoot);
                Throwable throwable = null;
                try {
                    FileSystem it = (FileSystem)closeable;
                    boolean bl = false;
                    Iterable<Path> iterable = it.getRootDirectories();
                    Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                    Object object2 = CollectionsKt.single(iterable);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"single(...)");
                    Object object3 = block.invoke(object2);
                    object = object3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                throw new IllegalStateException(("Unsupported classes output root: " + classRoot).toString());
            }
        }
        return (R)object;
    }

    private static final boolean withClassRootEntries$lambda$0$0(Path $classRoot, Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Intrinsics.areEqual((Object)PathsKt.getExtension((Path)path), (Object)"class") && !$classRoot.relativize(path).startsWith("META-INF/");
    }

    private static final ClassFileEntry withClassRootEntries$lambda$0$1(Path $nioRoot, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ClassFileEntry(PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)it, (Path)$nioRoot)), it);
    }

    private static final Object withClassRootEntries$lambda$0(Function1 $block, Path $classRoot, Path nioRoot) {
        Intrinsics.checkNotNullParameter((Object)nioRoot, (String)"nioRoot");
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)PathsKt.walk((Path)nioRoot, (PathWalkOption[])new PathWalkOption[0]), arg_0 -> ClassFileAnalyzerImplKt.withClassRootEntries$lambda$0$0($classRoot, arg_0)), arg_0 -> ClassFileAnalyzerImplKt.withClassRootEntries$lambda$0$1(nioRoot, arg_0));
        return $block.invoke((Object)sequence);
    }
}

