/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PackagePrefixIndex;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class PackagePrefixElementFinder
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;
    private final PackagePrefixIndex myPackagePrefixIndex;

    public PackagePrefixElementFinder(Project project) {
        this.myProject = project;
        this.myPackagePrefixIndex = new PackagePrefixIndex(project);
    }

    @NotNull
    public static PackagePrefixElementFinder getInstance(@NotNull Project project) {
        if (project == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(0);
        }
        PackagePrefixElementFinder packagePrefixElementFinder = (PackagePrefixElementFinder)((Object)PsiElementFinder.EP.findExtensionOrFail(PackagePrefixElementFinder.class, (AreaInstance)project));
        if (packagePrefixElementFinder == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(1);
        }
        return packagePrefixElementFinder;
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(3);
        }
        return null;
    }

    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(5);
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(6);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(7);
        }
        if (this.packagePrefixExists(qualifiedName)) {
            return new PsiPackageImpl(PsiManager.getInstance((Project)this.myProject), qualifiedName);
        }
        return null;
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(9);
        }
        HashMap<String, PsiPackageImpl> packagesMap = new HashMap<String, PsiPackageImpl>();
        String qualifiedName = psiPackage.getQualifiedName();
        for (String prefix : this.myPackagePrefixIndex.getAllPackagePrefixes(scope)) {
            int i;
            String childName;
            if (!StringUtil.isEmpty((String)qualifiedName) && !StringUtil.startsWithConcatenation((String)prefix, (String[])new String[]{qualifiedName, "."}) || packagesMap.containsKey(childName = (i = prefix.indexOf(46, qualifiedName.length() + 1)) >= 0 ? prefix.substring(0, i) : prefix)) continue;
            packagesMap.put(childName, new PsiPackageImpl(psiPackage.getManager(), childName));
        }
        packagesMap.remove(qualifiedName);
        PsiPackage[] psiPackageArray = packagesMap.values().toArray(PsiPackage.EMPTY_ARRAY);
        if (psiPackageArray == null) {
            PackagePrefixElementFinder.$$$reportNull$$$0(10);
        }
        return psiPackageArray;
    }

    @Contract(pure=true)
    public boolean packagePrefixExists(String packageQName) {
        for (String prefix : this.myPackagePrefixIndex.getAllPackagePrefixes(null)) {
            if (!StringUtil.startsWithConcatenation((String)prefix, (String[])new String[]{packageQName, "."}) && !prefix.equals(packageQName)) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getAllPackagePrefixes(GlobalSearchScope scope) {
        return this.myPackagePrefixIndex.getAllPackagePrefixes(scope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PackagePrefixElementFinder";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PackagePrefixElementFinder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 10 -> new IllegalStateException(string);
        };
    }
}

