/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParametersFolder {
    private final Map<PsiVariable, PsiExpression> myExpressions = new HashMap<PsiVariable, PsiExpression>();
    private final Map<PsiVariable, String> myArgs = new HashMap<PsiVariable, String>();
    private final Map<PsiVariable, List<PsiExpression>> myMentionedInExpressions = new HashMap<PsiVariable, List<PsiExpression>>();
    private final Set<PsiVariable> myDeleted = new HashSet<PsiVariable>();
    private boolean myFoldingSelectedByDefault;

    void clear() {
        this.myExpressions.clear();
        this.myMentionedInExpressions.clear();
        this.myDeleted.clear();
    }

    boolean isParameterSafeToDelete(@NotNull VariableData data, @NotNull LocalSearchScope scope) {
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(1);
        }
        block0: for (PsiReference reference : ReferencesSearch.search((PsiElement)data.variable, (SearchScope)scope).asIterable()) {
            PsiElement expression = reference.getElement();
            while (expression != null) {
                for (PsiExpression psiExpression : this.myExpressions.values()) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expression, (PsiElement)psiExpression)) continue;
                    continue block0;
                }
                expression = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiExpression.class);
            }
            return false;
        }
        PsiExpression psiExpression = this.myExpressions.get(data.variable);
        if (psiExpression == null) {
            return true;
        }
        for (PsiVariable variable : this.myExpressions.keySet()) {
            PsiExpression expr;
            if (variable == data.variable || this.myDeleted.contains(variable) || (expr = this.myExpressions.get(variable)) == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expr, (PsiElement)psiExpression)) continue;
            this.myDeleted.add(data.variable);
            return true;
        }
        return false;
    }

    void foldParameterUsagesInBody(@NotNull List<? extends VariableData> datum, PsiElement @NotNull [] elements, @NotNull SearchScope scope) {
        if (datum == null) {
            ParametersFolder.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            ParametersFolder.$$$reportNull$$$0(4);
        }
        LinkedHashMap equivalentExpressions = new LinkedHashMap();
        for (VariableData variableData : datum) {
            PsiExpression psiExpression;
            if (this.myDeleted.contains(variableData.variable) || (psiExpression = this.myExpressions.get(variableData.variable)) == null) continue;
            HashSet<PsiExpression> eqExpressions = new HashSet<PsiExpression>();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)variableData.variable, (SearchScope)scope).asIterable()) {
                PsiExpression expression = ParametersFolder.findEquivalent(psiExpression, reference.getElement());
                if (expression == null || !expression.isValid()) continue;
                eqExpressions.add(expression);
            }
            equivalentExpressions.put(variableData, eqExpressions);
        }
        for (VariableData variableData : equivalentExpressions.keySet()) {
            Set eqExpressions = (Set)equivalentExpressions.get((Object)variableData);
            block3: for (PsiExpression expression : eqExpressions) {
                if (!expression.isValid()) continue;
                PsiExpression refExpression = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(variableData.name, (PsiElement)expression);
                PsiElement replaced = expression.replace((PsiElement)refExpression);
                for (PsiElement psiElement : elements) {
                    if (expression != psiElement) continue;
                    elements[i] = replaced;
                    continue block3;
                }
            }
        }
    }

    boolean isParameterFoldable(@NotNull VariableData data, @NotNull LocalSearchScope scope, @NotNull List<? extends PsiVariable> inputVariables, @NotNull UniqueNameGenerator nameGenerator, @NotNull String defaultName) {
        List<PsiExpression> mentionedInExpressions;
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(6);
        }
        if (inputVariables == null) {
            ParametersFolder.$$$reportNull$$$0(7);
        }
        if (nameGenerator == null) {
            ParametersFolder.$$$reportNull$$$0(8);
        }
        if (defaultName == null) {
            ParametersFolder.$$$reportNull$$$0(9);
        }
        if ((mentionedInExpressions = this.getMentionedExpressions(data.variable, scope, inputVariables)) == null) {
            return false;
        }
        int currentRank = 0;
        PsiExpression mostRanked = null;
        for (PsiExpression expression : mentionedInExpressions.reversed()) {
            int r = ParametersFolder.findUsedVariables(data, inputVariables, expression).size();
            if (currentRank >= r && (!(expression instanceof PsiArrayAccessExpression) || !this.myFoldingSelectedByDefault || currentRank != r)) continue;
            currentRank = r;
            mostRanked = expression;
        }
        if (mostRanked != null) {
            this.myExpressions.put(data.variable, mostRanked);
            this.myArgs.put(data.variable, mostRanked.getText());
            data.type = RefactoringChangeUtil.getTypeByExpression((PsiExpression)mostRanked);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)mostRanked.getProject());
            SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, mostRanked, data.type);
            if (nameInfo.names.length > 0 && !Objects.equals(nameInfo.names[0], data.name) && !Objects.equals(nameInfo.names[0], defaultName)) {
                data.name = nameInfo.names[0];
                ParametersFolder.setUniqueName(data, nameGenerator, mostRanked, codeStyleManager);
            }
        }
        return mostRanked != null;
    }

    private static void setUniqueName(@NotNull VariableData data, @NotNull UniqueNameGenerator nameGenerator, @NotNull PsiExpression expr, @NotNull JavaCodeStyleManager codeStyleManager) {
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(10);
        }
        if (nameGenerator == null) {
            ParametersFolder.$$$reportNull$$$0(11);
        }
        if (expr == null) {
            ParametersFolder.$$$reportNull$$$0(12);
        }
        if (codeStyleManager == null) {
            ParametersFolder.$$$reportNull$$$0(13);
        }
        Object name = data.name;
        int idx = 1;
        while (true) {
            if (nameGenerator.isUnique((String)name, "", "") && ((String)name).equals(codeStyleManager.suggestUniqueVariableName((String)name, (PsiElement)expr, true))) break;
            name = data.name + idx++;
        }
        data.name = name;
        nameGenerator.addExistingName((String)name);
    }

    @NotNull
    private static Set<PsiVariable> findUsedVariables(@NotNull VariableData data, final @NotNull List<? extends PsiVariable> inputVariables, @NotNull PsiExpression expression) {
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(14);
        }
        if (inputVariables == null) {
            ParametersFolder.$$$reportNull$$$0(15);
        }
        if (expression == null) {
            ParametersFolder.$$$reportNull$$$0(16);
        }
        final HashSet<PsiVariable> found = new HashSet<PsiVariable>();
        expression.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(referenceExpression);
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiVariable && inputVariables.contains(resolved)) {
                    found.add((PsiVariable)resolved);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/refactoring/extractMethod/ParametersFolder$1", "visitReferenceExpression"));
            }
        });
        found.remove(data.variable);
        HashSet<PsiVariable> hashSet = found;
        if (hashSet == null) {
            ParametersFolder.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    boolean isFoldable() {
        return !this.myExpressions.isEmpty();
    }

    @Nullable
    private List<PsiExpression> getMentionedExpressions(@NotNull PsiVariable var, @NotNull LocalSearchScope scope, @NotNull List<? extends PsiVariable> inputVariables) {
        if (var == null) {
            ParametersFolder.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(19);
        }
        if (inputVariables == null) {
            ParametersFolder.$$$reportNull$$$0(20);
        }
        if (this.myMentionedInExpressions.containsKey(var)) {
            return this.myMentionedInExpressions.get(var);
        }
        PsiElement[] scopeElements = scope.getScope();
        ArrayList<PsiExpression> expressions = null;
        Boolean arrayAccess = null;
        List<PsiElement> refExpressions = ReferencesSearch.search((PsiElement)var, (SearchScope)scope).findAll().stream().map(ref -> ref.getElement()).sorted(Comparator.comparingInt(element -> element.getTextRange().getStartOffset())).toList();
        block0: for (PsiElement expression : refExpressions) {
            if (expressions == null) {
                expressions = new ArrayList<PsiExpression>();
                while (expression instanceof PsiExpression) {
                    PsiType expressionType;
                    PsiElement parent;
                    if (ParametersFolder.isAccessedForWriting((PsiExpression)expression)) {
                        return null;
                    }
                    if (ParametersFolder.isAncestor(expression, scopeElements) || ParametersFolder.dependsOnLocals(expression, inputVariables) || (parent = expression.getParent()) instanceof PsiExpressionStatement || (expressionType = ((PsiExpression)expression).getType()) == null || PsiTypes.voidType().equals((Object)expressionType) || ParametersFolder.isTooLongExpressionChain(expression)) continue block0;
                    if (!ParametersFolder.isMethodNameExpression(expression)) {
                        expressions.add((PsiExpression)expression);
                    }
                    if (expression instanceof PsiArrayAccessExpression && (arrayAccess == null || arrayAccess.booleanValue())) {
                        arrayAccess = ParametersFolder.isSafeToFoldArrayAccess(scope, expression);
                    }
                    expression = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiExpression.class);
                }
                continue;
            }
            Iterator iterator = expressions.iterator();
            while (iterator.hasNext()) {
                PsiExpression equivalent = ParametersFolder.findEquivalent((PsiExpression)iterator.next(), expression);
                if (equivalent == null) {
                    iterator.remove();
                    continue;
                }
                if (!(equivalent instanceof PsiArrayAccessExpression) || arrayAccess != null && !arrayAccess.booleanValue()) continue;
                arrayAccess = ParametersFolder.isSafeToFoldArrayAccess(scope, (PsiElement)equivalent);
            }
        }
        if (arrayAccess != null && arrayAccess.booleanValue()) {
            this.myFoldingSelectedByDefault = true;
        }
        this.myMentionedInExpressions.put(var, expressions);
        return expressions;
    }

    public static boolean isSafeToFoldArrayAccess(@NotNull LocalSearchScope scope, PsiElement expression) {
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(21);
        }
        while (true) {
            PsiElement parent;
            if ((parent = expression.getParent()) != null && scope.containsRange(parent.getContainingFile(), parent.getTextRange())) {
                if (parent instanceof PsiIfStatement || parent instanceof PsiConditionalExpression || parent instanceof PsiSwitchStatement) {
                    return false;
                }
            } else {
                return true;
            }
            expression = parent;
        }
    }

    private static boolean isAccessedForWriting(@NotNull PsiExpression expression) {
        if (expression == null) {
            ParametersFolder.$$$reportNull$$$0(22);
        }
        final PsiExpression[] exprWithWriteAccessInside = new PsiExpression[1];
        expression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (exprWithWriteAccessInside[0] != null) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitExpression(@NotNull PsiExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
                    exprWithWriteAccessInside[0] = expression;
                }
                super.visitExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ParametersFolder$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return exprWithWriteAccessInside[0] != null;
    }

    private static boolean isAncestor(@NotNull PsiElement expression, PsiElement @NotNull [] scopeElements) {
        if (expression == null) {
            ParametersFolder.$$$reportNull$$$0(23);
        }
        if (scopeElements == null) {
            ParametersFolder.$$$reportNull$$$0(24);
        }
        for (PsiElement scopeElement : scopeElements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)scopeElement, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTooLongExpressionChain(@NotNull PsiElement expression) {
        if (expression == null) {
            ParametersFolder.$$$reportNull$$$0(25);
        }
        int count = 0;
        PsiElement element = ParametersFolder.getInnerExpression(expression);
        while (element != null) {
            if (++count > 1) {
                return true;
            }
            element = ParametersFolder.getInnerExpression(element);
        }
        return false;
    }

    private static PsiElement getInnerExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            ParametersFolder.$$$reportNull$$$0(26);
        }
        if (expression instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression();
        }
        if (expression instanceof PsiArrayAccessExpression) {
            while (expression instanceof PsiArrayAccessExpression) {
                expression = ((PsiArrayAccessExpression)expression).getArrayExpression();
            }
            return expression;
        }
        return null;
    }

    private static boolean isMethodNameExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            ParametersFolder.$$$reportNull$$$0(27);
        }
        PsiElement parent = expression.getParent();
        return expression instanceof PsiReferenceExpression && parent instanceof PsiMethodCallExpression && ((PsiReferenceExpression)expression).getReferenceNameElement() == ((PsiMethodCallExpression)parent).getMethodExpression().getReferenceNameElement();
    }

    private static boolean dependsOnLocals(@NotNull PsiElement expression, final @NotNull List<? extends PsiVariable> inputVariables) {
        if (expression == null) {
            ParametersFolder.$$$reportNull$$$0(28);
        }
        if (inputVariables == null) {
            ParametersFolder.$$$reportNull$$$0(29);
        }
        final boolean[] localVarsUsed = new boolean[]{false};
        expression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                PsiVariable variable;
                PsiElement resolved;
                if (expression == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((resolved = expression.resolve()) instanceof PsiVariable && !((variable = (PsiVariable)resolved) instanceof PsiField) && !inputVariables.contains(variable)) {
                    localVarsUsed[0] = true;
                    return;
                }
                super.visitReferenceExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/extractMethod/ParametersFolder$3", "visitReferenceExpression"));
            }
        });
        return localVarsUsed[0];
    }

    @NotNull
    String getGeneratedCallArgument(@NotNull VariableData data) {
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(30);
        }
        String string = this.myArgs.containsKey(data.variable) ? this.myArgs.get(data.variable) : data.variable.getName();
        if (string == null) {
            ParametersFolder.$$$reportNull$$$0(31);
        }
        return string;
    }

    void putCallArgument(@NotNull PsiVariable argument, @NotNull PsiExpression value) {
        if (argument == null) {
            ParametersFolder.$$$reportNull$$$0(32);
        }
        if (value == null) {
            ParametersFolder.$$$reportNull$$$0(33);
        }
        this.myArgs.put(argument, value.getText());
    }

    boolean annotateWithParameter(@NotNull VariableData data, @NotNull PsiElement element) {
        PsiExpression expression;
        PsiExpression psiExpression;
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(34);
        }
        if (element == null) {
            ParametersFolder.$$$reportNull$$$0(35);
        }
        if ((psiExpression = this.myExpressions.get(data.variable)) != null && (expression = ParametersFolder.findEquivalent(psiExpression, element)) != null) {
            expression.putUserData(DuplicatesFinder.PARAMETER, (Object)new DuplicatesFinder.Parameter(data.variable, expression.getType(), true));
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiExpression findEquivalent(PsiExpression expr, @NotNull PsiElement element) {
        if (element == null) {
            ParametersFolder.$$$reportNull$$$0(36);
        }
        PsiElement expression = element;
        while (expression != null) {
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expression, (PsiElement)expr)) {
                PsiExpression psiExpression = (PsiExpression)expression;
                return PsiUtil.isAccessedForWriting((PsiExpression)psiExpression) ? null : psiExpression;
            }
            expression = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiExpression.class);
        }
        return null;
    }

    boolean wasExcluded(@NotNull PsiVariable variable) {
        if (variable == null) {
            ParametersFolder.$$$reportNull$$$0(37);
        }
        return this.myDeleted.contains(variable) || this.myMentionedInExpressions.containsKey(variable) && this.myExpressions.get(variable) == null;
    }

    boolean isFoldingSelectedByDefault() {
        return this.myFoldingSelectedByDefault;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "datum";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: 
            case 15: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameGenerator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleManager";
                break;
            }
            case 16: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/ParametersFolder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElements";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ParametersFolder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsedVariables";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedCallArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isParameterSafeToDelete";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "foldParameterUsagesInBody";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isParameterFoldable";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setUniqueName";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findUsedVariables";
                break;
            }
            case 17: 
            case 31: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMentionedExpressions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToFoldArrayAccess";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAccessedForWriting";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isTooLongExpressionChain";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getInnerExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isMethodNameExpression";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "dependsOnLocals";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedCallArgument";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "putCallArgument";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "annotateWithParameter";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findEquivalent";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "wasExcluded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 31 -> new IllegalStateException(string);
        };
    }
}

