/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public final class OptionalUsedAsFieldOrParameterTypeInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiTypeElement typeElement = (PsiTypeElement)infos[0];
        PsiElement parent = typeElement.getParent();
        if (parent instanceof PsiField) {
            PsiField field = (PsiField)parent;
            String string = InspectionGadgetsBundle.message("optional.used.as.field.type.problem.descriptor", field.getName());
            if (string == null) {
                OptionalUsedAsFieldOrParameterTypeInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (parent instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)parent;
            String string = InspectionGadgetsBundle.message("optional.used.as.parameter.type.problem.descriptor", parameter.getName());
            if (string == null) {
                OptionalUsedAsFieldOrParameterTypeInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        throw new AssertionError();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new OptionUsedAsFieldOrParameterTypeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/OptionalUsedAsFieldOrParameterTypeInspection", "buildErrorString"));
    }

    private static class OptionUsedAsFieldOrParameterTypeVisitor
    extends BaseInspectionVisitor {
        private OptionUsedAsFieldOrParameterTypeVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                OptionUsedAsFieldOrParameterTypeVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            this.checkTypeElement(field.getTypeElement());
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                OptionUsedAsFieldOrParameterTypeVisitor.$$$reportNull$$$0(1);
            }
            super.visitParameter(parameter);
            PsiElement scope = parameter.getDeclarationScope();
            if (!(scope instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)scope;
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            this.checkTypeElement(parameter.getTypeElement());
        }

        private void checkTypeElement(PsiTypeElement typeElement) {
            if (typeElement == null || !TypeUtils.isOptional(typeElement.getType())) {
                return;
            }
            this.registerError((PsiElement)typeElement, typeElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/abstraction/OptionalUsedAsFieldOrParameterTypeInspection$OptionUsedAsFieldOrParameterTypeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

