/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.LiteralFormatUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import org.jetbrains.annotations.NotNull;

public final class NegativeIntConstantInLongContextInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            NegativeIntConstantInLongContextInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression literal) {
                if (literal == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!NegativeIntConstantInLongContextInspection.isNegativeHexLiteral(literal)) {
                    return;
                }
                this.checkLongContext((PsiExpression)literal);
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression ref) {
                PsiVariable variable;
                if (ref == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((variable = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class)) == null || !variable.hasModifierProperty("final")) {
                    return;
                }
                PsiLiteralExpression initializer = (PsiLiteralExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)PsiFieldImpl.getDetachedInitializer((PsiVariable)variable)), PsiLiteralExpression.class);
                if (initializer == null || !NegativeIntConstantInLongContextInspection.isNegativeHexLiteral(initializer)) {
                    return;
                }
                this.checkLongContext((PsiExpression)ref);
            }

            private void checkLongContext(@NotNull PsiExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!PsiTypes.longType().equals((Object)ExpectedTypeUtils.findExpectedType(expression, true))) {
                    return;
                }
                if (NegativeIntConstantInLongContextInspection.isInAssertEqualsLong(expression)) {
                    return;
                }
                LocalQuickFix[] fixes = null;
                if (expression instanceof PsiLiteralExpression) {
                    fixes = new LocalQuickFix[]{new AddLongSuffixFix(), new ConvertToLongFix()};
                }
                holder.registerProblem((PsiElement)expression, InspectionGadgetsBundle.message("negative.int.constant.in.long.context.display.name", new Object[0]), fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "literal";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ref";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/bitwise/NegativeIntConstantInLongContextInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLiteralExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkLongContext";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isInAssertEqualsLong(PsiExpression expression) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
        if (call == null) {
            return false;
        }
        String name = call.getMethodExpression().getReferenceName();
        if (!"assertEquals".equals(name)) {
            return false;
        }
        Object[] args = ((PsiExpressionList)parent).getExpressions();
        return ContainerUtil.exists((Object[])args, arg -> !PsiTreeUtil.isAncestor((PsiElement)arg, (PsiElement)expression, (boolean)false) && PsiTypes.intType().equals((Object)arg.getType()));
    }

    private static boolean isNegativeHexLiteral(@NotNull PsiLiteralExpression literal) {
        if (literal == null) {
            NegativeIntConstantInLongContextInspection.$$$reportNull$$$0(1);
        }
        if (!PsiTypes.intType().equals((Object)literal.getType())) {
            return false;
        }
        String text = literal.getText();
        if (!text.startsWith("0x") && !text.startsWith("0X")) {
            return false;
        }
        Integer value = (Integer)ObjectUtils.tryCast((Object)literal.getValue(), Integer.class);
        return value != null && value < 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/bitwise/NegativeIntConstantInLongContextInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isNegativeHexLiteral";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConvertToLongFix
    extends PsiUpdateModCommandQuickFix {
        private ConvertToLongFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negative.int.constant.in.long.context.fix.convert", new Object[0]);
            if (string == null) {
                ConvertToLongFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiLiteralExpression literal;
            if (project == null) {
                ConvertToLongFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ConvertToLongFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ConvertToLongFix.$$$reportNull$$$0(3);
            }
            if ((literal = (PsiLiteralExpression)ObjectUtils.tryCast((Object)element, PsiLiteralExpression.class)) == null) {
                return;
            }
            Integer value = (Integer)ObjectUtils.tryCast((Object)literal.getValue(), Integer.class);
            if (value == null || value >= 0) {
                return;
            }
            String longLiteral = Long.toHexString(value.intValue());
            String result = LiteralFormatUtil.format((String)(literal.getText().substring(0, 2) + longLiteral + "L"), (PsiType)PsiTypes.longType());
            new CommentTracker().replaceAndRestoreComments((PsiElement)literal, result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bitwise/NegativeIntConstantInLongContextInspection$ConvertToLongFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bitwise/NegativeIntConstantInLongContextInspection$ConvertToLongFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class AddLongSuffixFix
    extends PsiUpdateModCommandQuickFix {
        private AddLongSuffixFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negative.int.constant.in.long.context.fix.add.suffix", new Object[0]);
            if (string == null) {
                AddLongSuffixFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiLiteralExpression literal;
            if (project == null) {
                AddLongSuffixFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AddLongSuffixFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AddLongSuffixFix.$$$reportNull$$$0(3);
            }
            if ((literal = (PsiLiteralExpression)ObjectUtils.tryCast((Object)element, PsiLiteralExpression.class)) == null) {
                return;
            }
            PsiType type = literal.getType();
            if (!PsiTypes.intType().equals((Object)type)) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)literal, literal.getText() + "L");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bitwise/NegativeIntConstantInLongContextInspection$AddLongSuffixFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bitwise/NegativeIntConstantInLongContextInspection$AddLongSuffixFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

