/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AssertWithSideEffectsInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assert.with.side.effects.problem.descriptor", infos[0]);
        if (string == null) {
            AssertWithSideEffectsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ASSERTIONS);
        if (set == null) {
            AssertWithSideEffectsInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AssertWithSideEffectsVisitor();
    }

    @Nullable
    @Nls
    private static String getCallSideEffectDescription(PsiMethodCallExpression call) {
        PsiCodeBlock body;
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        if (JavaMethodContractUtil.isPure(method)) {
            return null;
        }
        MutationSignature signature = MutationSignature.fromMethod(method);
        if (signature.mutatesAnything()) {
            if (signature.performsIO()) {
                return InspectionGadgetsBundle.message("assert.with.side.effects.call.performs.io", method.getName());
            }
            PsiExpression expression = signature.mutatedExpressions(call).filter(expr -> !ExpressionUtils.isNewObject(expr)).findFirst().orElse(null);
            if (expression != null) {
                return InspectionGadgetsBundle.message("assert.with.side.effects.call.mutates.expression", method.getName(), expression.getText());
            }
        }
        if ((body = method.getBody()) == null) {
            return null;
        }
        MethodSideEffectVisitor visitor2 = new MethodSideEffectVisitor();
        body.accept((PsiElementVisitor)visitor2);
        String description = visitor2.getMutatedField();
        if (description != null) {
            return InspectionGadgetsBundle.message("assert.with.side.effects.call.mutates.field", method.getName(), description);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/AssertWithSideEffectsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AssertWithSideEffectsVisitor
    extends BaseInspectionVisitor {
        private AssertWithSideEffectsVisitor() {
        }

        public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
            if (statement == null) {
                AssertWithSideEffectsVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssertStatement(statement);
            PsiExpression condition = statement.getAssertCondition();
            if (condition == null) {
                return;
            }
            SideEffectVisitor visitor2 = new SideEffectVisitor();
            condition.accept((PsiElementVisitor)visitor2);
            String description = visitor2.getSideEffectDescription();
            if (description == null) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, description);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/AssertWithSideEffectsInspection$AssertWithSideEffectsVisitor", "visitAssertStatement"));
        }
    }

    private static class MethodSideEffectVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private String mutatedField;

        private MethodSideEffectVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                MethodSideEffectVisitor.$$$reportNull$$$0(0);
            }
            this.checkExpression(expression.getLExpression());
            super.visitAssignmentExpression(expression);
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
            IElementType tokenType;
            if (expression == null) {
                MethodSideEffectVisitor.$$$reportNull$$$0(1);
            }
            if (JavaTokenType.PLUSPLUS.equals(tokenType = expression.getOperationTokenType()) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.checkExpression(expression.getOperand());
            }
            super.visitUnaryExpression(expression);
        }

        private void checkExpression(PsiExpression operand) {
            if (!((operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand)) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiField) {
                this.mutatedField = ((PsiField)target).getName();
                this.stopWalking();
            }
        }

        private String getMutatedField() {
            return this.mutatedField;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/bugs/AssertWithSideEffectsInspection$MethodSideEffectVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SideEffectVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @Nls
        private String sideEffectDescription;

        private SideEffectVisitor() {
        }

        @Nls
        private String getSideEffectDescription() {
            return this.sideEffectDescription;
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                SideEffectVisitor.$$$reportNull$$$0(0);
            }
            this.sideEffectDescription = expression.getLExpression().getText() + " " + expression.getOperationSign().getText() + " ...";
            this.stopWalking();
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                SideEffectVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethodCallExpression(expression);
            this.sideEffectDescription = AssertWithSideEffectsInspection.getCallSideEffectDescription(expression);
            if (this.sideEffectDescription != null) {
                this.stopWalking();
            }
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
            IElementType tokenType;
            if (expression == null) {
                SideEffectVisitor.$$$reportNull$$$0(2);
            }
            if (JavaTokenType.PLUSPLUS.equals(tokenType = expression.getOperationTokenType()) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.sideEffectDescription = expression.getText();
                this.stopWalking();
            } else {
                super.visitUnaryExpression(expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/bugs/AssertWithSideEffectsInspection$SideEffectVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

