/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ClassNewInstanceInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.new.instance.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassNewInstanceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ClassNewInstanceFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNewInstanceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ClassNewInstanceInspection", "buildErrorString"));
    }

    private static class ClassNewInstanceFix
    extends PsiUpdateModCommandQuickFix {
        private ClassNewInstanceFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Class.getConstructor().newInstance()"});
            if (string == null) {
                ClassNewInstanceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                ClassNewInstanceFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ClassNewInstanceFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ClassNewInstanceFix.$$$reportNull$$$0(3);
            }
            if (!((parent = element.getParent()) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent;
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiElement parentOfType = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiTryStatement.class, PsiLambdaExpression.class});
            if (parentOfType instanceof PsiTryStatement) {
                PsiTryStatement tryStatement = (PsiTryStatement)parentOfType;
                ClassNewInstanceFix.addCatchBlock(tryStatement, "java.lang.NoSuchMethodException", "java.lang.reflect.InvocationTargetException");
            } else if (parentOfType instanceof PsiLambdaExpression) {
                PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)parentOfType);
                if (FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{method})) {
                    ClassNewInstanceFix.addThrowsClause(method, "java.lang.NoSuchMethodException", "java.lang.reflect.InvocationTargetException");
                }
            } else if (parentOfType instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)parentOfType;
                ClassNewInstanceFix.addThrowsClause(method, "java.lang.NoSuchMethodException", "java.lang.reflect.InvocationTargetException");
            }
            @NonNls String newExpression = qualifier.getText() + ".getConstructor().newInstance()";
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression, new CommentTracker());
        }

        private static void addThrowsClause(PsiMethod method, String ... exceptionNames) {
            PsiReferenceList throwsList = method.getThrowsList();
            PsiClassType[] referencedTypes = throwsList.getReferencedTypes();
            HashSet<String> presentExceptionNames = new HashSet<String>();
            for (PsiClassType referencedType : referencedTypes) {
                String exceptionName = referencedType.getCanonicalText();
                presentExceptionNames.add(exceptionName);
            }
            Project project = method.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            GlobalSearchScope scope = method.getResolveScope();
            for (String exceptionName : exceptionNames) {
                if (presentExceptionNames.contains(exceptionName)) continue;
                PsiJavaCodeReferenceElement throwsReference = factory.createReferenceElementByFQClassName(exceptionName, scope);
                PsiElement element = throwsList.add((PsiElement)throwsReference);
                codeStyleManager.shortenClassReferences(element);
            }
        }

        protected static void addCatchBlock(PsiTryStatement tryStatement, String ... exceptionNames) {
            Project project = tryStatement.getProject();
            PsiParameter[] parameters = tryStatement.getCatchBlockParameters();
            Set presentExceptions = Arrays.stream(parameters).map(PsiParameter::getType).collect(Collectors.toSet());
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            String name = codeStyleManager.suggestUniqueVariableName("e", (PsiElement)tryStatement.getTryBlock(), false);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            for (String exceptionName : exceptionNames) {
                PsiClassType type = (PsiClassType)factory.createTypeFromText(exceptionName, (PsiElement)tryStatement);
                if (ContainerUtil.exists(presentExceptions, e -> e.isAssignableFrom((PsiType)type))) continue;
                PsiCatchSection section = factory.createCatchSection((PsiType)type, name, (PsiElement)tryStatement);
                PsiCatchSection element = (PsiCatchSection)tryStatement.add((PsiElement)section);
                codeStyleManager.shortenClassReferences((PsiElement)element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/ClassNewInstanceInspection$ClassNewInstanceFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/ClassNewInstanceInspection$ClassNewInstanceFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ClassNewInstanceVisitor
    extends BaseInspectionVisitor {
        private ClassNewInstanceVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression;
            String methodName;
            if (expression == null) {
                ClassNewInstanceVisitor.$$$reportNull$$$0(0);
            }
            if (!"newInstance".equals(methodName = (methodExpression = expression.getMethodExpression()).getReferenceName())) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!"java.lang.Class".equals(TypeUtils.resolvedClassName(qualifier.getType()))) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ClassNewInstanceInspection$ClassNewInstanceVisitor", "visitMethodCallExpression"));
        }
    }
}

