/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class EqualsWhichDoesntCheckParameterClassInspection
extends BaseInspection {
    private static final CallMatcher REFLECTION_EQUALS = CallMatcher.anyOf(CallMatcher.staticCall("org.apache.commons.lang.builder.EqualsBuilder", "reflectionEquals"), CallMatcher.staticCall("org.apache.commons.lang3.builder.EqualsBuilder", "reflectionEquals"));
    private static final CallMatcher CLASS_IS_INSTANCE = CallMatcher.instanceCall("java.lang.Class", "isInstance").parameterCount(1);
    private static final CallMatcher OBJECT_GET_CLASS = CallMatcher.instanceCall("java.lang.Object", "getClass").parameterCount(0);
    private static final CallMatcher HIBERNATE_GET_CLASS = CallMatcher.staticCall("org.hibernate.Hibernate", "getClass").parameterCount(1);
    private static final CallMatcher SPRING_GET_CLASS = CallMatcher.staticCall("org.springframework.data.util.ProxyUtils", "getUserClass").parameterCount(1);

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.doesnt.check.class.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            EqualsWhichDoesntCheckParameterClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsWhichDoesntCheckParameterClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EqualsWhichDoesntCheckParameterClassInspection", "buildErrorString"));
    }

    private static class EqualsWhichDoesntCheckParameterClassVisitor
    extends BaseInspectionVisitor {
        private EqualsWhichDoesntCheckParameterClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                EqualsWhichDoesntCheckParameterClassVisitor.$$$reportNull$$$0(0);
            }
            if (!MethodUtils.isEquals(method)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter parameter = parameters[0];
            PsiCodeBlock body = method.getBody();
            if (body == null || EqualsWhichDoesntCheckParameterClassVisitor.isParameterChecked(body, parameter) || EqualsWhichDoesntCheckParameterClassVisitor.isParameterCheckNotNeeded(body, parameter)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static boolean isParameterChecked(PsiCodeBlock body, PsiParameter parameter) {
            ParameterClassCheckVisitor visitor2 = new ParameterClassCheckVisitor(parameter);
            body.accept((PsiElementVisitor)visitor2);
            return visitor2.isChecked();
        }

        private static boolean isParameterCheckNotNeeded(PsiCodeBlock body, PsiParameter parameter) {
            if (ControlFlowUtils.isEmptyCodeBlock(body)) {
                return true;
            }
            PsiStatement statement = ControlFlowUtils.getOnlyStatementInBlock(body);
            if (statement == null) {
                return false;
            }
            if (!(statement instanceof PsiReturnStatement)) {
                return true;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            Object constant = ExpressionUtils.computeConstantExpression(returnValue);
            if (Boolean.FALSE.equals(constant)) {
                return true;
            }
            if (REFLECTION_EQUALS.matches(returnValue)) {
                return true;
            }
            return EqualsWhichDoesntCheckParameterClassVisitor.isIdentityEquals(returnValue, parameter);
        }

        private static boolean isIdentityEquals(PsiExpression expression, PsiParameter parameter) {
            if (!(expression instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            return EqualsWhichDoesntCheckParameterClassVisitor.isIdentityEquals(lhs, rhs, parameter) || EqualsWhichDoesntCheckParameterClassVisitor.isIdentityEquals(rhs, lhs, parameter);
        }

        private static boolean isIdentityEquals(PsiExpression lhs, PsiExpression rhs, PsiParameter parameter) {
            return ExpressionUtils.isReferenceTo(lhs, (PsiVariable)parameter) && rhs instanceof PsiThisExpression && ((PsiThisExpression)rhs).getQualifier() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/bugs/EqualsWhichDoesntCheckParameterClassInspection$EqualsWhichDoesntCheckParameterClassVisitor", "visitMethod"));
        }
    }

    private static class ParameterClassCheckVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiParameter myParameter;
        private boolean myChecked;

        ParameterClassCheckVisitor(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                ParameterClassCheckVisitor.$$$reportNull$$$0(0);
            }
            this.myParameter = parameter;
        }

        private void makeChecked() {
            this.myChecked = true;
            this.stopWalking();
        }

        @Contract(value="null -> false")
        private boolean isParameterReference(PsiExpression operand) {
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operand), PsiReferenceExpression.class);
            if (ref == null) {
                return false;
            }
            PsiParameter target = (PsiParameter)ObjectUtils.tryCast((Object)ref.resolve(), PsiParameter.class);
            if (target == this.myParameter) {
                return true;
            }
            if (target == null) {
                return false;
            }
            return target.getParent() instanceof PsiParameterList && target.getParent().getParent() instanceof PsiLambdaExpression;
        }

        private boolean isGetInstanceCall(PsiMethodCallExpression call) {
            if (!CLASS_IS_INSTANCE.test(call)) {
                return false;
            }
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            return this.isParameterReference(arg);
        }

        private boolean isGetClassCall(PsiMethodCallExpression call) {
            if (!OBJECT_GET_CLASS.test(call)) {
                return false;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            return this.isParameterReference(qualifier);
        }

        private boolean isSpringOrHibernateGetClass(PsiMethodCallExpression call) {
            if (!SPRING_GET_CLASS.test(call) && !HIBERNATE_GET_CLASS.test(call)) {
                return false;
            }
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            return this.isParameterReference(arg);
        }

        private boolean isCallToSuperEquals(PsiMethodCallExpression call) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiSuperExpression)) {
                return false;
            }
            String name = methodExpression.getReferenceName();
            if (!"equals".equals(name)) {
                return false;
            }
            PsiExpression[] arguments = call.getArgumentList().getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            return this.isParameterReference(arguments[0]);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ParameterClassCheckVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethodCallExpression(expression);
            if (this.isGetClassCall(expression) || this.isGetInstanceCall(expression) || this.isCallToSuperEquals(expression) || this.isSpringOrHibernateGetClass(expression)) {
                this.makeChecked();
            }
        }

        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            if (expression == null) {
                ParameterClassCheckVisitor.$$$reportNull$$$0(2);
            }
            super.visitMethodReferenceExpression(expression);
            if (CLASS_IS_INSTANCE.methodReferenceMatches(expression)) {
                this.makeChecked();
            }
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
            if (expression == null) {
                ParameterClassCheckVisitor.$$$reportNull$$$0(3);
            }
            super.visitInstanceOfExpression(expression);
            if (this.isParameterReference(expression.getOperand())) {
                this.makeChecked();
            }
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                ParameterClassCheckVisitor.$$$reportNull$$$0(4);
            }
            super.visitSwitchExpression(expression);
            this.visitSwitchBlock((PsiSwitchBlock)expression);
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                ParameterClassCheckVisitor.$$$reportNull$$$0(5);
            }
            super.visitSwitchStatement(statement);
            this.visitSwitchBlock((PsiSwitchBlock)statement);
        }

        private void visitSwitchBlock(@NotNull PsiSwitchBlock switchBlock) {
            if (switchBlock == null) {
                ParameterClassCheckVisitor.$$$reportNull$$$0(6);
            }
            if (!this.isParameterReference(switchBlock.getExpression())) {
                return;
            }
            PsiCodeBlock body = switchBlock.getBody();
            if (body == null) {
                return;
            }
            boolean checksType = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)body, PsiSwitchLabelStatementBase.class).stream().map(PsiSwitchLabelStatementBase::getCaseLabelElementList).filter(Objects::nonNull).flatMap(list -> Arrays.stream(list.getElements())).anyMatch(element -> element instanceof PsiPrimaryPattern);
            if (checksType) {
                this.makeChecked();
            }
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                ParameterClassCheckVisitor.$$$reportNull$$$0(7);
            }
            super.visitTypeCastExpression(expression);
            PsiExpression operand = expression.getOperand();
            if (!this.isParameterReference(operand)) {
                return;
            }
            PsiTryStatement statement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiTryStatement.class);
            if (statement == null) {
                return;
            }
            PsiParameter[] parameters = statement.getCatchBlockParameters();
            if (parameters.length < 2) {
                return;
            }
            boolean nullPointerExceptionFound = false;
            boolean classCastExceptionFound = false;
            for (PsiParameter parameter : parameters) {
                PsiType type = parameter.getType();
                if (type.equalsToText("java.lang.NullPointerException")) {
                    nullPointerExceptionFound = true;
                    if (!classCastExceptionFound) continue;
                    break;
                }
                if (!type.equalsToText("java.lang.ClassCastException")) continue;
                classCastExceptionFound = true;
                if (nullPointerExceptionFound) break;
            }
            if (classCastExceptionFound && nullPointerExceptionFound) {
                this.makeChecked();
            }
        }

        public boolean isChecked() {
            return this.myChecked;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchBlock";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/EqualsWhichDoesntCheckParameterClassInspection$ParameterClassCheckVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodReferenceExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInstanceOfExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchBlock";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeCastExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

