/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ThreeState;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InheritanceUtil;
import org.jetbrains.annotations.NotNull;

public final class InstanceofIncompatibleInterfaceInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Boolean isInterface = (Boolean)infos[0];
        String aClass = (String)infos[1];
        String string = InspectionGadgetsBundle.message("instanceof.with.incompatible.interface.problem.descriptor", isInterface != false ? 1 : 2, aClass);
        if (string == null) {
            InstanceofIncompatibleInterfaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofIncompatibleInterfaceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/InstanceofIncompatibleInterfaceInspection", "buildErrorString"));
    }

    private static class InstanceofIncompatibleInterfaceVisitor
    extends BaseInspectionVisitor {
        private InstanceofIncompatibleInterfaceVisitor() {
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
            if (expression == null) {
                InstanceofIncompatibleInterfaceVisitor.$$$reportNull$$$0(0);
            }
            super.visitInstanceOfExpression(expression);
            PsiTypeElement checkTypeElement = expression.getCheckType();
            if (checkTypeElement == null) {
                return;
            }
            PsiType checkType = checkTypeElement.getType();
            if (!(checkType instanceof PsiClassType)) {
                return;
            }
            PsiClassType checkClassType = (PsiClassType)checkType;
            PsiExpression operand = expression.getOperand();
            PsiType operandType = operand.getType();
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            PsiClassType operandClassType = (PsiClassType)operandType;
            if (DfaPsiUtil.isAssertionEffectively((PsiExpression)expression, false)) {
                return;
            }
            if (!TypeConversionUtil.areTypesConvertible((PsiType)operandClassType, (PsiType)checkType)) {
                return;
            }
            PsiClass checkClass = checkClassType.resolve();
            if (checkClass == null) {
                return;
            }
            PsiClass operandClass = operandClassType.resolve();
            if (operandClass == null) {
                return;
            }
            String operandClassName = operandClass.getName();
            if (operandClassName == null) {
                return;
            }
            ThreeState hasMutualSubclass = InheritanceUtil.existsMutualSubclass(operandClass, checkClass, this.isOnTheFly());
            if (hasMutualSubclass == ThreeState.NO) {
                this.registerError((PsiElement)checkTypeElement, checkClass.isInterface(), operandClassName);
            } else if (hasMutualSubclass == ThreeState.UNSURE) {
                this.registerPossibleProblem((PsiElement)checkTypeElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/InstanceofIncompatibleInterfaceInspection$InstanceofIncompatibleInterfaceVisitor", "visitInstanceOfExpression"));
        }
    }
}

