/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.RedundantCastUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MathRoundingWithIntArgumentInspection
extends BaseInspection {
    private static final CallMatcher MATH_ROUNDING_MATCHERS = CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "round", "ceil", "floor", "rint").parameterCount(1), CallMatcher.staticCall("java.lang.StrictMath", "round", "ceil", "floor", "rint").parameterCount(1));
    private static final CallMatcher QUICK_FIX_MATH_ROUNDING_MATCHERS = CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "ceil", "floor", "rint").parameterCount(1), CallMatcher.staticCall("java.lang.StrictMath", "ceil", "floor", "rint").parameterCount(1));

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("math.rounding.with.int.argument.problem.descriptor", new Object[0]);
        if (string == null) {
            MathRoundingWithIntArgumentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)infos[0];
        if (!QUICK_FIX_MATH_ROUNDING_MATCHERS.matches((PsiExpression)callExpression)) {
            return null;
        }
        return new MathRoundingWithIntArgumentFix(callExpression.getMethodExpression().getText());
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MathRoundingWithIntArgumentVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MathRoundingWithIntArgumentInspection", "buildErrorString"));
    }

    private static class MathRoundingWithIntArgumentFix
    extends PsiUpdateModCommandQuickFix {
        private final String method;

        private MathRoundingWithIntArgumentFix(@NlsSafe String method) {
            this.method = method;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("math.rounding.with.int.argument.quickfix", this.method);
            if (string == null) {
                MathRoundingWithIntArgumentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("math.rounding.with.int.argument.family.name", new Object[0]);
            if (string == null) {
                MathRoundingWithIntArgumentFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                MathRoundingWithIntArgumentFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                MathRoundingWithIntArgumentFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                MathRoundingWithIntArgumentFix.$$$reportNull$$$0(4);
            }
            if ((parent = element.getParent()) == null) {
                return;
            }
            PsiElement psiElement = parent.getParent();
            if (!(psiElement instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)psiElement;
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiExpression argument = arguments[0];
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)ct.replaceAndRestoreComments((PsiElement)callExpression, "(double)" + ct.text(argument, 4));
            if (RedundantCastUtil.isCastRedundant(castExpression)) {
                RemoveRedundantCastUtil.removeCast(castExpression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/MathRoundingWithIntArgumentInspection$MathRoundingWithIntArgumentFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/MathRoundingWithIntArgumentInspection$MathRoundingWithIntArgumentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MathRoundingWithIntArgumentVisitor
    extends BaseInspectionVisitor {
        private MathRoundingWithIntArgumentVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                MathRoundingWithIntArgumentVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!MATH_ROUNDING_MATCHERS.matches((PsiExpression)expression)) {
                return;
            }
            PsiExpression[] arguments = expression.getArgumentList().getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType type = argument.getType();
            if (type == null) {
                return;
            }
            if (!PsiTypes.intType().equals((Object)type) && !type.equalsToText("java.lang.Integer")) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/MathRoundingWithIntArgumentInspection$MathRoundingWithIntArgumentVisitor", "visitMethodCallExpression"));
        }
    }
}

