/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MismatchedStringCaseInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher STRING_COMPARISON_METHODS = CallMatcher.exactInstanceCall("java.lang.String", "equals", "startsWith", "endsWith", "contains", "indexOf", "lastIndexOf");
    private static final CallMatcher CASE_PRESERVING_METHODS = CallMatcher.exactInstanceCall("java.lang.String", "trim", "repeat", "substring", "strip");
    private static final CallMatcher TO_LOWER_CASE = CallMatcher.exactInstanceCall("java.lang.String", "toLowerCase");
    private static final CallMatcher TO_UPPER_CASE = CallMatcher.exactInstanceCall("java.lang.String", "toUpperCase");
    private static final int ANALYSIS_COMPLEXITY = 16;

    static StringCase fromExpression(@Nullable PsiExpression expression, int energy) {
        if (expression == null || energy <= 0) {
            return StringCase.UNSURE;
        }
        String str = (String)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)), String.class);
        if (str != null) {
            return MismatchedStringCaseInspection.fromConstant(str);
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (CASE_PRESERVING_METHODS.test(call)) {
                return MismatchedStringCaseInspection.fromExpression(call.getMethodExpression().getQualifierExpression(), energy - 1);
            }
            if (TO_LOWER_CASE.test(call)) {
                return new StringCase(ThreeState.UNSURE, ThreeState.NO);
            }
            if (TO_UPPER_CASE.test(call)) {
                return new StringCase(ThreeState.NO, ThreeState.UNSURE);
            }
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiExpression thenBranch = ((PsiConditionalExpression)expression).getThenExpression();
            StringCase thenCase = MismatchedStringCaseInspection.fromExpression(thenBranch, energy / 2);
            if (thenCase.equals(StringCase.UNSURE)) {
                return thenCase;
            }
            PsiExpression elseBranch = ((PsiConditionalExpression)expression).getElseExpression();
            return MismatchedStringCaseInspection.fromExpression(elseBranch, energy / 2).either(thenCase);
        }
        if (expression instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)expression).getOperationTokenType().equals(JavaTokenType.PLUS)) {
            PsiExpression[] operands = ((PsiPolyadicExpression)expression).getOperands();
            StringCase result = new StringCase(ThreeState.NO, ThreeState.NO);
            for (PsiExpression operand : operands) {
                StringCase operandCase = MismatchedStringCaseInspection.fromExpression(operand, energy / operands.length);
                result = result.concat(operandCase);
                if (result.myHasLower == ThreeState.YES && result.myHasUpper == ThreeState.YES) break;
            }
            return result;
        }
        if (expression instanceof PsiReferenceExpression) {
            return MismatchedStringCaseInspection.fromExpression(MismatchedStringCaseInspection.resolveDefinition(expression), energy - 4);
        }
        return StringCase.UNSURE;
    }

    @Nullable
    private static PsiExpression resolveDefinition(@NotNull PsiExpression expression) {
        PsiAssignmentExpression assignment;
        PsiReferenceExpression referenceExpression;
        if (expression == null) {
            MismatchedStringCaseInspection.$$$reportNull$$$0(0);
        }
        if ((referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression), PsiReferenceExpression.class)) == null) {
            return null;
        }
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiVariable.class);
        if (variable == null) {
            return null;
        }
        PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)PsiUtil.getVariableCodeBlock((PsiVariable)variable, null), PsiCodeBlock.class);
        if (block == null) {
            return null;
        }
        PsiElement[] defs = DefUseUtil.getDefs((PsiCodeBlock)block, (PsiVariable)variable, (PsiElement)expression);
        if (defs.length != 1) {
            return null;
        }
        PsiElement def = defs[0];
        if (def instanceof PsiLocalVariable) {
            return ((PsiLocalVariable)def).getInitializer();
        }
        if (def instanceof PsiReferenceExpression && (assignment = ExpressionUtils.getAssignment(def.getParent())) != null && assignment.getLExpression() == def) {
            return assignment.getRExpression();
        }
        if (def instanceof PsiExpression) {
            return (PsiExpression)def;
        }
        return null;
    }

    private static StringCase fromConstant(String str) {
        int codepoint;
        ThreeState hasLower = ThreeState.NO;
        ThreeState hasUpper = ThreeState.NO;
        for (int i = 0; i < str.length(); i += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(i);
            if (Character.isLowerCase(codepoint)) {
                hasLower = ThreeState.YES;
                if (hasUpper != ThreeState.YES) continue;
                break;
            }
            if (!Character.isUpperCase(codepoint)) continue;
            hasUpper = ThreeState.YES;
            if (hasLower == ThreeState.YES) break;
        }
        return new StringCase(hasLower, hasUpper);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MismatchedStringCaseInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.visitSwitchBlock((PsiSwitchBlock)statement);
            }

            public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.visitSwitchBlock((PsiSwitchBlock)expression);
            }

            private void visitSwitchBlock(PsiSwitchBlock block) {
                PsiCodeBlock body = block.getBody();
                if (body == null) {
                    return;
                }
                PsiExpression selector = block.getExpression();
                if (selector == null || !TypeUtils.isJavaLangString(selector.getType())) {
                    return;
                }
                if (PsiUtil.isConstantExpression((PsiExpression)selector)) {
                    return;
                }
                StringCase selectorCase = MismatchedStringCaseInspection.fromExpression(selector, 16);
                if (selectorCase.myHasUpper != ThreeState.NO && selectorCase.myHasLower != ThreeState.NO) {
                    return;
                }
                for (PsiStatement statement : body.getStatements()) {
                    PsiCaseLabelElementList labels;
                    if (!(statement instanceof PsiSwitchLabelStatementBase) || (labels = ((PsiSwitchLabelStatementBase)statement).getCaseLabelElementList()) == null) continue;
                    for (PsiCaseLabelElement label : labels.getElements()) {
                        String errorMessage;
                        if (!(label instanceof PsiExpression)) continue;
                        StringCase labelCase = MismatchedStringCaseInspection.fromExpression((PsiExpression)label, 16);
                        if (selectorCase.myHasLower == ThreeState.NO && labelCase.myHasLower == ThreeState.YES) {
                            errorMessage = InspectionGadgetsBundle.message("inspection.case.mismatch.message.label.is.lower", new Object[0]);
                        } else {
                            if (selectorCase.myHasUpper != ThreeState.NO || labelCase.myHasUpper != ThreeState.YES) continue;
                            errorMessage = InspectionGadgetsBundle.message("inspection.case.mismatch.message.label.is.upper", new Object[0]);
                        }
                        holder.registerProblem((PsiElement)label, errorMessage, new LocalQuickFix[0]);
                    }
                }
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                String errorMessage;
                String returnValue;
                String methodName;
                if (call == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!STRING_COMPARISON_METHODS.test(call)) {
                    return;
                }
                PsiExpression arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                StringCase argCase = MismatchedStringCaseInspection.fromExpression(arg, 16);
                if (argCase.myHasUpper != ThreeState.YES && argCase.myHasLower != ThreeState.YES) {
                    return;
                }
                StringCase qualifierCase = MismatchedStringCaseInspection.fromExpression(qualifier, 16);
                PsiElement anchor = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                switch (methodName = anchor.getText()) {
                    case "indexOf": 
                    case "lastIndexOf": {
                        String string = "-1";
                        break;
                    }
                    default: {
                        String string = returnValue = "false";
                    }
                }
                if (qualifierCase.myHasLower == ThreeState.NO && argCase.myHasLower == ThreeState.YES) {
                    errorMessage = InspectionGadgetsBundle.message("inspection.case.mismatch.message.arg.is.lower", methodName, returnValue);
                } else if (qualifierCase.myHasUpper == ThreeState.NO && argCase.myHasUpper == ThreeState.YES) {
                    errorMessage = InspectionGadgetsBundle.message("inspection.case.mismatch.message.arg.is.upper", methodName, returnValue);
                } else {
                    return;
                }
                holder.registerProblem(anchor, errorMessage, new LocalQuickFix[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/bugs/MismatchedStringCaseInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSwitchStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSwitchExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/bugs/MismatchedStringCaseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveDefinition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StringCase {
        static final StringCase UNSURE = new StringCase(ThreeState.UNSURE, ThreeState.UNSURE);
        @NotNull
        final ThreeState myHasLower;
        @NotNull
        final ThreeState myHasUpper;

        StringCase(@NotNull ThreeState hasLower, @NotNull ThreeState hasUpper) {
            if (hasLower == null) {
                StringCase.$$$reportNull$$$0(0);
            }
            if (hasUpper == null) {
                StringCase.$$$reportNull$$$0(1);
            }
            this.myHasLower = hasLower;
            this.myHasUpper = hasUpper;
        }

        StringCase either(@NotNull StringCase other) {
            ThreeState hasLower;
            if (other == null) {
                StringCase.$$$reportNull$$$0(2);
            }
            ThreeState threeState = this.myHasLower == ThreeState.NO && other.myHasLower == ThreeState.NO ? ThreeState.NO : (hasLower = this.myHasLower == ThreeState.YES && other.myHasLower == ThreeState.YES ? ThreeState.YES : ThreeState.UNSURE);
            ThreeState hasUpper = this.myHasUpper == ThreeState.NO && other.myHasUpper == ThreeState.NO ? ThreeState.NO : (this.myHasUpper == ThreeState.YES && other.myHasUpper == ThreeState.YES ? ThreeState.YES : ThreeState.UNSURE);
            return new StringCase(hasLower, hasUpper);
        }

        StringCase concat(@NotNull StringCase other) {
            ThreeState hasLower;
            if (other == null) {
                StringCase.$$$reportNull$$$0(3);
            }
            ThreeState threeState = this.myHasLower == ThreeState.YES || other.myHasLower == ThreeState.YES ? ThreeState.YES : (hasLower = this.myHasLower == ThreeState.NO && other.myHasLower == ThreeState.NO ? ThreeState.NO : ThreeState.UNSURE);
            ThreeState hasUpper = this.myHasUpper == ThreeState.YES || other.myHasUpper == ThreeState.YES ? ThreeState.YES : (this.myHasUpper == ThreeState.NO && other.myHasUpper == ThreeState.NO ? ThreeState.NO : ThreeState.UNSURE);
            return new StringCase(hasLower, hasUpper);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringCase aCase = (StringCase)o;
            return this.myHasLower == aCase.myHasLower && this.myHasUpper == aCase.myHasUpper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hasLower";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hasUpper";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/MismatchedStringCaseInspection$StringCase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "either";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "concat";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

