/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.BaseEqualsVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringEqualsCharSequenceInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message("string.equals.char.sequence.problem.descriptor", type.getPresentableText());
        if (string == null) {
            StringEqualsCharSequenceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiReferenceExpression expression = (PsiReferenceExpression)infos[1];
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression) && !StringEqualsCharSequenceInspection.isStringEqualsCall(expression)) {
            return null;
        }
        return new StringEqualsCharSequenceFix();
    }

    private static boolean isStringEqualsCall(PsiReferenceExpression expression) {
        if (!"equals".equals(expression.getReferenceName())) {
            return false;
        }
        PsiElement target = expression.resolve();
        if (!(target instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)target;
        PsiClass aClass = method.getContainingClass();
        return aClass != null && "java.lang.String".equals(aClass.getQualifiedName());
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StringEqualsCharSequenceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StringEqualsCharSequenceInspection", "buildErrorString"));
    }

    private static class StringEqualsCharSequenceFix
    extends PsiUpdateModCommandQuickFix {
        private StringEqualsCharSequenceFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"contentEquals()"});
            if (string == null) {
                StringEqualsCharSequenceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                StringEqualsCharSequenceFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                StringEqualsCharSequenceFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                StringEqualsCharSequenceFix.$$$reportNull$$$0(3);
            }
            PsiIdentifier identifier = JavaPsiFacade.getElementFactory((Project)project).createIdentifier("contentEquals");
            element.replace((PsiElement)identifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/StringEqualsCharSequenceInspection$StringEqualsCharSequenceFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/StringEqualsCharSequenceInspection$StringEqualsCharSequenceFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class StringEqualsCharSequenceVisitor
    extends BaseEqualsVisitor {
        private StringEqualsCharSequenceVisitor() {
        }

        @Override
        boolean checkTypes(@NotNull PsiReferenceExpression expression, @NotNull PsiType leftType, @NotNull PsiType rightType) {
            if (expression == null) {
                StringEqualsCharSequenceVisitor.$$$reportNull$$$0(0);
            }
            if (leftType == null) {
                StringEqualsCharSequenceVisitor.$$$reportNull$$$0(1);
            }
            if (rightType == null) {
                StringEqualsCharSequenceVisitor.$$$reportNull$$$0(2);
            }
            if (!leftType.equalsToText("java.lang.String")) {
                return false;
            }
            if (rightType.equalsToText("java.lang.String") || !InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.CharSequence")) {
                return false;
            }
            PsiElement name = expression.getReferenceNameElement();
            assert (name != null);
            this.registerError(name, rightType, expression);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leftType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rightType";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/bugs/StringEqualsCharSequenceInspection$StringEqualsCharSequenceVisitor";
            objectArray[2] = "checkTypes";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

