/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class TextLabelInSwitchStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("text.label.in.switch.statement.problem.descriptor", infos[0] instanceof PsiSwitchStatement ? 1 : 2);
        if (string == null) {
            TextLabelInSwitchStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new TextLabelInSwitchStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/TextLabelInSwitchStatementInspection", "buildErrorString"));
    }

    private static class TextLabelInSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private TextLabelInSwitchStatementVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                TextLabelInSwitchStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(statement);
            this.visitSwitchBlock((PsiSwitchBlock)statement);
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                TextLabelInSwitchStatementVisitor.$$$reportNull$$$0(1);
            }
            super.visitSwitchExpression(expression);
            this.visitSwitchBlock((PsiSwitchBlock)expression);
        }

        private void visitSwitchBlock(PsiSwitchBlock block) {
            PsiCodeBlock body = block.getBody();
            if (body == null) {
                return;
            }
            for (PsiStatement statement : body.getStatements()) {
                if (!(statement instanceof PsiLabeledStatement)) continue;
                PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
                this.registerError((PsiElement)labeledStatement.getLabelIdentifier(), block);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/TextLabelInSwitchStatementInspection$TextLabelInSwitchStatementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

