/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public final class VariableNotUsedInsideIfInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean isIf = (Boolean)infos[0];
        if (isIf) {
            String string = InspectionGadgetsBundle.message("variable.not.used.inside.if.problem.descriptor", new Object[0]);
            if (string == null) {
                VariableNotUsedInsideIfInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("variable.not.used.inside.conditional.problem.descriptor", new Object[0]);
        if (string == null) {
            VariableNotUsedInsideIfInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new VariableNotUsedInsideIfVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/VariableNotUsedInsideIfInspection", "buildErrorString"));
    }

    private static class VariableNotUsedInsideIfVisitor
    extends BaseInspectionVisitor {
        private VariableNotUsedInsideIfVisitor() {
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                VariableNotUsedInsideIfVisitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(expression);
            PsiExpression condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getCondition());
            if (!(condition instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiReferenceExpression referenceExpression = VariableNotUsedInsideIfVisitor.extractVariableReference(binaryExpression);
            if (referenceExpression == null) {
                return;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (tokenType == JavaTokenType.EQEQ) {
                if (VariableNotUsedInsideIfVisitor.checkVariableUsage(referenceExpression, (PsiElement)expression.getThenExpression(), (PsiElement)expression.getElseExpression())) {
                    this.registerError((PsiElement)referenceExpression, Boolean.FALSE);
                }
            } else if (tokenType == JavaTokenType.NE && VariableNotUsedInsideIfVisitor.checkVariableUsage(referenceExpression, (PsiElement)expression.getElseExpression(), (PsiElement)expression.getThenExpression())) {
                this.registerError((PsiElement)referenceExpression, Boolean.FALSE);
            }
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                VariableNotUsedInsideIfVisitor.$$$reportNull$$$0(1);
            }
            super.visitIfStatement(statement);
            PsiExpression condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getCondition());
            if (!(condition instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiReferenceExpression referenceExpression = VariableNotUsedInsideIfVisitor.extractVariableReference(binaryExpression);
            if (referenceExpression == null) {
                return;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (tokenType == JavaTokenType.EQEQ) {
                if (VariableNotUsedInsideIfVisitor.checkVariableUsage(referenceExpression, (PsiElement)statement.getThenBranch(), (PsiElement)statement.getElseBranch())) {
                    this.registerError((PsiElement)referenceExpression, Boolean.TRUE);
                }
            } else if (tokenType == JavaTokenType.NE && VariableNotUsedInsideIfVisitor.checkVariableUsage(referenceExpression, (PsiElement)statement.getElseBranch(), (PsiElement)statement.getThenBranch())) {
                this.registerError((PsiElement)referenceExpression, Boolean.TRUE);
            }
        }

        private static boolean checkVariableUsage(PsiReferenceExpression referenceExpression, PsiElement thenContext, PsiElement elseContext) {
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target;
            if (thenContext != null && (VariableNotUsedInsideIfVisitor.contextExits(thenContext) || VariableAccessUtils.variableIsAssigned(variable, thenContext))) {
                return false;
            }
            return elseContext != null && !VariableAccessUtils.variableIsUsed(variable, elseContext);
        }

        private static PsiReferenceExpression extractVariableReference(PsiBinaryExpression expression) {
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLOperand());
            if (lhs == null) {
                return null;
            }
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getROperand());
            if (rhs == null) {
                return null;
            }
            if (PsiTypes.nullType().equals(rhs.getType())) {
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return null;
                }
                return (PsiReferenceExpression)lhs;
            }
            if (PsiTypes.nullType().equals(lhs.getType())) {
                if (!(rhs instanceof PsiReferenceExpression)) {
                    return null;
                }
                return (PsiReferenceExpression)rhs;
            }
            return null;
        }

        private static boolean contextExits(PsiElement context) {
            if (context instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)context;
                PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(blockStatement.getCodeBlock());
                return VariableNotUsedInsideIfVisitor.statementExits((PsiElement)lastStatement);
            }
            return VariableNotUsedInsideIfVisitor.statementExits(context);
        }

        private static boolean statementExits(PsiElement context) {
            return context instanceof PsiReturnStatement || context instanceof PsiThrowStatement || context instanceof PsiBreakStatement || context instanceof PsiContinueStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/VariableNotUsedInsideIfInspection$VariableNotUsedInsideIfVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitConditionalExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

