/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.callMatcher;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.siyeh.ig.callMatcher.CallHandler;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;

public final class CallMapper<T> {
    private final Map<String, List<CallHandler<T>>> myMap;

    public CallMapper() {
        this.myMap = new LinkedHashMap<String, List<CallHandler<T>>>();
    }

    @SafeVarargs
    public CallMapper(CallHandler<T> ... handlers) {
        if (handlers == null) {
            CallMapper.$$$reportNull$$$0(0);
        }
        this.myMap = new LinkedHashMap<String, List<CallHandler<T>>>();
        for (CallHandler<T> handler : handlers) {
            this.register(handler);
        }
    }

    @Contract(value="_ -> this")
    public CallMapper<T> register(@NotNull CallHandler<T> handler) {
        if (handler == null) {
            CallMapper.$$$reportNull$$$0(1);
        }
        handler.matcher().names().forEach(name -> this.myMap.computeIfAbsent((String)name, k -> new ArrayList()).add(handler));
        return this;
    }

    @Contract(value="_,_ -> this")
    public CallMapper<T> register(@NotNull CallMatcher matcher, @NotNull Function<? super PsiMethodCallExpression, ? extends T> handler) {
        if (matcher == null) {
            CallMapper.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            CallMapper.$$$reportNull$$$0(3);
        }
        return this.register(CallHandler.of(matcher, handler));
    }

    @Contract(value="_,_ -> this")
    public CallMapper<T> register(@NotNull CallMatcher matcher, T value) {
        if (matcher == null) {
            CallMapper.$$$reportNull$$$0(4);
        }
        return this.register(CallHandler.of(matcher, call -> value));
    }

    @Contract(value="_ -> this")
    public CallMapper<T> registerAll(@NotNull List<? extends CallHandler<T>> handlers) {
        if (handlers == null) {
            CallMapper.$$$reportNull$$$0(5);
        }
        handlers.forEach(this::register);
        return this;
    }

    @Contract(value="null -> null")
    public T mapFirst(UCallExpression call) {
        if (call == null) {
            return null;
        }
        if (!call.isMethodNameOneOf(this.myMap.keySet())) {
            return null;
        }
        List<CallHandler<T>> functions = this.myMap.get(call.getMethodName());
        if (functions == null) {
            return null;
        }
        for (CallHandler<T> function : functions) {
            T t = function.apply(call);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Contract(value="null -> null")
    public T mapFirst(PsiMethodCallExpression call) {
        if (call == null) {
            return null;
        }
        List<CallHandler<T>> functions = this.myMap.get(call.getMethodExpression().getReferenceName());
        if (functions == null) {
            return null;
        }
        for (Function function : functions) {
            Object t = function.apply(call);
            if (t == null) continue;
            return (T)t;
        }
        return null;
    }

    @Contract(value="null -> null")
    public T mapFirst(PsiMethodReferenceExpression methodRef) {
        if (methodRef == null) {
            return null;
        }
        List<CallHandler<T>> functions = this.myMap.get(methodRef.getReferenceName());
        if (functions == null) {
            return null;
        }
        for (CallHandler<T> function : functions) {
            T t = function.applyMethodReference(methodRef);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Contract(value="null -> null")
    public T mapFirst(PsiMethod method) {
        if (method == null) {
            return null;
        }
        List<CallHandler<T>> functions = this.myMap.get(method.getName());
        if (functions == null) {
            return null;
        }
        for (CallHandler<T> function : functions) {
            T t = function.applyMethod(method);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public Stream<T> mapAll(PsiMethodCallExpression call) {
        if (call == null) {
            return null;
        }
        List<CallHandler<T>> functions = this.myMap.get(call.getMethodExpression().getReferenceName());
        if (functions == null) {
            return StreamEx.empty();
        }
        return StreamEx.of(functions).map(fn -> fn.apply(call)).nonNull();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/callMatcher/CallMapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

