/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.RemoveModifierFix;
import org.jetbrains.annotations.NotNull;

public final class FinalMethodInFinalClassInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new FinalMethodInFinalClassVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("final.method.in.final.class.problem.descriptor", new Object[0]);
        if (string == null) {
            FinalMethodInFinalClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new RemoveModifierFix("final");
    }

    public static boolean isApplicableFor(@NotNull PsiMethod method) {
        if (method == null) {
            FinalMethodInFinalClassInspection.$$$reportNull$$$0(1);
        }
        if (!method.hasModifierProperty("final")) {
            return false;
        }
        return method.hasModifierProperty("static") || AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (boolean)true, (String[])new String[]{"java.lang.SafeVarargs"}) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/classlayout/FinalMethodInFinalClassInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/classlayout/FinalMethodInFinalClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class FinalMethodInFinalClassVisitor
    extends BaseInspectionVisitor {
        private FinalMethodInFinalClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiElement[] children;
            if (method == null) {
                FinalMethodInFinalClassVisitor.$$$reportNull$$$0(0);
            }
            if (!FinalMethodInFinalClassInspection.isApplicableFor(method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || containingClass.isEnum()) {
                return;
            }
            if (!containingClass.hasModifierProperty("final")) {
                return;
            }
            PsiModifierList modifiers = method.getModifierList();
            for (PsiElement child : children = modifiers.getChildren()) {
                String text = child.getText();
                if (!"final".equals(text)) continue;
                this.registerError(child, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/classlayout/FinalMethodInFinalClassInspection$FinalMethodInFinalClassVisitor", "visitMethod"));
        }
    }
}

