/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.java.codeserver.core.JavaPsiModifierUtil;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.RemoveModifierFix;
import org.jetbrains.annotations.NotNull;

public final class FinalStaticMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("final.static.method.problem.descriptor", new Object[0]);
        if (string == null) {
            FinalStaticMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new FinalStaticMethodVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/FinalStaticMethodInspection", "buildErrorString"));
    }

    private static class FinalStaticMethodVisitor
    extends BaseInspectionVisitor {
        private FinalStaticMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                FinalStaticMethodVisitor.$$$reportNull$$$0(0);
            }
            if (!method.hasModifierProperty("final") || !method.hasModifierProperty("static")) {
                return;
            }
            if (!JavaPsiModifierUtil.isLegalModifierCombination((PsiModifierList)method.getModifierList())) {
                return;
            }
            this.registerModifierError("final", (PsiModifierListOwner)method, "final");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/classlayout/FinalStaticMethodInspection$FinalStaticMethodVisitor", "visitMethod"));
        }
    }
}

