/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationModCommandAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.MethodSignature;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class InterfaceMayBeAnnotatedFunctionalInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("interface.may.be.annotated.functional.problem.descriptor", new Object[0]);
        if (string == null) {
            InterfaceMayBeAnnotatedFunctionalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.LAMBDA_EXPRESSIONS);
        if (set == null) {
            InterfaceMayBeAnnotatedFunctionalInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        LocalQuickFix localQuickFix = LocalQuickFix.from((ModCommandAction)new AddAnnotationModCommandAction("java.lang.FunctionalInterface", (PsiModifierListOwner)aClass, new String[0]));
        if (localQuickFix == null) {
            InterfaceMayBeAnnotatedFunctionalInspection.$$$reportNull$$$0(2);
        }
        return localQuickFix;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new InterfaceMayBeAnnotatedFunctionalVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/InterfaceMayBeAnnotatedFunctionalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFix";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class InterfaceMayBeAnnotatedFunctionalVisitor
    extends BaseInspectionVisitor {
        private InterfaceMayBeAnnotatedFunctionalVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                InterfaceMayBeAnnotatedFunctionalVisitor.$$$reportNull$$$0(0);
            }
            super.visitClass(aClass);
            if (!aClass.isInterface() || aClass.isAnnotationType() || aClass.hasModifierProperty("sealed") || AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"java.lang.FunctionalInterface", (int)0)) {
                return;
            }
            if (LambdaUtil.checkInterfaceFunctional((PsiClass)aClass) != LambdaUtil.FunctionalInterfaceStatus.VALID) {
                return;
            }
            MethodSignature signature = LambdaUtil.getFunction((PsiClass)aClass);
            if (signature == null || signature.getTypeParameters().length > 0) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/InterfaceMayBeAnnotatedFunctionalInspection$InterfaceMayBeAnnotatedFunctionalVisitor", "visitClass"));
        }
    }
}

