/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.DelegatingFixFactory;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class CloneInNonCloneableClassInspection
extends BaseInspection {
    public boolean onlyWarnOnPublicClone = true;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            String text = anonymousClass.getBaseClassType().getPresentableText();
            String string = InspectionGadgetsBundle.message("clone.method.in.non.cloneable.anonymous.class.problem.descriptor", text);
            if (string == null) {
                CloneInNonCloneableClassInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (aClass.isInterface()) {
            String string = InspectionGadgetsBundle.message("clone.method.in.non.cloneable.interface.problem.descriptor", aClass.getName());
            if (string == null) {
                CloneInNonCloneableClassInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("clone.method.in.non.cloneable.class.problem.descriptor", aClass.getName());
        if (string == null) {
            CloneInNonCloneableClassInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"onlyWarnOnPublicClone", (String)InspectionGadgetsBundle.message("only.warn.on.public.clone.methods", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            CloneInNonCloneableClassInspection.$$$reportNull$$$0(3);
        }
        return optPane;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            CloneInNonCloneableClassInspection.$$$reportNull$$$0(4);
        }
        this.writeBooleanOption(node, "onlyWarnOnPublicClone", true);
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return DelegatingFixFactory.createMakeCloneableFix((PsiClass)infos[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CloneInNonCloneableClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/cloneable/CloneInNonCloneableClassInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/cloneable/CloneInNonCloneableClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4 -> new IllegalArgumentException(string);
        };
    }

    private class CloneInNonCloneableClassVisitor
    extends BaseInspectionVisitor {
        private CloneInNonCloneableClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                CloneInNonCloneableClassVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!CloneUtils.isClone(method)) {
                return;
            }
            if (CloneInNonCloneableClassInspection.this.onlyWarnOnPublicClone && !method.hasModifierProperty("public")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (CloneUtils.isCloneable(containingClass) || ControlFlowUtils.methodAlwaysThrowsException(method)) {
                return;
            }
            this.registerMethodError(method, containingClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/cloneable/CloneInNonCloneableClassInspection$CloneInNonCloneableClassVisitor", "visitMethod"));
        }
    }
}

