/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.NotNull;

public final class ExpressionMayBeFactorizedInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("if.may.be.factorized.problem.descriptor", new Object[0]);
        if (string == null) {
            ExpressionMayBeFactorizedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ExpressionMayBeFactorizedVisitor(null);
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ExpressionMayBeFactorizedFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ExpressionMayBeFactorizedInspection", "buildErrorString"));
    }

    private static class ExpressionMayBeFactorizedVisitor
    extends BaseInspectionVisitor {
        private static final TokenSet outerTokens = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.OROR, JavaTokenType.ANDAND, JavaTokenType.OR, JavaTokenType.AND, JavaTokenType.PLUS, JavaTokenType.MINUS});
        private static final TokenSet innerTokens = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.OROR, JavaTokenType.ANDAND, JavaTokenType.OR, JavaTokenType.AND, JavaTokenType.ASTERISK});
        private static final TokenSet eagerTokens = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.OR, JavaTokenType.AND, JavaTokenType.ASTERISK, JavaTokenType.PLUS, JavaTokenType.MINUS});
        private final ExpressionMayBeFactorizedFix expressionMayBeFactorizedFix;

        private ExpressionMayBeFactorizedVisitor(ExpressionMayBeFactorizedFix expressionMayBeFactorizedFix) {
            this.expressionMayBeFactorizedFix = expressionMayBeFactorizedFix;
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            boolean eagerEvaluation;
            PsiBinaryExpression lBinaryExpression;
            PsiExpression rhs;
            IElementType tokenType;
            block9: {
                block8: {
                    if (expression == null) {
                        ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(0);
                    }
                    super.visitBinaryExpression(expression);
                    tokenType = expression.getOperationTokenType();
                    if (!outerTokens.contains(tokenType)) {
                        return;
                    }
                    PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLOperand());
                    rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getROperand());
                    if (!(lhs instanceof PsiBinaryExpression)) break block8;
                    lBinaryExpression = (PsiBinaryExpression)lhs;
                    if (rhs instanceof PsiBinaryExpression) break block9;
                }
                return;
            }
            PsiBinaryExpression rBinaryExpression = (PsiBinaryExpression)rhs;
            IElementType lTokenType = lBinaryExpression.getOperationTokenType();
            IElementType rTokenType = rBinaryExpression.getOperationTokenType();
            if (!innerTokens.contains(lTokenType) || !lTokenType.equals(rTokenType) || tokenType.equals(lTokenType) || lBinaryExpression.getOperands().length != 2 || rBinaryExpression.getOperands().length != 2) {
                return;
            }
            PsiExpression llExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)lBinaryExpression.getLOperand());
            PsiExpression lrExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)lBinaryExpression.getROperand());
            PsiExpression rlExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)rBinaryExpression.getLOperand());
            PsiExpression rrExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)rBinaryExpression.getROperand());
            if (llExpression == null || lrExpression == null || rlExpression == null || rrExpression == null) {
                return;
            }
            boolean bl = eagerEvaluation = eagerTokens.contains(tokenType) && eagerTokens.contains(lTokenType);
            if (!(this.maybeReplaceDuplicateExpression(expression, lBinaryExpression, llExpression, rlExpression, lrExpression, rrExpression, eagerEvaluation, false, true) || this.maybeReplaceDuplicateExpression(expression, lBinaryExpression, llExpression, rrExpression, lrExpression, rlExpression, eagerEvaluation, false, false) || this.maybeReplaceDuplicateExpression(expression, lBinaryExpression, lrExpression, rlExpression, llExpression, rrExpression, eagerEvaluation, true, true))) {
                this.maybeReplaceDuplicateExpression(expression, lBinaryExpression, lrExpression, rrExpression, llExpression, rlExpression, eagerEvaluation, true, false);
            }
        }

        private boolean maybeReplaceDuplicateExpression(@NotNull PsiBinaryExpression visitedElement, @NotNull PsiBinaryExpression lBinaryExpression, @NotNull PsiExpression factor, @NotNull PsiExpression factorDuplicate, @NotNull PsiExpression thenExpression, @NotNull PsiExpression elseExpression, boolean eagerEvaluation, boolean isThenExpressionFirst, boolean isElseExpressionLast) {
            if (visitedElement == null) {
                ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(1);
            }
            if (lBinaryExpression == null) {
                ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(2);
            }
            if (factor == null) {
                ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(3);
            }
            if (factorDuplicate == null) {
                ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(4);
            }
            if (thenExpression == null) {
                ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(5);
            }
            if (elseExpression == null) {
                ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(6);
            }
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(factor, factorDuplicate) && !EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression, elseExpression) && !BoolUtils.areExpressionsOpposite(thenExpression, elseExpression) && ExpressionMayBeFactorizedVisitor.isPassiveWithoutBreak(factor)) {
                boolean isThenExpressionPassiveWithoutBreak = ExpressionMayBeFactorizedVisitor.isPassiveWithoutBreak(thenExpression);
                boolean isElseExpressionPassiveWithoutBreak = ExpressionMayBeFactorizedVisitor.isPassiveWithoutBreak(elseExpression);
                if (isThenExpressionPassiveWithoutBreak && isElseExpressionLast && (eagerEvaluation || isElseExpressionPassiveWithoutBreak)) {
                    this.warnOrFix(visitedElement, lBinaryExpression, factorDuplicate, thenExpression, elseExpression, true);
                    return true;
                }
                if (isElseExpressionPassiveWithoutBreak && (isThenExpressionFirst || isThenExpressionPassiveWithoutBreak)) {
                    this.warnOrFix(visitedElement, lBinaryExpression, factorDuplicate, thenExpression, elseExpression, false);
                    return true;
                }
            }
            return false;
        }

        private static boolean isPassiveWithoutBreak(@NotNull PsiExpression disturbingExpression) {
            if (disturbingExpression == null) {
                ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(7);
            }
            return TypeConversionUtil.isPrimitiveAndNotNull((PsiType)disturbingExpression.getType()) && !SideEffectChecker.mayHaveSideEffects(disturbingExpression);
        }

        private void warnOrFix(@NotNull PsiBinaryExpression visitedElement, @NotNull PsiBinaryExpression lBinaryExpression, @NotNull PsiExpression duplicateExpression, @NotNull PsiExpression thenExpression, @NotNull PsiExpression elseExpression, boolean isFactorizedExpressionFirst) {
            if (visitedElement == null) {
                ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(8);
            }
            if (lBinaryExpression == null) {
                ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(9);
            }
            if (duplicateExpression == null) {
                ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(10);
            }
            if (thenExpression == null) {
                ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(11);
            }
            if (elseExpression == null) {
                ExpressionMayBeFactorizedVisitor.$$$reportNull$$$0(12);
            }
            if (this.expressionMayBeFactorizedFix == null) {
                this.registerError((PsiElement)visitedElement, new Object[0]);
            } else {
                ExpressionMayBeFactorizedFix.effectivelyDoFix(visitedElement, lBinaryExpression, duplicateExpression, thenExpression, elseExpression, isFactorizedExpressionFirst);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitedElement";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lBinaryExpression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factorDuplicate";
                    break;
                }
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenExpression";
                    break;
                }
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseExpression";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disturbingExpression";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicateExpression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/ExpressionMayBeFactorizedInspection$ExpressionMayBeFactorizedVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "maybeReplaceDuplicateExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPassiveWithoutBreak";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warnOrFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ExpressionMayBeFactorizedFix
    extends PsiUpdateModCommandQuickFix {
        private ExpressionMayBeFactorizedFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("if.may.be.factorized.quickfix", new Object[0]);
            if (string == null) {
                ExpressionMayBeFactorizedFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ExpressionMayBeFactorizedFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ExpressionMayBeFactorizedFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ExpressionMayBeFactorizedFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiBinaryExpression)) {
                return;
            }
            new ExpressionMayBeFactorizedVisitor(this).visitBinaryExpression((PsiBinaryExpression)element);
        }

        private static void effectivelyDoFix(@NotNull PsiBinaryExpression visitedElement, @NotNull PsiBinaryExpression lBinaryExpression, @NotNull PsiExpression duplicateExpression, @NotNull PsiExpression thenExpression, @NotNull PsiExpression elseExpression, boolean isFactorizedExpressionFirst) {
            if (visitedElement == null) {
                ExpressionMayBeFactorizedFix.$$$reportNull$$$0(4);
            }
            if (lBinaryExpression == null) {
                ExpressionMayBeFactorizedFix.$$$reportNull$$$0(5);
            }
            if (duplicateExpression == null) {
                ExpressionMayBeFactorizedFix.$$$reportNull$$$0(6);
            }
            if (thenExpression == null) {
                ExpressionMayBeFactorizedFix.$$$reportNull$$$0(7);
            }
            if (elseExpression == null) {
                ExpressionMayBeFactorizedFix.$$$reportNull$$$0(8);
            }
            CommentTracker commentTracker = new CommentTracker();
            if (isFactorizedExpressionFirst) {
                PsiReplacementUtil.replaceExpression((PsiExpression)visitedElement, commentTracker.text(duplicateExpression, ParenthesesUtils.getPrecedence((PsiExpression)lBinaryExpression)) + ExpressionMayBeFactorizedFix.getOperatorText(lBinaryExpression) + "(" + commentTracker.text(thenExpression, ParenthesesUtils.getPrecedence((PsiExpression)visitedElement)) + ExpressionMayBeFactorizedFix.getOperatorText(visitedElement) + commentTracker.text(elseExpression, ParenthesesUtils.getPrecedence((PsiExpression)visitedElement)) + ")", commentTracker);
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)visitedElement, "(" + commentTracker.text(thenExpression, ParenthesesUtils.getPrecedence((PsiExpression)visitedElement)) + ExpressionMayBeFactorizedFix.getOperatorText(visitedElement) + commentTracker.text(elseExpression, ParenthesesUtils.getPrecedence((PsiExpression)visitedElement)) + ")" + ExpressionMayBeFactorizedFix.getOperatorText(lBinaryExpression) + commentTracker.text(duplicateExpression, ParenthesesUtils.getPrecedence((PsiExpression)lBinaryExpression)), commentTracker);
            }
        }

        private static String getOperatorText(@NotNull PsiBinaryExpression binaryExpression) {
            if (binaryExpression == null) {
                ExpressionMayBeFactorizedFix.$$$reportNull$$$0(9);
            }
            PsiExpression rhs = binaryExpression.getROperand();
            assert (rhs != null);
            PsiJavaToken token = binaryExpression.getTokenBeforeOperand(rhs);
            assert (token != null);
            return token.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/ExpressionMayBeFactorizedInspection$ExpressionMayBeFactorizedFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitedElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lBinaryExpression";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicateExpression";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenExpression";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseExpression";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binaryExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/ExpressionMayBeFactorizedInspection$ExpressionMayBeFactorizedFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "effectivelyDoFix";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getOperatorText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
            };
        }
    }
}

