/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class EmptyFinallyBlockInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("empty.finally.block.problem.descriptor", new Object[0]);
        if (string == null) {
            EmptyFinallyBlockInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        Boolean canDeleteTry = (Boolean)infos[0];
        if (canDeleteTry.booleanValue()) {
            return new RemoveTryFinallyBlockFix();
        }
        return new RemoveFinallyBlockFix();
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            EmptyFinallyBlockInspection.$$$reportNull$$$0(1);
        }
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyFinallyBlockVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/errorhandling/EmptyFinallyBlockInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/errorhandling/EmptyFinallyBlockInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class RemoveTryFinallyBlockFix
    extends PsiUpdateModCommandQuickFix {
        private RemoveTryFinallyBlockFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("remove.try.finally.block.quickfix", new Object[0]);
            if (string == null) {
                RemoveTryFinallyBlockFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiTryStatement tryStatement;
            if (project == null) {
                RemoveTryFinallyBlockFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                RemoveTryFinallyBlockFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveTryFinallyBlockFix.$$$reportNull$$$0(3);
            }
            if ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class)) == null || tryStatement.getResourceList() != null || tryStatement.getParent() == null) {
                return;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            if (!(tryStatement.getParent() instanceof PsiCodeBlock)) {
                tryStatement = (PsiTryStatement)BlockUtils.expandSingleStatementToBlockStatement((PsiStatement)tryStatement);
                tryBlock = Objects.requireNonNull(tryStatement.getTryBlock());
            }
            PsiElement first = tryBlock.getFirstBodyElement();
            PsiElement last = tryBlock.getLastBodyElement();
            if (first != null && last != null) {
                tryStatement.getParent().addRangeAfter(first, last, (PsiElement)tryStatement);
            }
            tryStatement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/errorhandling/EmptyFinallyBlockInspection$RemoveTryFinallyBlockFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/errorhandling/EmptyFinallyBlockInspection$RemoveTryFinallyBlockFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class RemoveFinallyBlockFix
    extends PsiUpdateModCommandQuickFix {
        private RemoveFinallyBlockFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("remove.finally.block.quickfix", new Object[0]);
            if (string == null) {
                RemoveFinallyBlockFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiTryStatement tryStatement;
            if (project == null) {
                RemoveFinallyBlockFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                RemoveFinallyBlockFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveFinallyBlockFix.$$$reportNull$$$0(3);
            }
            if ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class)) == null) {
                return;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            RemoveFinallyBlockFix.deleteUntilFinally((PsiElement)finallyBlock);
        }

        private static void deleteUntilFinally(PsiElement element) {
            PsiJavaToken keyword;
            IElementType tokenType;
            if (element instanceof PsiJavaToken && (tokenType = (keyword = (PsiJavaToken)element).getTokenType()).equals(JavaTokenType.FINALLY_KEYWORD)) {
                keyword.delete();
                return;
            }
            RemoveFinallyBlockFix.deleteUntilFinally(element.getPrevSibling());
            if (!(element instanceof PsiWhiteSpace)) {
                element.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/errorhandling/EmptyFinallyBlockInspection$RemoveFinallyBlockFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/errorhandling/EmptyFinallyBlockInspection$RemoveFinallyBlockFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class EmptyFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private EmptyFinallyBlockVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiElement[] children;
            if (statement == null) {
                EmptyFinallyBlockVisitor.$$$reportNull$$$0(0);
            }
            super.visitTryStatement(statement);
            PsiCodeBlock finallyBlock = statement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            if (!finallyBlock.isEmpty()) {
                return;
            }
            for (PsiElement child : children = statement.getChildren()) {
                String childText = child.getText();
                if (!"finally".equals(childText)) continue;
                boolean canDeleteTry = statement.getCatchBlocks().length == 0 && statement.getResourceList() == null;
                this.registerError(child, canDeleteTry);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/EmptyFinallyBlockInspection$EmptyFinallyBlockVisitor", "visitTryStatement"));
        }
    }
}

