/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ExceptionFromCatchWhichDoesntWrapInspection
extends BaseInspection {
    public boolean ignoreGetMessage;
    public boolean ignoreCantWrap;

    @NotNull
    public String getID() {
        return "ThrowInsideCatchBlockWhichIgnoresCaughtException";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("exception.from.catch.which.doesnt.wrap.problem.descriptor", new Object[0]);
        if (string == null) {
            ExceptionFromCatchWhichDoesntWrapInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreGetMessage", (String)InspectionGadgetsBundle.message("exception.from.catch.which.doesntwrap.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreCantWrap", (String)InspectionGadgetsBundle.message("exception.from.catch.which.doesntwrap.ignore.cant.wrap.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ExceptionFromCatchWhichDoesntWrapInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ExceptionFromCatchWhichDoesntWrapVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/ExceptionFromCatchWhichDoesntWrapInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ExceptionFromCatchWhichDoesntWrapVisitor
    extends BaseInspectionVisitor {
        private ExceptionFromCatchWhichDoesntWrapVisitor() {
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
            PsiClassType classType;
            PsiClass exceptionClass;
            PsiType thrownType;
            if (statement == null) {
                ExceptionFromCatchWhichDoesntWrapVisitor.$$$reportNull$$$0(0);
            }
            super.visitThrowStatement(statement);
            PsiCatchSection catchSection = (PsiCatchSection)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiCatchSection.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            if (catchSection == null) {
                return;
            }
            PsiParameter parameter = catchSection.getParameter();
            if (parameter == null || parameter.isUnnamed()) {
                return;
            }
            @NonNls String parameterName = parameter.getName();
            if (PsiUtil.isIgnoredName((String)parameterName)) {
                return;
            }
            PsiExpression exception = statement.getException();
            if (exception == null) {
                return;
            }
            if (ExceptionFromCatchWhichDoesntWrapInspection.this.ignoreCantWrap && (thrownType = exception.getType()) instanceof PsiClassType && (exceptionClass = (classType = (PsiClassType)thrownType).resolve()) != null) {
                PsiMethod[] constructors = exceptionClass.getConstructors();
                PsiClassType throwableType = TypeUtils.getType("java.lang.Throwable", (PsiElement)statement);
                boolean canWrap = false;
                block0: for (PsiMethod constructor : constructors) {
                    PsiParameter[] parameters;
                    PsiParameterList parameterList = constructor.getParameterList();
                    for (PsiParameter constructorParameter : parameters = parameterList.getParameters()) {
                        PsiType type = constructorParameter.getType();
                        if (!throwableType.equals((Object)type)) continue;
                        canWrap = true;
                        break block0;
                    }
                }
                if (!canWrap) {
                    return;
                }
            }
            ReferenceFinder visitor2 = new ReferenceFinder(parameter);
            exception.accept((PsiElementVisitor)visitor2);
            if (visitor2.usesParameter()) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/ExceptionFromCatchWhichDoesntWrapInspection$ExceptionFromCatchWhichDoesntWrapVisitor", "visitThrowStatement"));
        }
    }

    private class ReferenceFinder
    extends JavaRecursiveElementVisitor {
        private final Set<PsiReferenceExpression> visited = new HashSet<PsiReferenceExpression>();
        private boolean argumentsContainCatchParameter;
        private final PsiParameter parameter;

        ReferenceFinder(PsiParameter parameter) {
            this.parameter = parameter;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                ReferenceFinder.$$$reportNull$$$0(0);
            }
            if (this.argumentsContainCatchParameter || !this.visited.add(expression)) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement target = expression.resolve();
            if (this.parameter.equals((Object)target)) {
                PsiElement grandParent;
                PsiElement parent;
                if (!ExceptionFromCatchWhichDoesntWrapInspection.this.ignoreGetMessage && (parent = expression.getParent()) instanceof PsiReferenceExpression && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression) {
                    return;
                }
                this.argumentsContainCatchParameter = true;
            } else if (target instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)target;
                Query query = ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope(), (boolean)false);
                query.forEach(reference -> {
                    PsiExpression[] arguments;
                    PsiElement element = reference.getElement();
                    PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{PsiParenthesizedExpression.class});
                    if (!(parent instanceof PsiReferenceExpression)) {
                        return true;
                    }
                    PsiElement grandParent = parent.getParent();
                    if (!(grandParent instanceof PsiMethodCallExpression)) {
                        return true;
                    }
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                    PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                    for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                        argument.accept((PsiElementVisitor)this);
                    }
                    return true;
                });
                PsiExpression initializer = variable.getInitializer();
                if (initializer != null) {
                    initializer.accept((PsiElementVisitor)this);
                }
            } else if (target instanceof PsiPatternVariable) {
                PsiExpression selector;
                PsiSwitchLabelStatementBase label;
                PsiSwitchBlock switchBlock;
                PsiElement psiElement;
                PsiElement pattern = target.getParent();
                if (!(pattern instanceof PsiTypeTestPattern)) {
                    return;
                }
                PsiElement parent = pattern.getParent();
                if (parent instanceof PsiInstanceOfExpression) {
                    PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)parent;
                    instanceOfExpression.getOperand().accept((PsiElementVisitor)this);
                } else if (parent instanceof PsiCaseLabelElementList && (psiElement = parent.getParent()) instanceof PsiSwitchLabelStatementBase && (switchBlock = (label = (PsiSwitchLabelStatementBase)psiElement).getEnclosingSwitchBlock()) != null && (selector = switchBlock.getExpression()) != null) {
                    selector.accept((PsiElementVisitor)this);
                }
            }
        }

        boolean usesParameter() {
            return this.argumentsContainCatchParameter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/errorhandling/ExceptionFromCatchWhichDoesntWrapInspection$ReferenceFinder", "visitReferenceExpression"));
        }
    }
}

