/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.fixes.EqualityToSafeEqualsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualityToEqualsFix
extends PsiUpdateModCommandQuickFix {
    private final boolean myNegated;

    @Deprecated
    public EqualityToEqualsFix() {
        this(true);
    }

    private EqualityToEqualsFix(boolean negated) {
        this.myNegated = negated;
    }

    @Nullable
    public static EqualityToEqualsFix buildFix(PsiBinaryExpression expression) {
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLOperand());
        Nullability nullability = NullabilityUtil.getExpressionNullability(expression.getLOperand(), true);
        if (nullability == Nullability.NULLABLE) {
            return null;
        }
        if (lhs instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)lhs).resolve()) instanceof PsiModifierListOwner) {
            NullableNotNullManager.getInstance((Project)expression.getProject());
            if (NullableNotNullManager.isNullable((PsiModifierListOwner)((PsiModifierListOwner)target))) {
                return null;
            }
        }
        return new EqualityToEqualsFix(JavaTokenType.NE.equals(expression.getOperationTokenType()));
    }

    public static LocalQuickFix @NotNull [] buildEqualityFixes(PsiBinaryExpression expression) {
        ArrayList result = new ArrayList(2);
        ContainerUtil.addIfNotNull(result, (Object)((Object)EqualityToEqualsFix.buildFix(expression)));
        ContainerUtil.addIfNotNull(result, (Object)((Object)EqualityToSafeEqualsFix.buildFix(expression)));
        LocalQuickFix[] localQuickFixArray = result.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            EqualityToEqualsFix.$$$reportNull$$$0(0);
        }
        return localQuickFixArray;
    }

    @Nls
    @NotNull
    public String getName() {
        return EqualityToEqualsFix.getFixName(this.myNegated);
    }

    @NotNull
    @IntentionFamilyName
    public static String getFixName(boolean negated) {
        String string = negated ? CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"!=", "!equals()"}) : CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"==", "equals()"});
        if (string == null) {
            EqualityToEqualsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return EqualityToEqualsFix.getFixName(false);
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement comparisonToken, @NotNull ModPsiUpdater updater) {
        PsiElement parent;
        if (project == null) {
            EqualityToEqualsFix.$$$reportNull$$$0(2);
        }
        if (comparisonToken == null) {
            EqualityToEqualsFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            EqualityToEqualsFix.$$$reportNull$$$0(4);
        }
        if (!((parent = comparisonToken.getParent()) instanceof PsiBinaryExpression)) {
            return;
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)parent;
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLOperand());
        PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getROperand());
        if (lhs == null || rhs == null) {
            return;
        }
        CommentTracker commentTracker = new CommentTracker();
        @NonNls StringBuilder newExpression = new StringBuilder();
        if (JavaTokenType.NE.equals(expression.getOperationTokenType())) {
            newExpression.append('!');
        }
        newExpression.append(commentTracker.text(lhs, 1));
        newExpression.append(".equals(").append(commentTracker.text((PsiElement)rhs)).append(')');
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression, newExpression.toString(), commentTracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/EqualityToEqualsFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparisonToken";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEqualityFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/EqualityToEqualsFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

