/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EqualsToEqualityFix
extends PsiUpdateModCommandQuickFix {
    private final boolean myNegated;

    private EqualsToEqualityFix(boolean negated) {
        this.myNegated = negated;
    }

    @Nullable
    public static EqualsToEqualityFix buildFix(PsiMethodCallExpression expressionToFix, boolean negated) {
        if (ExpressionUtils.isVoidContext((PsiExpression)expressionToFix)) {
            return null;
        }
        return new EqualsToEqualityFix(negated);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.myNegated ? CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"!equals()", "!="}) : CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"equals()", "=="});
        if (string == null) {
            EqualsToEqualityFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiMethodCallExpression call;
        EqualityCheck check;
        PsiExpression expr;
        if (project == null) {
            EqualsToEqualityFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            EqualsToEqualityFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            EqualsToEqualityFix.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiExpression && BoolUtils.isNegation(expr = (PsiExpression)element)) {
            element = BoolUtils.getNegated(expr);
        }
        if ((check = EqualityCheck.from((PsiExpression)(call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false)))) == null) {
            return;
        }
        PsiExpression lhs = check.getLeft();
        PsiExpression rhs = check.getRight();
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)call);
        CommentTracker commentTracker = new CommentTracker();
        String lhsText = commentTracker.text(lhs, 9);
        String rhsText = commentTracker.text(rhs, 9);
        if (parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent)) {
            PsiReplacementUtil.replaceExpression((PsiExpression)parent, lhsText + "!=" + rhsText, commentTracker);
        } else {
            PsiReplacementUtil.replaceExpression((PsiExpression)call, lhsText + "==" + rhsText, commentTracker);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/EqualsToEqualityFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/EqualsToEqualityFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

